/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class DataTrackTimeControl
extends JPanel
implements PropertyChangeListener {
    protected DataTrack dataTrack;
    private JRadioButton videoButton;
    private JRadioButton dataButton;

    public DataTrackTimeControl(DataTrack dataTrack) {
        this.dataTrack = dataTrack;
        dataTrack.addPropertyChangeListener(this);
        this.createGUI();
        this.refreshGUI();
    }

    protected void createGUI() {
        this.videoButton = new JRadioButton();
        this.videoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTrackTimeControl.this.setTimeSourceToDataTrack(false);
            }
        });
        this.dataButton = new JRadioButton();
        this.dataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataTrackTimeControl.this.setTimeSourceToDataTrack(true);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.videoButton);
        buttonGroup.add(this.dataButton);
        this.videoButton.setSelected(true);
        this.add(this.videoButton);
        this.add(this.dataButton);
    }

    protected void setTimeSourceToDataTrack(boolean bl) {
        if (this.dataTrack.getVideoPanel() == null) {
            return;
        }
        VideoPlayer videoPlayer = this.dataTrack.getVideoPanel().getPlayer();
        videoPlayer.getClipControl().setTimeSource(bl ? this.dataTrack : null);
        videoPlayer.refresh();
        if (this.dataTrack instanceof ParticleDataTrack) {
            ((ParticleDataTrack)this.dataTrack).refreshInitialTime();
        }
    }

    protected void refreshGUI() {
        this.setBorder(BorderFactory.createTitledBorder(TrackerRes.getString("DataTrackTimeControl.Border.Title")));
        this.videoButton.setText(TrackerRes.getString("DataTrackTimeControl.Button.Video"));
        this.dataButton.setText(TrackerRes.getString("DataTrackTimeControl.Button.Data"));
        this.dataButton.setEnabled(this.dataTrack.isTimeDataAvailable());
        boolean bl = ClipControl.isTimeSource(this.dataTrack);
        this.dataButton.setSelected(bl);
        this.videoButton.setSelected(!bl);
        FontSizer.setFonts(this.getBorder(), FontSizer.getLevel());
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        dimension.height = this.getPreferredSize().height;
        return dimension;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refreshGUI();
    }
}

