/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class CoordAxesStep
extends Step {
    private Origin origin;
    private Handle handle;
    private boolean originEnabled = true;
    private boolean handleEnabled = true;
    private Map<TrackerPanel, Shape> handleShapes = new HashMap<TrackerPanel, Shape>();
    private Shape[] fillShapes = new Shape[2];
    private GeneralPath path = new GeneralPath();

    public CoordAxesStep(CoordAxes coordAxes, int n) {
        super(coordAxes, n);
        this.origin = new Origin();
        this.origin.setCoordsEditTrigger(true);
        this.handle = new Handle();
        this.handle.setCoordsEditTrigger(true);
        this.points = new TPoint[]{this.origin, this.handle};
        this.screenPoints = new Point[1];
    }

    public TPoint getOrigin() {
        return this.origin;
    }

    public TPoint getHandle() {
        return this.handle;
    }

    public void setOriginEnabled(boolean bl) {
        this.originEnabled = bl;
    }

    public boolean isOriginEnabled() {
        return this.originEnabled;
    }

    public void setHandleEnabled(boolean bl) {
        this.handleEnabled = bl;
    }

    public boolean isHandleEnabled() {
        return this.handleEnabled;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Object object;
        AutoTracker autoTracker;
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        this.setHitRectCenter(n, n2);
        AutoTracker autoTracker2 = autoTracker = this.track.trackerPanel == null ? null : this.track.trackerPanel.getAutoTracker();
        if (this.handleEnabled && (object = this.handleShapes.get(trackerPanel)) != null && object.intersects(hitRect)) {
            int n3;
            AutoTracker.FrameData frameData;
            if (autoTracker != null && autoTracker.getTrack() == this.track && this.track.getTargetIndex() == 1 && (frameData = autoTracker.getFrame(n3 = this.track.trackerPanel.getFrameNumber())) == frameData.getKeyFrame()) {
                return null;
            }
            return this.handle;
        }
        if (this.originEnabled && !this.track.isLocked() && (object = super.findInteractive(drawingPanel, n, n2)) == this.origin) {
            int n4;
            AutoTracker.FrameData frameData;
            if (autoTracker != null && autoTracker.getTrack() == this.track && this.track.getTargetIndex() == 0 && (frameData = autoTracker.getFrame(n4 = this.track.trackerPanel.getFrameNumber())) == frameData.getKeyFrame()) {
                return null;
            }
            return this.origin;
        }
        return null;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        PropertyChangeListener propertyChangeListener;
        if (this.track.trackerPanel == drawingPanel && ((AutoTracker)(propertyChangeListener = this.track.trackerPanel.getAutoTracker())).isInteracting(this.track)) {
            return;
        }
        propertyChangeListener = (TrackerPanel)drawingPanel;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.getMark((TrackerPanel)propertyChangeListener).draw(graphics2D, false);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.marks.get(trackerPanel);
        TPoint tPoint = null;
        if (mark == null) {
            Serializable serializable;
            tPoint = trackerPanel.getSelectedPoint();
            ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
            int n = trackerPanel.getFrameNumber();
            if (this.track.trackerPanel != null) {
                n = this.track.trackerPanel.getFrameNumber();
            }
            double d = imageCoordSystem.getOriginX(n);
            double d2 = imageCoordSystem.getOriginY(n);
            this.origin.setLocation(d, d2);
            Point point = this.screenPoints[0] = this.origin.getScreenPosition(trackerPanel);
            this.fillShapes[0] = this.footprint.getShape(this.screenPoints);
            this.path.reset();
            this.path.moveTo(point.x + 15, point.y);
            this.path.lineTo(point.x + 3000, point.y);
            Shape shape = this.path;
            if (trackerPanel.isDrawingInImageSpace()) {
                double d3 = imageCoordSystem.getAngle(n);
                transform.setToRotation(-d3, point.x, point.y);
                this.fillShapes[0] = transform.createTransformedShape(this.fillShapes[0]);
                shape = transform.createTransformedShape(shape);
            }
            this.handleShapes.put(trackerPanel, shape);
            int n2 = FontSizer.getIntegerFactor();
            if (tPoint == this.origin) {
                transform.setToTranslation(point.x, point.y);
                if (n2 > 1) {
                    transform.scale(n2, n2);
                }
                this.fillShapes[1] = transform.createTransformedShape(selectionShape);
            } else if (tPoint == this.handle) {
                serializable = this.handle.getScreenPosition(trackerPanel);
                transform.setToTranslation(serializable.x, serializable.y);
                if (n2 > 1) {
                    transform.scale(n2, n2);
                }
                this.fillShapes[1] = transform.createTransformedShape(selectionShape);
            } else {
                this.fillShapes[1] = null;
            }
            serializable = this.footprint.getColor();
            TrackerPanel trackerPanel2 = trackerPanel;
            mark = new Mark((Color)serializable, trackerPanel2){
                private final /* synthetic */ Color val$color;
                private final /* synthetic */ TrackerPanel val$panel;
                {
                    this.val$color = color;
                    this.val$panel = trackerPanel;
                }

                @Override
                public void draw(Graphics2D graphics2D, boolean bl) {
                    Paint paint = graphics2D.getPaint();
                    graphics2D.setPaint(this.val$color);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    int n = 0;
                    while (n < 2) {
                        if (CoordAxesStep.this.fillShapes[n] != null) {
                            graphics2D.fill(CoordAxesStep.this.fillShapes[n]);
                        }
                        ++n;
                    }
                    graphics2D.setPaint(paint);
                }

                @Override
                public Rectangle getBounds(boolean bl) {
                    Rectangle rectangle = this.val$panel.getBounds();
                    if (CoordAxesStep.this.fillShapes[1] != null) {
                        rectangle.add(CoordAxesStep.this.fillShapes[1].getBounds());
                    }
                    return rectangle;
                }
            };
            this.marks.put(trackerPanel, mark);
        }
        return mark;
    }

    @Override
    public int getPointIndex(TPoint tPoint) {
        int n = super.getPointIndex(tPoint);
        if (n == -1) {
            if (tPoint instanceof CoordAxes.OriginPoint) {
                return 0;
            }
            if (tPoint instanceof CoordAxes.AnglePoint) {
                return 1;
            }
        }
        return n;
    }

    @Override
    public Rectangle getBounds(TrackerPanel trackerPanel) {
        Rectangle rectangle = this.getMark(trackerPanel).getBounds(false);
        return rectangle;
    }

    @Override
    public Object clone() {
        CoordAxesStep coordAxesStep = (CoordAxesStep)super.clone();
        if (coordAxesStep != null) {
            coordAxesStep.handleShapes = new HashMap<TrackerPanel, Shape>();
        }
        return coordAxesStep;
    }

    @Override
    public String toString() {
        return "CoordAxesStep " + this.n;
    }

    public static int getLength() {
        return 2;
    }

    class Handle
    extends TPoint {
        private double angleIncrement = 0.0;
        protected Point2D.Double p = new Point2D.Double();
        private double lastX;
        private double lastY;

        Handle() {
        }

        @Override
        public void setXY(double d, double d2) {
            double d3;
            double d4;
            if (CoordAxesStep.this.track.isLocked()) {
                return;
            }
            CoordAxes coordAxes = (CoordAxes)CoordAxesStep.this.track;
            if (coordAxes.trackerPanel == null) {
                super.setXY(d, d2);
                return;
            }
            if (this.angleIncrement >= Math.PI / 180) {
                this.p.setLocation(d, d2);
                d4 = CoordAxesStep.this.origin.distance(this.p);
                d3 = CoordAxesStep.this.origin.angle(this.p);
                int n = Math.round((float)(d3 / this.angleIncrement));
                d3 = (double)n * this.angleIncrement;
                d = CoordAxesStep.this.origin.getX() + d4 * Math.cos(d3);
                d2 = CoordAxesStep.this.origin.getY() + d4 * Math.sin(d3);
            }
            if (this.isAdjusting()) {
                this.lastX = d;
                this.lastY = d2;
            }
            super.setXY(d, d2);
            d4 = CoordAxesStep.this.origin.cos(this);
            d3 = CoordAxesStep.this.origin.sin(this);
            ImageCoordSystem imageCoordSystem = coordAxes.trackerPanel.getCoords();
            imageCoordSystem.setAdjusting(this.isAdjusting());
            int n = coordAxes.trackerPanel.getFrameNumber();
            imageCoordSystem.setCosineSine(n, d4, d3);
            coordAxes.angleField.setValue(imageCoordSystem.getAngle(n));
            this.angleIncrement = 0.0;
            if (this.isAdjusting()) {
                CoordAxesStep.this.repaint();
            }
        }

        @Override
        public void setScreenPosition(int n, int n2, VideoPanel videoPanel, InputEvent inputEvent) {
            this.angleIncrement = inputEvent == null ? 0.0 : (inputEvent.isShiftDown() ? 0.08726646259971647 : 0.0);
            this.setScreenPosition(n, n2, videoPanel);
        }

        @Override
        public void showCoordinates(VideoPanel videoPanel) {
            TrackerPanel trackerPanel;
            if (videoPanel instanceof TrackerPanel && this != (trackerPanel = (TrackerPanel)videoPanel).getSelectedPoint()) {
                this.setLocation(videoPanel.getMouseX(), videoPanel.getMouseY());
                Point2D point2D = this.getWorldPosition(videoPanel);
                point2D.setLocation(point2D.getX(), 0.0);
                int n = videoPanel.getFrameNumber();
                AffineTransform affineTransform = videoPanel.getCoords().getToImageTransform(n);
                affineTransform.transform(point2D, point2D);
                this.setLocation(point2D);
            }
            super.showCoordinates(videoPanel);
        }

        @Override
        public void setAdjusting(boolean bl) {
            boolean bl2 = this.isAdjusting();
            super.setAdjusting(bl);
            if (bl2 && !bl) {
                this.setXY(this.lastX, this.lastY);
            }
        }
    }

    class Origin
    extends TPoint {
        private double lastX;
        private double lastY;

        Origin() {
        }

        @Override
        public void setXY(double d, double d2) {
            if (CoordAxesStep.this.track.isLocked()) {
                return;
            }
            if (this.isAdjusting()) {
                this.lastX = d;
                this.lastY = d2;
            }
            super.setXY(d, d2);
            TrackerPanel trackerPanel = CoordAxesStep.this.track.trackerPanel;
            if (trackerPanel != null) {
                ImageCoordSystem imageCoordSystem = CoordAxesStep.this.track.trackerPanel.getCoords();
                imageCoordSystem.setAdjusting(this.isAdjusting());
                int n = trackerPanel.getFrameNumber();
                imageCoordSystem.setOriginXY(n, d, d2);
                CoordAxes coordAxes = (CoordAxes)CoordAxesStep.this.track;
                coordAxes.xField.setValue(imageCoordSystem.getOriginX(n));
                coordAxes.yField.setValue(imageCoordSystem.getOriginY(n));
            }
            if (this.isAdjusting()) {
                CoordAxesStep.this.repaint();
            }
        }

        @Override
        public void setAdjusting(boolean bl) {
            boolean bl2 = this.isAdjusting();
            super.setAdjusting(bl);
            if (bl2 && !bl) {
                this.setXY(this.lastX, this.lastY);
                CoordAxesStep.this.track.firePropertyChange("step", null, CoordAxesStep.this.track.trackerPanel.getFrameNumber());
            }
        }
    }
}

