/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class CircleFootprint
implements Footprint,
Cloneable {
    protected static float plainStrokeSize = 1.0f;
    protected static float boldStrokeSize = 2.0f;
    protected String name;
    protected Ellipse2D circle = new Ellipse2D.Double();
    protected Ellipse2D center = new Ellipse2D.Double();
    protected Shape highlight;
    protected Shape outline;
    protected Shape spot;
    protected AffineTransform transform = new AffineTransform();
    protected Color color = new Color(255, 0, 0, 127);
    protected Color highlightColor = Color.red;
    protected Shape[] hitShapes = new Shape[1];
    protected BasicStroke baseHighlightStroke;
    protected BasicStroke baseOutlineStroke;
    protected BasicStroke highlightStroke;
    protected BasicStroke outlineStroke;
    protected boolean outlined = true;
    protected boolean spotted;
    protected int alpha = 0;
    protected CircleDialog dialog;
    protected int r;
    protected int prevRadius;
    protected float prevStrokeSize;
    protected boolean prevSpot;
    private static Collection<Footprint> footprints = new HashSet<Footprint>();
    private static final CircleFootprint CIRCLE = new CircleFootprint("CircleFootprint.Circle", 4);
    private static final CircleFootprint FILLED_CIRCLE;

    static {
        footprints.add(CIRCLE);
        FILLED_CIRCLE = new CircleFootprint("CircleFootprint.FilledCircle", 8);
        FILLED_CIRCLE.setSpotShown(true);
        FILLED_CIRCLE.setAlpha(102);
        footprints.add(FILLED_CIRCLE);
    }

    public CircleFootprint(String string, int n) {
        this.name = string;
        this.setRadius(n);
        this.setStroke(new BasicStroke(1.0f));
        this.center.setFrame(-1.0, -1.0, 2.0, 2.0);
    }

    protected Object clone() throws CloneNotSupportedException {
        CircleFootprint circleFootprint = (CircleFootprint)super.clone();
        circleFootprint.circle = new Ellipse2D.Double();
        return circleFootprint;
    }

    public static Footprint getFootprint(String string) {
        for (CircleFootprint circleFootprint : footprints) {
            if (string != circleFootprint.getName()) continue;
            try {
                CircleFootprint circleFootprint2 = (CircleFootprint)circleFootprint.clone();
                return circleFootprint2;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return TrackerRes.getString(this.name);
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Icon getIcon(int n, int n2) {
        int n3 = FontSizer.getIntegerFactor();
        n *= n3;
        n2 *= n3;
        int n4 = this.r;
        this.setRadius(this.outlined ? 5 : 6);
        Shape shape = this.getShape(new Point[]{new Point()});
        Area area = null;
        if (this.spotted) {
            area = new Area(this.spot);
        }
        if (this.outlined) {
            if (area == null) {
                area = new Area(this.outline);
            } else {
                area.add(new Area(this.outline));
            }
        }
        ShapeIcon shapeIcon = new ShapeIcon(shape, area, n, n2);
        shapeIcon.setColor(this.color, this.highlightColor);
        this.setRadius(n4);
        return shapeIcon;
    }

    @Override
    public Mark getMark(Point[] pointArray) {
        final Shape shape = this.getShape(pointArray);
        final Shape shape2 = this.outline;
        final Shape shape3 = this.highlight;
        final Shape shape4 = this.spot;
        return new Mark(){

            @Override
            public void draw(Graphics2D graphics2D, boolean bl) {
                Paint paint = graphics2D.getPaint();
                graphics2D.setPaint(CircleFootprint.this.color);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.fill(shape);
                graphics2D.setPaint(CircleFootprint.this.highlightColor);
                if (CircleFootprint.this.spotted) {
                    graphics2D.fill(shape4);
                }
                if (CircleFootprint.this.outlined) {
                    graphics2D.fill(shape2);
                }
                if (bl) {
                    graphics2D.fill(shape3);
                }
                graphics2D.setPaint(paint);
            }

            @Override
            public Rectangle getBounds(boolean bl) {
                Rectangle rectangle = shape.getBounds();
                if (bl) {
                    rectangle.add(shape3.getBounds());
                }
                return rectangle;
            }
        };
    }

    @Override
    public Shape[] getHitShapes() {
        return this.hitShapes;
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        this.baseOutlineStroke = basicStroke;
        this.baseHighlightStroke = new BasicStroke(basicStroke.getLineWidth() + 1.0f);
    }

    @Override
    public BasicStroke getStroke() {
        return null;
    }

    @Override
    public void setColor(Color color) {
        this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
        this.highlightColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public Color getColor() {
        return this.highlightColor;
    }

    public void setRadius(int n) {
        this.r = n;
        this.circle.setFrame(-this.r, -this.r, 2 * this.r, 2 * this.r);
    }

    public void setOutlined(boolean bl) {
        this.outlined = bl;
    }

    public void setSpotShown(boolean bl) {
        this.spotted = bl;
    }

    public void setAlpha(int n) {
        this.alpha = n;
        this.setColor(this.color);
    }

    public String getProperties() {
        String string = String.valueOf(this.r) + " ";
        if (this.outlined) {
            string = String.valueOf(string) + "outline ";
        }
        if (this.spotted) {
            string = String.valueOf(string) + "spot ";
        }
        if (this.baseOutlineStroke.getLineWidth() > plainStrokeSize) {
            string = String.valueOf(string) + "bold ";
        }
        return string;
    }

    public void setProperties(String string) {
        if (string == null) {
            return;
        }
        int n = string.indexOf(" ");
        String string2 = string.substring(0, n);
        try {
            this.setRadius(Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {}
        this.setOutlined(string.indexOf("outline") > -1);
        this.setSpotShown(string.indexOf("spot") > -1);
        float f = string.indexOf("bold") > -1 ? boldStrokeSize : plainStrokeSize;
        this.setStroke(new BasicStroke(f));
    }

    public void showProperties(TTrack tTrack) {
        if (this.dialog == null) {
            this.dialog = new CircleDialog(tTrack);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this.dialog.getBounds().width) / 2;
            int n2 = (dimension.height - this.dialog.getBounds().height) / 2;
            this.dialog.setLocation(n, n2);
        }
        this.dialog.boldCheckbox.setSelected(this.baseOutlineStroke.getLineWidth() > plainStrokeSize);
        this.dialog.spotCheckbox.setSelected(this.spotted);
        this.dialog.spinner.setValue(this.r);
        this.prevSpot = this.spotted;
        this.prevStrokeSize = this.baseOutlineStroke.getLineWidth();
        this.prevRadius = this.r;
        this.dialog.setVisible(true);
    }

    @Override
    public Shape getShape(Point[] pointArray) {
        Point point = pointArray[0];
        this.transform.setToTranslation(point.x, point.y);
        int n = FontSizer.getIntegerFactor();
        if (n > 1) {
            this.transform.scale(n, n);
        }
        Shape shape = this.transform.createTransformedShape(this.circle);
        if (this.outlineStroke == null || this.outlineStroke.getLineWidth() != (float)n * this.baseOutlineStroke.getLineWidth()) {
            this.outlineStroke = new BasicStroke((float)n * this.baseOutlineStroke.getLineWidth());
            this.highlightStroke = new BasicStroke((float)n * this.baseHighlightStroke.getLineWidth());
        }
        this.highlight = this.highlightStroke.createStrokedShape(shape);
        this.outline = this.outlineStroke.createStrokedShape(shape);
        this.hitShapes[0] = this.spot = this.transform.createTransformedShape(this.center);
        return shape;
    }

    private class CircleDialog
    extends JDialog {
        TTrack track;
        JSpinner spinner;
        JLabel spinnerLabel;
        JButton okButton;
        JButton cancelButton;
        JCheckBox boldCheckbox;
        JCheckBox spotCheckbox;

        public CircleDialog(TTrack tTrack) {
            super((Frame)tTrack.trackerPanel.getTFrame(), true);
            this.track = tTrack;
            this.setTitle(TrackerRes.getString("CircleFootprint.Dialog.Title"));
            this.setResizable(false);
            this.setDefaultCloseOperation(1);
            this.createGUI();
            this.pack();
            this.okButton.requestFocusInWindow();
        }

        void createGUI() {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.setContentPane(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createEtchedBorder());
            jPanel.add((Component)jPanel2, "North");
            this.spinnerLabel = new JLabel(TrackerRes.getString("CircleFootprint.Dialog.Label.Radius"));
            this.spinnerLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            jPanel2.add(this.spinnerLabel);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(3, 3, 100, 1);
            this.spinner = new JSpinner(spinnerNumberModel);
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
            jFormattedTextField.setEnabled(false);
            jFormattedTextField.setDisabledTextColor(Color.BLACK);
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n = (Integer)CircleDialog.this.spinner.getValue();
                    if (n == ((CircleDialog)CircleDialog.this).CircleFootprint.this.r) {
                        return;
                    }
                    CircleFootprint.this.setRadius(n);
                    CircleDialog.this.track.trackerPanel.changed = true;
                    CircleDialog.this.track.repaint();
                }
            };
            this.spinner.addChangeListener(changeListener);
            jPanel2.add(this.spinner);
            this.boldCheckbox = new JCheckBox(TrackerRes.getString("CircleFootprint.Dialog.Checkbox.Bold"));
            this.boldCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            this.boldCheckbox.setOpaque(false);
            this.boldCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    float f = CircleDialog.this.boldCheckbox.isSelected() ? boldStrokeSize : plainStrokeSize;
                    CircleFootprint.this.setStroke(new BasicStroke(f));
                    CircleDialog.this.track.trackerPanel.changed = true;
                    CircleDialog.this.track.repaint();
                }
            });
            jPanel2.add(this.boldCheckbox);
            this.spotCheckbox = new JCheckBox(TrackerRes.getString("CircleFootprint.Dialog.Checkbox.CenterSpot"));
            this.spotCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            this.spotCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CircleFootprint.this.setSpotShown(CircleDialog.this.spotCheckbox.isSelected());
                    CircleDialog.this.track.trackerPanel.changed = true;
                    CircleDialog.this.track.repaint();
                }
            });
            jPanel2.add(this.spotCheckbox);
            JPanel jPanel3 = new JPanel();
            jPanel.add((Component)jPanel3, "South");
            this.okButton = new JButton(TrackerRes.getString("Dialog.Button.OK"));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CircleDialog.this.setVisible(false);
                    CircleDialog.this.track.setFootprint(CircleFootprint.this.getName());
                }
            });
            jPanel3.add(this.okButton);
            this.cancelButton = new JButton(TrackerRes.getString("Dialog.Button.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CircleFootprint.this.setSpotShown(((CircleDialog)CircleDialog.this).CircleFootprint.this.prevSpot);
                    CircleFootprint.this.setStroke(new BasicStroke(((CircleDialog)CircleDialog.this).CircleFootprint.this.prevStrokeSize));
                    CircleFootprint.this.setRadius(((CircleDialog)CircleDialog.this).CircleFootprint.this.prevRadius);
                    CircleDialog.this.track.repaint();
                    CircleDialog.this.setVisible(false);
                }
            });
            jPanel3.add(this.cancelButton);
        }
    }
}

