/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.CircleFitter;
import org.opensourcephysics.cabrillo.tracker.CircleFitterFootprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.FontSizer;

public class CircleFitterStep
extends Step {
    protected static AffineTransform transform = new AffineTransform();
    protected static TPoint endPoint1 = new TPoint();
    protected static TPoint endPoint2 = new TPoint();
    protected CircleFitter circleFitter;
    protected ArrayList<DataPoint> dataPoints = new ArrayList();
    protected TPoint center;
    protected TPoint edge;
    protected Slider slider;
    protected double radius;
    protected Map<TrackerPanel, Shape> lineHitShapes = new HashMap<TrackerPanel, Shape>();
    protected ArrayList<Map<TrackerPanel, Shape>> pointHitShapes = new ArrayList();
    protected Shape selectedShape;

    public CircleFitterStep(CircleFitter circleFitter, int n) {
        super(circleFitter, n);
        this.circleFitter = circleFitter;
        this.center = new TPoint();
        this.edge = new TPoint();
        this.slider = new Slider(0.0, 0.0);
        this.points = new TPoint[]{this.center, this.edge, this.slider};
        this.screenPoints = new Point[this.points.length];
    }

    public void addDataPoint(double d, double d2, boolean bl) {
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (!this.circleFitter.isFixed()) {
            this.circleFitter.keyFrames.add(this.n);
        }
        this.dataPoints.add(new DataPoint(d, d2));
        if (bl) {
            this.defaultIndex = this.dataPoints.size() - 1;
            this.refreshCircle();
            this.circleFitter.dataValid = false;
            this.circleFitter.firePropertyChange("data", null, this.circleFitter);
            if (this.circleFitter.trackerPanel != null) {
                this.circleFitter.trackerPanel.changed = true;
            }
            TTrackBar.getTrackbar(this.circleFitter.trackerPanel).refresh();
            Undo.postStepEdit(this, xMLControlElement);
        }
    }

    public void removeDataPoint(TPoint tPoint, boolean bl) {
        boolean bl2 = false;
        for (TPoint object2 : this.dataPoints) {
            if (object2 != tPoint) continue;
            bl2 = true;
            break;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (bl2) {
            if (!this.circleFitter.isFixed()) {
                this.circleFitter.keyFrames.add(this.n);
            }
            this.dataPoints.remove(tPoint);
            if (this.circleFitter.trackerPanel != null) {
                this.circleFitter.trackerPanel.changed = true;
            }
        }
        this.refreshCircle();
        if (bl2 && bl) {
            Undo.postStepEdit(this, xMLControlElement);
        }
        if (this.n == this.circleFitter.trackerPanel.getFrameNumber()) {
            this.repaint();
            this.circleFitter.refreshFields(this.n);
        }
        this.circleFitter.dataValid = false;
        this.circleFitter.firePropertyChange("data", null, null);
        this.circleFitter.trackerPanel.setSelectedPoint(null);
        TTrackBar.getTrackbar(this.circleFitter.trackerPanel).refresh();
        this.repaint();
    }

    @Override
    public TPoint getDefaultPoint() {
        if (this.dataPoints.size() > this.defaultIndex) {
            return this.dataPoints.get(this.defaultIndex);
        }
        return this.slider;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Shape shape;
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        this.setHitRectCenter(n, n2);
        Interactive interactive = null;
        int n3 = 0;
        while (n3 < this.pointHitShapes.size()) {
            Map<TrackerPanel, Shape> map = this.pointHitShapes.get(n3);
            if (map != null && (shape = map.get(trackerPanel)) != null && shape.intersects(hitRect)) {
                interactive = this.dataPoints.get(n3);
            }
            ++n3;
        }
        if (interactive == null && this.circleFitter.isRadialLineVisible() && (shape = this.lineHitShapes.get(trackerPanel)) != null && shape.intersects(hitRect)) {
            interactive = this.slider;
        }
        return interactive;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.getMark(trackerPanel).draw(graphics2D, false);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.marks.get(trackerPanel);
        TPoint tPoint = null;
        if (mark == null) {
            Shape[] shapeArray;
            tPoint = trackerPanel.getSelectedPoint();
            if (this.screenPoints.length != this.points.length + this.dataPoints.size()) {
                this.screenPoints = new Point[this.points.length + this.dataPoints.size()];
            }
            Point point = null;
            int n = 0;
            while (n < this.points.length) {
                this.screenPoints[n] = this.points[n].getScreenPosition(trackerPanel);
                if (tPoint == this.points[n]) {
                    point = this.screenPoints[n];
                }
                ++n;
            }
            n = 0;
            while (n < this.dataPoints.size()) {
                shapeArray = this.dataPoints.get(n);
                this.screenPoints[n + this.points.length] = shapeArray.getScreenPosition(trackerPanel);
                if (tPoint == shapeArray) {
                    point = this.screenPoints[n + this.points.length];
                }
                ++n;
            }
            CircleFitterFootprint circleFitterFootprint = (CircleFitterFootprint)this.footprint;
            circleFitterFootprint.setSelectedPoint(point);
            circleFitterFootprint.setDrawRadialLine(this.circleFitter.isRadialLineVisible());
            circleFitterFootprint.setPixelRadius(this.radius * trackerPanel.getXPixPerUnit());
            mark = this.footprint.getMark(this.screenPoints);
            if (point != null) {
                shapeArray = this.footprint.getColor();
                final Mark mark2 = mark;
                transform.setToTranslation(point.x, point.y);
                int n2 = FontSizer.getIntegerFactor();
                if (n2 > 1) {
                    transform.scale(n2, n2);
                }
                this.selectedShape = transform.createTransformedShape(selectionShape);
                mark = new Mark((Color)shapeArray){
                    private final /* synthetic */ Color val$color;
                    {
                        this.val$color = color;
                    }

                    @Override
                    public void draw(Graphics2D graphics2D, boolean bl) {
                        mark2.draw(graphics2D, false);
                        Paint paint = graphics2D.getPaint();
                        graphics2D.setPaint(this.val$color);
                        if (CircleFitterStep.this.selectedShape != null) {
                            graphics2D.fill(CircleFitterStep.this.selectedShape);
                        }
                        graphics2D.setPaint(paint);
                    }

                    @Override
                    public Rectangle getBounds(boolean bl) {
                        Rectangle rectangle = mark2.getBounds(false);
                        if (CircleFitterStep.this.selectedShape != null) {
                            rectangle.add(CircleFitterStep.this.selectedShape.getBounds());
                        }
                        return rectangle;
                    }
                };
            }
            this.marks.put(trackerPanel, mark);
            shapeArray = this.footprint.getHitShapes();
            this.lineHitShapes.put(trackerPanel, shapeArray[0]);
            if (shapeArray.length - 1 < this.pointHitShapes.size()) {
                this.pointHitShapes.clear();
            }
            int n3 = 1;
            while (n3 < shapeArray.length) {
                if (this.pointHitShapes.size() <= n3 - 1) {
                    HashMap hashMap = new HashMap();
                    this.pointHitShapes.add(hashMap);
                }
                Map<TrackerPanel, Shape> map = this.pointHitShapes.get(n3 - 1);
                map.put(trackerPanel, shapeArray[n3]);
                ++n3;
            }
        }
        return mark;
    }

    public double getWorldRadius() {
        if (this.dataPoints.size() < 3) {
            return Double.NaN;
        }
        return this.radius / this.circleFitter.trackerPanel.getCoords().getScaleX(this.n);
    }

    public Point2D getWorldCenter() {
        if (this.dataPoints.size() < 3 || Double.isInfinite(this.radius) || this.radius > 100000.0) {
            return null;
        }
        return this.center.getWorldPosition(this.circleFitter.trackerPanel);
    }

    public double getSliderAngle() {
        if (this.dataPoints.size() < 3 || Double.isNaN(this.radius) || this.radius > 100000.0) {
            return Double.NaN;
        }
        double d = -this.center.angle(this.slider);
        if (this.circleFitter.trackerPanel != null) {
            d -= this.circleFitter.trackerPanel.getCoords().getAngle(this.n);
        }
        return d;
    }

    public void setSliderAngle(double d) {
        double d2 = this.getSliderAngle();
        if (d == d2 || Double.isNaN(d2)) {
            return;
        }
        if (this.circleFitter.trackerPanel != null) {
            d += this.circleFitter.trackerPanel.getCoords().getAngle(this.n);
        }
        double d3 = -Math.sin(d);
        double d4 = Math.cos(d);
        this.slider.setLocation(this.center.x + this.radius * d4, this.center.y + this.radius * d3);
        this.repaint();
        this.circleFitter.refreshFields(this.n);
    }

    public boolean isValidCircle() {
        return this.dataPoints.size() > 2 && !Double.isInfinite(this.radius) && this.radius > 0.0 && this.radius < 100000.0;
    }

    public void refreshCircle() {
        boolean bl;
        double d = this.radius;
        double d2 = this.center.x;
        double d3 = this.center.y;
        int n = this.dataPoints.size();
        double d4 = 1.0;
        double d5 = 0.0;
        if (!Double.isInfinite(this.radius) && this.radius > 0.0 && this.radius < 100000.0) {
            d5 = (this.slider.x - this.center.x) / this.radius;
            d4 = (this.slider.y - this.center.y) / this.radius;
        }
        TPoint tPoint = null;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                DataPoint dataPoint = this.dataPoints.get(0);
                this.center.setLocation(dataPoint);
                break;
            }
            case 2: {
                DataPoint dataPoint = this.dataPoints.get(0);
                DataPoint dataPoint2 = this.dataPoints.get(1);
                this.center.center(dataPoint, dataPoint2);
                this.edge.setLocation(dataPoint);
                break;
            }
            case 3: {
                DataPoint dataPoint = this.dataPoints.get(0);
                DataPoint dataPoint3 = this.dataPoints.get(1);
                DataPoint dataPoint4 = this.dataPoints.get(2);
                this.refreshCircle(dataPoint, dataPoint3, dataPoint4);
                if (this.circleFitter.trackerPanel != null) {
                    tPoint = this.circleFitter.trackerPanel.getSelectedPoint();
                }
                this.edge.setLocation(tPoint == dataPoint3 ? dataPoint3 : (tPoint == dataPoint4 ? dataPoint4 : dataPoint));
                break;
            }
            default: {
                DataPoint dataPoint;
                this.refreshCircle(this.dataPoints);
                if (Double.isInfinite(this.radius) || this.radius > 100000.0) {
                    if (this.circleFitter.trackerPanel != null) {
                        tPoint = this.circleFitter.trackerPanel.getSelectedPoint();
                    }
                    dataPoint = this.dataPoints.get(0);
                    DataPoint dataPoint5 = this.dataPoints.get(1);
                    DataPoint dataPoint6 = this.dataPoints.get(2);
                    this.edge.setLocation(tPoint == dataPoint5 ? dataPoint5 : (tPoint == dataPoint6 ? dataPoint6 : dataPoint));
                    break;
                }
                this.edge.setLocation(this.center.x, this.center.y + this.radius);
            }
        }
        boolean bl2 = bl = this.circleFitter.trackerPanel != null && this.n == this.circleFitter.trackerPanel.getFrameNumber();
        if (this.radius != d || this.center.x != d2 || this.center.y != d3) {
            if (!Double.isInfinite(this.radius) && this.radius > 0.0 && this.radius < 100000.0) {
                this.slider.setLocation(this.center.x + this.radius * d5, this.center.y + this.radius * d4);
            }
            if (bl) {
                this.repaint();
            } else {
                this.erase();
            }
        }
        if (bl) {
            this.circleFitter.refreshFields(this.n);
        }
    }

    private void refreshCircle(TPoint tPoint, TPoint tPoint2, TPoint tPoint3) {
        double d = tPoint2.getX() - tPoint.getX();
        double d2 = tPoint2.getY() - tPoint.getY();
        double d3 = tPoint3.getX() - tPoint2.getX();
        double d4 = tPoint3.getY() - tPoint2.getY();
        double d5 = d2 / d;
        double d6 = d4 / d3;
        double d7 = (tPoint2.getX() + tPoint.getX()) / 2.0;
        double d8 = (tPoint2.getY() + tPoint.getY()) / 2.0;
        double d9 = (tPoint3.getX() + tPoint2.getX()) / 2.0;
        double d10 = (tPoint3.getY() + tPoint2.getY()) / 2.0;
        if (d == 0.0 && d3 == 0.0 || d5 == d6) {
            this.radius = Double.POSITIVE_INFINITY;
            return;
        }
        if (d2 == 0.0) {
            this.center.x = d7;
            this.center.y = d3 == 0.0 ? d10 : d10 + (d9 - this.center.x) / d6;
        } else if (d4 == 0.0) {
            this.center.x = d9;
            this.center.y = d == 0.0 ? d8 : d8 + (d7 - this.center.x) / d5;
        } else if (d == 0.0) {
            this.center.y = d8;
            this.center.x = d6 * (d10 - this.center.y) + d9;
        } else if (d3 == 0.0) {
            this.center.y = d10;
            this.center.x = d5 * (d8 - this.center.y) + d7;
        } else {
            this.center.x = (d5 * d6 * (d8 - d10) - d5 * d9 + d6 * d7) / (d6 - d5);
            this.center.y = d8 - (this.center.x - d7) / d5;
        }
        this.radius = this.center.distance(tPoint);
    }

    private void refreshCircle(ArrayList<DataPoint> arrayList) {
        double[] dArray = new double[arrayList.size() - 1];
        double[] dArray2 = new double[arrayList.size() - 1];
        double[] dArray3 = new double[arrayList.size() - 1];
        DataPoint dataPoint = null;
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        while (n < arrayList.size()) {
            DataPoint dataPoint2 = arrayList.get(n);
            if (n == 0) {
                dataPoint = dataPoint2;
            } else {
                dArray[n - 1] = dataPoint2.x - dataPoint.x;
                dArray2[n - 1] = dataPoint2.y - dataPoint.y;
                dArray3[n - 1] = dArray2[n - 1] / dArray[n - 1];
                if (n > 1) {
                    bl = bl && dArray[n - 1] == dArray[n - 2];
                    bl2 = bl2 && dArray3[n - 1] == dArray3[n - 2];
                }
            }
            ++n;
        }
        if (bl || bl2) {
            this.radius = Double.POSITIVE_INFINITY;
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        for (DataPoint dataPoint3 : arrayList) {
            double d10 = dataPoint3.x;
            d += d10;
            d3 += (d10 *= dataPoint3.x);
            d5 += (d10 *= dataPoint3.x);
            d10 = dataPoint3.y;
            d2 += d10;
            d4 += (d10 *= dataPoint3.y);
            d6 += (d10 *= dataPoint3.y);
            d10 = dataPoint3.x * dataPoint3.y;
            d7 += d10;
            d8 += d10 * dataPoint3.y;
            d9 += d10 * dataPoint3.x;
        }
        double d11 = arrayList.size();
        double d12 = d11 * d3 - d * d;
        double d13 = d11 * d7 - d * d2;
        double d14 = d11 * d4 - d2 * d2;
        double d15 = 0.5 * (d11 * d8 - d * d4 + d11 * d5 - d * d3);
        double d16 = 0.5 * (d11 * d9 - d2 * d3 + d11 * d6 - d2 * d4);
        double d17 = d12 * d14 - d13 * d13;
        double d18 = (d15 * d14 - d13 * d16) / d17;
        double d19 = (d12 * d16 - d13 * d15) / d17;
        this.center.setLocation(d18, d19);
        double d20 = 0.0;
        for (DataPoint dataPoint4 : arrayList) {
            double d21 = dataPoint4.x - d18;
            double d22 = dataPoint4.y - d19;
            d20 += Math.sqrt(d21 * d21 + d22 * d22);
        }
        this.radius = d20 / d11;
    }

    @Override
    public Object clone() {
        CircleFitterStep circleFitterStep = (CircleFitterStep)super.clone();
        if (circleFitterStep != null) {
            circleFitterStep.points[0] = circleFitterStep.center = new TPoint(this.center.getX(), this.center.getY());
            circleFitterStep.points[1] = circleFitterStep.edge = new TPoint(this.edge.getX(), this.edge.getY());
            TPoint[] tPointArray = circleFitterStep.points;
            CircleFitterStep circleFitterStep2 = circleFitterStep;
            circleFitterStep2.getClass();
            circleFitterStep.slider = circleFitterStep2.new Slider(this.slider.getX(), this.slider.getY());
            tPointArray[2] = circleFitterStep.slider;
            circleFitterStep.lineHitShapes = new HashMap<TrackerPanel, Shape>();
            circleFitterStep.pointHitShapes = new ArrayList();
            circleFitterStep.dataPoints = new ArrayList();
            for (DataPoint dataPoint : this.dataPoints) {
                circleFitterStep.dataPoints.add(new DataPoint(dataPoint.x, dataPoint.y));
            }
        }
        return circleFitterStep;
    }

    public void copy(CircleFitterStep circleFitterStep) {
        int n;
        if (this.dataPoints.size() != circleFitterStep.dataPoints.size()) {
            this.dataPoints.clear();
            n = 0;
            while (n < circleFitterStep.dataPoints.size()) {
                this.dataPoints.add(new DataPoint(0.0, 0.0));
                ++n;
            }
        }
        n = 0;
        while (n < circleFitterStep.dataPoints.size()) {
            DataPoint dataPoint = circleFitterStep.dataPoints.get(n);
            this.dataPoints.get(n).setLocation(dataPoint);
            ++n;
        }
        this.defaultIndex = this.dataPoints.size() - 1;
        double d = circleFitterStep.getSliderAngle();
        this.refreshCircle();
        this.setSliderAngle(d);
    }

    @Override
    public String toString() {
        return "CircleFitterStep " + this.n + " [center (" + this.center.x + ", " + this.center.y + "), radius " + this.radius + "]";
    }

    public static int getLength() {
        return 3;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class DataPoint
    extends TPoint {
        public DataPoint(double d, double d2) {
            super(d, d2);
            this.setStepEditTrigger(true);
        }

        public DataPoint(TPoint tPoint) {
            this(tPoint.x, tPoint.y);
        }

        @Override
        public void setXY(double d, double d2) {
            if (CircleFitterStep.this.track.locked) {
                return;
            }
            if (CircleFitterStep.this.circleFitter.isFixed()) {
                int n = 0;
                int n2 = 0;
                while (n2 < CircleFitterStep.this.dataPoints.size()) {
                    DataPoint dataPoint = CircleFitterStep.this.dataPoints.get(n2);
                    if (dataPoint == this) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                CircleFitterStep circleFitterStep = (CircleFitterStep)CircleFitterStep.this.circleFitter.steps.getStep(0);
                while (circleFitterStep.dataPoints.size() <= n) {
                    ArrayList<DataPoint> arrayList = circleFitterStep.dataPoints;
                    CircleFitterStep circleFitterStep2 = circleFitterStep;
                    circleFitterStep2.getClass();
                    arrayList.add(circleFitterStep2.new DataPoint(0.0, 0.0));
                }
                circleFitterStep.dataPoints.get(n).setLocation(d, d2);
                circleFitterStep.refreshCircle();
                CircleFitterStep.this.circleFitter.refreshStep(CircleFitterStep.this);
            } else {
                this.setLocation(d, d2);
                CircleFitterStep.this.circleFitter.keyFrames.add(CircleFitterStep.this.n);
                CircleFitterStep.this.refreshCircle();
            }
            CircleFitterStep.this.circleFitter.dataValid = false;
            CircleFitterStep.this.circleFitter.firePropertyChange("data", null, CircleFitterStep.this.circleFitter);
            if (CircleFitterStep.this.circleFitter.trackerPanel != null) {
                CircleFitterStep.this.circleFitter.trackerPanel.changed = true;
            }
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            CircleFitterStep circleFitterStep = (CircleFitterStep)object;
            double[][] dArray = new double[circleFitterStep.dataPoints.size()][2];
            int n = 0;
            while (n < dArray.length) {
                DataPoint dataPoint = circleFitterStep.dataPoints.get(n);
                double[] dArray2 = new double[]{dataPoint.x, dataPoint.y};
                dArray[n] = dArray2;
                ++n;
            }
            xMLControl.setValue("datapoints", dArray);
            double[] dArray3 = new double[]{circleFitterStep.slider.x, circleFitterStep.slider.y};
            xMLControl.setValue("slider", dArray3);
            if (circleFitterStep.circleFitter != null && !circleFitterStep.circleFitter.isFixed()) {
                xMLControl.setValue("iskey", circleFitterStep.circleFitter.keyFrames.contains(circleFitterStep.n));
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Object object2;
            int n;
            double[][] dArray;
            int n2;
            CircleFitterStep circleFitterStep = (CircleFitterStep)object;
            if (circleFitterStep.circleFitter != null && circleFitterStep.circleFitter.isFixed() && circleFitterStep.n != 0) {
                circleFitterStep = (CircleFitterStep)circleFitterStep.circleFitter.getStep(0);
            }
            if (circleFitterStep.circleFitter != null && !circleFitterStep.circleFitter.isFixed()) {
                boolean bl = xMLControl.getBoolean("iskey");
                if (bl) {
                    circleFitterStep.circleFitter.keyFrames.add(circleFitterStep.n);
                } else {
                    circleFitterStep.circleFitter.keyFrames.remove(circleFitterStep.n);
                }
            }
            if ((n2 = (dArray = (double[][])xMLControl.getObject("datapoints")).length - circleFitterStep.dataPoints.size()) < 0) {
                n = 0;
                while (n < -n2) {
                    circleFitterStep.removeDataPoint(circleFitterStep.dataPoints.get(circleFitterStep.dataPoints.size() - 1), false);
                    ++n;
                }
            } else if (n2 > 0) {
                n = 0;
                while (n < n2) {
                    object2 = dArray[dArray.length - 1 - n];
                    circleFitterStep.addDataPoint(object2[0], object2[1], false);
                    ++n;
                }
            }
            n = 0;
            while (n < dArray.length) {
                object2 = dArray[n];
                circleFitterStep.dataPoints.get(n).setLocation(object2[0], object2[1]);
                ++n;
            }
            double[] dArray2 = (double[])xMLControl.getObject("slider");
            circleFitterStep.refreshCircle();
            circleFitterStep.slider.setLocation(dArray2[0], dArray2[1]);
            if (circleFitterStep.circleFitter != null) {
                object2 = circleFitterStep;
                Runnable runnable = new Runnable((CircleFitterStep)object2){
                    private final /* synthetic */ CircleFitterStep val$cstep;
                    {
                        this.val$cstep = circleFitterStep;
                    }

                    @Override
                    public void run() {
                        this.val$cstep.circleFitter.dataValid = false;
                        this.val$cstep.circleFitter.firePropertyChange("data", null, null);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
            return object;
        }
    }

    class Slider
    extends TPoint {
        public Slider(double d, double d2) {
            super(d, d2);
            this.setStepEditTrigger(true);
        }

        @Override
        public void setXY(double d, double d2) {
            if (CircleFitterStep.this.circleFitter.isFixed()) {
                CircleFitterStep circleFitterStep = (CircleFitterStep)CircleFitterStep.this.circleFitter.steps.getStep(0);
                circleFitterStep.slider.setLocation(d, d2);
                Point point = circleFitterStep.slider.getScreenPosition(CircleFitterStep.this.circleFitter.trackerPanel);
                circleFitterStep.slider.setPositionOnCircle(point.x, point.y, CircleFitterStep.this.circleFitter.trackerPanel);
                CircleFitterStep.this.circleFitter.refreshStep(CircleFitterStep.this);
            } else {
                this.setLocation(d, d2);
                Point point = this.getScreenPosition(CircleFitterStep.this.circleFitter.trackerPanel);
                this.setPositionOnCircle(point.x, point.y, CircleFitterStep.this.circleFitter.trackerPanel);
            }
            CircleFitterStep.this.repaint();
            CircleFitterStep.this.circleFitter.refreshFields(CircleFitterStep.this.n);
            CircleFitterStep.this.circleFitter.dataValid = false;
            if (CircleFitterStep.this.circleFitter.trackerPanel != null) {
                CircleFitterStep.this.circleFitter.trackerPanel.changed = true;
            }
        }

        public void setPositionOnCircle(int n, int n2, TrackerPanel trackerPanel) {
            if (CircleFitterStep.this.circleFitter.isFixed() && CircleFitterStep.this.n != 0) {
                CircleFitterStep circleFitterStep = (CircleFitterStep)CircleFitterStep.this.circleFitter.steps.getStep(0);
                circleFitterStep.slider.setPositionOnCircle(n, n2, trackerPanel);
                return;
            }
            CircleFitterStep.this.circleFitter.keyFrames.add(CircleFitterStep.this.n);
            if (Double.isInfinite(CircleFitterStep.this.radius) || CircleFitterStep.this.radius > 100000.0) {
                if (CircleFitterStep.this.dataPoints.size() < 2) {
                    return;
                }
                double d = CircleFitterStep.this.dataPoints.get(1).getX() - CircleFitterStep.this.dataPoints.get(0).getX();
                double d2 = CircleFitterStep.this.dataPoints.get(1).getY() - CircleFitterStep.this.dataPoints.get(0).getY();
                double d3 = d2 / d;
                double d4 = 1000.0;
                if (d == 0.0) {
                    endPoint1.setLocation(CircleFitterStep.this.edge.x, CircleFitterStep.this.edge.y - d4);
                    endPoint2.setLocation(CircleFitterStep.this.edge.x, CircleFitterStep.this.edge.y + d4);
                } else if (Math.abs(d) > Math.abs(d2)) {
                    endPoint1.setLocation(CircleFitterStep.this.edge.x - d4, CircleFitterStep.this.edge.y - d3 * d4);
                    endPoint2.setLocation(CircleFitterStep.this.edge.x + d4, CircleFitterStep.this.edge.y + d3 * d4);
                } else {
                    endPoint1.setLocation(CircleFitterStep.this.edge.x - d4 / d3, CircleFitterStep.this.edge.y - d4);
                    endPoint2.setLocation(CircleFitterStep.this.edge.x + d4 / d3, CircleFitterStep.this.edge.y + d4);
                }
                this.setPositionOnLine(n, n2, trackerPanel, endPoint1, endPoint2);
                return;
            }
            if (this.screenPt == null) {
                this.screenPt = new Point();
            }
            if (this.worldPt == null) {
                this.worldPt = new Point2D.Double();
            }
            this.screenPt.setLocation(n, n2);
            AffineTransform affineTransform = trackerPanel.getPixelTransform();
            if (!trackerPanel.isDrawingInImageSpace()) {
                int n3 = this.getFrameNumber(trackerPanel);
                affineTransform.concatenate(trackerPanel.getCoords().getToWorldTransform(n3));
            }
            try {
                affineTransform.inverseTransform(this.screenPt, this.worldPt);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
            double d = CircleFitterStep.this.center.distance(this.worldPt);
            double d5 = this.worldPt.getX() - CircleFitterStep.this.center.getX();
            double d6 = this.worldPt.getY() - CircleFitterStep.this.center.getY();
            double d7 = CircleFitterStep.this.center.distance(CircleFitterStep.this.edge);
            double d8 = CircleFitterStep.this.center.getX() + d7 * d5 / d;
            double d9 = CircleFitterStep.this.center.getY() + d7 * d6 / d;
            this.setLocation(d8, d9);
            CircleFitterStep.this.repaint();
        }

        @Override
        public void setAdjusting(boolean bl) {
            boolean bl2 = this.isAdjusting();
            super.setAdjusting(bl);
            if (bl2 && !bl) {
                CircleFitterStep.this.circleFitter.firePropertyChange("data", null, CircleFitterStep.this.circleFitter);
            }
        }
    }
}

