/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.cabrillo.tracker.CenterOfMassInspector;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.PositionVectorFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;

public class CenterOfMass
extends PointMass {
    protected PointMass[] masses;
    protected ArrayList<String> massNames = new ArrayList();
    protected JMenuItem inspectorItem;
    protected DatasetManager newData;
    protected CenterOfMassInspector inspector;

    public CenterOfMass() {
        this(new PointMass[0]);
    }

    public CenterOfMass(PointMass[] pointMassArray) {
        this.defaultColors = new Color[]{new Color(51, 204, 51)};
        this.massField.setMinValue(0.0);
        this.setName(TrackerRes.getString("CenterOfMass.New.Name"));
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.Spot"), PointShapeFootprint.getFootprint("Footprint.SolidDiamond"), PointShapeFootprint.getFootprint("Footprint.SolidTriangle"), PointShapeFootprint.getFootprint("Footprint.SolidCircle"), PointShapeFootprint.getFootprint("Footprint.BoldVerticalLine"), PointShapeFootprint.getFootprint("Footprint.BoldHorizontalLine"), new PositionVectorFootprint(this, "Footprint.BoldPositionVector", 2)});
        this.defaultFootprint = this.getFootprint();
        this.masses = pointMassArray;
        this.setColor(this.defaultColors[0]);
        int n = 0;
        while (n < pointMassArray.length) {
            pointMassArray[n].addPropertyChangeListener(this);
            ++n;
        }
        this.locked = true;
        if (pointMassArray.length == 0) {
            this.hint = TrackerRes.getString("CenterOfMass.Empty.Hint");
        }
        this.update();
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.massNames.isEmpty() && drawingPanel instanceof TrackerPanel) {
            TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
            if (trackerPanel instanceof WorldTView) {
                trackerPanel = ((WorldTView)trackerPanel).getTrackerPanel();
            }
            ArrayList<PointMass> arrayList = trackerPanel.getDrawables(PointMass.class);
            for (String string : this.massNames) {
                for (PointMass pointMass : arrayList) {
                    if (!pointMass.getName().equals(string)) continue;
                    this.addMass(pointMass);
                }
            }
            this.massNames.clear();
        }
        super.draw(drawingPanel, graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMass(PointMass pointMass) {
        PointMass[] pointMassArray = this.masses;
        synchronized (this.masses) {
            int n = 0;
            while (n < this.masses.length) {
                if (this.masses[n] == pointMass) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                ++n;
            }
            PointMass[] pointMassArray2 = new PointMass[this.masses.length + 1];
            System.arraycopy(this.masses, 0, pointMassArray2, 0, this.masses.length);
            pointMassArray2[this.masses.length] = pointMass;
            this.masses = pointMassArray2;
            pointMass.addPropertyChangeListener(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.update();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMass(PointMass pointMass) {
        PointMass[] pointMassArray = this.masses;
        synchronized (this.masses) {
            int n = 0;
            while (n < this.masses.length) {
                if (this.masses[n] == pointMass) {
                    pointMass.removePropertyChangeListener(this);
                    PointMass[] pointMassArray2 = new PointMass[this.masses.length - 1];
                    System.arraycopy(this.masses, 0, pointMassArray2, 0, n);
                    System.arraycopy(this.masses, n + 1, pointMassArray2, n, pointMassArray2.length - n);
                    this.masses = pointMassArray2;
                    break;
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.update();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointMass[] getMasses() {
        PointMass[] pointMassArray = this.masses;
        synchronized (this.masses) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (PointMass[])this.masses.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsMass(PointMass pointMass) {
        PointMass[] pointMassArray = this.masses;
        synchronized (this.masses) {
            int n = 0;
            while (true) {
                if (n >= this.masses.length) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                if (this.masses[n] == pointMass) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                ++n;
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Interactive interactive = super.findInteractive(drawingPanel, n, n2);
        this.hint = interactive instanceof PositionStep.Position ? TrackerRes.getString("PointMass.Position.Locked.Hint") : (this.masses.length == 0 ? TrackerRes.getString("CenterOfMass.Empty.Hint") : null);
        return interactive;
    }

    @Override
    public void setFontLevel(int n) {
        super.setFontLevel(n);
        if (this.inspector != null && this.inspector.isVisible()) {
            this.inspector.setVisible(true);
        }
    }

    @Override
    public void setLocked(boolean bl) {
    }

    @Override
    public void setMass(double d) {
    }

    @Override
    public boolean isStepComplete(int n) {
        return true;
    }

    @Override
    public boolean isDependent() {
        return true;
    }

    @Override
    protected boolean isAutoTrackable() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TTrack tTrack;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("track") && propertyChangeEvent.getNewValue() == null && (tTrack = (TTrack)propertyChangeEvent.getOldValue()) instanceof PointMass) {
            this.removeMass((PointMass)tTrack);
        }
        if (propertyChangeEvent.getSource() instanceof PointMass) {
            if (string.equals("mass")) {
                this.update();
            } else if (string.equals("step")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                this.update(n, true);
            } else if (string.equals("steps")) {
                this.update();
            }
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        if (this.inspector != null) {
            this.inspector.dispose();
        }
    }

    private void update() {
        this.mass = 0.0;
        int n = this.getSteps().length;
        int n2 = 0;
        while (n2 < this.masses.length) {
            this.mass += this.masses[n2].getMass();
            n = Math.max(n, this.masses[n2].getSteps().length);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            this.update(n2, false);
            ++n2;
        }
        this.updateDerivatives();
        this.support.firePropertyChange("steps", null, null);
        this.repaint();
        if (this.inspector != null && this.inspector.isVisible()) {
            this.inspector.updateDisplay();
        }
    }

    private void update(int n, boolean bl) {
        if (this.mass == 0.0) {
            if (bl) {
                this.locked = false;
                this.deleteStep(n);
            } else {
                this.steps.setStep(n, null);
            }
            this.locked = true;
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < this.masses.length) {
            PositionStep positionStep = (PositionStep)this.masses[n2].getStep(n);
            if (positionStep == null) {
                if (this.getStep(n) != null) {
                    if (bl) {
                        this.locked = false;
                        Step step = this.deleteStep(n);
                        this.repaint(step);
                    } else {
                        this.steps.setStep(n, null);
                    }
                    this.locked = true;
                }
                return;
            }
            double d3 = this.masses[n2].getMass();
            d += d3 * positionStep.getPosition().getX();
            d2 += d3 * positionStep.getPosition().getY();
            ++n2;
        }
        d /= this.mass;
        d2 /= this.mass;
        PositionStep positionStep = (PositionStep)this.getStep(n);
        if (positionStep == null) {
            if (bl) {
                this.locked = false;
                positionStep = (PositionStep)this.createStep(n, d, d2);
                this.repaint(positionStep);
            } else {
                positionStep = new PositionStep(this, n, d, d2);
                this.steps.setStep(n, positionStep);
                positionStep.setFootprint(this.getFootprint());
            }
        } else if (bl) {
            this.locked = false;
            positionStep.getPosition().setXY(d, d2);
        } else {
            this.point.setLocation(d, d2);
            positionStep.getPosition().setPosition(this.point);
        }
        this.locked = true;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        this.inspectorItem = new JMenuItem(TrackerRes.getString("CenterOfMass.MenuItem.Inspector"));
        this.inspectorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CenterOfMassInspector centerOfMassInspector = CenterOfMass.this.getInspector();
                centerOfMassInspector.updateDisplay();
                centerOfMassInspector.setVisible(true);
            }
        });
        JMenu jMenu = super.getMenu(trackerPanel);
        jMenu.remove(this.lockedItem);
        jMenu.remove(this.autoAdvanceItem);
        jMenu.remove(this.markByDefaultItem);
        jMenu.insert(this.inspectorItem, 0);
        if (jMenu.getItemCount() > 1) {
            jMenu.insertSeparator(1);
        }
        JMenuItem jMenuItem = this.inspectorItem;
        int n = jMenu.getItemCount();
        int n2 = 1;
        while (n2 < n) {
            JMenuItem jMenuItem2 = jMenu.getItem(n2);
            if (jMenuItem2 == null && jMenuItem == null) {
                jMenu.remove(n2 - 1);
                --n2;
                --n;
            }
            jMenuItem = jMenuItem2;
            ++n2;
        }
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        this.massField.setEnabled(false);
        return arrayList;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint tPoint) {
        ArrayList<Component> arrayList = super.getToolbarPointComponents(trackerPanel, tPoint);
        this.xField.setEnabled(false);
        this.yField.setEnabled(false);
        return arrayList;
    }

    @Override
    public String toString() {
        return TrackerRes.getString("CenterOfMass.Name");
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public CenterOfMassInspector getInspector() {
        if (this.inspector == null) {
            this.inspector = new CenterOfMassInspector(this);
            this.inspector.setLocation(200, 200);
        }
        return this.inspector;
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            CenterOfMass centerOfMass = (CenterOfMass)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            PointMass[] pointMassArray = centerOfMass.getMasses();
            int n = 0;
            while (n < pointMassArray.length) {
                arrayList.add(pointMassArray[n].getName());
                ++n;
            }
            xMLControl.setValue("masses", arrayList);
            XML.getLoader(PointMass.class).saveObject(xMLControl, object);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new CenterOfMass();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            CenterOfMass centerOfMass = (CenterOfMass)object;
            XML.getLoader(PointMass.class).loadObject(xMLControl, object);
            Collection collection = (Collection)Collection.class.cast(xMLControl.getObject("masses"));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                centerOfMass.massNames.add((String)iterator.next());
            }
            return object;
        }
    }
}

