/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

public class BounceMatrix {
    private double[][] A;
    private int m;
    private int n;

    public BounceMatrix(int n, int n2) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
    }

    public BounceMatrix(double[][] dArray) {
        this.m = dArray.length;
        this.n = dArray[0].length;
        int n = 0;
        while (n < this.m) {
            if (dArray[n].length != this.n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            ++n;
        }
        this.A = dArray;
    }

    public BounceMatrix(double[][] dArray, int n, int n2) {
        this.A = dArray;
        this.m = n;
        this.n = n2;
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m][this.n];
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = this.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int n, int n2) {
        return this.A[n][n2];
    }

    public BounceMatrix getMatrix(int n, int n2, int n3, int n4) {
        BounceMatrix bounceMatrix = new BounceMatrix(n2 - n + 1, n4 - n3 + 1);
        double[][] dArray = bounceMatrix.getArray();
        try {
            int n5 = n;
            while (n5 <= n2) {
                int n6 = n3;
                while (n6 <= n4) {
                    dArray[n5 - n][n6 - n3] = this.A[n5][n6];
                    ++n6;
                }
                ++n5;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return bounceMatrix;
    }

    public BounceMatrix getMatrix(int[] nArray, int n, int n2) {
        BounceMatrix bounceMatrix = new BounceMatrix(nArray.length, n2 - n + 1);
        double[][] dArray = bounceMatrix.getArray();
        try {
            int n3 = 0;
            while (n3 < nArray.length) {
                int n4 = n;
                while (n4 <= n2) {
                    dArray[n3][n4 - n] = this.A[nArray[n3]][n4];
                    ++n4;
                }
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return bounceMatrix;
    }

    public BounceMatrix minus(BounceMatrix bounceMatrix) {
        if (bounceMatrix.m != this.m || bounceMatrix.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
        BounceMatrix bounceMatrix2 = new BounceMatrix(this.m, this.n);
        double[][] dArray = bounceMatrix2.getArray();
        int n = 0;
        while (n < this.m) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray[n][n2] = this.A[n][n2] - bounceMatrix.A[n][n2];
                ++n2;
            }
            ++n;
        }
        return bounceMatrix2;
    }

    public BounceMatrix times(BounceMatrix bounceMatrix) {
        if (bounceMatrix.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        BounceMatrix bounceMatrix2 = new BounceMatrix(this.m, bounceMatrix.n);
        double[][] dArray = bounceMatrix2.getArray();
        double[] dArray2 = new double[this.n];
        int n = 0;
        while (n < bounceMatrix.n) {
            int n2 = 0;
            while (n2 < this.n) {
                dArray2[n2] = bounceMatrix.A[n2][n];
                ++n2;
            }
            n2 = 0;
            while (n2 < this.m) {
                double[] dArray3 = this.A[n2];
                double d = 0.0;
                int n3 = 0;
                while (n3 < this.n) {
                    d += dArray3[n3] * dArray2[n3];
                    ++n3;
                }
                dArray[n2][n] = d;
                ++n2;
            }
            ++n;
        }
        return bounceMatrix2;
    }

    public BounceMatrix solve(BounceMatrix bounceMatrix) {
        return this.m == this.n ? new LUDecomposition(this).solve(bounceMatrix) : new QRDecomposition(this).solve(bounceMatrix);
    }

    public BounceMatrix inverse() {
        return this.solve(BounceMatrix.identity(this.m, this.m));
    }

    public static BounceMatrix identity(int n, int n2) {
        BounceMatrix bounceMatrix = new BounceMatrix(n, n2);
        double[][] dArray = bounceMatrix.getArray();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[n3][n4] = n3 == n4 ? 1.0 : 0.0;
                ++n4;
            }
            ++n3;
        }
        return bounceMatrix;
    }

    static class LUDecomposition {
        private double[][] LU;
        private int m;
        private int n;
        private int pivsign;
        private int[] piv;

        public LUDecomposition(BounceMatrix bounceMatrix) {
            this.LU = bounceMatrix.getArrayCopy();
            this.m = bounceMatrix.getRowDimension();
            this.n = bounceMatrix.getColumnDimension();
            this.piv = new int[this.m];
            int n = 0;
            while (n < this.m) {
                this.piv[n] = n;
                ++n;
            }
            this.pivsign = 1;
            double[] dArray = new double[this.m];
            int n2 = 0;
            while (n2 < this.n) {
                double d;
                int n3;
                int n4 = 0;
                while (n4 < this.m) {
                    dArray[n4] = this.LU[n4][n2];
                    ++n4;
                }
                n4 = 0;
                while (n4 < this.m) {
                    double[] dArray2 = this.LU[n4];
                    n3 = Math.min(n4, n2);
                    d = 0.0;
                    int n5 = 0;
                    while (n5 < n3) {
                        d += dArray2[n5] * dArray[n5];
                        ++n5;
                    }
                    int n6 = n4++;
                    double d2 = dArray[n6] - d;
                    dArray[n6] = d2;
                    dArray2[n2] = d2;
                }
                n4 = n2;
                n3 = n2 + 1;
                while (n3 < this.m) {
                    if (Math.abs(dArray[n3]) > Math.abs(dArray[n4])) {
                        n4 = n3;
                    }
                    ++n3;
                }
                if (n4 != n2) {
                    n3 = 0;
                    while (n3 < this.n) {
                        d = this.LU[n4][n3];
                        this.LU[n4][n3] = this.LU[n2][n3];
                        this.LU[n2][n3] = d;
                        ++n3;
                    }
                    n3 = this.piv[n4];
                    this.piv[n4] = this.piv[n2];
                    this.piv[n2] = n3;
                    this.pivsign = -this.pivsign;
                }
                if (n2 < this.m & this.LU[n2][n2] != 0.0) {
                    n3 = n2 + 1;
                    while (n3 < this.m) {
                        double[] dArray3 = this.LU[n3];
                        int n7 = n2;
                        dArray3[n7] = dArray3[n7] / this.LU[n2][n2];
                        ++n3;
                    }
                }
                ++n2;
            }
        }

        public boolean isNonsingular() {
            int n = 0;
            while (n < this.n) {
                if (this.LU[n][n] == 0.0) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public BounceMatrix solve(BounceMatrix bounceMatrix) {
            int n;
            int n2;
            if (bounceMatrix.getRowDimension() != this.m) {
                throw new IllegalArgumentException("Matrix row dimensions must agree.");
            }
            if (!this.isNonsingular()) {
                throw new RuntimeException("Matrix is singular.");
            }
            int n3 = bounceMatrix.getColumnDimension();
            BounceMatrix bounceMatrix2 = bounceMatrix.getMatrix(this.piv, 0, n3 - 1);
            double[][] dArray = bounceMatrix2.getArray();
            int n4 = 0;
            while (n4 < this.n) {
                n2 = n4 + 1;
                while (n2 < this.n) {
                    n = 0;
                    while (n < n3) {
                        double[] dArray2 = dArray[n2];
                        int n5 = n;
                        dArray2[n5] = dArray2[n5] - dArray[n4][n] * this.LU[n2][n4];
                        ++n;
                    }
                    ++n2;
                }
                ++n4;
            }
            n4 = this.n - 1;
            while (n4 >= 0) {
                n2 = 0;
                while (n2 < n3) {
                    double[] dArray3 = dArray[n4];
                    int n6 = n2++;
                    dArray3[n6] = dArray3[n6] / this.LU[n4][n4];
                }
                n2 = 0;
                while (n2 < n4) {
                    n = 0;
                    while (n < n3) {
                        double[] dArray4 = dArray[n2];
                        int n7 = n;
                        dArray4[n7] = dArray4[n7] - dArray[n4][n] * this.LU[n2][n4];
                        ++n;
                    }
                    ++n2;
                }
                --n4;
            }
            return bounceMatrix2;
        }
    }

    static class QRDecomposition {
        private double[][] QR;
        private int m;
        private int n;
        private double[] Rdiag;

        public QRDecomposition(BounceMatrix bounceMatrix) {
            this.QR = bounceMatrix.getArrayCopy();
            this.m = bounceMatrix.getRowDimension();
            this.n = bounceMatrix.getColumnDimension();
            this.Rdiag = new double[this.n];
            int n = 0;
            while (n < this.n) {
                double d = 0.0;
                int n2 = n;
                while (n2 < this.m) {
                    d = this.hypot(d, this.QR[n2][n]);
                    ++n2;
                }
                if (d != 0.0) {
                    if (this.QR[n][n] < 0.0) {
                        d = -d;
                    }
                    n2 = n;
                    while (n2 < this.m) {
                        double[] dArray = this.QR[n2];
                        int n3 = n;
                        dArray[n3] = dArray[n3] / d;
                        ++n2;
                    }
                    double[] dArray = this.QR[n];
                    int n4 = n;
                    dArray[n4] = dArray[n4] + 1.0;
                    n2 = n + 1;
                    while (n2 < this.n) {
                        double d2 = 0.0;
                        int n5 = n;
                        while (n5 < this.m) {
                            d2 += this.QR[n5][n] * this.QR[n5][n2];
                            ++n5;
                        }
                        d2 = -d2 / this.QR[n][n];
                        n5 = n;
                        while (n5 < this.m) {
                            double[] dArray2 = this.QR[n5];
                            int n6 = n2;
                            dArray2[n6] = dArray2[n6] + d2 * this.QR[n5][n];
                            ++n5;
                        }
                        ++n2;
                    }
                }
                this.Rdiag[n] = -d;
                ++n;
            }
        }

        public boolean isFullRank() {
            int n = 0;
            while (n < this.n) {
                if (this.Rdiag[n] == 0.0) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public BounceMatrix solve(BounceMatrix bounceMatrix) {
            int n;
            if (bounceMatrix.getRowDimension() != this.m) {
                throw new IllegalArgumentException("Matrix row dimensions must agree.");
            }
            if (!this.isFullRank()) {
                throw new RuntimeException("Matrix is rank deficient.");
            }
            int n2 = bounceMatrix.getColumnDimension();
            double[][] dArray = bounceMatrix.getArrayCopy();
            int n3 = 0;
            while (n3 < this.n) {
                n = 0;
                while (n < n2) {
                    double d = 0.0;
                    int n4 = n3;
                    while (n4 < this.m) {
                        d += this.QR[n4][n3] * dArray[n4][n];
                        ++n4;
                    }
                    d = -d / this.QR[n3][n3];
                    n4 = n3;
                    while (n4 < this.m) {
                        double[] dArray2 = dArray[n4];
                        int n5 = n;
                        dArray2[n5] = dArray2[n5] + d * this.QR[n4][n3];
                        ++n4;
                    }
                    ++n;
                }
                ++n3;
            }
            n3 = this.n - 1;
            while (n3 >= 0) {
                n = 0;
                while (n < n2) {
                    double[] dArray3 = dArray[n3];
                    int n6 = n++;
                    dArray3[n6] = dArray3[n6] / this.Rdiag[n3];
                }
                n = 0;
                while (n < n3) {
                    int n7 = 0;
                    while (n7 < n2) {
                        double[] dArray4 = dArray[n];
                        int n8 = n7;
                        dArray4[n8] = dArray4[n8] - dArray[n3][n7] * this.QR[n][n3];
                        ++n7;
                    }
                    ++n;
                }
                --n3;
            }
            return new BounceMatrix(dArray, this.n, n2).getMatrix(0, this.n - 1, 0, n2 - 1);
        }

        public double hypot(double d, double d2) {
            double d3;
            if (Math.abs(d) > Math.abs(d2)) {
                d3 = d2 / d;
                d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
            } else if (d2 != 0.0) {
                d3 = d / d2;
                d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
            } else {
                d3 = 0.0;
            }
            return d3;
        }
    }
}

