---@type Ellyb
local Ellyb = Ellyb(...);

if Ellyb.Enum then
	return
end

local Enum = {};
Ellyb.Enum = Enum;

Enum.CHARS = {
	NON_BREAKING_SPACE = " "
}

Enum.UI_ESCAPE_SEQUENCES = {
	CLOSE = "|r",
	COLOR = "|c%.2x%.2x%.2x%.2x",
}

Enum.ITEM_QUALITY = {
	POOR = LE_ITEM_QUALITY_POOR,
	COMMON = LE_ITEM_QUALITY_COMMON,
	UNCOMMON = LE_ITEM_QUALITY_UNCOMMON,
	RARE = LE_ITEM_QUALITY_RARE,
	EPIC = LE_ITEM_QUALITY_EPIC,
	LEGENDARY = LE_ITEM_QUALITY_LEGENDARY,
	ARTIFACT = LE_ITEM_QUALITY_ARTIFACT,
	HEIRLOOM = LE_ITEM_QUALITY_HEIRLOOM,
	WOW_TOKEN = LE_ITEM_QUALITY_WOW_TOKEN,
}

Enum.CLASSES = {
	HUNTER = "HUNTER",
	WARLOCK = "WARLOCK",
	PRIEST = "PRIEST",
	PALADIN = "PALADIN",
	MAGE = "MAGE",
	ROGUE = "ROGUE",
	DRUID = "DRUID",
	SHAMAN = "SHAMAN",
	WARRIOR = "WARRIOR",
	DEATHKNIGHT = "DEATHKNIGHT",
	MONK = "MONK",
	DEMONHUNTER = "DEMONHUNTER",
}

Enum.LOCALES = {
	FRENCH = "frFR",
	ENGLISH = "enUS",
}

Enum.GAME_CLIENT_TYPES = {
	RETAIL = WOW_PROJECT_MAINLINE,
	CLASSIC = WOW_PROJECT_CLASSIC
}