TheoryCraft_Version = "1.07.1"
TheoryCraft_DataVersion = "1.06"

-- All types mentioned in this file refer to the following:
-- Variable Name:	Description:
-- Frost		The amount of +dam exclusive to this school (eg from frozen wrath items)
-- Frostcritchance	Bonus crit chance exclusive to this school (eg from critical mass, for fire)
-- Frostcritbonus	The crit multiplier, above base. (base is 1.5, so ice shards would make Frostcritbonus 0.5 for a total of 1)
-- Frostmodifier	Any % bonuses that need to be applied specific to the frost school, eg piercing ice would make this 0.06
-- Frostmanacost	A multiplier to change the mana cost of spells of this school by. 
--			Nothing should affect this, as wow includes talents effecting mana cost in the tooltip already. 
--			Only gets used when testing talents, eg frost chanelling (which would make this value -0.15 at top rank)
-- Frosthitchance	Increased chance to hit with spells of this school, eg Arcane Focus. A value of 1 increases it by 1%, not 100%
-- Frostcasttime	A flat modifier to be applied to spells of this school. Eg -0.5 reduces the cast time of all spells of this
--			school by 0.5. Once again only gets used when testing talents, and usually by spells put in their own school.
--			Eg, I have a school called fireball which only fireball is part of, to receive the bonus by improved fireball
--			when testing talents
-- Frostbaseincrease	Used internally only. It multiplies the base spell read off the tooltip by this amount.
--			Used for testing things like Piercing ice, when the player has a different number of points in it.
--			Any changes to Frostmodifier through testing talents will automatically change this to suit.
--			Eg if you have piercing ice rank 3, which increases the values on the tooltip by 6%, and you attempt to test
--			a talent build with 0 in piercing ice... Theorycraft will automatically set Frostbaseincrease to 1/1.06.
-- There is one school common to all spells, called All.  Eg Allcritchance is crit chance for all spells.

-- All talents are read from here. 
-- Variable Name:	Description:
-- class		The class player that the talent applies to, eg "Mage"
-- name			What the user types in to set the talent to a forced rank, for testing
-- bonustype		What variable the talent affects, from one of the above schools. Eg for arcane focus, you would modify 
--			Arcanehitchance	by 10. Other modifiable properties are ICPercent (effect by spirit during 5 second rule) and
--			manamultiplier (increases your effective mana pool, eg clearcasting)
-- tree			The tree the talent is in, left most tree is 1, right most 3
-- number		The talent number.  Starting from the top left most talent, count across the rows until you get to the talent
--			to get its number
-- perrank		How much to add (or remove if negative) from the bonustype per rank
-- firstrank		If there is a first rank then the first rank of the talent gets this bonus, every further rank perrank

TheoryCraft_Talents = {
	{ class="MAGE", name="subtlety", bonustype="Arcanethreat", tree=1, number=1, perrank=-0.2 },
	{ class="MAGE", name="subtlety", bonustype="Allpenetration", tree=1, number=1, perrank=5, dontlist=1 },
	{ class="MAGE", name="focus", bonustype="Arcanehitchance", tree=1, number=2, perrank=2 },
	{ class="MAGE", name="clearcast", bonustype="clearcast", tree=1, number=6, perrank=0.02 },
	{ class="MAGE", name="impae", bonustype="Arcane Explosioncritchance", tree=1, number=8, perrank=2 },
	{ class="MAGE", name="meditation", bonustype="ICPercent", tree=1, number=12, perrank=0.05 },
	{ class="MAGE", name="arcanemind", bonustype="manamultiplier", tree=1, number=14, perrank=0.02 },
	{ class="MAGE", name="instab", bonustype="Damagemodifier", tree=1, number=15, perrank=0.01 },
	{ class="MAGE", name="instab", bonustype="Allcritchance", tree=1, number=15, perrank=1, dontlist=1 },
	{ class="MAGE", name="impfire", bonustype="Fireballcasttime", tree=2, number=1, perrank=-0.1, forceonly=1 },
	{ class="MAGE", name="ignite", bonustype="Firecritbonus", tree=2, number=3, perrank=0.12 },
	{ class="MAGE", name="ignite", bonustype="Firesepignite", tree=2, number=3, perrank=0.12, dontlist=1 },
	{ class="MAGE", name="incinerate", bonustype="Incineratecritchance", tree=2, number=6, perrank=2 },
	{ class="MAGE", name="impflame", bonustype="Flamestrikecritchance", tree=2, number=7, perrank=5 },
	{ class="MAGE", name="burnsoul", bonustype="Firethreat", tree=2, number=9, perrank=-0.15 },
	{ class="MAGE", name="masterofelements", bonustype="Fireillum", tree=2, number=12, perrank=0.1 },
	{ class="MAGE", name="masterofelements", bonustype="Frostillum", tree=2, number=12, perrank=0.1, dontlist=1 },
	{ class="MAGE", name="critmass", bonustype="Firecritchance", tree=2, number=13, perrank=2 },
	{ class="MAGE", name="firepower", bonustype="Firemodifier", tree=2, number=15, perrank=0.02 },
	{ class="MAGE", name="impfrost", bonustype="Frostboltcasttime", tree=3, number=2, perrank=-0.1, forceonly=1 },
	{ class="MAGE", name="elemprec", bonustype="Frosthitchance", tree=3, number=3, perrank=2 },
	{ class="MAGE", name="elemprec", bonustype="Firehitchance", tree=3, number=3, perrank=2, dontlist=1 },
	{ class="MAGE", name="shards", bonustype="Frostcritbonus", tree=3, number=4, perrank=0.1 },
	{ class="MAGE", name="piercice", bonustype="Frostmodifier", tree=3, number=8, perrank=0.02 },
	{ class="MAGE", name="chanelling", bonustype="Frostmanacost", tree=3, number=12, perrank=-0.05, forceonly=1 },
	{ class="MAGE", name="chanelling", bonustype="Frostthreat", tree=3, number=12, perrank=-0.1, dontlist=1 },
	{ class="MAGE", name="shatter", bonustype="Allshatter", tree=3, number=13, perrank=10 },
	{ class="MAGE", name="impcoc", bonustype="Cone of Coldmodifier", tree=3, number=15, firstrank=0.15, perrank=0.10 },

	{ class="WARLOCK", name="suppression", bonustype="Afflictionhitchance", tree=1, number=1, perrank=2 },
	{ class="WARLOCK", name="impcorrupt", bonustype="Corruptioncasttime", tree=1, number=2, perrank=-0.4, forceonly=1 },
	{ class="WARLOCK", name="impdrainlife", bonustype="Drain Lifemodifier", tree=1, number=6, perrank=0.02 },
	{ class="WARLOCK", name="impcoa", bonustype="Curse of Agonymodifier", tree=1, number=7, perrank=0.02 },
	{ class="WARLOCK", name="shadowmastery", bonustype="Shadowmodifier", tree=1, number=16, perrank=0.02 },
	{ class="WARLOCK", name="demonicembrace", bonustype="stammultiplier", tree=2, number=3, perrank=0.03 },
	{ class="WARLOCK", name="demonicembrace", bonustype="spiritmultiplier", tree=2, number=3, perrank=-0.01, dontlist=1 },
	{ class="WARLOCK", name="devastation", bonustype="Destructioncritchance", tree=3, number=7, perrank=1 },
	{ class="WARLOCK", name="impsearing", bonustype="Searing Paincritchance", tree=3, number=11, perrank=2 },
	{ class="WARLOCK", name="impimmolate", bonustype="ImmolateUpFrontmodifier", tree=3, number=13, perrank=0.05 },
	{ class="WARLOCK", name="ruin", bonustype="Destructioncritbonus", tree=3, number=14, perrank=0.5 },
	{ class="WARLOCK", name="emberstorm", bonustype="Firemodifier", tree=3, number=15, perrank=0.02 },

	{ class="PRIEST", name="imppwrword", bonustype="Power Word: Shieldmodifier", tree=1, number=5, perrank=0.05 },
	{ class="PRIEST", name="pmeditation", bonustype="ICPercent", tree=1, number=8, perrank=0.05 },
	{ class="PRIEST", name="mentalagility", bonustype="MentalAgilitymanacost", tree=1, number=10, perrank=-0.02, forceonly=1 },
	{ class="PRIEST", name="mentalstrength", bonustype="manamultiplier", tree=1, number=12, perrank=0.02 },
	{ class="PRIEST", name="forceofwill", bonustype="Damagemodifier", tree=1, number=14, perrank=0.01 },
	{ class="PRIEST", name="forceofwill", bonustype="Damagecritchance", tree=1, number=14, perrank=1, dontlist=1 },
	{ class="PRIEST", name="imprenew", bonustype="Renewmodifier", tree=2, number=2, perrank=0.05 },
	{ class="PRIEST", name="holyspec", bonustype="Holycritchance", tree=2, number=3, perrank=1 },
	{ class="PRIEST", name="divinefury", bonustype="Divinefurycasttime", tree=2, number=5, perrank=-0.1, forceonly=1 },
	{ class="PRIEST", name="imphealing", bonustype="ImpHealingmanacost", tree=2, number=10, perrank=-0.05, forceonly=1 },
	{ class="PRIEST", name="searinglight", bonustype="SearingLightmodifier", tree=2, number=11, perrank=0.05 },
	{ class="PRIEST", name="imppoh", bonustype="Prayer of Healingmanacost", tree=2, number=12, perrank=-0.1, forceonly=1, forcetree=3 },
	{ class="PRIEST", name="guidance", bonustype="Allspiritual", tree=2, number=14, perrank=0.05 },
	{ class="PRIEST", name="spiritual", bonustype="Healingmodifier", tree=2, number=15, perrank=0.02 },
	{ class="PRIEST", name="shadowfocus", bonustype="Shadowhitchance", tree=3, number=5, perrank=2 },
	{ class="PRIEST", name="darkness", bonustype="Shadowmodifier", tree=3, number=15, perrank=0.02 },

	{ class="DRUID", name="impwrath", bonustype="Wrathcasttime", tree=1, number=1, perrank=-0.1, forceonly=1 },
	{ class="DRUID", name="impmoon", bonustype="Moonfiremodifier", tree=1, number=5, perrank=0.02 },
	{ class="DRUID", name="impmoon", bonustype="Moonfirecritchance", tree=1, number=5, perrank=2, dontlist=1 },
	{ class="DRUID", name="natweapons", bonustype="Meleemodifier", tree=1, number=6, perrank=0.02, forcetree=2 },
	{ class="DRUID", name="vengeance", bonustype="Vengeancecritbonus", tree=1, number=11, perrank=0.1 },
	{ class="DRUID", name="impstarfire", bonustype="Starfirecasttime", tree=1, number=12, perrank=-0.1, forceonly=1 },
	{ class="DRUID", name="grace", bonustype="Allgrace", tree=1, number=13, perrank=0.5 },
	{ class="DRUID", name="moonfury", bonustype="Vengeancemodifier", tree=1, number=15, perrank=0.02 },
	{ class="DRUID", name="claws", bonustype="Formcritchance", tree=2, number=8, perrank=2 },
	{ class="DRUID", name="strikes", bonustype="Predatory", tree=2, number=10, perrank=0.5 },
	{ class="DRUID", name="savagefury", bonustype="Savagefurymodifier", tree=2, number=13, perrank=0.1 },
	{ class="DRUID", name="hotw", bonustype="HotW", tree=2, number=15, perrank=0.04 },
	{ class="DRUID", name="hotw", bonustype="intmultiplier", tree=2, number=15, perrank=0.04, dontlist=1 },
	{ class="DRUID", name="imptouch", bonustype="Healing Touchcasttime", tree=3, number=3, perrank=-0.1, forceonly=1 },
	{ class="DRUID", name="reflection", bonustype="ICPercent", tree=3, number=6, perrank=0.05 },
	{ class="DRUID", name="tranquil", bonustype="Healing Touchmanacost", tree=3, number=9, perrank=-0.02, forceonly=1 },
	{ class="DRUID", name="tranquil", bonustype="Tranquilitymanacost", tree=3, number=9, perrank=-0.02, forceonly=1, dontlist=1 },
	{ class="DRUID", name="imprejuve", bonustype="Rejuvenationmodifier", tree=3, number=10, perrank=0.05 },
	{ class="DRUID", name="giftofnat", bonustype="Healingmodifier", tree=3, number=12, perrank=0.02 },
	{ class="DRUID", name="impregrowth", bonustype="Regrowthcritchance", tree=3, number=14, perrank=10 },

	{ class="ROGUE", name="malice", bonustype="CritReport", tree=1, number=3, perrank=1 },
	{ class="ROGUE", name="lethality", bonustype="Lethalitycritbonus", tree=1, number=9, perrank=0.06 },
	{ class="ROGUE", name="impbs", bonustype="Backstabcritchance", tree=2, number=4, perrank=10 },
	{ class="ROGUE", name="daggerspec", bonustype="Daggerspec", tree=2, number=11, perrank=1 },
	{ class="ROGUE", name="fistspec", bonustype="Fistspec", tree=2, number=16, perrank=1 },
	{ class="ROGUE", name="aggression", bonustype="Sinister Strikemodifier", tree=2, number=18, perrank=0.02 },
	{ class="ROGUE", name="opportunity", bonustype="Backstabmodifier", tree=3, number=5, perrank=0.04 },
	{ class="ROGUE", name="opportunity", bonustype="Ambushmodifier", tree=3, number=5, perrank=0.04, dontlist=1 },
	{ class="ROGUE", name="impambush", bonustype="Ambushcritchance", tree=3, number=9, perrank=15 },

	{ class="WARRIOR", name="impoverpower", bonustype="Overpowercritchance", tree=1, number=7, perrank=25 },
	{ class="WARRIOR", name="impale", bonustype="Meleecritbonus", tree=1, number=11, perrank=0.1 },
	{ class="WARRIOR", name="twohandspec", bonustype="Twohandmodifier", tree=1, number=10, perrank=0.01 },
	{ class="WARRIOR", name="axespec", bonustype="Axespec", tree=1, number=12, perrank=1 },
	{ class="WARRIOR", name="polearmspec", bonustype="Polearmspec", tree=1, number=16, perrank=1 },
	{ class="WARRIOR", name="cruelty", bonustype="CritReport", tree=2, number=2, perrank=1 },
	{ class="WARRIOR", name="onehandspec", bonustype="Onehandmodifier", tree=3, number=16, perrank=0.02 },

	{ class="PALADIN", name="divinestrength", bonustype="strmultiplier", tree=1, number=1, perrank=0.02 },
	{ class="PALADIN", name="divineint", bonustype="intmultiplier", tree=1, number=2, perrank=0.02 },
	{ class="PALADIN", name="illumination", bonustype="Holyillum", tree=1, number=9, perrank=0.2 },
	{ class="PALADIN", name="holypower", bonustype="Holycritchance", tree=1, number=13, perrank=1 },
	{ class="PALADIN", name="onehandspec", bonustype="Onehandmodifier", tree=2, number=14, perrank=0.02 },
	{ class="PALADIN", name="conviction", bonustype="CritReport", tree=3, number=7, perrank=1 },

	{ class="SHAMAN", name="convection", bonustype="Shockmanacost", tree=1, number=1, perrank=0.02, forceonly=1 },
	{ class="SHAMAN", name="convection", bonustype="Lightningmanacost", tree=1, number=1, perrank=0.02, forceonly=1, dontlist=1 },
	{ class="SHAMAN", name="concussion", bonustype="Shockmodifier", tree=1, number=2, perrank=0.01 },
	{ class="SHAMAN", name="concussion", bonustype="Lightningmodifier", tree=1, number=2, perrank=0.01, dontlist=1 },
	{ class="SHAMAN", name="elemfocus", bonustype="clearcast", tree=1, number=6, perrank=0.1 },
	{ class="SHAMAN", name="callofthunder", bonustype="Lightningcritchance", tree=1, number=8, perrank=1.2 },
	{ class="SHAMAN", name="fury", bonustype="Shockcritbonus", tree=1, number=13, perrank=0.5 },
	{ class="SHAMAN", name="fury", bonustype="Lightningcritbonus", tree=1, number=13, perrank=0.5, dontlist=1 },
	{ class="SHAMAN", name="lightningmast", bonustype="Lightningcasttime", tree=1, number=14, perrank=-0.2, forceonly=1 },
	{ class="SHAMAN", name="ancestral", bonustype="manamultiplier", tree=2, number=1, perrank=0.01 },
	{ class="SHAMAN", name="thundering", bonustype="CritReport", tree=2, number=4, perrank=1 },
	{ class="SHAMAN", name="impls", bonustype="Lightning Shieldmodifier", tree=2, number=6, perrank=0.05 },
	{ class="SHAMAN", name="weaponmast", bonustype="Meleemodifier", tree=2, number=15, perrank=0.02 },
	{ class="SHAMAN", name="imphealingwave", bonustype="Healing Wavecasttime", tree=3, number=1, perrank=-0.1, forceonly=1 },
	{ class="SHAMAN", name="tidalfocus", bonustype="Healingmanacost", tree=3, number=2, perrank=-0.01, forceonly=1 },
	{ class="SHAMAN", name="natguid", bonustype="Allhitchance", tree=3, number=6, perrank=1 },
	{ class="SHAMAN", name="tidalmastery", bonustype="Lightningcritchance", tree=3, number=11, perrank=1 },
	{ class="SHAMAN", name="tidalmastery", bonustype="Healingcritchance", tree=3, number=11, perrank=1, dontlist=1 },
	{ class="SHAMAN", name="purification", bonustype="Healingmodifier", tree=3, number=14, perrank=0.03 },

	{ class="HUNTER", name="lethalshots", bonustype="Rangedcritchance", tree=2, number=4, perrank=1 },
	{ class="HUNTER", name="lethalshots", bonustype="Huntercritchance", tree=2, number=4, perrank=1, dontlist=1 },
	{ class="HUNTER", name="mortalshots", bonustype="Rangedcritbonus", tree=2, number=9, perrank=0.06 },
	{ class="HUNTER", name="mortalshots", bonustype="Huntercritbonus", tree=2, number=9, perrank=0.06, dontlist=1 },
	{ class="HUNTER", name="barrage", bonustype="Barragemodifier", tree=2, number=11, perrank=0.05 },
	{ class="HUNTER", name="barrage", bonustype="Barragetalent", tree=2, number=11, perrank=0.05, dontlist=1 },
	{ class="HUNTER", name="rws", bonustype="Rangedmodifier", tree=2, number=13, perrank=0.01 },
	{ class="HUNTER", name="rws", bonustype="Huntermodifier", tree=2, number=13, perrank=0.01, dontlist=1 },
	{ class="HUNTER", name="monsterslaying", bonustype="monsterslaying", tree=3, number=1, perrank=0.01, dontlist=1 },
	{ class="HUNTER", name="humanoidslaying", bonustype="humanoidslaying", tree=3, number=2, perrank=0.01, dontlist=1 },
	{ class="HUNTER", name="savagestrikes", bonustype="Raptor Strikecritchance", tree=3, number=5, perrank=10 },
	{ class="HUNTER", name="survivalist", bonustype="healthmultiplier", tree=3, number=8, perrank=0.02 },
	{ class="HUNTER", name="killerinstinct", bonustype="CritReport", tree=3, number=13, perrank=1 },
	{ class="HUNTER", name="reflexes", bonustype="agimultiplier", tree=3, number=15, perrank=0.03 },
}

-- All spells are read from here
-- Variable Name:	Description:
-- me			The name of the spell.  Has to match what's on the tooltip... sadly doesn't work with spells that require
-- id			The id of the spell, this later gets looked up and fills in your languages name from the above table
-- percent		The +damage modifier of that spell.  As a general rule it's cast time divided by 3.5, however that rarely
--			holds true.  AoE's get 1/3 of the above rule.
-- isdot		Stops talents from affecting the +damage amount (dots don't benefit from % talents)
-- dodps		Whether to perform DPS calculations or not.
-- cancrit		Self explanatory
-- Schools		A table that contains the names of all the schools the spell belongs to. All the bonuses to the spell get added
--			from these schools
-- aoe			Slightly changes the tooltip description
-- percentdot		The +damage modifier of the DoT component
-- hasdot		Checks for dot and applies the percentdot component
-- To disable any of the above parameters, simply delete it from that spell.. to enable it, set it to any value

TheoryCraft_Spells = {
	["MAGE"] = {
		{ id="Frostbolt", binary=1, level1=4, level2=8, level3=14, level4=60, level1per=1.5/3, level2per=1.8/3, level3per=2.2/3, level4per=2.6/3, percent=3/3.5*0.95, dodps=1, cancrit=1,
			Schools={ "All", "Damage", "Frost" } },
		{ id="Frost Nova", binary=1, level1=10, percent=1.5/3.5/3*0.2, cancrit=1, dontdomax=1, dodps=1,
			Schools={ "All", "Damage", "Frost" } },
		{ id="Cone of Cold", binary=1, percent=1.5/3.5/3*0.895, cancrit=1, dodps=1, aoe=1, dontdomax=1,
			Schools={ "All", "Damage", "Frost" } },
		{ id="Blizzard", percent=1/3, dodps=1, aoe=1, casttime=8, regencasttime=8, tickinterval=1,
			Schools={ "All", "Damage", "Frost" } },
		{ id="Arcane Explosion", level1=14, percent=1.5/3.5/3, cancrit=1, dodps=1, aoe=1,
			Schools={ "All", "Damage", "Arcane" } },
		{ id="Arcane Missiles", level1=8, level1manamult=1/3, level2=16, level2manamult=1/4, percent=1.2/5, dodps=1, manamultiplier=1/5, cancrit=1, casttime=1, regencasttime=1, tickinterval=1,
			Schools={ "All", "Damage", "Arcane" } },
		{ id="Fire Blast", level1=6, level2=14, percent=1.5/3.5, cancrit=1, dodps=1, dontdomax=1,
			Schools={ "All", "Damage", "Fire", "Incinerate" } },
		{ id="Fireball", level1=1, level2=6, level3=12, level4=18, level1per=1.5/3.5, level2per=2/3.5, level3per=2.5/3.5, level4per=3/3.5, percent=1, dodps=1, cancrit=1,
			Schools={ "All", "Damage", "Fire" } },
		{ id="Pyroblast", percent=1, percentdot=0.7, dodps=1, cancrit=1, hasdot=1, dontdomax=1,
			Schools={ "All", "Damage", "Fire" } },
		{ id="Scorch", percent=1.5/3.5, dodps=1, cancrit=1,
			Schools={ "All", "Damage", "Fire", "Incinerate" } },
		{ id="Blast Wave", binary=1, percent=1.5/3.5/3*0.895, dodps=1, cancrit=1, aoe=1, dontdomax=1,
			Schools={ "All", "Damage", "Fire" } },
		{ id="Flamestrike", level1=16, percent=3/3.5/3*0.7*0.95, percentdot=3/3.5/3*0.3*0.95, cancrit=1, dodps=1, aoe=1, hasdot=1,
			Schools={ "All", "Damage", "Fire" } },
		{ id="Ice Barrier", isheal=1, percent=0.1, dodps=1, dontdomax=1, talentsbeforegear=1,
			Schools={ "All", "Damage", "Frost" } },
		{ id="Evocation", evocation=1,
			Schools={ } },
		{ id="Shoot", shoot=1, isranged=1, cancrit=1,
			Schools={ } },
		},
	["WARLOCK"] = {
		{ id="Shadow Bolt", level1=1, level1per=1.7/3, level2=6, level2per=2.2/3, level3=12, level3per=2.8/3, percent=3/3.5, dodps=1, cancrit=1,
			Schools={ "All", "Damage", "Shadow", "Destruction" } },
		{ id="Soul Fire", percent=1, cancrit=1, dodps=1, dontdomax=1,
			Schools={ "All", "Damage", "Fire", "Destruction" } },
		{ id="Searing Pain", level1=18, percent=1.5/3.5, dodps=1, cancrit=1,
			Schools={ "All", "Damage", "Fire", "Destruction" } },
		{ id="Immolate", level1=1, level2=10, percent=0.198, percentdot=0.653, dodps=1, cancrit=1, hasdot=1, tickinterval=3,
			Schools={ "All", "Damage", "Fire", "Destruction" } },
--		{ id="Firebolt", percent=0, dodps=1, cancrit=1, petspell=1, showmore=1,
--			Schools={ } },
--		{ id="Lash of Pain", percent=0, dodps=1, overcooldown=1, cancrit=1, petspell=1, showmore=1, dontdomax=1,
--			Schools={ } },
		{ id="Conflagrate", percent=1.5/3.5, dodps=1, cancrit=1, dontdomax=1,
			Schools={ "All", "Damage", "Fire", "Destruction" } },
		{ id="Rain of Fire", percent=1/3, dodps=1, aoe=1, casttime=8, regencasttime=8, tickinterval=2,
			Schools={ "All", "Damage", "Fire", "Destruction" } },
		{ id="Hellfire", percent=1/3.5/3*0.22, dodps=1, aoe=1, casttime=1, regencasttime=15, hellfire=1, tickinterval=1, manamultiplier=1/15,
			Schools={ "All", "Damage", "Fire", "Destruction" } },
		{ id="Corruption", percent=1, dodps=1, basedotduration=18, dontdomax=1, isdot=1, tickinterval=3,
			Schools={ "All", "Damage", "Shadow", "Affliction" } },
		{ id="Curse of Agony", level1=8, level2=18, isdot=1, percent=1, dodps=1, basedotduration=24, dontdomax=1, coa=1, talentsbeforegear=1, 
			Schools={ "All", "Damage", "Shadow", "Affliction" } },
		{ id="Curse of Doom", isdot=1, percent=1, dodps=1, basedotduration=60, dontdomax=1, talentsbeforegear=1,
			Schools={ "All", "Damage", "Shadow", "Affliction" } },
		{ id="Drain Soul", level1=10, percent=0.5, dodps=1, casttime=15, regencasttime=15, isdot=1, tickinterval=3,
			Schools={ "All", "Damage", "Shadow", "Affliction" } },
		{ id="Siphon Life", percent=1/20, dodps=1, casttime=3, regencasttime=1.5, manamultiplier=1/10, tickinterval=3, dontdomax=1, drain=1, talentsbeforegear=1, dontdpsafterresists=1, 
			Schools={ "All", "Damage", "Shadow", "Affliction" } },
		{ id="Drain Life", level1=14, percent=1/10, dodps=1, casttime=1, regencasttime=1, manamultiplier=1/5, tickinterval=1, drain=1, talentsbeforegear=1, dontdpsafterresists=1, -- old percent=1/3.5*0.36
			Schools={ "All", "Damage", "Shadow", "Affliction" } },
		{ id="Death Coil", percent=1.5/3.5*0.5, dodps=1, deathcoil=1, dontdomax=1, drain=1, talentsbeforegear=1,
			Schools={ "All", "Damage", "Shadow", "Affliction" } },
		{ id="Shadowburn", percent=1.5/3.5, cancrit=1, dodps=1, dontdomax=1,
			Schools={ "All", "Damage", "Shadow", "Destruction" } },
		{ id="Shoot", shoot=1, isranged=1, cancrit=1,
			Schools={ } },
		},
	["PRIEST"] = {
		{ id="Prayer of Healing", isheal=1, percent=3/3.5/3, dodps=1, cancrit=1, prayerofhealing=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "Holy" } },
		{ id="Shadow Word: Pain", level1=4, level2=10, level3=18, percent=1, dodps=1, basedotduration=18, dontdomax=1, isdot=1,
			Schools={ "All", "Damage", "Shadow", "MentalAgility" } },
		{ id="Mind Flay", percent=0.457, dodps=1, casttime=3, regencasttime=3,
			Schools={ "All", "Damage", "Shadow", } },
		{ id="Mind Blast", level1=10, level2=16, percent=1.5/3.5, dodps=1, cancrit=1, dontdomax=1,
			Schools={ "All", "Damage", "Shadow" } },
		{ id="Smite", level1=1, level2=6, level3=14, level1per=1.5/3.5, level2per=2/3.5, percent=2.5/3.5, dodps=1, cancrit=1,
			Schools={ "All", "Damage", "Holy", "Divinefury", "SearingLight" } },
		{ id="Holy Fire", percent=0.75, percentdot=0.25, dodps=1, cancrit=1, hasdot=1,
			Schools={ "All", "Damage", "Holy", "Divinefury", "SearingLight" } },
		{ id="Holy Nova", percent=1.5/3.5/3*0.8, percentheal=0.11, dodps=1, cancrit=1, holynova=1,
			Schools={ "All", "Damage", "Holy", "MentalAgility" } },
		{ id="Power Word: Shield", isheal=1, percent=0.1, dodps=1, dontdomax=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "MentalAgility" } },
		{ id="Desperate Prayer", isheal=1, percent=1.5/3.5, dodps=1, dontdomax=1, cancrit=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "Holy" } },
		{ id="Lesser Heal", level1=1, level1per=2.1/3.5, level2=4, level2per=2.9/3.5, level3=10, percent=2.51/3.5, isheal=1, dodps=1, cancrit=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "Holy", "ImpHealing" } },
		{ id="Heal", level1=16, percent=3/3.5, isheal=1, dodps=1, cancrit=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "Holy", "Divinefury", "ImpHealing" } },
		{ id="Flash Heal", percent=1.5/3.5, isheal=1, dodps=1, cancrit=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "Holy" } },
		{ id="Greater Heal", percent=3/3.5, isheal=1, dodps=1, cancrit=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "Holy", "Divinefury", "ImpHealing" } },
		{ id="Devouring Plague", binary=1, percent=1/2, isdot=1, dodps=1, basedotduration=24, dontdomax=1,
			Schools={ "All", "Damage", "Shadow", "MentalAgility" } },
		{ id="Renew", level1=8, level2=14, percent=1, dodps=1, isheal=1, basedotduration=15, dontdomax=1, isdot=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "Holy", "MentalAgility" } },
		{ id="Starshards", level1=10, level2=18, percent=1, dodps=1, casttime=6, regencasttime=6, starshards=1,
			Schools={ "All", "Damage", "Arcane" } },
		{ id="Shoot", shoot=1, isranged=1, cancrit=1,
			Schools={ } },
		},
	["DRUID"] = {
		{ id="Healing Touch", level1=1, level1per=1.5/3.5, level2=8, level2per=2/3.5, level3=14, level3per=2.5/3.5, level4per=3/3.5, percent=1, dodps=1, isheal=1, cancrit=1, talentsbeforegear=1, 
			Schools={ "All", "Healing", "Restoration" } },
		{ id="Tranquility", percent=1/3/5, dodps=1, isheal=1, casttime=2, regencasttime=2, manamultiplier=1/5, tickinterval=2, dontdomax=1, talentsbeforegear=1, dontdomax=1,
			Schools={ "All", "Healing", "Restoration" } },
		{ id="Rejuvenation", level1=4, level2=10, level3=16, percent=0.8, dodps=1, isheal=1, basedotduration=12, dontdomax=1, tickinterval=3, isdot=1, talentsbeforegear=1, 
			Schools={ "All", "Healing", "Restoration" } },
		{ id="Regrowth", level1=12, level2=18, percent=0.325, percentdot=0.513, dodps=1, isheal=1, cancrit=1, hasdot=1, tickinterval=3, talentsbeforegear=1, 
			Schools={ "All", "Healing", "Restoration" } },
		{ id="Starfire", talentsbeforegear=1, percent=1, dodps=1, cancrit=1,
			Schools={ "All", "Damage", "Arcane", "Vengeance" } },
		{ id="Wrath", talentsbeforegear=1, level1=1, level1per=1.5/2, level2=6, level2per=1.7/2, level3=14, percent=2/3.5, dodps=1, cancrit=1,
			Schools={ "All", "Damage", "Nature", "Vengeance" } },
		{ id="Insect Swarm", percent=0.95, dodps=1, dontdomax=1, insectswarm=1, basedotduration=12, tickinterval=2, isdot=1,
			Schools={ "All", "Damage", "Nature" } },
		{ id="Entangling Roots", level1=8, level2=18, percent=1.5/3.5*0.75, dodps=1, dontdomax=1, basedotduration=24, isdot=1, tickinterval=3,
			Schools={ "All", "Damage", "Nature" } },
		{ id="Moonfire", talentsbeforegear=1, level1=4, level2=10, level3=16, percent=0.2, percentdot=2/3.5, dodps=1, cancrit=1, hasdot=1, tickinterval=3,
			Schools={ "All", "Damage", "Arcane", "Vengeance" } },
		{ id="Hurricane", talentsbeforegear=1, percent=0.03, dodps=1, casttime=1, regencasttime=1, manamultiplier=1/10, tickinterval=1, dontdomax=1,
			Schools={ "All", "Damage", "Nature" } },
		{ id="Ravage", ismelee=1, cancrit=1, catform=1, armor=1,
			Schools={ "Melee" } },
		{ id="Shred", ismelee=1, cancrit=1, catform=1, armor=1,
			Schools={ "Melee" } },
		{ id="Claw", ismelee=1, cancrit=1, catform=1, armor=1,
			Schools={ "Melee", "Savagefury" } },
		{ id="Maul", nextattack=1, ismelee=1, cancrit=1, bearform=1, armor=1,
			Schools={ "Melee", "Savagefury" } },
		{ id="Ferocious Bite", ismelee=1, cancrit=1, iscombo=1, armor=1,
			Schools={ "Melee" } },
		{ id="Swipe", ismelee=1, cancrit=1, noscale=1, armor=1,
			Schools={ "Melee", "Savagefury" } },
		},
	["WARRIOR"] = {
		{ id="Mortal Strike", ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee" } },
		{ id="Bloodthirst", ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee" } },
		{ id="Overpower", ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee" } },
		{ id="Whirlwind", ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee" } },
		{ id="Heroic Strike", nextattack=1, ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee" } },
		{ id="Cleave", nextattack=1, ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee" } },
		{ id="Thunder Clap", cancrit=1, noscale=1, armor=1, ismelee=1, dontusemelee=1,
			Schools={ "Melee" } },
		{ id="Shield Slam", cancrit=1, armor=1, ismelee=1, forcemult=2.2,
			Schools={ "Melee" } },
		{ id="Mocking Blow", ismelee=1, cancrit=1, noscale=1, armor=1,
			Schools={ "Melee" } },
		{ id="Block", ismelee=1, block=1, armor=1,
			Schools={ } },
		},
	["ROGUE"] = {
		{ id="Sinister Strike", ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee", "Lethality" } },
		{ id="Hemorrhage", ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee", "Lethality" } },
		{ id="Backstab", ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee", "Lethality" } },
		{ id="Ghostly Strike", ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee", "Lethality" } },
		{ id="Ambush", ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee" } },
		{ id="Riposte",  ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee" } },
		{ id="Eviscerate", ismelee=1, cancrit=1, iscombo=1, armor=1,
			Schools={ "Melee" } },
		},
	["PALADIN"] = {
		{ id="Flash of Light", percent=1.5/3.5, isheal=1, dodps=1, cancrit=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "Holy" } },
		{ id="Holy Light", level1=1, level2=6, level3=14, percent=2.5/3.5, isheal=1, dodps=1, cancrit=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "Holy" } },
		{ id="Exorcism", percent=1.5/3.5, dodps=1, cancrit=1, dontdomax=1,
			Schools={ "All", "Damage", "Holy" } },
		{ id="Holy Wrath", percent=2/3.5/3, dodps=1, cancrit=1, aoe=1, dontdomax=1,
			Schools={ "All", "Damage", "Holy" } },
		{ id="Consecration", percent=1/3, dodps=1, aoe=1, basedotduration=8, dontdomax=1, isdot=1,
			Schools={ "All", "Damage", "Holy" } },
		{ id="Hammer of Wrath", percent=1.5/3.5, dodps=1, dontdomax=1, cancrit=1, usemelee=1,
			Schools={ "All", "Damage", "Holy" } },
		{ id="Seal of Command", isseal=1, percent=1.5/3.5, percentdot=1.5/3.5/2, hasdot=1, command=1, dodps=1,
			Schools={ "All", "Damage", "Holy" } },
		{ id="Seal of Righteousness", isseal=1, percent=0.1, percent2=0.12, percentdot=0.5, hasdot=1, righteousness=1, dodps=1,
			Schools={ "All", "Damage", "Holy" } },
		{ id="Holy Shock", percent=1.5/3.5, percentheal=1.5/3.5, cancrit=1, holynova=1, dontdomax=1, dodps=1,
			Schools={ "All", "Damage", "Holy" } },
		{ id="Seal of the Crusader", isseal=1, percent=0, crusader=1, dodps=1, dontresist=1,
			Schools={} },
		},
	["SHAMAN"] = {
		{ id="Chain Lightning", percent=2.5/3.5, dodps=1, cancrit=1, aoe=1, dontdomax=1,
			Schools={ "All", "Nature", "Damage", "Lightning" } },
		{ id="Lightning Bolt", level1=1, level1per=1.5/3, level2=8, level2per=2/3, level3=14, level3per=2.5/3, percent=3/3.5, dodps=1, cancrit=1,
			Schools={ "All", "Nature", "Damage", "Lightning" } },
		{ id="Lesser Healing Wave", percent=1.5/3.5, isheal=1, dodps=1, cancrit=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "EarthfuryBonus" } },
		{ id="Healing Wave", level1=1, level1per=1.5/3, level2=6, level2per=2/3, level3=12, level3per=2.5/3, level4=18, percent=3/3.5, isheal=1, dodps=1, cancrit=1, talentsbeforegear=1,
			Schools={ "All", "Healing", "EarthfuryBonus" } },
		{ id="Chain Heal", percent=2.5/3.5, isheal=1, dodps=1, cancrit=1, aoe=1, talentsbeforegear=1,
			Schools={ "All", "Healing" } },
		{ id="Earth Shock", binary=1, level1=4, level2=8, level3=14, percent=1.5/3.5*0.95, dodps=1, cancrit=1, dontdomax=1,
			Schools={ "All", "Damage", "Nature", "Shock" } },
		{ id="Flame Shock", level1=10, level2=18, percent=1.5/3.5/2, percentdot=1.5/3.5, dodps=1, cancrit=1, hasdot=1, dontdomax=1,
			Schools={ "All", "Damage", "Fire", "Shock" } },
		{ id="Frost Shock", binary=1, percent=1.5/3.5*0.95, dodps=1, cancrit=1, dontdomax=1,
			Schools={ "All", "Damage", "Frost", "Shock" } },
		{ id="Lightning Shield", percent=0.26844, dontdomax=1, lightningshield=1, talentsbeforegear=1, dontdpsafterresists=1, manamultiplier=1/3,
			Schools={ "All", "Damage", "Nature" } },
		{ id="Magma Totem", percent=1/3/10, dontdomax=1, manamultiplier=1/10, lightningshield=1,
			Schools={ "All", "Damage", "Fire" } },
		{ id="Searing Totem", percent=0.08, cancrit=1, dontdomax=1, manamultiplier=1/10, lightningshield=1,
			Schools={ "All", "Damage", "Fire" } },
		{ id="Healing Stream Totem", percent=0.022, isheal=1, dontdomax=1, manamultiplier=1/10, lightningshield=1,
			Schools={ "All", "Healing" } },
		},
	["HUNTER"] = {
--		{ id="Attack", autoattack=1, ismelee=1, cancrit=1, nextattack=1,
--			Schools={ "Melee" } },
		{ id="Mend Pet", level1=12, percent=1/5, dodps=1, manamultiplier=1/5, casttime=1, regencasttime=1, tickinterval=1, isheal=1, talentsbeforegear=1,
			Schools={ "All", "Damage", "Arcane" } },
		{ id="Arcane Shot", percent=1.5/3.5, dodps=1, cancrit=1, dontdomax=1, overcooldown=1,
			Schools={ "All", "Damage", "Arcane", "Hunter" } },
		{ id="Volley", percent=1/3/6, dodps=1, casttime=1, regencasttime=1, manamultiplier=1/6, tickinterval=1, dontdomax=1,
			Schools={ "All", "Damage", "Arcane", "Hunter", "Barrage" } },
		{ id="Serpent Sting", percent=1, dodps=1, isdot=1, dontdomax=1, basedotduration=15,
			Schools={ "All", "Damage", "Nature" } },
		{ id="Raptor Strike", nextattack=1, ismelee=1, cancrit=1, armor=1,
			Schools={ "Melee" } },
		{ id="Multi-Shot", isranged=1, cancrit=1, armor=1,
			Schools={ "Ranged", "Barrage" } },
		{ id="Aimed Shot", isranged=1, cancrit=1, armor=1,
			Schools={ "Ranged" } },
		{ id="Scatter Shot", isranged=1, cancrit=1, armor=1,
			Schools={ "Ranged" } },
		{ id="Auto Shot", autoshot=1, isranged=1, cancrit=1, armor=1,
			Schools={ "Ranged" } },
		},
}

-- Agi per crit, Int per crit, Base Melee, Base Spell

do

local nakedint = 85
local nakedcc = 3.6
local fullint = 336
local fullcc = 8.798

TheoryCraft_CritChance = {
	["HUNTER"] 	= { 52.91, 20, 0, 0 }, --0.3634
	["ROGUE"] 	= { 29, 20, 0, 0 },
	["WARRIOR"] 	= { 20, 20, 0, 0 },

	["MAGE"] 	= { 20, 59.5, 0, 0.2 },
	["PRIEST"] 	= { 20, 59.5, 0, 0.8 },
	["WARLOCK"] 	= { 20, 60.6, 0, 1.7 },
	["DRUID"] 	= { 20, 60, 0.9, 1.8 },

	["PALADIN"] 	= { 20, 29.5, 0.75, 0 },
	["SHAMAN"] 	= { 20, 59.2, 0, 2.3 },
}

local setwear = { "Finger0", "Finger1", "Trinket0", "Neck", "Trinket1", "Back", "MainHand", "SecondaryHand", 
		  "Ranged", "Tabard", "Ammo" }
local setdestat=  { "Head", "Shoulder", "Chest", "Waist", "Legs", "Feet", "Wrist", "Hands" }
local setweartier3 = { "Finger1", "Trinket0", "Neck", "Trinket1", "Back", "MainHand", "SecondaryHand", 
		  "Ranged", "Tabard", "Ammo" }
local setdestattier3 =  { "Finger0", "Head", "Shoulder", "Chest", "Waist", "Legs", "Feet", "Wrist", "Hands" }
local setwearaq = { "Finger1", "Trinket0", "Neck", "Trinket1", "Back", "MainHand", "SecondaryHand", "Wrist",
		  "Ranged", "Tabard", "Ammo", "Waist", "Hands" }
local setdestataq =  { "Head", "Shoulder", "Chest", "Legs", "Feet" }

TheoryCraft_Outfits = { 
	{ 
			name = "Equipped",
			wear = { "Head", "Neck", "Shoulder", "Chest", "Waist", "Legs", "Feet", "Wrist",
				 "Hands", "Finger0", "Finger1", "Trinket0", "Trinket1", "Back", "MainHand", 
				 "SecondaryHand", "Ranged", "Tabard", "Ammo" },
			destat = {},
			newstat = {},
			strength = 0,
			agility = 0,
			stamina = 0,
			intellect = 0,
			spirit = 0,
	},
	{
			name = "Custom",
			shortname = "Custom...",
			wear = { "Ammo" },
			destat = { "Head", "Neck", "Shoulder", "Chest", "Waist", "Legs", "Feet", "Wrist",
				 "Hands", "Finger0", "Finger1", "Trinket0", "Trinket1", "Back", "MainHand", 
				 "SecondaryHand", "Ranged", "Tabard" },
	},
	{ 
			name = "Naked",
			wear = {},
			destat = { "Head", "Neck", "Shoulder", "Chest", "Waist", "Legs", "Feet", "Wrist",
				 "Hands", "Finger0", "Finger1", "Trinket0", "Trinket1", "Back", "MainHand", 
				 "SecondaryHand", "Ranged", "Tabard", "Ammo" },
			newstat = {},
			strength = 0,
			agility = 0,
			stamina = 0,
			intellect = 0,
			spirit = 0,
	},
	{ 
			class = "MAGE",
			name = "Magisters",
			wear = setwear,
			destat = setdestat,
			newstat = { },
			stamina = 66,
			intellect = 167,
			spirit = 79,
	},
	{ 
			class = "MAGE",
			name = "Sorcerers",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 107},
				    {type = "Allcritchance", amount = 1},
				    {type = "Allhitchance", amount = 1},
				    {type = "Allpenetration", amount = 20},
				  },
			stamina = 104,
			intellect = 145,
			spirit = 72,
	},
	{ 
			class = "MAGE",
			name = "Arcanist",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 128}, 
				    {type = "manaperfive", amount = 11},
				    {type = "Allcritchance", amount = 2},
				    {type = "Allhitchance", amount = 1},
				  },
			stamina = 109,
			intellect = 160,
			spirit = 72,
	},
	{ 
			class = "MAGE",
			name = "Netherwind",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 204}, 
				    {type = "manaperfive", amount = 12},
				    {type = "Allcritchance", amount = 3},
				  },
			stamina = 116,
			intellect = 159,
			spirit = 69,
	},
	{
			class = "MAGE",
			name = "Enigma",
			wear = setwearaq,
			destat = setdestataq,
			newstat = { {type = "All", amount = 164},
				    {type = "Allhitchance", amount = 1},
				    {type = "Allcritchance", amount = 3},
				    {type = "Allpenetration", amount = 30},
				    {type = "manaperfive", amount = 13},
				  },
			stamina = 95,
			intellect = 100,
			spirit = 37,
	},
	{
			class = "MAGE",
			name = "Frostfire",
			wear = setweartier3,
			destat = setdestattier3,
			newstat = { {type = "All", amount = 305}, 
				    {type = "Allhitchance", amount = 5},
				    {type = "Allcritchance", amount = 5},
				  },
			stamina = 162,
			intellect = 178,
			spirit = 61,
	},
	{ 
			class = "WARLOCK",
			name = "Dreadmist",
			wear = setwear,
			destat = setdestat,
			newstat = { },
			stamina = 114,
			intellect = 118,
			spirit = 95,
	},
	{ 
			class = "WARLOCK",
			name = "Deathmist",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 101}, 
				    {type = "Allcritchance", amount = 1}, 
				    {type = "Allhitchance", amount = 2}, 
				  },
			stamina = 157,
			intellect = 138,
	},
	{ 
			class = "WARLOCK",
			name = "Felheart",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 132}, 
				    {type = "Allcritchance", amount = 1},
				    {type = "Allhitchance", amount = 1},
				  },
			stamina = 180,
			intellect = 128,
			spirit = 51,
	},
	{ 
			class = "WARLOCK",
			name = "Nemesis",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 204}, 
				    {type = "Allcritchance", amount = 3},
				  },
			stamina = 171,
			intellect = 112,
			spirit = 42,
	},
	{
			class = "WARLOCK",
			name = "Doomcaller",
			wear = setwearaq,
			destat = setdestataq,
			newstat = { {type = "All", amount = 164},
				    {type = "Allhitchance", amount = 2},
				    {type = "Allcritchance", amount = 3},
				    {type = "Allpenetration", amount = 40},
				  },
			stamina = 118,
			intellect = 92,
			spirit = 29,
	},
	{
			class = "WARLOCK",
			name = "Plagueheart",
			wear = setweartier3,
			destat = setdestattier3,
			newstat = { {type = "All", amount = 292},
				    {type = "Allcritchance", amount = 6},
				    {type = "Allhitchance", amount = 4},
				  },
			stamina = 227,
			intellect = 155,
	},
	{ 
			class = "PRIEST",
			name = "Devout",
			wear = setwear,
			destat = setdestat,
			newstat = { },
			stamina = 71,
			intellect = 134,
			spirit = 115,
	},
	{ 
			class = "PRIEST",
			name = "Virtuous",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 97}, 
				    {type = "Allcritchance", amount = 1}, 
				    {type = "manaperfive", amount = 27}, 
				  },
			stamina = 108,
			intellect = 115,
			spirit = 96,
	},
	{ 
			class = "PRIEST",
			name = "Prophecy",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 30}, 
				    {type = "Healing", amount = 104},
				    {type = "manaperfive", amount = 18},
				  },
			stamina = 113,
			intellect = 170,
			spirit = 117,
	},
	{
			class = "PRIEST",
			name = "Transcendence",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "Healing", amount = 300},
				    {type = "Allcritchance", amount = 1},
				    {type = "manaperfive", amount = 7},
				  },
			stamina = 114,
			intellect = 176,
			spirit = 127,
	},
	{
			class = "PRIEST",
			name = "Oracle",
			wear = setwearaq,
			destat = setdestataq,
			newstat = { {type = "All", amount = 138},
				    {type = "Allhitchance", amount = 1},
				    {type = "Allcritchance", amount = 1},
				    {type = "Allpenetration", amount = 20},
				    {type = "manaperfive", amount = 19},
				  },
			stamina = 109,
			intellect = 109,
			spirit = 65,
	},
	{ 
			class = "PRIEST",
			name = "Faith",
			wear = setweartier3,
			destat = setdestattier3,
			newstat = { {type = "Healing", amount = 496},
				    {type = "manaperfive", amount = 19},
				  },
			stamina = 154,
			intellect = 188,
			spirit = 171,
	},
	{ 
			class = "DRUID",
			name = "Wildheart",
			wear = setwear,
			destat = setdestat,
			newstat = { },
			attackpower = 26,
			strength = 26,
			agility = 12,
			stamina = 65,
			intellect = 122,
			spirit = 110,
	},
	{ 
			class = "DRUID",
			name = "Feralheart",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 77}, 
				    {type = "manaperfive", amount = 8}, 
				  },
			attackpower = 26,
			strength = 86,
			agility = 64,
			stamina = 95,
			intellect = 112,
			spirit = 85,
	},
	{ 
			class = "DRUID",
			name = "Cenarion",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "Healing", amount = 98},
				    {type = "All", amount = 27}, 
				    {type = "manaperfive", amount = 18},
				    {type = "Allcritchance", amount = 1},
				  },
			stamina = 136,
			intellect = 158,
			spirit = 112,
	},
	{
			class = "DRUID",
			name = "Stormrage",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "Healing", amount = 275},
				    {type = "manaperfive", amount = 20},
				    {type = "Allcritchance", amount = 2},
				  },
			stamina = 122,
			intellect = 177,
			spirit = 103,
	},
	{
			class = "DRUID",
			name = "Genesis",
			wear = setwearaq,
			destat = setdestataq,
			newstat = { {type = "All", amount = 122},
				    {type = "Allcritchance", amount = 1},
				    {type = "Allpenetration", amount = 10},
				    {type = "manaperfive", amount = 11},
				    {type = "CritReport", amount = 3},
				  },
			meleecritchance = 3,
			agility = 63,
			stamina = 97,
			intellect = 95,
			spirit = 44,
			strength = 67,
	},
	{
			class = "DRUID",
			name = "Dreamwalker",
			wear = setweartier3,
			destat = setdestattier3,
			newstat = { {type = "Healing", amount = 457},
				    {type = "manaperfive", amount = 35},
				  },
			stamina = 174,
			intellect = 205,
			spirit = 130,
	},
	{ 
			class = "SHAMAN",
			name = "Elements",
			wear = setwear,
			destat = setdestat,
			newstat = { },
			stamina = 64,
			intellect = 110,
			spirit = 108,
	},
	{ 
			class = "SHAMAN",
			name = "Five Thunders",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 95},
				    {type = "Allcritchance", amount = 2},
				    {type = "manaperfive", amount = 12},
				  },
			stamina = 113,
			intellect = 112,
			spirit = 73,
	},
	{ 
			class = "SHAMAN",
			name = "Earthfury",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 27},
				    {type = "Healing", amount = 98},
				    {type = "manaperfive", amount = 20},
				    {type = "Allcritchance", amount = 2},
				  },
			stamina = 127,
			intellect = 148,
			spirit = 112,
	},
	{
			class = "SHAMAN",
			name = "Ten Storms",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 89},
				    {type = "Healing", amount = 59},
				    {type = "manaperfive", amount = 12},
				    {type = "Allcritchance", amount = 4},
				  },
			stamina = 134,
			intellect = 157,
			spirit = 105,
	},
	{
			class = "SHAMAN",
			name = "Stormcaller",
			wear = setwearaq,
			destat = setdestataq,
			newstat = { {type = "All", amount = 143},
				    {type = "manaperfive", amount = 11},
				    {type = "Allcritchance", amount = 3},
				    {type = "Allpenetration", amount = 10},
				    {type = "CritReport", amount = 1},
				  },
			meleecritchance = 1,
			agility = 46,
			strength = 57,
			stamina = 97,
			intellect = 95,
			spirit = 47,
	},
	{
			class = "SHAMAN",
			name = "Earthshatter",
			wear = setweartier3,
			destat = setdestattier3,
			newstat = { {type = "Healing", amount = 412},
				    {type = "manaperfive", amount = 64},
				  },
			stamina = 194,
			intellect = 226,
	},
	{ 
			class = "PALADIN",
			name = "Lightforge",
			wear = setwear,
			destat = setdestat,
			newstat = { },
			attackpower = 40,
			strength = 94,
			agility = 22,
			stamina = 116,
			intellect = 68,
			spirit = 69,
	},
	{ 
			class = "PALADIN",
			name = "Soulforge",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 94}, 
				    {type = "Allcritchance", amount = 1},
				    {type = "CritReport", amount = 2},
				    {type = "manaperfive", amount = 12},
				  },
			meleecritchance = 2,
			attackpower = 40,
			strength = 98,
			stamina = 106,
			intellect = 104,
			spirit = 44,
	},
	{ 
			class = "PALADIN",
			name = "Lawbringer",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "Healing", amount = 138},
				    {type = "manaperfive", amount = 13},
				  },
			meleecritchance = 1,
			strength = 74,
			stamina = 153,
			intellect = 134,
			spirit = 92,
	},
	{ 
			class = "PALADIN",
			name = "Judgement",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "All", amount = 153}, 
				    {type = "manaperfive", amount = 20},
				  },
			strength = 92,
			stamina = 155,
			intellect = 148,
			spirit = 50,
	},
	{
			class = "PALADIN",
			name = "Avenger",
			wear = setwearaq,
			destat = setdestataq,
			newstat = { {type = "All", amount = 85},
				    {type = "Allcritchance", amount = 1},
				    {type = "manaperfive", amount = 11},
				    {type = "CritReport", amount = 3},
				  },
			meleecritchance = 3,
			agility = 63,
			stamina = 101,
			intellect = 95,
			spirit = 44,
			strength = 100,
	},
	{ 
			class = "PALADIN",
			name = "Redemption",
			wear = setweartier3,
			destat = setdestattier3,
			newstat = { {type = "Healing", amount = 386}, 
				    {type = "manaperfive", amount = 58},
				    {type = "Allcritchance", amount = 5},
				  },
			stamina = 204,
			intellect = 207,
	},
	{ 
			class = "WARRIOR",
			name = "Valor",
			wear = setwear,
			destat = setdestat,
			newstat = { },
			attackpower = 40,
			strength = 110,
			agility = 56,
			stamina = 131,
			spirit = 35,
	},
	{ 
			class = "WARRIOR",
			name = "Heroism",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "CritReport", amount = 2},
				    {type = "Meleehitchance", amount = 2},
				  },
			meleecritchance = 2,
			attackpower = 40,
			strength = 138,
			agility = 50,
			stamina = 150,
	},
	{ 
			class = "WARRIOR",
			name = "Might",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "Meleehitchance", amount = 1},
				  },
			strength = 143,
			stamina = 189,
	},
	{
			class = "WARRIOR",
			name = "Wrath",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "BlockValueReport", amount = 41},
				  },
			strength = 127,
			stamina = 231,
	},
	{
			class = "WARRIOR",
			name = "Conqueror",
			wear = setwearaq,
			destat = setdestataq,
			newstat = { {type = "Meleehitchance", amount = 2},
				  },
			agility = 96,
			strength = 137,
			stamina = 140,
	},
	{
			class = "WARRIOR",
			name = "Dreadnaught",
			wear = setweartier3,
			destat = setdestattier3,
			newstat = { {type = "Meleehitchance", amount = 2},
				    {type = "BlockValueReport", amount = 92},
				  },
			strength = 141,
			stamina = 298,
	},
	{ 
			class = "ROGUE",
			name = "Shadowcraft",
			wear = setwear,
			destat = setdestat,
			newstat = { },
			attackpower = 40,
			strength = 43,
			agility = 157,
			stamina = 87,
			spirit = 36,
	},
	{ 
			class = "ROGUE",
			name = "Darkmantle",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "CritReport", amount = 1},
				    {type = "Meleehitchance", amount = 2},
				  },
			meleecritchance = 1,
			attackpower = 40,
			strength = 57,
			agility = 184,
			stamina = 97,
	},
	{ 
			class = "ROGUE",
			name = "Nightslayer",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "CritReport", amount = 5},
				    {type = "Meleehitchance", amount = 2},
				  },
			meleecritchance = 5,
			strength = 50,
			agility = 189,
			stamina = 134,
	},
	{ 
			class = "ROGUE",
			name = "Bloodfang",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "CritReport", amount = 4},
				    {type = "Meleehitchance", amount = 3},
				  },
			meleecritchance = 4,
			strength = 86,
			agility = 203,
			stamina = 141,
	},
	{
			class = "ROGUE",
			name = "Deathdealer",
			wear = setwearaq,
			destat = setdestataq,
			newstat = { {type = "Meleehitchance", amount = 4},
				    {type = "CritReport", amount = 3},
				  },
			meleecritchance = 3,
			agility = 157,
			strength = 94,
			stamina = 122,
	},
	{
			class = "ROGUE",
			name = "Bonescythe",
			wear = setweartier3,
			destat = setdestattier3,
			newstat = { {type = "CritReport", amount = 5},
				    {type = "Meleehitchance", amount = 9},
				  },
			meleecritchance = 5,
			strength = 47,
			agility = 285,
			stamina = 196,
	},
	{
			class = "HUNTER",
			name = "Beaststalker",
			wear = setwear,
			destat = setdestat,
			newstat = { },
			attackpower = 40,
			strength = 20,
			agility = 138,
			stamina = 90,
			intellect = 48,
			spirit = 49,
	},
	{ 
			class = "HUNTER",
			name = "Beastmaster",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "Meleehitchance", amount = 1},
				    {type = "CritReport", amount = 1},
				  },
			meleecritchance = 1,
			attackpower = 40,
			agility = 157,
			stamina = 113,
			intellect = 69,
	},
	{ 
			class = "HUNTER",
			name = "Giantstalker",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "Meleehitchance", amount = 3},
				    {type = "CritReport", amount = 4},
				  },
			meleecritchance = 4,
			agility = 189,
			stamina = 128,
			intellect = 52,
			spirit = 40,
	},
	{
			class = "HUNTER",
			name = "Dragonstalker",
			wear = setwear,
			destat = setdestat,
			newstat = { {type = "Meleehitchance", amount = 2},
				    {type = "CritReport", amount = 5},
				  },
			meleecritchance = 5,
			agility = 208,
			stamina = 134,
			intellect = 96,
			spirit = 57,
	},
	{
			class = "HUNTER",
			name = "Striker",
			wear = setwearaq,
			destat = setdestataq,
			newstat = { {type = "All", amount = 42},
				    {type = "CritReport", amount = 3},
				  },
			meleecritchance = 3,
			agility = 161,
			spirit = 38,
			stamina = 114,
			intellect = 66,
	},
	{
			class = "HUNTER",
			name = "Cryptstalker",
			wear = setweartier3,
			destat = setdestattier3,
			newstat = { {type = "Meleehitchance", amount = 5},
				    {type = "CritReport", amount = 7},
				    {type = "manaperfive", amount = 16},
				  },
			meleecritchance = 7,
			agility = 285,
			stamina = 188,
			intellect = 98,
	},
}

end
