// ==UserScript==
// @name         上学吧免会员查看答案
// @namespace    http://tampermonkey.net/
// @version      2.1.0
// @icon         data:image/x-icon;base64,AAABAAEAEBAAAAEAIABoBAAAFgAAACgAAAAQAAAAIAAAAAEAIAAAAAAAQAQAAAAAAAAAAAAAAAAAAAAAAAAzzGb/M8xm/zPMZv8zzGb/M8xm/zPMZv8zzGb/M8xm/zPMZv8zzGb/M8xm/zPMZv8zzGb/M8xm/zPMZv8zzGb/M8xm/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAM8xm/zPMZv8AAAAAAAAAAAAAAAAAAAAAM5n//zOZ//8zmf//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADPMZv8zzGb/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADOZ//8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzzGb/M8xm/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzmf//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAM8xm/zPMZv8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAM5n//wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADPMZv8zzGb/AAAAADOZ//8zmf//M5n//zOZ//8zmf//M5n//zOZ//8zmf//M5n//zOZ//8zmf//M5n//wAAAAAzzGb/M8xm/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzmf//M5n//wAAAAAAAAAAAAAAAAAAAAAAAAAAM8xm/zPMZv8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAzmf//AAAAAAAAAAAAAAAAAAAAADPMZv8zzGb/AAAAAAAAAAAAAAAAM5n//zOZ//8zmf//M5n//zOZ//8zmf//M5n//zOZ//8AAAAAAAAAAAAAAAAzzGb/M8xm/wAAAAAzmf//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADOZ//8AAAAAM8xm/zPMZv8AAAAAM5n//zOZ//8zmf//M5n//zOZ//8zmf//M5n//zOZ//8zmf//M5n//zOZ//8zmf//AAAAADPMZv8zzGb/AAAAAAAAAAAAAAAAM5n//wAAAAAAAAAAAAAAADOZ//8AAAAAAAAAADOZ//8AAAAAAAAAAAAAAAAzzGb/M8xm/wAAAAAAAAAAM5n//wAAAAAAAAAAAAAAADOZ//8AAAAAAAAAAAAAAAAAAAAAM5n//wAAAAAAAAAAM8xm/zPMZv8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADPMZv8zzGb/M8xm/zPMZv8zzGb/M8xm/zPMZv8zzGb/M8xm/zPMZv8zzGb/M8xm/zPMZv8zzGb/M8xm/zPMZv8zzGb/AAAAAH/+AAB4/gAAf34AAH9+AAB/fgAAQAIAAH8+AAB/3gAAcA4AAF/6AABAAgAAd24AAG72AAB//gAAAAAAAA==
// @description  上学吧，免会员免VIP，即可在页面上直接查看答案。
// @author       chenshao
// @match        *://www.shangxueba.com/ask/*
// @match        *://m.shangxueba.com/ask/*
// @grant        GM_addStyle
// @grant        GM_getValue
// @grant        GM_setValue
// @grant        GM_xmlhttpRequest
// @require      https://cdn.jsdelivr.net/npm/sweetalert@2.1.2/dist/sweetalert.min.js
// @require      https://greasyfork.org/scripts/405869-tips4code/code/tips4Code.js
// @connect      www.yyxxs.cn
// @connect      localhost
// @run-at       document-end
// ==/UserScript==

(function() {
    'use strict';
    /* global swal */
    /* global GM_addStyle */
    /* global GM_getValue */
    /* global GM_setValue */
    /* global GM_info */
    /* global GM_xmlhttpRequest */
    // ==============================参数配置
    let settingData = {
        storageNamePrefix: 'rukai_StorageName_', // 本地储存名称前缀
        // getAnswerUrl: 'http://localhost:8080/sxb/getanswer.php',
        getAnswerUrl: 'http://www.yyxxs.cn/sxb/getanswer.php',
    };
    // 验证码
    let veriCode = {
        getCode: () => {
            return GM_getValue(settingData.storageNamePrefix + 'veriCode');
        },
        setCode: (code) => {
            GM_setValue(settingData.storageNamePrefix + 'veriCode', code);
        }
    }

    // 添加新按钮
    let btnAnswer = {
        id: 'btnTampermonkey',
        innerText: '猴友查看答案',
        title: '免会员免VIP，即可查看答案',
        setStartState: () => {
            let btn = document.querySelector('#rukai_zjbtn');
            btn.removeEventListener('click', getRemoteAnswer);
            btn.innerText = '正在查询答案...';
        },
        setStopState: () => {
            let btn = document.querySelector('#rukai_zjbtn');
            btn.addEventListener('click', getRemoteAnswer);
            btn.innerText = btnAnswer.innerText;
        }
    }

    // 是否移动端
    let checkIsMobile = function() {
        let host = window.location.hostname;
        let isMobile = false;
        if (host.split('.')[0] === 'm') isMobile = true;
        return isMobile;
    }

    // 问题类别（ask：普通  jxjy：继续教育）
    let checkAskType = function() {
        let pathName = window.document.location.pathname;
        let askType = pathName.substring(1, pathName.substr(1).indexOf('/') + 1);
        return askType;
    }

    // 创建按钮
    let createBtnAnswer = function() {
        let askType = checkAskType();
        let btn;
        switch (askType) {
        case 'ask':
            btn = document.createElement('a');
            btn.className = 'zjbtn';
            break;
        }
        Object.assign(btn, btnAnswer);
        btn.id = 'rukai_zjbtn';
        btn.style.cssText = 'margin-top: 10px; background: red;';
        btn.addEventListener('click', getRemoteAnswer);
        return btn;
    }

    // #region 服务端查询答案
    let getCurrentUrl = (isEncode) => {
        let url = window.location.href;
        // url编码
        if (isEncode) {
            url = encodeURIComponent(url);
        }
        return url;
    };
    let getRemoteAnswer = () => {
        // 提示输入验证码
        let code = veriCode.getCode();
        // code = '';
        console.log('开始发起服务端请求，验证码为：' + code);
        if (!code) {
            showTips4Code();
            return;
        }
        // PC端、移动端
        let client = checkIsMobile() ? 'mobile' : 'pc';
        // 问题类别（ask：普通  jxjy：继续教育）
        let askType = checkAskType();
        // 发起请求
        let details = {
            method: 'GET',
            responseType: 'json',
            timeout: 20000, // 20秒超时
            url: settingData.getAnswerUrl + `?url=${getCurrentUrl(true)}&code=${code}&client=${client}&askType=${askType}&ver=${GM_info.version}&t=` + new Date().getTime(),
            onloadstart: function() {
                btnAnswer.setStartState();
            },
            onload: function(res) {
                // 分3种情况处理返回结果：0正常返回（参考源网站）、1验证码不正确（调用showTips4Code）、100其它错误（调用showErrorTips）
                console.log(res);
                if (res.status === 200) {
                    switch (res.response.retCode) {
                    case 0: // 正常返回
                        let answer = res.response.answer;
                        btnAnswer.setStopState();
                        processAnswer(answer, client);
                        break;
                    case 1: // 验证码不正确
                        showTips4Code('<u>验证码不正确</u> 或 <u>验证码已过期（请从公众号获取最新验证码）</u>');
                        break;
                    default: // 其它错误
                        showErrorTips(res, res.response.answer);
                        break;
                    }
                } else {
                    showErrorTips(res);
                }
            },
            ontimeout: (res) => {
                showErrorTips(res);
            },
            onerror: (res) => {
                showErrorTips(res);
            }
        };
        try {
            GM_xmlhttpRequest(details);
        } catch (error) {
            showErrorTips(error);
        }
    }
    // 处理服务端返回的答案（使用更加简单的方式显示答案，不再参考源网站处理方式）
    let processAnswer = function(answer, client) {
        switch (client) {
        case 'pc':
            $('.zjbtndiv').html(answer);
            // document.querySelector('#daanmaxdiv').innerHTML = answer;
            break;
        case 'mobile':
            $('#zuijiadiv').html(answer);
            $('#zuijiadiv').next().hide();
            // document.querySelector('#daanmaxdiv').innerHTML = answer;
            break;
        }
    }
    // 出错 统一提示
    let showErrorTips = (error, errorMessage) => {
        console.error(error);
        btnAnswer.setStopState();
        let errorContent = '请稍后重试或到公众号反馈，收到反馈后我会第一时间修复！';
        if (errorMessage) {
            errorContent = errorMessage;
        }
        swal('Sorry，查询答案出错', errorContent, 'error');
    }
    // #endregion 服务端查询答案

    // 在【查看最佳答案】下面新增按钮
    function setZjBtn(btn) {
        let askType = checkAskType();
        console.log(askType);
        let btnZJ = null;
        switch (askType) {
        case 'ask':
            btnZJ = document.querySelector('.zjbtn');
            if (!btnZJ) btnZJ = document.querySelector('.buymember');// 悬赏问题
            break;
        }
        if (!btnZJ) {
            setTimeout(() => {
                setZjBtn(btn);
            }, 300);
        } else {
            console.log('找到按钮【查看答案】：');
            // console.log(btnZJ);
            let parent = btnZJ.parentNode;
            parent.insertBefore(btn, btnZJ.nextSibling);
        }
    }

    // ########################################################
    function showTips4Code(message) {
        swal({
            // title: '免费获取验证码步骤',
            content: tips4Code,
            // button: 'O K',
            button: false,
            className: 'swal-modal-autowidth'
        }).then((value) => {
            btnAnswer.setStopState();
        });
        // 验证码不正确或过期：给出提示
        let divErrorMessage = document.querySelector('#rukai_error');
        if (message) {
            divErrorMessage.innerHTML = message;
            divErrorMessage.style.display = '';
        } else {
            divErrorMessage.style.display = 'none';
        }
        let Img = document.querySelector('#rukai_Img');
        let indexImg = Img.src.indexOf('jjjjKSwLKclc');
        if (indexImg === -1) $('#rukai_divCode').hide();
        document.querySelector('#rukai_code').focus();
        let submitBtn = document.querySelector('#rukai_submitBtn');
        submitBtn.removeEventListener('click', setCodeFromInput);
        submitBtn.addEventListener('click', setCodeFromInput);
    }

    function setCodeFromInput() {
        let code = document.querySelector('#rukai_code').value.trim();
        if (code.length > 0) {
            veriCode.setCode(code);
            swal.close();
            getRemoteAnswer();
        }
    }
    GM_addStyle(`
        #rukai_divCode{}
        #rukai_divCode .rukai_CodeInput{
            margin-bottom: 30px;
            margin-top: 50px;
        }
        #rukai_divCode .rukai_CodeTitle{
            font-size: 30px;
            font-weight: bold;
            margin-bottom: 20px;
        }
        #rukai_divCode .rukai_CodeImg{
            float: left;
        }
        #rukai_divCode .rukai_CodeImg img{
            width: 200px;
        }
        #rukai_divCode .rukai_CodeTips{
            float: left;
            text-align: left;
            padding-top: 10px;
        }
        #rukai_divCode .rukai_CodeTips p{
            white-space:nowrap;
            margin-bottom: 15px;
        }
        }
        #rukai_divCode .rukai_CodeTips p.rukai_CodeLast{
            margin-bottom: 0px;
        }
        #rukai_divCode .rukai_clear{
            clear: both;
            margin-bottom: 30px;
        }
        .swal-modal-autowidth{
            width: auto;
        }

        #rukai_code{
            width: 100%;
            border: 1px solid #ccc;
            padding: 7px 0;
            background: #F4F4F7;
            border-radius: 3px;
            padding-left:5px;
            -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
            box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
            -webkit-transition: border-color ease-in-out .15s,-webkit-box-shadow ease-in-out .15s;
            -o-transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s;
            transition: border-color ease-in-out .15s,box-shadow ease-in-out .15s
        }
        #rukai_code:focus{
            border-color: #66afe9;
            outline: 0;
            -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,.075),0 0 8px rgba(102,175,233,.6);
            box-shadow: inset 0 1px 1px rgba(0,0,0,.075),0 0 8px rgba(102,175,233,.6)
        }
        /* 验证码 */
        .rukai_submitBtn {
            line-height: 1.499;
            position: relative;
            display: inline-block;
            font-weight: 400;
            white-space: nowrap;
            text-align: center;
            background-image: none;
            border: 1px solid transparent;
            -webkit-box-shadow: 0 2px 0 rgba(0,0,0,0.015);
            box-shadow: 0 2px 0 rgba(0,0,0,0.015);
            cursor: pointer;
            -webkit-transition: all .3s cubic-bezier(.645, .045, .355, 1);
            transition: all .3s cubic-bezier(.645, .045, .355, 1);
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
            -ms-touch-action: manipulation;
            touch-action: manipulation;
            height: 32px;
            padding: 0 15px;
            font-size: 14px;
            border-radius: 4px;
            color: rgba(0,0,0,0.65);
            background-color: #fff;
            border-color: #d9d9d9;
        }
        .rukai_submitBtn-primary {
            color: #fff;
            background-color: #1890ff;
            border-color: #1890ff;
            text-shadow: 0 -1px 0 rgba(0,0,0,0.12);
            -webkit-box-shadow: 0 2px 0 rgba(0,0,0,0.045);
            box-shadow: 0 2px 0 rgba(0,0,0,0.045);
        }
        .rukai_submitBtn-red {
            color: #fff;
            background-color: #FF5A44;
            border-color: #FF5A44;
            text-shadow: 0 -1px 0 rgba(0,0,0,0.12);
            -webkit-box-shadow: 0 2px 0 rgba(0,0,0,0.045);
            box-shadow: 0 2px 0 rgba(0,0,0,0.045);
        }
        #rukai_error{
            color: #f00;
            margin-bottom: 30px;
        }
        /*修改上学吧网站的css*/
        span.gre{
            display: none;
        }
        div.replyCon{
            margin: 0px 0 10px 50px;
            /*line-height: 30px;*/
        }
        div.replyCon_mobile{
            margin: 0px 0 25px 0px;
        }
    `);

    // ==================================== 逻辑代码开始
    console.log('脚本 START');
    let btn = createBtnAnswer();
    setZjBtn(btn);
    console.log('脚本 END');
    // 查答案功能今天检查正常 ########
})();