/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.im.InputContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.SwingPropertyChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAction
extends AbstractAction {
    public static final String RESOURCE_CLASS = "ResourceClass";
    public static final String RESOURCE_PREFIX = "ResourcePrefix";
    public static final String VISIBLE = "Visible";
    public static final String POPUP = "Popup";
    public static final String TOGGLE_BUTTON_MODEL = "ToggleButtonModel";
    public static final String TOOL_BAR_ICON = "ToolBarIcon";
    private static final String[] LATIN_AND_SUPPORTED_LOCALES = new String[]{"cs", "da", "de", "en", "es", "et", "fi", "fr", "hr", "hu", "it", "ja", "lt", "lv", "nl", "no", "pl", "pt", "ro", "sk", "sl", "sv", "tr", "vi"};
    private static KeyStroke previousActionAccelerator;
    private static Timer doubleEventsTimer;

    public ResourceAction(UserPreferences userPreferences, Class<?> clazz, String string) {
        this(userPreferences, clazz, string, false);
    }

    public ResourceAction(UserPreferences userPreferences, Class<?> clazz, String string, boolean bl) {
        this.putValue(RESOURCE_CLASS, clazz);
        this.putValue(RESOURCE_PREFIX, string);
        this.putValue(VISIBLE, Boolean.TRUE);
        this.readActionProperties(userPreferences, clazz, string);
        this.setEnabled(bl);
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
    }

    private void readActionProperties(UserPreferences userPreferences, Class<?> clazz, String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = string + ".";
        this.putValue("Name", this.getOptionalString(userPreferences, clazz, string6 + "Name", true));
        this.putValue("Default", this.getValue("Name"));
        this.putValue(POPUP, this.getOptionalString(userPreferences, clazz, string6 + POPUP, true));
        this.putValue("ShortDescription", this.getOptionalString(userPreferences, clazz, string6 + "ShortDescription", false));
        this.putValue("LongDescription", this.getOptionalString(userPreferences, clazz, string6 + "LongDescription", false));
        String string7 = this.getOptionalString(userPreferences, clazz, string6 + "SmallIcon", false);
        if (string7 != null) {
            this.putValue("SmallIcon", SwingTools.getScaledImageIcon(clazz.getResource(string7)));
        }
        if ((string5 = this.getOptionalString(userPreferences, clazz, string6 + TOOL_BAR_ICON, false)) != null) {
            this.putValue(TOOL_BAR_ICON, SwingTools.getScaledImageIcon(clazz.getResource(string5)));
        }
        if ((string4 = this.getOptionalString(userPreferences, clazz, (string3 = string6 + "AcceleratorKey") + "." + System.getProperty("os.name"), false)) == null) {
            string4 = this.getOptionalString(userPreferences, clazz, string3, false);
        }
        if (string4 != null) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(string4));
        }
        if ((string2 = this.getOptionalString(userPreferences, clazz, string6 + "MnemonicKey", false)) != null) {
            this.putValue("MnemonicKey", KeyStroke.getKeyStroke(string2).getKeyCode());
        }
    }

    private String getOptionalString(UserPreferences userPreferences, Class<?> clazz, String string, boolean bl) {
        try {
            String string2;
            String string3 = string2 = bl ? SwingTools.getLocalizedLabelText(userPreferences, clazz, string, new Object[0]) : userPreferences.getLocalizedString(clazz, string, new Object[0]);
            if (string2 != null && string2.length() > 0) {
                return string2;
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        throw new UnsupportedOperationException();
    }

    static boolean isActionValid(Action action) {
        Locale locale;
        if (OperatingSystem.isMacOSX() && OperatingSystem.isJavaVersionBetween("1.7", "9") && (locale = InputContext.getInstance().getLocale()) != null && Arrays.binarySearch(LATIN_AND_SUPPORTED_LOCALES, locale.getLanguage()) < 0) {
            if (!ResourceAction.isInvokedFromMenuItem()) {
                previousActionAccelerator = (KeyStroke)action.getValue("AcceleratorKey");
                if (doubleEventsTimer == null) {
                    doubleEventsTimer = new Timer(1000, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            previousActionAccelerator = null;
                            doubleEventsTimer.stop();
                        }
                    });
                }
                doubleEventsTimer.restart();
            } else if (previousActionAccelerator != null && previousActionAccelerator.equals(action.getValue("AcceleratorKey"))) {
                previousActionAccelerator = null;
                return false;
            }
        }
        return true;
    }

    private static boolean isInvokedFromMenuItem() {
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (!"com.apple.laf.ScreenMenuItem".equals(stackTraceElement.getClassName()) || !"actionPerformed".equals(stackTraceElement.getMethodName())) continue;
            return true;
        }
        return false;
    }

    public static class ButtonAction
    extends AbstractDecoratedAction {
        public ButtonAction(Action action) {
            super(action);
        }

        public Object getValue(String string) {
            if (OperatingSystem.isMacOSX() && string.equals("MnemonicKey")) {
                return null;
            }
            return super.getValue(string);
        }
    }

    public static class ToolBarAction
    extends AbstractDecoratedAction {
        public ToolBarAction(Action action) {
            super(action);
        }

        public Object getValue(String string) {
            Object object;
            if (string.equals("Name")) {
                return null;
            }
            if (string.equals("SmallIcon") && (object = super.getValue(ResourceAction.TOOL_BAR_ICON)) != null) {
                return object;
            }
            return super.getValue(string);
        }
    }

    public static class PopupMenuItemAction
    extends MenuItemAction {
        public PopupMenuItemAction(Action action) {
            super(action);
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (ResourceAction.POPUP.equals(propertyChangeEvent.getPropertyName()) && (propertyChangeEvent.getOldValue() != null || propertyChangeEvent.getNewValue() != null)) {
                        PopupMenuItemAction.this.firePropertyChange("Name", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    }
                }
            });
        }

        public Object getValue(String string) {
            if (string.equals("Name")) {
                Object object = super.getValue(ResourceAction.POPUP);
                if (object != null) {
                    return object;
                }
            } else {
                if (string.equals("SmallIcon")) {
                    return null;
                }
                if (OperatingSystem.isMacOSX() && string.equals("AcceleratorKey")) {
                    return null;
                }
            }
            return super.getValue(string);
        }
    }

    public static class MenuItemAction
    extends AbstractDecoratedAction {
        public MenuItemAction(Action action) {
            super(action);
        }

        public Object getValue(String string) {
            if (OperatingSystem.isMacOSX() && (string.equals("MnemonicKey") || string.equals("SmallIcon") || string.equals("ShortDescription"))) {
                return null;
            }
            return super.getValue(string);
        }
    }

    private static class AbstractDecoratedAction
    implements Action {
        private Action action;
        private SwingPropertyChangeSupport propertyChangeSupport;

        public AbstractDecoratedAction(Action action) {
            this.action = action;
            this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
            action.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if ("enabled".equals(string)) {
                        AbstractDecoratedAction.this.propertyChangeSupport.firePropertyChange(propertyChangeEvent);
                    } else {
                        Object object = AbstractDecoratedAction.this.getValue(string);
                        if (object != null) {
                            AbstractDecoratedAction.this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), string, propertyChangeEvent.getOldValue(), object));
                        }
                    }
                }
            });
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            if (ResourceAction.isActionValid(this)) {
                this.action.actionPerformed(actionEvent);
            }
        }

        public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public Object getValue(String string) {
            return this.action.getValue(string);
        }

        public final boolean isEnabled() {
            return this.action.isEnabled();
        }

        public final void putValue(String string, Object object) {
            this.action.putValue(string, object);
        }

        public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public final void setEnabled(boolean bl) {
            this.action.setEnabled(bl);
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            this.propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    private static class LanguageChangeListener
    implements PropertyChangeListener {
        private final WeakReference<ResourceAction> resourceAction;

        public LanguageChangeListener(ResourceAction resourceAction) {
            this.resourceAction = new WeakReference<ResourceAction>(resourceAction);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ResourceAction resourceAction = (ResourceAction)this.resourceAction.get();
            if (resourceAction == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                resourceAction.readActionProperties((UserPreferences)propertyChangeEvent.getSource(), (Class)resourceAction.getValue(ResourceAction.RESOURCE_CLASS), (String)resourceAction.getValue(ResourceAction.RESOURCE_PREFIX));
            }
        }
    }
}

