/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.HomeDescriptor;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.PatternsCatalog;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.TextureImage;
import com.eteks.sweethome3d.model.TexturesCatalog;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserPreferences {
    public static final String FURNITURE_LIBRARY_TYPE = "Furniture library";
    public static final String TEXTURES_LIBRARY_TYPE = "Textures library";
    public static final String LANGUAGE_LIBRARY_TYPE = "Language library";
    private static final String[] DEFAULT_SUPPORTED_LANGUAGES;
    private static final List<ClassLoader> DEFAULT_CLASS_LOADER;
    private static final TextStyle DEFAULT_TEXT_STYLE;
    private static final TextStyle DEFAULT_ROOM_TEXT_STYLE;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Map<Class<?>, ResourceBundle> classResourceBundles = new HashMap();
    private final Map<String, ResourceBundle> resourceBundles = new HashMap<String, ResourceBundle>();
    private FurnitureCatalog furnitureCatalog;
    private TexturesCatalog texturesCatalog;
    private PatternsCatalog patternsCatalog;
    private final String defaultCountry;
    private String[] supportedLanguages;
    private String language;
    private String currency;
    private boolean valueAddedTaxEnabled;
    private BigDecimal defaultValueAddedTaxPercentage;
    private LengthUnit unit;
    private boolean furnitureCatalogViewedInTree = true;
    private boolean aerialViewCenteredOnSelectionEnabled;
    private boolean observerCameraSelectedAtChange = true;
    private boolean navigationPanelVisible = true;
    private boolean magnetismEnabled = true;
    private boolean rulersVisible = true;
    private boolean gridVisible = true;
    private String defaultFontName;
    private boolean drawingModeEnabled;
    private boolean furnitureViewedFromTop;
    private int furnitureModelIconSize = 128;
    private boolean roomFloorColoredOrTextured;
    private TextureImage wallPattern;
    private TextureImage newWallPattern;
    private float newWallThickness;
    private float newWallHeight;
    private float newWallBaseboardThickness;
    private float newWallBaseboardHeight;
    private Integer newRoomFloorColor;
    private float newFloorThickness;
    private List<String> recentHomes;
    private boolean checkUpdatesEnabled;
    private Long updatesMinimumDate;
    private int autoSaveDelayForRecovery;
    private Map<String, List<String>> autoCompletionStrings = new LinkedHashMap<String, List<String>>();
    private List<Integer> recentColors;
    private List<TextureImage> recentTextures;
    private List<HomeDescriptor> homeExamples;

    public UserPreferences() {
        this.recentHomes = Collections.emptyList();
        this.recentColors = Collections.emptyList();
        this.recentTextures = Collections.emptyList();
        this.homeExamples = Collections.emptyList();
        try {
            this.drawingModeEnabled = Boolean.getBoolean("com.eteks.sweethome3d.j3d.drawingModeEnabled");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.supportedLanguages = DEFAULT_SUPPORTED_LANGUAGES;
        this.defaultCountry = Locale.getDefault().getCountry();
        String string = Locale.getDefault().getLanguage();
        for (String string2 : this.supportedLanguages) {
            if (string2.equals(string + "_" + this.defaultCountry)) {
                this.language = string2;
                break;
            }
            if (this.language != null || !string2.startsWith(string)) continue;
            this.language = string2;
        }
        if (this.language == null) {
            this.language = Locale.ENGLISH.getLanguage();
        }
        this.updateDefaultLocale();
    }

    private void updateDefaultLocale() {
        try {
            int n = this.language.indexOf("_");
            if (n != -1) {
                Locale.setDefault(new Locale(this.language.substring(0, n), this.language.substring(n + 1)));
            } else {
                Locale.setDefault(new Locale(this.language, this.defaultCountry));
            }
        }
        catch (AccessControlException accessControlException) {
            this.language = Locale.getDefault().getLanguage();
        }
    }

    public abstract void write() throws RecorderException;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public FurnitureCatalog getFurnitureCatalog() {
        return this.furnitureCatalog;
    }

    protected void setFurnitureCatalog(FurnitureCatalog furnitureCatalog) {
        this.furnitureCatalog = furnitureCatalog;
    }

    public TexturesCatalog getTexturesCatalog() {
        return this.texturesCatalog;
    }

    protected void setTexturesCatalog(TexturesCatalog texturesCatalog) {
        this.texturesCatalog = texturesCatalog;
    }

    public PatternsCatalog getPatternsCatalog() {
        return this.patternsCatalog;
    }

    protected void setPatternsCatalog(PatternsCatalog patternsCatalog) {
        this.patternsCatalog = patternsCatalog;
    }

    public LengthUnit getLengthUnit() {
        return this.unit;
    }

    public void setUnit(LengthUnit lengthUnit) {
        if (this.unit != lengthUnit) {
            LengthUnit lengthUnit2 = this.unit;
            this.unit = lengthUnit;
            this.propertyChangeSupport.firePropertyChange(Property.UNIT.name(), (Object)lengthUnit2, (Object)lengthUnit);
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        if (!string.equals(this.language) && this.isLanguageEditable()) {
            String string2 = this.language;
            this.language = string;
            this.updateDefaultLocale();
            this.classResourceBundles.clear();
            this.resourceBundles.clear();
            this.propertyChangeSupport.firePropertyChange(Property.LANGUAGE.name(), string2, string);
        }
    }

    public boolean isLanguageEditable() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new PropertyPermission("user.language", "write"));
            }
            return true;
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public String[] getDefaultSupportedLanguages() {
        return (String[])DEFAULT_SUPPORTED_LANGUAGES.clone();
    }

    public String[] getSupportedLanguages() {
        return (String[])this.supportedLanguages.clone();
    }

    protected void setSupportedLanguages(String[] stringArray) {
        if (!Arrays.deepEquals(this.supportedLanguages, stringArray)) {
            String[] stringArray2 = this.supportedLanguages;
            this.supportedLanguages = (String[])stringArray.clone();
            this.propertyChangeSupport.firePropertyChange(Property.SUPPORTED_LANGUAGES.name(), stringArray2, stringArray);
        }
    }

    public String getLocalizedString(Class<?> clazz, String string, Object ... objectArray) {
        ResourceBundle resourceBundle = this.classResourceBundles.get(clazz);
        if (resourceBundle == null) {
            try {
                resourceBundle = this.getResourceBundle(clazz.getName());
                this.classResourceBundles.put(clazz, resourceBundle);
            }
            catch (IOException iOException) {
                try {
                    String string2 = clazz.getName();
                    int n = string2.lastIndexOf(".");
                    String string3 = n != -1 ? string2.substring(0, n) + ".package" : "package";
                    resourceBundle = new PrefixedResourceBundle(this.getResourceBundle(string3), clazz.getSimpleName() + ".");
                    this.classResourceBundles.put(clazz, resourceBundle);
                }
                catch (IOException iOException2) {
                    throw new IllegalArgumentException("Can't find resource bundle for " + clazz, iOException);
                }
            }
        }
        return this.getLocalizedString(resourceBundle, string, objectArray);
    }

    public String getLocalizedString(String string, String string2, Object ... objectArray) {
        try {
            ResourceBundle resourceBundle = this.getResourceBundle(string);
            return this.getLocalizedString(resourceBundle, string2, objectArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Can't find resource bundle for " + string, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getResourceBundle(String string) throws IOException {
        String[] stringArray;
        ResourceBundle resourceBundle = this.resourceBundles.get(string = string.replace('.', '/'));
        if (resourceBundle != null) {
            return resourceBundle;
        }
        Locale locale = Locale.getDefault();
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        block5: for (String string4 : stringArray = new String[]{".properties", "_" + string2 + ".properties", "_" + string2 + "_" + string3 + ".properties"}) {
            for (ClassLoader classLoader : this.getResourceClassLoaders()) {
                InputStream inputStream = classLoader.getResourceAsStream(string + string4);
                if (inputStream == null) continue;
                final ResourceBundle resourceBundle2 = resourceBundle;
                try {
                    resourceBundle = new PropertyResourceBundle(inputStream){
                        {
                            super(inputStream);
                            this.setParent(resourceBundle2);
                        }
                    };
                    continue block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                finally {
                    inputStream.close();
                }
            }
        }
        if (resourceBundle == null) {
            throw new IOException("No available resource bundle for " + string);
        }
        this.resourceBundles.put(string, resourceBundle);
        return resourceBundle;
    }

    private String getLocalizedString(ResourceBundle resourceBundle, String string, Object ... objectArray) {
        try {
            String string2 = resourceBundle.getString(string);
            if (objectArray.length > 0) {
                string2 = String.format(string2, objectArray);
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            throw new IllegalArgumentException("Unknown key " + string);
        }
    }

    public Iterator<String> getLocalizedStringKeys(String string) {
        try {
            final Enumeration<String> enumeration = this.getResourceBundle(string).getKeys();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                @Override
                public String next() {
                    return (String)enumeration.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Enumeration not modifiable");
                }
            };
        }
        catch (IOException iOException) {
            return Collections.emptyList().iterator();
        }
    }

    public List<ClassLoader> getResourceClassLoaders() {
        return DEFAULT_CLASS_LOADER;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String string) {
        if (!(string == this.currency || string != null && string.equals(this.currency))) {
            String string2 = this.currency;
            this.currency = string;
            this.propertyChangeSupport.firePropertyChange(Property.CURRENCY.name(), string2, string);
        }
    }

    public boolean isValueAddedTaxEnabled() {
        return this.valueAddedTaxEnabled;
    }

    public void setValueAddedTaxEnabled(boolean bl) {
        if (this.valueAddedTaxEnabled != bl) {
            this.valueAddedTaxEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VALUE_ADDED_TAX_ENABLED.name(), !bl, bl);
        }
    }

    public BigDecimal getDefaultValueAddedTaxPercentage() {
        return this.defaultValueAddedTaxPercentage;
    }

    public void setDefaultValueAddedTaxPercentage(BigDecimal bigDecimal) {
        if (!(bigDecimal == this.defaultValueAddedTaxPercentage || bigDecimal != null && bigDecimal.equals(this.defaultValueAddedTaxPercentage))) {
            BigDecimal bigDecimal2 = this.defaultValueAddedTaxPercentage;
            this.defaultValueAddedTaxPercentage = bigDecimal;
            this.propertyChangeSupport.firePropertyChange(Property.DEFAULT_VALUE_ADDED_TAX_PERCENTAGE.name(), bigDecimal2, bigDecimal);
        }
    }

    public boolean isFurnitureCatalogViewedInTree() {
        return this.furnitureCatalogViewedInTree;
    }

    public void setFurnitureCatalogViewedInTree(boolean bl) {
        if (this.furnitureCatalogViewedInTree != bl) {
            this.furnitureCatalogViewedInTree = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_CATALOG_VIEWED_IN_TREE.name(), !bl, bl);
        }
    }

    public boolean isNavigationPanelVisible() {
        return this.navigationPanelVisible;
    }

    public void setNavigationPanelVisible(boolean bl) {
        if (this.navigationPanelVisible != bl) {
            this.navigationPanelVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.NAVIGATION_PANEL_VISIBLE.name(), !bl, bl);
        }
    }

    public void setAerialViewCenteredOnSelectionEnabled(boolean bl) {
        if (bl != this.aerialViewCenteredOnSelectionEnabled) {
            this.aerialViewCenteredOnSelectionEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isAerialViewCenteredOnSelectionEnabled() {
        return this.aerialViewCenteredOnSelectionEnabled;
    }

    public void setObserverCameraSelectedAtChange(boolean bl) {
        if (bl != this.observerCameraSelectedAtChange) {
            this.observerCameraSelectedAtChange = bl;
            this.propertyChangeSupport.firePropertyChange(Property.OBSERVER_CAMERA_SELECTED_AT_CHANGE.name(), !bl, bl);
        }
    }

    public boolean isObserverCameraSelectedAtChange() {
        return this.observerCameraSelectedAtChange;
    }

    public boolean isMagnetismEnabled() {
        return this.magnetismEnabled;
    }

    public void setMagnetismEnabled(boolean bl) {
        if (this.magnetismEnabled != bl) {
            this.magnetismEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MAGNETISM_ENABLED.name(), !bl, bl);
        }
    }

    public boolean isRulersVisible() {
        return this.rulersVisible;
    }

    public void setRulersVisible(boolean bl) {
        if (this.rulersVisible != bl) {
            this.rulersVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.RULERS_VISIBLE.name(), !bl, bl);
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean bl) {
        if (this.gridVisible != bl) {
            this.gridVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.GRID_VISIBLE.name(), !bl, bl);
        }
    }

    public boolean isDrawingModeEnabled() {
        return this.drawingModeEnabled;
    }

    public String getDefaultFontName() {
        return this.defaultFontName;
    }

    public void setDefaultFontName(String string) {
        if (!(string == this.defaultFontName || string != null && string.equals(this.defaultFontName))) {
            String string2 = this.defaultFontName;
            this.defaultFontName = string;
            this.propertyChangeSupport.firePropertyChange(Property.DEFAULT_FONT_NAME.name(), string2, string);
        }
    }

    public boolean isFurnitureViewedFromTop() {
        return this.furnitureViewedFromTop;
    }

    public void setFurnitureViewedFromTop(boolean bl) {
        if (this.furnitureViewedFromTop != bl) {
            this.furnitureViewedFromTop = bl;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_VIEWED_FROM_TOP.name(), !bl, bl);
        }
    }

    public int getFurnitureModelIconSize() {
        return this.furnitureModelIconSize;
    }

    public void setFurnitureModelIconSize(int n) {
        if (n != this.furnitureModelIconSize) {
            int n2 = this.furnitureModelIconSize;
            this.furnitureModelIconSize = n;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_MODEL_ICON_SIZE.name(), n2, n);
        }
    }

    public boolean isRoomFloorColoredOrTextured() {
        return this.roomFloorColoredOrTextured;
    }

    public void setFloorColoredOrTextured(boolean bl) {
        if (this.roomFloorColoredOrTextured != bl) {
            this.roomFloorColoredOrTextured = bl;
            this.propertyChangeSupport.firePropertyChange(Property.ROOM_FLOOR_COLORED_OR_TEXTURED.name(), !bl, bl);
        }
    }

    public TextureImage getWallPattern() {
        return this.wallPattern;
    }

    public void setWallPattern(TextureImage textureImage) {
        if (this.wallPattern != textureImage) {
            TextureImage textureImage2 = this.wallPattern;
            this.wallPattern = textureImage;
            this.propertyChangeSupport.firePropertyChange(Property.WALL_PATTERN.name(), textureImage2, textureImage);
        }
    }

    public TextureImage getNewWallPattern() {
        return this.newWallPattern;
    }

    public void setNewWallPattern(TextureImage textureImage) {
        if (this.newWallPattern != textureImage) {
            TextureImage textureImage2 = this.newWallPattern;
            this.newWallPattern = textureImage;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_WALL_PATTERN.name(), textureImage2, textureImage);
        }
    }

    public float getNewWallThickness() {
        return this.newWallThickness;
    }

    public void setNewWallThickness(float f) {
        if (this.newWallThickness != f) {
            float f2 = this.newWallThickness;
            this.newWallThickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_WALL_THICKNESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getNewWallHeight() {
        return this.newWallHeight;
    }

    public void setNewWallHeight(float f) {
        if (this.newWallHeight != f) {
            float f2 = this.newWallHeight;
            this.newWallHeight = f;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_WALL_HEIGHT.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getNewWallBaseboardThickness() {
        return this.newWallBaseboardThickness;
    }

    public void setNewWallBaseboardThickness(float f) {
        if (this.newWallBaseboardThickness != f) {
            float f2 = this.newWallBaseboardThickness;
            this.newWallBaseboardThickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_WALL_SIDEBOARD_THICKNESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getNewWallBaseboardHeight() {
        return this.newWallBaseboardHeight;
    }

    public void setNewWallBaseboardHeight(float f) {
        if (this.newWallBaseboardHeight != f) {
            float f2 = this.newWallBaseboardHeight;
            this.newWallBaseboardHeight = f;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_WALL_SIDEBOARD_HEIGHT.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public Integer getNewRoomFloorColor() {
        return this.newRoomFloorColor;
    }

    public void setNewRoomFloorColor(Integer n) {
        if (this.newRoomFloorColor != n) {
            Integer n2 = this.newRoomFloorColor;
            this.newRoomFloorColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_ROOM_FLOOR_COLOR.name(), n2, n);
        }
    }

    public float getNewFloorThickness() {
        return this.newFloorThickness;
    }

    public void setNewFloorThickness(float f) {
        if (this.newFloorThickness != f) {
            float f2 = this.newFloorThickness;
            this.newFloorThickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.NEW_FLOOR_THICKNESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public boolean isCheckUpdatesEnabled() {
        return this.checkUpdatesEnabled;
    }

    public void setCheckUpdatesEnabled(boolean bl) {
        if (bl != this.checkUpdatesEnabled) {
            this.checkUpdatesEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(Property.CHECK_UPDATES_ENABLED.name(), !bl, bl);
        }
    }

    public Long getUpdatesMinimumDate() {
        return this.updatesMinimumDate;
    }

    public void setUpdatesMinimumDate(Long l) {
        if (!(this.updatesMinimumDate == l || l != null && l.equals(this.updatesMinimumDate))) {
            Long l2 = this.updatesMinimumDate;
            this.updatesMinimumDate = l;
            this.propertyChangeSupport.firePropertyChange(Property.UPDATES_MINIMUM_DATE.name(), l2, l);
        }
    }

    public int getAutoSaveDelayForRecovery() {
        return this.autoSaveDelayForRecovery;
    }

    public void setAutoSaveDelayForRecovery(int n) {
        if (this.autoSaveDelayForRecovery != n) {
            float f = this.autoSaveDelayForRecovery;
            this.autoSaveDelayForRecovery = n;
            this.propertyChangeSupport.firePropertyChange(Property.AUTO_SAVE_DELAY_FOR_RECOVERY.name(), Float.valueOf(f), (Object)n);
        }
    }

    public List<String> getRecentHomes() {
        return Collections.unmodifiableList(this.recentHomes);
    }

    public void setRecentHomes(List<String> list) {
        if (!list.equals(this.recentHomes)) {
            List<String> list2 = this.recentHomes;
            this.recentHomes = new ArrayList<String>(list);
            this.propertyChangeSupport.firePropertyChange(Property.RECENT_HOMES.name(), list2, this.getRecentHomes());
        }
    }

    public int getRecentHomesMaxCount() {
        return 10;
    }

    public int getStoredCamerasMaxCount() {
        return 50;
    }

    public void setActionTipIgnored(String string) {
        this.propertyChangeSupport.firePropertyChange(Property.IGNORED_ACTION_TIP.name(), null, string);
    }

    public boolean isActionTipIgnored(String string) {
        return true;
    }

    public void resetIgnoredActionTips() {
        this.propertyChangeSupport.firePropertyChange(Property.IGNORED_ACTION_TIP.name(), null, null);
    }

    public TextStyle getDefaultTextStyle(Class<? extends Selectable> clazz) {
        if (Room.class.isAssignableFrom(clazz)) {
            return DEFAULT_ROOM_TEXT_STYLE;
        }
        return DEFAULT_TEXT_STYLE;
    }

    public List<String> getAutoCompletionStrings(String string) {
        List<String> list = this.autoCompletionStrings.get(string);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public void addAutoCompletionString(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            List<String> list = this.autoCompletionStrings.get(string);
            if (list == null) {
                list = new ArrayList<String>();
            } else if (!list.contains(string2)) {
                list = new ArrayList<String>(list);
            } else {
                return;
            }
            list.add(0, string2);
            this.setAutoCompletionStrings(string, list);
        }
    }

    public void setAutoCompletionStrings(String string, List<String> list) {
        List<String> list2 = this.autoCompletionStrings.get(string);
        if (!list.equals(list2)) {
            this.autoCompletionStrings.put(string, new ArrayList<String>(list));
            this.propertyChangeSupport.firePropertyChange(Property.AUTO_COMPLETION_STRINGS.name(), null, string);
        }
    }

    public List<String> getAutoCompletedProperties() {
        if (this.autoCompletionStrings != null) {
            return Arrays.asList(this.autoCompletionStrings.keySet().toArray(new String[this.autoCompletionStrings.size()]));
        }
        return Collections.emptyList();
    }

    public List<Integer> getRecentColors() {
        return Collections.unmodifiableList(this.recentColors);
    }

    public void setRecentColors(List<Integer> list) {
        if (!list.equals(this.recentColors)) {
            List<Integer> list2 = this.recentColors;
            this.recentColors = new ArrayList<Integer>(list);
            this.propertyChangeSupport.firePropertyChange(Property.RECENT_COLORS.name(), list2, this.getRecentColors());
        }
    }

    public List<TextureImage> getRecentTextures() {
        return Collections.unmodifiableList(this.recentTextures);
    }

    public void setRecentTextures(List<TextureImage> list) {
        if (!list.equals(this.recentTextures)) {
            List<TextureImage> list2 = this.recentTextures;
            this.recentTextures = new ArrayList<TextureImage>(list);
            this.propertyChangeSupport.firePropertyChange(Property.RECENT_TEXTURES.name(), list2, this.getRecentTextures());
        }
    }

    protected void setHomeExamples(List<HomeDescriptor> list) {
        if (!list.equals(this.homeExamples)) {
            List<HomeDescriptor> list2 = this.homeExamples;
            this.homeExamples = new ArrayList<HomeDescriptor>(list);
            this.propertyChangeSupport.firePropertyChange(Property.HOME_EXAMPLES.name(), list2, this.getHomeExamples());
        }
    }

    public List<HomeDescriptor> getHomeExamples() {
        return Collections.unmodifiableList(this.homeExamples);
    }

    public abstract void addLanguageLibrary(String var1) throws RecorderException;

    public abstract boolean languageLibraryExists(String var1) throws RecorderException;

    public abstract void addFurnitureLibrary(String var1) throws RecorderException;

    public abstract boolean furnitureLibraryExists(String var1) throws RecorderException;

    public abstract void addTexturesLibrary(String var1) throws RecorderException;

    public abstract boolean texturesLibraryExists(String var1) throws RecorderException;

    public abstract List<Library> getLibraries();

    static {
        String[] stringArray;
        DEFAULT_CLASS_LOADER = Arrays.asList(UserPreferences.class.getClassLoader());
        DEFAULT_TEXT_STYLE = new TextStyle(18.0f);
        DEFAULT_ROOM_TEXT_STYLE = new TextStyle(24.0f);
        Properties properties = new Properties();
        try {
            InputStream inputStream = UserPreferences.class.getResourceAsStream("SupportedLanguages.properties");
            properties.load(inputStream);
            inputStream.close();
            stringArray = properties.getProperty("supportedLanguages", "en").split("\\s");
        }
        catch (IOException iOException) {
            stringArray = new String[]{"en"};
        }
        DEFAULT_SUPPORTED_LANGUAGES = stringArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrefixedResourceBundle
    extends ResourceBundle {
        private ResourceBundle resourceBundle;
        private String keyPrefix;

        public PrefixedResourceBundle(ResourceBundle resourceBundle, String string) {
            this.resourceBundle = resourceBundle;
            this.keyPrefix = string;
        }

        @Override
        public Locale getLocale() {
            return this.resourceBundle.getLocale();
        }

        @Override
        protected Object handleGetObject(String string) {
            string = this.keyPrefix + string;
            return this.resourceBundle.getObject(string);
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.resourceBundle.getKeys();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        LANGUAGE,
        SUPPORTED_LANGUAGES,
        UNIT,
        CURRENCY,
        VALUE_ADDED_TAX_ENABLED,
        DEFAULT_VALUE_ADDED_TAX_PERCENTAGE,
        MAGNETISM_ENABLED,
        RULERS_VISIBLE,
        GRID_VISIBLE,
        DEFAULT_FONT_NAME,
        FURNITURE_VIEWED_FROM_TOP,
        FURNITURE_MODEL_ICON_SIZE,
        ROOM_FLOOR_COLORED_OR_TEXTURED,
        WALL_PATTERN,
        NEW_WALL_PATTERN,
        NEW_WALL_THICKNESS,
        NEW_WALL_HEIGHT,
        NEW_WALL_SIDEBOARD_THICKNESS,
        NEW_WALL_SIDEBOARD_HEIGHT,
        NEW_ROOM_FLOOR_COLOR,
        NEW_FLOOR_THICKNESS,
        RECENT_HOMES,
        IGNORED_ACTION_TIP,
        FURNITURE_CATALOG_VIEWED_IN_TREE,
        NAVIGATION_PANEL_VISIBLE,
        AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED,
        OBSERVER_CAMERA_SELECTED_AT_CHANGE,
        CHECK_UPDATES_ENABLED,
        UPDATES_MINIMUM_DATE,
        AUTO_SAVE_DELAY_FOR_RECOVERY,
        AUTO_COMPLETION_STRINGS,
        RECENT_COLORS,
        RECENT_TEXTURES,
        HOME_EXAMPLES;

    }
}

