/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HomeObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final String ID_DEFAULT_PREFIX = "object";
    private String id;
    private Map<String, String> properties;
    private transient PropertyChangeSupport propertyChangeSupport;

    public HomeObject() {
        this(HomeObject.createId(ID_DEFAULT_PREFIX));
    }

    protected static String createId(String string) {
        return string + "-" + UUID.randomUUID();
    }

    protected HomeObject(String string) {
        if (string == null) {
            throw new IllegalArgumentException("ID must exist");
        }
        this.id = string;
    }

    private void readObjectNoData() throws ObjectStreamException {
        String string = this.getClass().getSimpleName();
        if (string.length() == 0) {
            string = ID_DEFAULT_PREFIX;
        } else {
            if (string.startsWith("Home") && !string.equals("Home")) {
                string = string.substring(4);
            }
            string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        this.id = HomeObject.createId(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.readObjectNoData();
        objectInputStream.defaultReadObject();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
            if (this.propertyChangeSupport.getPropertyChangeListeners().length == 0) {
                this.propertyChangeSupport = null;
            }
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(string, propertyChangeListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    public final String getId() {
        return this.id;
    }

    public String getProperty(String string) {
        if (this.properties != null) {
            return this.properties.get(string);
        }
        return null;
    }

    public void setProperty(String string, String string2) {
        String string3;
        String string4 = string3 = this.properties != null ? this.properties.get(string) : null;
        if (string2 == null) {
            if (this.properties != null && string3 != null) {
                try {
                    this.properties.remove(string);
                    if (this.properties.size() == 0) {
                        this.properties = null;
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.properties = null;
                }
                this.firePropertyChange(string, string3, null);
            }
        } else {
            if (this.properties == null || this.properties.size() == 1 && string3 != null) {
                this.properties = Collections.singletonMap(string, string2);
            } else {
                if (this.properties.size() == 1) {
                    this.properties = new HashMap<String, String>(this.properties);
                }
                this.properties.put(string, string2);
            }
            this.firePropertyChange(string, string3, string2);
        }
    }

    public Collection<String> getPropertyNames() {
        if (this.properties != null) {
            return this.properties.keySet();
        }
        return Collections.emptySet();
    }

    public HomeObject duplicate() {
        char c;
        int n;
        HomeObject homeObject = this.clone();
        for (n = 0; n < this.id.length() && (c = Character.toLowerCase(this.id.charAt(n))) >= 'a' && c <= 'z'; ++n) {
        }
        String string = n >= 0 ? this.id.substring(0, n) : ID_DEFAULT_PREFIX;
        homeObject.id = HomeObject.createId(string);
        return homeObject;
    }

    public HomeObject clone() {
        try {
            HomeObject homeObject = (HomeObject)super.clone();
            if (this.properties != null) {
                homeObject.properties = homeObject.properties.size() == 1 ? Collections.singletonMap(this.properties.keySet().iterator().next(), this.properties.values().iterator().next()) : new HashMap<String, String>(this.properties);
            }
            homeObject.propertyChangeSupport = null;
            return homeObject;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Super class isn't cloneable");
        }
    }
}

