/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.LightSource;
import java.util.Arrays;

public class HomeLight
extends HomePieceOfFurniture
implements Light {
    private static final long serialVersionUID = 1L;
    private LightSource[] lightSources;
    private float power;

    public HomeLight(Light light) {
        this(HomeLight.createId("light"), light);
    }

    public HomeLight(String string, Light light) {
        super(string, light);
        this.lightSources = light.getLightSources();
        this.power = 0.5f;
    }

    public LightSource[] getLightSources() {
        if (this.lightSources.length == 0) {
            return this.lightSources;
        }
        return (LightSource[])this.lightSources.clone();
    }

    public void setLightSources(LightSource[] lightSourceArray) {
        if (!Arrays.equals(lightSourceArray, this.lightSources)) {
            LightSource[] lightSourceArray2 = this.lightSources.length == 0 ? this.lightSources : (LightSource[])this.lightSources.clone();
            this.lightSources = lightSourceArray.length == 0 ? lightSourceArray : (LightSource[])lightSourceArray.clone();
            this.firePropertyChange(Property.LIGHT_SOURCES.name(), lightSourceArray2, lightSourceArray);
        }
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float f) {
        if (f != this.power) {
            float f2 = this.power;
            this.power = f;
            this.firePropertyChange(Property.POWER.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public HomeLight clone() {
        return (HomeLight)super.clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        POWER,
        LIGHT_SOURCES;

    }
}

