/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.OBJMaterial;
import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBJLoader
extends LoaderBase
implements Loader {
    private static final String JAVA_3D_MATERIALS = "newmtl amber\nKa 0.0531 0.0531 0.0531\nKd 0.5755 0.2678 0.0000\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl amber_trans\nKa 0.0531 0.0531 0.0531\nKd 0.5755 0.2678 0.0000\nKs 0.3000 0.3000 0.3000\nillum 2\nd 0.1600\nNs 60.0000\n\nnewmtl charcoal\nKa 0.0082 0.0082 0.0082\nKd 0.0041 0.0041 0.0041\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl lavendar\nKa 0.1281 0.0857 0.2122\nKd 0.2187 0.0906 0.3469\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl navy_blue\nKa 0.0000 0.0000 0.0490\nKd 0.0000 0.0000 0.0531\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl pale_green\nKa 0.0444 0.0898 0.0447\nKd 0.0712 0.3796 0.0490\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl pale_pink\nKa 0.0898 0.0444 0.0444\nKd 0.6531 0.2053 0.4160\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl pale_yellow\nKa 0.3606 0.3755 0.0935\nKd 0.6898 0.6211 0.1999\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl peach\nKa 0.3143 0.1187 0.0167\nKd 0.6367 0.1829 0.0156\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl periwinkle\nKa 0.0000 0.0000 0.1184\nKd 0.0000 0.0396 0.8286\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl redwood\nKa 0.0204 0.0027 0.0000\nKd 0.2571 0.0330 0.0000\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl smoked_glass\nKa 0.0000 0.0000 0.0000\nKd 0.0041 0.0041 0.0041\nKs 0.1878 0.1878 0.1878\nillum 2\nd 0.0200\nNs 91.4700\n\nnewmtl aqua_filter\nKa 0.0000 0.0000 0.0000\nKd 0.3743 0.6694 0.5791\nKs 0.1878 0.1878 0.1878\nillum 2\nd 0.0200\nNs 91.4700\n\nnewmtl yellow_green\nKa 0.0000 0.0000 0.0000\nKd 0.1875 0.4082 0.0017\nKs 0.1878 0.1878 0.1878\nillum 2\nNs 91.4700\n\nnewmtl bluetint\nKa 0.1100 0.4238 0.5388\nKd 0.0468 0.7115 0.9551\nKs 0.3184 0.3184 0.3184\nillum 9\nd 0.4300\nNs 60.0000\nsharpness 60.0000\n\nnewmtl plasma\nKa 0.4082 0.0816 0.2129\nKd 1.0000 0.0776 0.4478\nKs 0.3000 0.3000 0.3000\nillum 9\nd 0.2500\nNs 60.0000\nsharpness 60.0000\n\nnewmtl emerald\nKa 0.0470 1.0000 0.0000\nKd 0.0470 1.0000 0.0000\nKs 0.2000 0.2000 0.2000\nillum 9\nd 0.2500\nNs 60.0000\nsharpness 60.0000\n\nnewmtl ruby\nKa 1.0000 0.0000 0.0000\nKd 1.0000 0.0000 0.0000\nKs 0.2000 0.2000 0.2000\nillum 9\nd 0.2500\nNs 60.0000\nsharpness 60.0000\n\nnewmtl sapphire\nKa 0.0235 0.0000 1.0000\nKd 0.0235 0.0000 1.0000\nKs 0.2000 0.2000 0.2000\nillum 9\nd 0.2500\nNs 60.0000\nsharpness 60.0000\n\nnewmtl white\nKa 0.4000 0.4000 0.4000\nKd 1.0000 1.0000 1.0000\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl red\nKa 0.4449 0.0000 0.0000\nKd 0.7714 0.0000 0.0000\nKs 0.8857 0.0000 0.0000\nillum 2\nNs 136.4300\n\nnewmtl blue_pure\nKa 0.0000 0.0000 0.5000\nKd 0.0000 0.0000 1.0000\nKs 0.0000 0.0000 0.5000\nillum 2\nNs 65.8900\n\nnewmtl lime\nKa 0.0000 0.5000 0.0000\nKd 0.0000 1.0000 0.0000\nKs 0.0000 0.5000 0.0000\nillum 2\nNs 65.8900\n\nnewmtl green\nKa 0.0000 0.2500 0.0000\nKd 0.0000 0.2500 0.0000\nKs 0.0000 0.2500 0.0000\nillum 2\nNs 65.8900\n\nnewmtl yellow\nKa 1.0000 0.6667 0.0000\nKd 1.0000 0.6667 0.0000\nKs 1.0000 0.6667 0.0000\nillum 2\nNs 65.8900\n\nnewmtl purple\nKa 0.5000 0.0000 1.0000\nKd 0.5000 0.0000 1.0000\nKs 0.5000 0.0000 1.0000\nillum 2\nNs 65.8900\n\nnewmtl orange\nKa 1.0000 0.1667 0.0000\nKd 1.0000 0.1667 0.0000\nKs 1.0000 0.1667 0.0000\nillum 2\nNs 65.8900\n\nnewmtl grey\nKa 0.5000 0.5000 0.5000\nKd 0.1837 0.1837 0.1837\nKs 0.5000 0.5000 0.5000\nillum 2\nNs 65.8900\n\nnewmtl rubber\nKa 0.0000 0.0000 0.0000\nKd 0.0100 0.0100 0.0100\nKs 0.1000 0.1000 0.1000\nillum 2\nNs 65.8900\n\nnewmtl flaqua\nKa 0.0000 0.4000 0.4000\nKd 0.0000 0.5000 0.5000\nillum 1\n\nnewmtl flblack\nKa 0.0000 0.0000 0.0000\nKd 0.0041 0.0041 0.0041\nillum 1\n\nnewmtl flblue_pure\nKa 0.0000 0.0000 0.5592\nKd 0.0000 0.0000 0.7102\nillum 1\n\nnewmtl flgrey\nKa 0.2163 0.2163 0.2163\nKd 0.5000 0.5000 0.5000\nillum 1\n\nnewmtl fllime\nKa 0.0000 0.3673 0.0000\nKd 0.0000 1.0000 0.0000\nillum 1\n\nnewmtl florange\nKa 0.6857 0.1143 0.0000\nKd 1.0000 0.1667 0.0000\nillum 1\n\nnewmtl flpurple\nKa 0.2368 0.0000 0.4735\nKd 0.3755 0.0000 0.7510\nillum 1\n\nnewmtl flred\nKa 0.4000 0.0000 0.0000\nKd 1.0000 0.0000 0.0000\nillum 1\n\nnewmtl flyellow\nKa 0.7388 0.4925 0.0000\nKd 1.0000 0.6667 0.0000\nillum 1\n\nnewmtl pink\nKa 0.9469 0.0078 0.2845\nKd 0.9878 0.1695 0.6702\nKs 0.7429 0.2972 0.2972\nillum 2\nNs 106.2000\n\nnewmtl flbrown\nKa 0.0571 0.0066 0.0011\nKd 0.1102 0.0120 0.0013\nillum 1\n\nnewmtl brown\nKa 0.1020 0.0185 0.0013\nKd 0.0857 0.0147 0.0000\nKs 0.1633 0.0240 0.0000\nillum 2\nNs 65.8900\n\nnewmtl glass\nKa 1.0000 1.0000 1.0000\nKd 0.4873 0.4919 0.5306\nKs 0.6406 0.6939 0.9020\nillum 2\nNs 200.0000\n\nnewmtl flesh\nKa 0.4612 0.3638 0.2993\nKd 0.5265 0.4127 0.3374\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl aqua\nKa 0.0000 0.4000 0.4000\nKd 0.0000 0.5000 0.5000\nKs 0.5673 0.5673 0.5673\nillum 2\nNs 60.0000\n\nnewmtl black\nKa 0.0000 0.0000 0.0000\nKd 0.0020 0.0020 0.0020\nKs 0.5184 0.5184 0.5184\nillum 2\nNs 157.3600\n\nnewmtl silver\nKa 0.9551 0.9551 0.9551\nKd 0.6163 0.6163 0.6163\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl dkblue_pure\nKa 0.0000 0.0000 0.0449\nKd 0.0000 0.0000 0.1347\nKs 0.0000 0.0000 0.5673\nillum 2\nNs 65.8900\n\nnewmtl fldkblue_pure\nKa 0.0000 0.0000 0.0449\nKd 0.0000 0.0000 0.1347\nillum 1\n\nnewmtl dkgreen\nKa 0.0000 0.0122 0.0000\nKd 0.0058 0.0245 0.0000\nKs 0.0000 0.0490 0.0000\nillum 2\nNs 60.0000\n\nnewmtl dkgrey\nKa 0.0490 0.0490 0.0490\nKd 0.0490 0.0490 0.0490\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl ltbrown\nKa 0.1306 0.0538 0.0250\nKd 0.2776 0.1143 0.0531\nKs 0.3000 0.1235 0.0574\nillum 2\nNs 60.0000\n\nnewmtl fldkgreen\nKa 0.0000 0.0122 0.0000\nKd 0.0058 0.0245 0.0000\nillum 1\n\nnewmtl flltbrown\nKa 0.1306 0.0538 0.0250\nKd 0.2776 0.1143 0.0531\nillum 1\n\nnewmtl tan\nKa 0.4000 0.3121 0.1202\nKd 0.6612 0.5221 0.2186\nKs 0.5020 0.4118 0.2152\nillum 2\nNs 60.0000\n\nnewmtl fltan\nKa 0.4000 0.3121 0.1202\nKd 0.6612 0.4567 0.1295\nillum 1\n\nnewmtl brzskin\nKa 0.4408 0.2694 0.1592\nKd 0.3796 0.2898 0.2122\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 25.0000\n\nnewmtl lips\nKa 0.4408 0.2694 0.1592\nKd 0.9265 0.2612 0.2898\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 25.0000\n\nnewmtl redorange\nKa 0.3918 0.0576 0.0000\nKd 0.7551 0.0185 0.0000\nKs 0.4694 0.3224 0.1667\nillum 2\nNs 132.5600\n\nnewmtl blutan\nKa 0.4408 0.2694 0.1592\nKd 0.0776 0.2571 0.2041\nKs 0.1467 0.1469 0.0965\nillum 2\nNs 25.0000\n\nnewmtl bluteal\nKa 0.0041 0.1123 0.1224\nKd 0.0776 0.2571 0.2041\nKs 0.1467 0.1469 0.0965\nillum 2\nNs 25.0000\n\nnewmtl pinktan\nKa 0.4408 0.2694 0.1592\nKd 0.6857 0.2571 0.2163\nKs 0.1467 0.1469 0.0965\nillum 2\nNs 25.0000\n\nnewmtl brnhair\nKa 0.0612 0.0174 0.0066\nKd 0.0898 0.0302 0.0110\nKs 0.1306 0.0819 0.0352\nillum 2\nNs 60.4700\n\nnewmtl blondhair\nKa 0.4449 0.2632 0.0509\nKd 0.5714 0.3283 0.0443\nKs 0.7755 0.4602 0.0918\nillum 2\nNs 4.6500\n\nnewmtl flblonde\nKa 0.4449 0.2632 0.0509\nKd 0.5714 0.3283 0.0443\nillum 1\n\nnewmtl yelloworng\nKa 0.5837 0.1715 0.0000\nKd 0.8857 0.2490 0.0000\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl bone\nKa 0.3061 0.1654 0.0650\nKd 0.9000 0.7626 0.4261\nKs 0.8939 0.7609 0.5509\nillum 2\nNs 200.0000\n\nnewmtl teeth\nKa 0.6408 0.5554 0.3845\nKd 0.9837 0.7959 0.4694\nillum 1\n\nnewmtl brass\nKa 0.2490 0.1102 0.0000\nKd 0.4776 0.1959 0.0000\nKs 0.5796 0.5796 0.5796\nillum 2\nNs 134.8800\n\nnewmtl dkred\nKa 0.0939 0.0000 0.0000\nKd 0.2286 0.0000 0.0000\nKs 0.2490 0.0000 0.0000\nillum 2\nNs 60.0000\n\nnewmtl taupe\nKa 0.1061 0.0709 0.0637\nKd 0.2041 0.1227 0.1058\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 84.5000\n\nnewmtl dkteal\nKa 0.0000 0.0245 0.0163\nKd 0.0000 0.0653 0.0449\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 55.0400\n\nnewmtl dkdkgrey\nKa 0.0000 0.0000 0.0000\nKd 0.0122 0.0122 0.0122\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl dkblue\nKa 0.0000 0.0029 0.0408\nKd 0.0000 0.0041 0.0571\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl gold\nKa 0.7224 0.1416 0.0000\nKd 1.0000 0.4898 0.0000\nKs 0.7184 0.3695 0.3695\nillum 2\nNs 123.2600\n\nnewmtl redbrick\nKa 0.1102 0.0067 0.0067\nKd 0.3306 0.0398 0.0081\nillum 1\n\nnewmtl flmustard\nKa 0.4245 0.2508 0.0000\nKd 0.8898 0.3531 0.0073\nillum 1\n\nnewmtl flpinegreen\nKa 0.0367 0.0612 0.0204\nKd 0.1061 0.2163 0.0857\nillum 1\n\nnewmtl fldkred\nKa 0.0939 0.0000 0.0000\nKd 0.2286 0.0082 0.0082\nillum 1\n\nnewmtl fldkgreen2\nKa 0.0025 0.0122 0.0014\nKd 0.0245 0.0694 0.0041\nillum 1\n\nnewmtl flmintgreen\nKa 0.0408 0.1429 0.0571\nKd 0.1306 0.2898 0.1673\nillum 1\n\nnewmtl olivegreen\nKa 0.0167 0.0245 0.0000\nKd 0.0250 0.0367 0.0000\nKs 0.2257 0.2776 0.1167\nillum 2\nNs 97.6700\n\nnewmtl skin\nKa 0.2286 0.0187 0.0187\nKd 0.1102 0.0328 0.0139\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 17.8300\n\nnewmtl redbrown\nKa 0.1469 0.0031 0.0000\nKd 0.2816 0.0060 0.0000\nKs 0.3714 0.3714 0.3714\nillum 2\nNs 141.0900\n\nnewmtl deepgreen\nKa 0.0000 0.0050 0.0000\nKd 0.0000 0.0204 0.0050\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 113.1800\n\nnewmtl flltolivegreen\nKa 0.0167 0.0245 0.0000\nKd 0.0393 0.0531 0.0100\nillum 1\n\nnewmtl jetflame\nKa 0.7714 0.0000 0.0000\nKd 0.9510 0.4939 0.0980\nKs 0.8531 0.5222 0.0000\nillum 2\nNs 132.5600\n\nnewmtl brownskn\nKa 0.0122 0.0041 0.0000\nKd 0.0204 0.0082 0.0000\nKs 0.0735 0.0508 0.0321\nillum 2\nNs 20.1600\n\nnewmtl greenskn\nKa 0.0816 0.0449 0.0000\nKd 0.0000 0.0735 0.0000\nKs 0.0490 0.1224 0.0898\nillum 3\nNs 46.5100\nsharpness 146.5100\n\nnewmtl ltgrey\nKa 0.5000 0.5000 0.5000\nKd 0.3837 0.3837 0.3837\nKs 0.5000 0.5000 0.5000\nillum 2\nNs 65.8900\n\nnewmtl bronze\nKa 0.0449 0.0204 0.0000\nKd 0.0653 0.0367 0.0122\nKs 0.0776 0.0408 0.0000\nillum 3\nNs 137.2100\nsharpness 125.5800\n\nnewmtl bone1\nKa 0.6408 0.5554 0.3845\nKd 0.9837 0.7959 0.4694\nillum 1\n\nnewmtl flwhite1\nKa 0.9306 0.9306 0.9306\nKd 1.0000 1.0000 1.0000\nillum 1\n\nnewmtl flwhite\nKa 0.6449 0.6116 0.5447\nKd 0.9837 0.9309 0.8392\nKs 0.8082 0.7290 0.5708\nillum 2\nNs 200.0000\n\nnewmtl shadow\nKd 0.0350 0.0248 0.0194\nillum 0\nd 0.2500\n\nnewmtl fldkolivegreen\nKa 0.0056 0.0082 0.0000\nKd 0.0151 0.0204 0.0038\nillum 1\n\nnewmtl fldkdkgrey\nKa 0.0000 0.0000 0.0000\nKd 0.0122 0.0122 0.0122\nillum 1\n\nnewmtl lcdgreen\nKa 0.4000 0.4000 0.4000\nKd 0.5878 1.0000 0.5061\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl brownlips\nKa 0.1143 0.0694 0.0245\nKd 0.1429 0.0653 0.0408\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 25.0000\n\nnewmtl muscle\nKa 0.2122 0.0077 0.0154\nKd 0.4204 0.0721 0.0856\nKs 0.1184 0.1184 0.1184\nillum 2\nNs 25.5800\n\nnewmtl flltgrey\nKa 0.5224 0.5224 0.5224\nKd 0.8245 0.8245 0.8245\nillum 1\n\nnewmtl offwhite.warm\nKa 0.5184 0.4501 0.3703\nKd 0.8367 0.6898 0.4490\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl offwhite.cool\nKa 0.5184 0.4501 0.3703\nKd 0.8367 0.6812 0.5703\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl yellowbrt\nKa 0.4000 0.4000 0.4000\nKd 1.0000 0.7837 0.0000\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl chappie\nKa 0.4000 0.4000 0.4000\nKd 0.5837 0.1796 0.0367\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 60.0000\n\nnewmtl archwhite\nKa 0.2816 0.2816 0.2816\nKd 0.9959 0.9959 0.9959\nillum 1\n\nnewmtl archwhite2\nKa 0.2816 0.2816 0.2816\nKd 0.8408 0.8408 0.8408\nillum 1\n\nnewmtl lighttan\nKa 0.0980 0.0536 0.0220\nKd 0.7020 0.4210 0.2206\nKs 0.8286 0.8057 0.5851\nillum 2\nNs 177.5200\n\nnewmtl lighttan2\nKa 0.0980 0.0492 0.0144\nKd 0.3143 0.1870 0.0962\nKs 0.8286 0.8057 0.5851\nillum 2\nNs 177.5200\n\nnewmtl lighttan3\nKa 0.0980 0.0492 0.0144\nKd 0.1796 0.0829 0.0139\nKs 0.8286 0.8057 0.5851\nillum 2\nNs 177.5200\n\nnewmtl lightyellow\nKa 0.5061 0.1983 0.0000\nKd 1.0000 0.9542 0.3388\nKs 1.0000 0.9060 0.0000\nillum 2\nNs 177.5200\n\nnewmtl lighttannew\nKa 0.0980 0.0492 0.0144\nKd 0.7878 0.6070 0.3216\nKs 0.8286 0.8057 0.5851\nillum 2\nNs 177.5200\n\nnewmtl default\nKa 0.4000 0.4000 0.4000\nKd 0.7102 0.7020 0.6531\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 128.0000\n\nnewmtl ship2\nKa 0.0000 0.0000 0.0000\nKd 1.0000 1.0000 1.0000\nKs 0.1143 0.1143 0.1143\nillum 2\nNs 60.0000\n\nnewmtl dkpurple\nKa 0.0082 0.0000 0.0163\nKd 0.0245 0.0000 0.0490\nKs 0.1266 0.0000 0.2531\nillum 2\nNs 65.8900\n\nnewmtl dkorange\nKa 0.4041 0.0123 0.0000\nKd 0.7143 0.0350 0.0000\nKs 0.7102 0.0870 0.0000\nillum 2\nNs 65.8900\n\nnewmtl mintgrn\nKa 0.0101 0.1959 0.0335\nKd 0.0245 0.4776 0.0816\nKs 0.0245 0.4776 0.0816\nillum 2\nNs 65.8900\n\nnewmtl fgreen\nKa 0.0000 0.0449 0.0000\nKd 0.0000 0.0449 0.0004\nKs 0.0062 0.0694 0.0000\nillum 2\nNs 106.2000\n\nnewmtl glassblutint\nKa 0.4000 0.4000 0.4000\nKd 0.5551 0.8000 0.7730\nKs 0.7969 0.9714 0.9223\nillum 4\nd 0.6700\nNs 60.0000\nsharpness 60.0000\n\nnewmtl bflesh\nKa 0.0122 0.0122 0.0122\nKd 0.0245 0.0081 0.0021\nKs 0.0531 0.0460 0.0153\nillum 2\nNs 20.1600\n\nnewmtl meh\nKa 0.4000 0.4000 0.4000\nKd 0.5551 0.8000 0.7730\nKs 0.7969 0.9714 0.9223\nillum 4\nd 0.2500\nNs 183.7200\nsharpness 60.0000\n\nnewmtl violet\nKa 0.0083 0.0000 0.1265\nKd 0.0287 0.0269 0.1347\nKs 0.2267 0.4537 0.6612\nillum 2\nNs 96.9000\n\nnewmtl iris\nKa 0.3061 0.0556 0.0037\nKd 0.0000 0.0572 0.3184\nKs 0.8041 0.6782 0.1477\nillum 2\nNs 188.3700\n\nnewmtl blugrn\nKa 0.4408 0.4144 0.1592\nKd 0.0811 0.6408 0.2775\nKs 0.1467 0.1469 0.0965\nillum 2\nNs 25.0000\n\nnewmtl glasstransparent\nKa 0.2163 0.2163 0.2163\nKd 0.4694 0.4694 0.4694\nKs 0.6082 0.6082 0.6082\nillum 4\nd 0.2500\nNs 200.0000\nsharpness 60.0000\n\nnewmtl fleshtransparent\nKa 0.4000 0.2253 0.2253\nKd 0.6898 0.2942 0.1295\nKs 0.7388 0.4614 0.4614\nillum 4\nd 0.2500\nNs 6.2000\nsharpness 60.0000\n\nnewmtl fldkgrey\nKa 0.0449 0.0449 0.0449\nKd 0.0939 0.0939 0.0939\nillum 1\n\nnewmtl sky_blue\nKa 0.1363 0.2264 0.4122\nKd 0.1241 0.5931 0.8000\nKs 0.0490 0.0490 0.0490\nillum 2\nNs 13.9500\n\nnewmtl fldkpurple\nKa 0.0443 0.0257 0.0776\nKd 0.1612 0.0000 0.3347\nKs 0.0000 0.0000 0.0000\nillum 2\nNs 13.9500\n\nnewmtl dkbrown\nKa 0.0143 0.0062 0.0027\nKd 0.0087 0.0038 0.0016\nKs 0.2370 0.2147 0.1821\nillum 3\nNs 60.0000\nsharpness 60.0000\n\nnewmtl bone2\nKa 0.6408 0.5388 0.3348\nKd 0.9837 0.8620 0.6504\nillum 1\n\nnewmtl bluegrey\nKa 0.4000 0.4000 0.4000\nKd 0.1881 0.2786 0.2898\nKs 0.3000 0.3000 0.3000\nillum 2\nNs 14.7300\n\nnewmtl metal\nKa 0.9102 0.8956 0.1932\nKd 0.9000 0.7626 0.4261\nKs 0.8939 0.8840 0.8683\nillum 2\nNs 200.0000\n\nnewmtl sand_stone\nKa 0.1299 0.1177 0.0998\nKd 0.1256 0.1138 0.0965\nKs 0.2370 0.2147 0.1821\nillum 3\nNs 60.0000\nsharpness 60.0000\n\nnewmtl hair\nKa 0.0013 0.0012 0.0010\nKd 0.0008 0.0007 0.0006\nKs 0.0000 0.0000 0.0000\nillum 3\nNs 60.0000\nsharpness 60.0000\n";
    private static final Map<String, Appearance> DEFAULT_APPEARANCES;
    private Boolean useCaches;
    private List<Point3f> vertices;
    private List<TexCoord2f> textureCoordinates;
    private List<Vector3f> normals;
    private Map<String, Group> groups;
    private Group currentGroup;
    private String currentMaterial;
    private boolean currentSmooth;
    private Map<String, Appearance> appearances;

    public void setUseCaches(Boolean bl) {
        this.useCaches = (boolean)bl;
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        URL uRL;
        try {
            uRL = this.basePath != null ? new File(this.basePath).toURI().toURL() : new File(string).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileNotFoundException(string);
        }
        try {
            return this.load(new InputStreamReader((InputStream)new FileInputStream(string), "ISO-8859-1"), uRL);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.load(new InputStreamReader(new FileInputStream(string)));
        }
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        InputStream inputStream;
        URL uRL2 = this.baseUrl;
        if (this.baseUrl == null) {
            uRL2 = uRL;
        }
        try {
            inputStream = OBJLoader.openStream(uRL, this.useCaches);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Can't read " + uRL);
        }
        try {
            return this.load(new InputStreamReader(inputStream, "ISO-8859-1"), uRL2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return this.load(new InputStreamReader(inputStream));
        }
    }

    private static InputStream openStream(URL uRL, Boolean bl) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (bl != null) {
            uRLConnection.setUseCaches(bl);
        }
        return uRLConnection.getInputStream();
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        return this.load(reader, null);
    }

    private Scene load(Reader reader, URL uRL) throws FileNotFoundException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        try {
            Scene scene = this.parseObjectStream(reader, uRL);
            return scene;
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                throw new ParsingErrorException(iOException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scene parseObjectStream(Reader reader, URL uRL) throws IOException {
        this.vertices = new ArrayList<Point3f>();
        this.textureCoordinates = new ArrayList<TexCoord2f>();
        this.normals = new ArrayList<Vector3f>();
        this.groups = new LinkedHashMap<String, Group>();
        this.currentGroup = new Group("default");
        this.groups.put("default", this.currentGroup);
        this.currentMaterial = "default";
        this.appearances = new HashMap<String, Appearance>(DEFAULT_APPEARANCES);
        StreamTokenizer streamTokenizer = OBJLoader.createTokenizer(reader);
        block7: while (streamTokenizer.nextToken() != -1) {
            switch (streamTokenizer.ttype) {
                case -3: {
                    this.parseObjectLine(streamTokenizer, uRL);
                    continue block7;
                }
                case 10: {
                    continue block7;
                }
            }
            throw new IncorrectFormatException("Unexpected token " + streamTokenizer.sval + " at row " + streamTokenizer.lineno());
        }
        try {
            SceneBase sceneBase = this.createScene();
            return sceneBase;
        }
        finally {
            this.vertices = null;
            this.textureCoordinates = null;
            this.normals = null;
            this.groups = null;
            this.appearances = null;
        }
    }

    private SceneBase createScene() {
        Point3f[] point3fArray = this.vertices.toArray(new Point3f[this.vertices.size()]);
        TexCoord2f[] texCoord2fArray = this.textureCoordinates.toArray(new TexCoord2f[this.textureCoordinates.size()]);
        Vector3f[] vector3fArray = this.normals.toArray(new Vector3f[this.normals.size()]);
        SceneBase sceneBase = new SceneBase();
        BranchGroup branchGroup = new BranchGroup();
        sceneBase.setSceneGroup(branchGroup);
        for (Group group : this.groups.values()) {
            List<Geometry> list = group.getGeometries();
            if (list == null || list.isEmpty()) continue;
            int n = 0;
            while (n < list.size()) {
                LineStripArray lineStripArray;
                Object object;
                Object object2;
                Geometry geometry = list.get(n);
                boolean bl = geometry.hasTextureCoordinateIndices();
                boolean bl2 = geometry instanceof Face && ((Face)geometry).hasNormalIndices();
                boolean bl3 = geometry instanceof Face && ((Face)geometry).isSmooth();
                String string = geometry.getMaterial();
                Appearance appearance = this.getAppearance(string);
                int n2 = n;
                while (++n2 < list.size()) {
                    Geometry geometry2 = list.get(n2);
                    String string2 = geometry2.getMaterial();
                    if (!(geometry2.getClass() != geometry.getClass() || string2 == null && string != null || string2 != null && this.getAppearance(string2) != appearance || bl3 ^ (geometry2 instanceof Face && ((Face)geometry2).isSmooth()) || bl ^ geometry2.hasTextureCoordinateIndices()) && !(bl2 ^ (geometry2 instanceof Face && ((Face)geometry2).hasNormalIndices()))) continue;
                    break;
                }
                int n3 = n2 - n;
                int n4 = 0;
                for (int i = 0; i < n3; ++i) {
                    n4 += list.get(n + i).getVertexIndices().length;
                }
                int[] nArray = new int[n4];
                int[] nArray2 = new int[n3];
                int n5 = 0;
                for (int i = 0; i < n3; ++i) {
                    object2 = list.get(n + i).getVertexIndices();
                    System.arraycopy(object2, 0, nArray, n5, ((int[])object2).length);
                    nArray2[i] = ((int[])object2).length;
                    n5 += ((int[])object2).length;
                }
                int[] nArray3 = null;
                if (bl) {
                    nArray3 = new int[n4];
                    int n6 = 0;
                    for (n5 = 0; n5 < n3; ++n5) {
                        object = list.get(n + n5).getTextureCoordinateIndices();
                        System.arraycopy(object, 0, nArray3, n6, ((int[])object).length);
                        n6 += ((int[])object).length;
                    }
                }
                if (geometry instanceof Face) {
                    GeometryInfo geometryInfo = new GeometryInfo(5);
                    geometryInfo.setCoordinates(point3fArray);
                    geometryInfo.setCoordinateIndices(nArray);
                    geometryInfo.setStripCounts(nArray2);
                    if (bl) {
                        geometryInfo.setTextureCoordinateParams(1, 2);
                        geometryInfo.setTextureCoordinates(0, texCoord2fArray);
                        geometryInfo.setTextureCoordinateIndices(0, nArray3);
                    }
                    if (bl2) {
                        object = new int[n4];
                        int n7 = 0;
                        for (int i = 0; i < n3; ++i) {
                            int[] nArray4 = ((Face)list.get(n + i)).getNormalIndices();
                            System.arraycopy(nArray4, 0, object, n7, nArray4.length);
                            n7 += nArray4.length;
                        }
                        geometryInfo.setNormals(vector3fArray);
                        geometryInfo.setNormalIndices(object);
                    } else {
                        object = new NormalGenerator(1.5707963267948966);
                        if (!bl3) {
                            object.setCreaseAngle(0.0);
                        }
                        object.generateNormals(geometryInfo);
                    }
                    lineStripArray = geometryInfo.getGeometryArray(true, true, false);
                } else {
                    int n8;
                    int n9 = 1;
                    if (bl) {
                        n9 |= 0x20;
                    }
                    lineStripArray = new LineStripArray(nArray.length, n9, nArray2);
                    for (n8 = 0; n8 < nArray.length; ++n8) {
                        lineStripArray.setCoordinate(n8, point3fArray[nArray[n8]]);
                    }
                    if (bl) {
                        for (n8 = 0; n8 < nArray.length; ++n8) {
                            lineStripArray.setTextureCoordinate(0, n8, texCoord2fArray[nArray3[n8]]);
                        }
                    }
                }
                if (appearance != null) {
                    appearance = (Appearance)appearance.cloneNodeComponent(false);
                    if (!bl && appearance.getTexture() != null) {
                        appearance.setTexCoordGeneration(new TexCoordGeneration());
                    }
                }
                object2 = new Shape3D((javax.media.j3d.Geometry)lineStripArray, appearance);
                branchGroup.addChild((Node)object2);
                sceneBase.addNamedObject(group.getName() + (n == 0 ? "" : "_" + String.valueOf(n)), object2);
                n = n2;
            }
        }
        return sceneBase;
    }

    private Appearance getAppearance(String string) {
        Appearance appearance = null;
        if (string != null) {
            appearance = this.appearances.get(string);
        }
        if (appearance == null) {
            appearance = DEFAULT_APPEARANCES.get("default");
        }
        return appearance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseObjectLine(StreamTokenizer streamTokenizer, URL uRL) throws IOException {
        if ("v".equals(streamTokenizer.sval)) {
            float f = OBJLoader.parseNumber(streamTokenizer);
            OBJLoader.skipBackSlash(streamTokenizer);
            float f2 = OBJLoader.parseNumber(streamTokenizer);
            OBJLoader.skipBackSlash(streamTokenizer);
            float f3 = OBJLoader.parseNumber(streamTokenizer);
            this.vertices.add(new Point3f(f, f2, f3));
            if (streamTokenizer.nextToken() == 10) {
                streamTokenizer.pushBack();
            }
        } else if ("vn".equals(streamTokenizer.sval)) {
            float f = OBJLoader.parseNumber(streamTokenizer);
            OBJLoader.skipBackSlash(streamTokenizer);
            float f4 = OBJLoader.parseNumber(streamTokenizer);
            OBJLoader.skipBackSlash(streamTokenizer);
            float f5 = OBJLoader.parseNumber(streamTokenizer);
            this.normals.add(new Vector3f(f, f4, f5));
        } else if ("vt".equals(streamTokenizer.sval)) {
            float f = OBJLoader.parseNumber(streamTokenizer);
            OBJLoader.skipBackSlash(streamTokenizer);
            float f6 = OBJLoader.parseNumber(streamTokenizer);
            this.textureCoordinates.add(new TexCoord2f(f, f6));
            if (streamTokenizer.nextToken() == 10) {
                streamTokenizer.pushBack();
            }
        } else if ("l".equals(streamTokenizer.sval)) {
            streamTokenizer.ordinaryChar(47);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(2);
            boolean bl = true;
            while (true) {
                if (bl) {
                    bl = false;
                } else {
                    OBJLoader.skipBackSlash(streamTokenizer);
                }
                if (streamTokenizer.nextToken() == 10) break;
                streamTokenizer.pushBack();
                int n = OBJLoader.parseInteger(streamTokenizer) - 1;
                if (n < 0) {
                    n += this.vertices.size() + 1;
                }
                arrayList.add(n);
                if (streamTokenizer.nextToken() != 47) {
                    streamTokenizer.pushBack();
                    continue;
                }
                int n2 = OBJLoader.parseInteger(streamTokenizer) - 1;
                if (n2 < 0) {
                    n2 += this.textureCoordinates.size() + 1;
                }
                arrayList2.add(n2);
            }
            streamTokenizer.pushBack();
            streamTokenizer.wordChars(47, 47);
            if (arrayList2.size() != 0 && arrayList2.size() != arrayList.size()) {
                arrayList2.clear();
            }
            if (arrayList.size() > 1) {
                this.currentGroup.addGeometry(new Line(arrayList, arrayList2, this.currentMaterial));
            }
        } else if ("f".equals(streamTokenizer.sval)) {
            streamTokenizer.ordinaryChar(47);
            ArrayList<Integer> arrayList = new ArrayList<Integer>(4);
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>(4);
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>(4);
            boolean bl = true;
            while (true) {
                int n;
                if (bl) {
                    bl = false;
                } else {
                    OBJLoader.skipBackSlash(streamTokenizer);
                }
                if (streamTokenizer.nextToken() == 10) break;
                streamTokenizer.pushBack();
                int n3 = OBJLoader.parseInteger(streamTokenizer) - 1;
                if (n3 < 0) {
                    n3 += this.vertices.size() + 1;
                }
                arrayList.add(n3);
                if (streamTokenizer.nextToken() != 47) {
                    streamTokenizer.pushBack();
                    continue;
                }
                if (streamTokenizer.nextToken() != 47) {
                    streamTokenizer.pushBack();
                    n = OBJLoader.parseInteger(streamTokenizer) - 1;
                    if (n < 0) {
                        n += this.textureCoordinates.size() + 1;
                    }
                    arrayList3.add(n);
                    streamTokenizer.nextToken();
                }
                if (streamTokenizer.ttype == 47) {
                    n = OBJLoader.parseInteger(streamTokenizer) - 1;
                    if (n < 0) {
                        n += this.normals.size() + 1;
                    }
                    arrayList4.add(n);
                    continue;
                }
                streamTokenizer.pushBack();
            }
            streamTokenizer.pushBack();
            streamTokenizer.wordChars(47, 47);
            if (arrayList3.size() != 0 && arrayList3.size() != arrayList.size()) {
                arrayList3.clear();
            }
            if (arrayList4.size() != 0 && arrayList4.size() != arrayList.size()) {
                arrayList4.clear();
            }
            if (arrayList.size() > 2) {
                this.currentGroup.addGeometry(new Face(arrayList, arrayList3, arrayList4, this.currentSmooth, this.currentMaterial));
            }
        } else if ("g".equals(streamTokenizer.sval) || "o".equals(streamTokenizer.sval)) {
            if (streamTokenizer.nextToken() == -3) {
                this.currentGroup = this.groups.get(streamTokenizer.sval);
                if (this.currentGroup == null) {
                    this.currentGroup = new Group(streamTokenizer.sval);
                    this.groups.put(this.currentGroup.getName(), this.currentGroup);
                }
            } else {
                if (streamTokenizer.ttype != 10) throw new IncorrectFormatException("Expected group or object name at line " + streamTokenizer.lineno());
                this.currentGroup = this.groups.get("default");
                streamTokenizer.pushBack();
            }
            while (streamTokenizer.nextToken() == -3) {
            }
            streamTokenizer.pushBack();
        } else if ("s".equals(streamTokenizer.sval)) {
            if (streamTokenizer.nextToken() != -3) throw new IncorrectFormatException("Expected smoothing group or off at line " + streamTokenizer.lineno());
            this.currentSmooth = !"off".equals(streamTokenizer.sval);
        } else if ("usemtl".equals(streamTokenizer.sval)) {
            streamTokenizer.wordChars(32, 32);
            int n = streamTokenizer.nextToken();
            streamTokenizer.whitespaceChars(32, 32);
            if (n != -3) throw new IncorrectFormatException("Expected material name at line " + streamTokenizer.lineno());
            this.currentMaterial = streamTokenizer.sval;
        } else if ("mtllib".equals(streamTokenizer.sval)) {
            String[] stringArray;
            streamTokenizer.wordChars(32, 32);
            int n = streamTokenizer.nextToken();
            streamTokenizer.whitespaceChars(32, 32);
            if (n != -3) throw new IncorrectFormatException("Expected material library at line " + streamTokenizer.lineno());
            String string = streamTokenizer.sval.trim();
            int n4 = 0;
            for (String string2 : stringArray = string.split(" ")) {
                if (!this.parseMaterial(string2, uRL)) continue;
                ++n4;
            }
            if (stringArray.length > 1 && n4 == 0) {
                this.parseMaterial(string, uRL);
            }
        } else {
            int n;
            while ((n = streamTokenizer.nextToken()) != 10 && n != -1) {
            }
            streamTokenizer.pushBack();
        }
        int n = streamTokenizer.nextToken();
        if (n == 10 || n == -1) return;
        throw new IncorrectFormatException("Expected end of line at line " + streamTokenizer.lineno());
    }

    private static StreamTokenizer createTokenizer(Reader reader) {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.resetSyntax();
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.wordChars(33, 126);
        streamTokenizer.wordChars(128, 255);
        streamTokenizer.whitespaceChars(32, 32);
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.whitespaceChars(13, 13);
        streamTokenizer.whitespaceChars(9, 9);
        return streamTokenizer;
    }

    private static int parseInteger(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != -3) {
            throw new IncorrectFormatException("Expected an integer at line " + streamTokenizer.lineno());
        }
        try {
            return Integer.parseInt(streamTokenizer.sval);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IncorrectFormatException("Found " + streamTokenizer.sval + " instead of an integer at line " + streamTokenizer.lineno());
        }
    }

    private static float parseNumber(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() != -3) {
            throw new IncorrectFormatException("Expected a number at line " + streamTokenizer.lineno());
        }
        try {
            return Float.parseFloat(streamTokenizer.sval);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IncorrectFormatException("Found " + streamTokenizer.sval + " instead of a number at line " + streamTokenizer.lineno());
        }
    }

    private static void skipBackSlash(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.ordinaryChar(92);
        if (streamTokenizer.nextToken() == 92) {
            if (streamTokenizer.nextToken() != 10) {
                throw new IncorrectFormatException("Expected new line after \\ character");
            }
        } else {
            streamTokenizer.pushBack();
        }
        streamTokenizer.wordChars(92, 92);
    }

    private boolean parseMaterial(String string, URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL != null ? OBJLoader.openStream(new URL(uRL, string.replace("%", "%25").replace("#", "%23")), this.useCaches) : new FileInputStream(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (inputStream != null) {
            try {
                this.appearances.putAll(OBJLoader.parseMaterialStream(new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1")), uRL, this.useCaches));
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                throw new ParsingErrorException(iOException.getMessage());
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new ParsingErrorException(iOException.getMessage());
                }
            }
        }
        return false;
    }

    private static Map<String, Appearance> parseMaterialStream(Reader reader, URL uRL, Boolean bl) throws IOException {
        HashMap<String, Appearance> hashMap = new HashMap<String, Appearance>();
        Appearance appearance = null;
        StreamTokenizer streamTokenizer = OBJLoader.createTokenizer(reader);
        block4: while (streamTokenizer.nextToken() != -1) {
            switch (streamTokenizer.ttype) {
                case -3: {
                    appearance = OBJLoader.parseMaterialLine(streamTokenizer, hashMap, appearance, uRL, bl);
                    continue block4;
                }
                case 10: {
                    continue block4;
                }
            }
            throw new IncorrectFormatException("Unexpected token " + streamTokenizer.sval + " at row " + streamTokenizer.lineno());
        }
        return hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Appearance parseMaterialLine(StreamTokenizer streamTokenizer, Map<String, Appearance> map, Appearance appearance, URL uRL, Boolean bl) throws IOException {
        if ("newmtl".equals(streamTokenizer.sval)) {
            streamTokenizer.wordChars(32, 32);
            int n = streamTokenizer.nextToken();
            streamTokenizer.whitespaceChars(32, 32);
            if (n != -3) throw new IncorrectFormatException("Expected material name at line " + streamTokenizer.lineno());
            appearance = new Appearance();
            map.put(streamTokenizer.sval, appearance);
            try {
                appearance.setName(streamTokenizer.sval);
            }
            catch (NoSuchMethodError noSuchMethodError) {}
        } else if ("Ka".equals(streamTokenizer.sval)) {
            Color3f color3f = new Color3f(OBJLoader.parseNumber(streamTokenizer), OBJLoader.parseNumber(streamTokenizer), OBJLoader.parseNumber(streamTokenizer));
            if (appearance != null) {
                OBJMaterial oBJMaterial = OBJLoader.getMaterial(appearance);
                oBJMaterial.setAmbientColor(color3f);
            }
        } else if ("Kd".equals(streamTokenizer.sval)) {
            Color3f color3f = new Color3f(OBJLoader.parseNumber(streamTokenizer), OBJLoader.parseNumber(streamTokenizer), OBJLoader.parseNumber(streamTokenizer));
            if (appearance != null) {
                OBJMaterial oBJMaterial = OBJLoader.getMaterial(appearance);
                oBJMaterial.setDiffuseColor(color3f);
                appearance.setColoringAttributes(new ColoringAttributes(color3f, 3));
            }
        } else if ("Ks".equals(streamTokenizer.sval)) {
            Color3f color3f = new Color3f(OBJLoader.parseNumber(streamTokenizer), OBJLoader.parseNumber(streamTokenizer), OBJLoader.parseNumber(streamTokenizer));
            if (appearance != null) {
                OBJMaterial oBJMaterial = OBJLoader.getMaterial(appearance);
                if (!oBJMaterial.isIlluminationModelSet() || oBJMaterial.getIlluminationModel() >= 2) {
                    oBJMaterial.setSpecularColor(color3f);
                } else {
                    oBJMaterial.setSpecularColor(0.0f, 0.0f, 0.0f);
                }
            }
        } else if ("Ns".equals(streamTokenizer.sval)) {
            float f = OBJLoader.parseNumber(streamTokenizer);
            if (appearance != null) {
                OBJMaterial oBJMaterial = OBJLoader.getMaterial(appearance);
                if (!oBJMaterial.isIlluminationModelSet() || oBJMaterial.getIlluminationModel() >= 2) {
                    oBJMaterial.setShininess(Math.max(1.0f, Math.min(f, 128.0f)));
                } else {
                    oBJMaterial.setShininess(1.0f);
                }
            }
        } else if ("Ni".equals(streamTokenizer.sval)) {
            float f = OBJLoader.parseNumber(streamTokenizer);
            if (appearance != null) {
                OBJMaterial oBJMaterial = OBJLoader.getMaterial(appearance);
                oBJMaterial.setOpticalDensity(f);
            }
        } else if ("sharpness".equals(streamTokenizer.sval)) {
            float f = OBJLoader.parseNumber(streamTokenizer);
            if (appearance != null) {
                OBJMaterial oBJMaterial = OBJLoader.getMaterial(appearance);
                oBJMaterial.setSharpness(f);
            }
        } else if ("d".equals(streamTokenizer.sval)) {
            if (streamTokenizer.nextToken() != -3) throw new IncorrectFormatException("Expected transparency factor at line " + streamTokenizer.lineno());
            if ("-halo".equals(streamTokenizer.sval)) {
                OBJLoader.parseNumber(streamTokenizer);
            } else {
                streamTokenizer.pushBack();
                float f = OBJLoader.parseNumber(streamTokenizer);
                if (appearance != null) {
                    if (f >= 1.0f) {
                        appearance.setTransparencyAttributes(null);
                    } else {
                        appearance.setTransparencyAttributes(new TransparencyAttributes(1, 1.0f - Math.max(0.0f, f)));
                    }
                }
            }
        } else if ("illum".equals(streamTokenizer.sval)) {
            int n = OBJLoader.parseInteger(streamTokenizer);
            if (appearance != null) {
                OBJMaterial oBJMaterial = OBJLoader.getMaterial(appearance);
                oBJMaterial.setIlluminationModel(n);
                oBJMaterial.setLightingEnable(n >= 1);
                if (n <= 1) {
                    oBJMaterial.setSpecularColor(0.0f, 0.0f, 0.0f);
                    oBJMaterial.setShininess(1.0f);
                }
            }
        } else if ("map_Kd".equals(streamTokenizer.sval)) {
            streamTokenizer.wordChars(32, 32);
            int n = streamTokenizer.nextToken();
            streamTokenizer.whitespaceChars(32, 32);
            if (n != -3) throw new IncorrectFormatException("Expected image file name at line " + streamTokenizer.lineno());
            String string = streamTokenizer.sval.trim();
            String[] stringArray = string.split(" ");
            if (stringArray.length > 0) {
                Texture texture = OBJLoader.readTexture(stringArray[stringArray.length - 1], map, uRL, bl);
                if (texture == null && stringArray.length > 1) {
                    texture = OBJLoader.readTexture(string, map, uRL, bl);
                }
                if (texture != null) {
                    appearance.setTexture(texture);
                }
            }
        } else {
            int n;
            while ((n = streamTokenizer.nextToken()) != 10 && n != -1) {
            }
            streamTokenizer.pushBack();
        }
        int n = streamTokenizer.nextToken();
        if (n == 10 || n == -1) return appearance;
        throw new IncorrectFormatException("Expected end of line at line " + streamTokenizer.lineno());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Texture readTexture(String string, Map<String, Appearance> map, URL uRL, Boolean bl) throws IOException {
        block14: {
            InputStream inputStream = null;
            try {
                Texture texture;
                URL uRL2 = uRL != null ? new URL(uRL, string.replace("%", "%25").replace("#", "%23")) : new File(string).toURI().toURL();
                for (Appearance appearance : map.values()) {
                    texture = appearance.getTexture();
                    if (texture == null || !uRL2.equals(texture.getUserData())) continue;
                    Texture texture2 = texture;
                    return texture2;
                }
                inputStream = OBJLoader.openStream(uRL2, bl);
                Object object = null;
                try {
                    object = ImageIO.read(inputStream);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    inputStream.close();
                    inputStream = OBJLoader.openStream(uRL2, bl);
                    object = ImageIO.read(inputStream);
                }
                if (object != null) {
                    Appearance appearance;
                    appearance = new TextureLoader((BufferedImage)object);
                    texture = appearance.getTexture();
                    texture.setUserData((Object)uRL2);
                    Texture texture3 = texture;
                    return texture3;
                }
            }
            catch (IOException iOException) {
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getClass().getName().equals("com.sun.j3d.utils.image.ImageException")) {
                    break block14;
                }
                throw runtimeException;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return null;
    }

    private static OBJMaterial getMaterial(Appearance appearance) {
        OBJMaterial oBJMaterial = (OBJMaterial)appearance.getMaterial();
        if (oBJMaterial == null) {
            oBJMaterial = new OBJMaterial();
            appearance.setMaterial((Material)oBJMaterial);
        }
        return oBJMaterial;
    }

    static {
        try {
            DEFAULT_APPEARANCES = OBJLoader.parseMaterialStream(new StringReader(JAVA_3D_MATERIALS), null, null);
        }
        catch (IOException iOException) {
            throw new InternalError("Can't access to default materials");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Group {
        private final String name;
        private List<Geometry> geometries;

        public Group(String string) {
            this.name = string;
            this.geometries = new ArrayList<Geometry>();
        }

        public String getName() {
            return this.name;
        }

        public void addGeometry(Geometry geometry) {
            this.geometries.add(geometry);
        }

        public List<Geometry> getGeometries() {
            return this.geometries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Face
    extends Geometry {
        private int[] normalIndices;
        private boolean smooth;

        public Face(List<Integer> list, List<Integer> list2, List<Integer> list3, boolean bl, String string) {
            super(list, list2, string);
            this.smooth = bl;
            if (list3.size() != 0) {
                this.normalIndices = new int[list3.size()];
                for (int i = 0; i < this.normalIndices.length; ++i) {
                    this.normalIndices[i] = list3.get(i);
                }
            }
        }

        public boolean isSmooth() {
            return this.smooth;
        }

        public int[] getNormalIndices() {
            return this.normalIndices;
        }

        public boolean hasNormalIndices() {
            return this.normalIndices != null && this.normalIndices.length > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Line
    extends Geometry {
        public Line(List<Integer> list, List<Integer> list2, String string) {
            super(list, list2, string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Geometry {
        private int[] vertexIndices;
        private int[] textureCoordinateIndices;
        private String material;

        public Geometry(List<Integer> list, List<Integer> list2, String string) {
            int n;
            this.vertexIndices = new int[list.size()];
            for (n = 0; n < this.vertexIndices.length; ++n) {
                this.vertexIndices[n] = list.get(n);
            }
            if (list2.size() != 0) {
                this.textureCoordinateIndices = new int[list2.size()];
                for (n = 0; n < this.textureCoordinateIndices.length; ++n) {
                    this.textureCoordinateIndices[n] = list2.get(n);
                }
            }
            this.material = string;
        }

        public int[] getVertexIndices() {
            return this.vertexIndices;
        }

        public int[] getTextureCoordinateIndices() {
            return this.textureCoordinateIndices;
        }

        public boolean hasTextureCoordinateIndices() {
            return this.textureCoordinateIndices != null && this.textureCoordinateIndices.length > 0;
        }

        public String getMaterial() {
            return this.material;
        }
    }
}

