# -*- coding:utf-8 -*-

# Speedflow Add-on
# Copyright (C) 2018 Cedric Lepiller aka Pitiwazou & Legigan Jeremy AKA Pistiwique and Stephen Leger
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# <pep8 compliant>


import bpy
from bpy.types import Menu
from bpy.props import (StringProperty,
                       BoolProperty,
                       FloatVectorProperty,
                       FloatProperty,
                       EnumProperty,
                       IntProperty)
import bmesh
from .functions import *
                
#Expand
def toggle_all_modifiers(self, context):
    """EXPAND MODIFIERS LIST"""
    for mod in context.object.modifiers:
        mod.show_expanded = self.toggle_all_modifiers_prop

def hide_all_modifiers(self, context):
    """SHOW/HIDE MODIFIERS"""
    for mod in context.object.modifiers:
        mod.show_viewport = self.hide_all_modifiers_prop

def get_modifier_list(obj, mod_type):
    return [mod.name for mod in obj.modifiers if mod.type == mod_type]

#Remove    
class SFC_OT_add_apply_remove_modifiers_Types(bpy.types.Operator):
    """
        MODIFIERS

        Add
        Apply
        Remove


        """
    bl_idname = "object.sfc_add_apply_remove_modifiers"
    bl_label = "Sfc Apply Modifiers Enum"
    bl_options = {"REGISTER","UNDO"}

    modifiers_types : EnumProperty(
        items = (('all', "All", "ALL MODIFIERS"),
                 ('bevel', "Bevel", "BEVEL"),
                 ('boolean', "Boolean", "BOOLEAN"),
                 ('subsurf', "Subsurf", "SUBSURF"),
                 ('mirror', "Mirror", "MIRROR"),
                 ('solidify', "Solidify", "SOLIDIFY"),
                 ('array', "Array", "ARRAY"),
                 ('decimate', "Decimate", "DECIMATE"),
                 ('displace', "Displace", "DISPLACE"),),
                 default = 'all'
                 )

    def execute(self, context):
        SFC = bpy.context.window_manager.SFC
        selection = bpy.context.selected_objects
        
        
        # if bpy.context.object.mode == "EDIT":
        #     edit_mode = True
        #     bpy.ops.object.mode_set(mode = 'OBJECT')
        
        for obj in selection:
            bpy.context.view_layer.objects.active = obj
            obj.select_set(state=True)


            #SHADING
            if obj.mode == 'EDIT':
                bpy.ops.object.mode_set(mode='OBJECT')
                bpy.ops.object.shade_smooth()
                bpy.context.object.data.use_auto_smooth = True
                bpy.context.object.data.auto_smooth_angle = 0.523599
                bpy.ops.object.mode_set(mode='EDIT')

            #Add
            if SFC.add_apply_remove == 'add' or not obj.modifiers :
                if self.modifiers_types == 'subsurf':
                    new_subsurf = obj.modifiers.new("Subsurf", "SUBSURF")
                    new_subsurf.show_only_control_edges = True
                    new_subsurf.levels = 2
            
                elif self.modifiers_types == 'bevel':
                    new_bevel = obj.modifiers.new("Bevel", "BEVEL")
                    new_bevel.width = 0.05
                    new_bevel.segments = 4
                    new_bevel.profile = 0.5
                    new_bevel.use_clamp_overlap = False
                    new_bevel.limit_method = 'ANGLE'
                    new_bevel.loop_slide = True
                    new_bevel.angle_limit = 1.0472
                    new_bevel.name = 'Bevel - %s' % new_bevel.limit_method

                    if obj.mode == 'EDIT':
                        me = obj.data
                        bm = bmesh.from_edit_mesh(me)

                        if any([v.select for v in bm.verts]):
                            vgroups = obj.vertex_groups

                            new_bevel.limit_method = 'VGROUP'
                            new_bevel.name = 'Bevel - %s - VGROUP' % new_bevel.limit_method
                            new_bevel.show_in_editmode = True
                            bpy.ops.object.vertex_group_add()
                            context.scene.tool_settings.vertex_group_weight = 1
                            bpy.ops.object.vertex_group_assign()
                            new_bevel.vertex_group = vgroups.active.name
                            new_bevel.show_on_cage = True



                        elif any([e.select for e in bm.edges]):
                            new_bevel.limit_method = 'WEIGHT'
                            new_bevel.loop_slide = False
                            bpy.ops.transform.edge_bevelweight(value=1)
                            new_bevel.name = 'Bevel - %s' % new_bevel.limit_method




                elif self.modifiers_types == 'mirror':
                    bpy.ops.object.modifier_add(type='MIRROR')
                
                elif self.modifiers_types == 'array':
                    bpy.ops.object.modifier_add(type='ARRAY')

                elif self.modifiers_types == 'boolean':
                    bpy.ops.object.modifier_add(type='BOOLEAN')
                    
                elif self.modifiers_types == 'solidify':
                    new_solidify = obj.modifiers.new("Solidify", "SOLIDIFY")
                    new_solidify.offset = 0
                    new_solidify.use_even_offset = True
                    new_solidify.use_quality_normals = True
                    new_solidify.thickness = 0.01

                elif self.modifiers_types == 'decimate':
                    new_decimate = obj.modifiers.new("Decimate", "DECIMATE")
                    new_decimate.decimate_type = 'DISSOLVE'
                    new_decimate.angle_limit = 0.0174533

                elif self.modifiers_types == 'displace':
                    new_displace = obj.modifiers.new("Displace", "DISPLACE")
                    new_displace.direction = 'X'
                    new_displace.mid_level = 0
                    new_displace.strength = 1

            #Apply / Remove
            else:
                if obj.modifiers:
                    bpy.context.view_layer.objects.active=obj
                    for mod in obj.modifiers :
                        
                        #All
                        if self.modifiers_types == 'all':
                            if SFC.add_apply_remove == 'apply':
                                bpy.ops.object.sfc_apply_modifiers()
                            elif SFC.add_apply_remove == 'remove':
                                bpy.ops.object.sfc_remove_modifiers()
                        
                        #Subsurf     
                        elif self.modifiers_types == 'subsurf':
                            if mod.type == 'SUBSURF': 
                                if SFC.add_apply_remove == 'apply':
                                    bpy.ops.object.modifier_apply(apply_as='DATA', modifier=mod.name)
                                elif SFC.add_apply_remove == 'remove':
                                    bpy.ops.object.modifier_remove(modifier=mod.name)
                                
                        #Bevel
                        elif self.modifiers_types == 'bevel':
                            if mod.type == 'BEVEL':
                                if SFC.add_apply_remove == 'apply':
                                    bpy.ops.object.modifier_apply(apply_as='DATA', modifier=mod.name)
                                elif SFC.add_apply_remove == 'remove':
                                    bpy.ops.object.modifier_remove(modifier=mod.name)
                       
                        #Mirror
                        elif self.modifiers_types == 'mirror':
                            if mod.type == 'MIRROR':  
                                if SFC.add_apply_remove == 'apply':
                                    bpy.ops.object.modifier_apply(apply_as='DATA', modifier=mod.name)
                                elif SFC.add_apply_remove == 'remove':
                                    bpy.ops.object.modifier_remove(modifier=mod.name)
                        
                        #Booleans
                        elif self.modifiers_types == 'boolean':
                            if mod.type == 'BOOLEAN':   
                                if SFC.add_apply_remove == 'apply':
                                    bpy.ops.object.modifier_apply(apply_as='DATA', modifier=mod.name)
                                elif SFC.add_apply_remove == 'remove':
                                    bpy.ops.object.modifier_remove(modifier=mod.name)
                        
                        #Array
                        elif self.modifiers_types == 'array':
                            if mod.type == 'ARRAY':
                                if SFC.add_apply_remove == 'apply':
                                    bpy.ops.object.modifier_apply(apply_as='DATA', modifier=mod.name)
                                elif SFC.add_apply_remove == 'remove':
                                    bpy.ops.object.modifier_remove(modifier=mod.name)
                        
                        #Solidify
                        elif self.modifiers_types == 'solidify':
                            if mod.type == 'SOLIDIFY':
                                if SFC.add_apply_remove == 'apply':
                                    bpy.ops.object.modifier_apply(apply_as='DATA', modifier=mod.name)
                                elif SFC.add_apply_remove == 'remove':
                                    bpy.ops.object.modifier_remove(modifier=mod.name)

                        # DECIMATE
                        elif self.modifiers_types == 'decimate':
                            if mod.type == 'DECIMATE':
                                if SFC.add_apply_remove == 'apply':
                                    bpy.ops.object.modifier_apply(apply_as='DATA', modifier=mod.name)
                                elif SFC.add_apply_remove == 'remove':
                                    bpy.ops.object.modifier_remove(modifier=mod.name)

                        # DISPLACE
                        elif self.modifiers_types == 'displace':
                            if mod.type == 'DISPLACE':
                                if SFC.add_apply_remove == 'apply':
                                    bpy.ops.object.modifier_apply(apply_as='DATA', modifier=mod.name)
                                elif SFC.add_apply_remove == 'remove':
                                    bpy.ops.object.modifier_remove(modifier=mod.name)


            weighted = False

            for mod in bpy.context.active_object.modifiers:
                if mod.type == "WEIGHTED_NORMAL":
                    weighted = True

            if not weighted:
                new_weighted = obj.modifiers.new("Weighted Normal", "WEIGHTED_NORMAL")
                new_weighted.keep_sharp = True
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")

            else:
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")
                bpy.ops.object.modifier_move_down(modifier="Weighted Normal")

        bpy.ops.object.mode_set(mode='OBJECT')
        # if edit_mode == True:
        #     bpy.ops.object.mode_set(mode = 'EDIT')
                        
        return {"FINISHED"}
                       

def SFC_List_Modifiers(self, context):
    
    mirror = False
    bevel = False  
    boolean = False  
    subsurf = False
    array = False
    solidify = False
    decimate = False
    displace = False
    for mod in bpy.context.active_object.modifiers:
        if mod.type == "BOOLEAN":
            boolean = True
        if mod.type == "MIRROR":
            mirror = True
        if mod.type == "BEVEL":
            bevel = True  
        if mod.type == "SUBSURF":
            subsurf = True  
        if mod.type == "ARRAY":
            array = True   
        if mod.type == "SOLIDIFY":
            solidify = True
        if mod.type == "DECIMATE":
            decimate = True
        if mod.type == "DISPLACE":
            displace = True
      
    layout = self.layout
    row = layout.row(align=True) 
    row.scale_y= 1.5
    row.scale_x= 3
    
    row.operator("object.sfc_add_apply_remove_modifiers",text="All").modifiers_types = "all"
    if bevel:
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_BEVEL').modifiers_types = "bevel"
    if boolean:
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_BOOLEAN').modifiers_types = "boolean"
    if mirror:
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_MIRROR').modifiers_types = "mirror"
    if subsurf:
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_SUBSURF').modifiers_types = "subsurf"
    if array:
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_ARRAY').modifiers_types = "array"
    if solidify:
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_SOLIDIFY').modifiers_types = "solidify"
    if displace:
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_DISPLACE').modifiers_types = "displace"
    if decimate:
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_DECIM').modifiers_types = "decimate"

def SFC_Add_Apply_Remove_Popup(self, context):
    obj = context.active_object
    # wm = context.window_manager
    SFC = context.window_manager.SFC

    layout = self.layout
    row = layout.row(align=True)
    
    
    if obj.modifiers:
        row.scale_x= 3
        icon = 'TRIA_DOWN' if SFC.toggle_all_modifiers_prop else 'TRIA_RIGHT'
        row.prop(SFC, 'toggle_all_modifiers_prop', text='', icon=icon)

        icon = 'RESTRICT_VIEW_OFF' if SFC.hide_all_modifiers_prop else 'RESTRICT_VIEW_ON'
        row.prop(SFC, 'hide_all_modifiers_prop', text = '', icon = icon)
                
        row.prop(SFC, "add_apply_remove", expand=True)

        if SFC.add_apply_remove == 'add':
            row = layout.row(align=True)
            row.operator_menu_enum("object.modifier_add", "type")
            row = layout.row(align=True) 
            row.scale_y= 1.5
            row.scale_x= 3
            row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_BEVEL').modifiers_types = "bevel"
            row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_SUBSURF').modifiers_types = "subsurf"
            row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_MIRROR').modifiers_types = "mirror"
            row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_ARRAY').modifiers_types = "array"

            if bpy.context.object.type == 'MESH':
                row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_SOLIDIFY').modifiers_types = "solidify"
                row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_BOOLEAN').modifiers_types = "boolean"
                row.operator("object.sfc_add_apply_remove_modifiers", text="", icon='MOD_DISPLACE').modifiers_types = "displace"
                row.operator("object.sfc_add_apply_remove_modifiers", text="", icon='MOD_DECIM').modifiers_types = "decimate"
            
        elif SFC.add_apply_remove == 'apply':
            SFC_List_Modifiers(self, context)

        elif SFC.add_apply_remove == 'remove':
            SFC_List_Modifiers(self, context)
    
    else:
        row.operator_menu_enum("object.modifier_add", "type")
        row = layout.row(align=True)
        row.scale_y= 1.5
        row.scale_x= 3
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_BEVEL').modifiers_types = "bevel"
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_SUBSURF').modifiers_types = "subsurf"
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_MIRROR').modifiers_types = "mirror"
        row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_ARRAY').modifiers_types = "array"
        if bpy.context.object.type == 'MESH':
            row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_SOLIDIFY').modifiers_types = "solidify"
            row.operator("object.sfc_add_apply_remove_modifiers",text="", icon ='MOD_BOOLEAN').modifiers_types = "boolean"
            row.operator("object.sfc_add_apply_remove_modifiers", text="", icon='MOD_DISPLACE').modifiers_types = "displace"
            row.operator("object.sfc_add_apply_remove_modifiers", text="",icon='MOD_DECIM').modifiers_types = "decimate"
 
        
def SFC_modifiers_list(self, context):
    layout = self.layout
    ob = context.object
    md_self = bpy.types.DATA_PT_modifiers
    for md in ob.modifiers:
      box = layout.template_modifier(md)
      if box:
        getattr(md_self, md.type)(md_self, box, ob, md)        
        

class SFC_OT_modifiers_popup(bpy.types.Operator):
    bl_idname = "sfc.modifiers_popup"
    bl_label = "Modifiers Popup"
    bl_options = {'REGISTER','UNDO'}

    @classmethod
    def poll(cls, context):
        return context.active_object is not None 

    def check(self, context):
        
        return True
    
    def execute(self, context):
        return {'FINISHED'}
    
    
        
    def draw(self, context):
        obj = context.active_object
        layout = self.layout
        SFC_Add_Apply_Remove_Popup(self, context)
        SFC_modifiers_list(self, context)
        

    def invoke(self, context, event):

        dpi_value = bpy.context.preferences.view.ui_scale
        coef = dpi_value * (-175) + 525
        return context.window_manager.invoke_props_dialog(self, width=dpi_value * coef, height=100)

CLASSES = [SFC_OT_add_apply_remove_modifiers_Types,
           SFC_OT_modifiers_popup]

def register():
    for cls in CLASSES:
        try:
            bpy.utils.register_class(cls)
        except:
            print(f"{cls.__name__} already registred")


def unregister():
    for cls in CLASSES:
        bpy.utils.unregister_class(cls)