# -*- coding:utf-8 -*-

# Speedflow Add-on
# Copyright (C) 2018 Cedric Lepiller aka Pitiwazou & Legigan Jeremy AKA Pistiwique and Stephen Leger
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# <pep8 compliant>

import bpy
from bpy.types import Menu, Panel
from bpy.props import StringProperty
from .icon.icons import load_icons
from .utils.functions import get_addon_preferences

from rna_prop_ui import PropertyPanel


def get_modal_dictionnary():

    icons = load_icons()

    array = icons.get("icon_array")
    bevel = icons.get("icon_bevel")
    solidify = icons.get("icon_solidify")
    boolean = icons.get("icon_boolean")
    mirror = icons.get("icon_mirror")
    # rotate = icons.get("icon_rotate")
    subsurf = icons.get("icon_subsurf")
    tubify = icons.get("icon_tubify")
    screw = icons.get("icon_screw")
    displace = icons.get("icon_displace")
    decimate = icons.get("icon_decimate")
    triangulate = icons.get("icon_triangulate")
    edge_split = icons.get("icon_edge_split")
    shrinkwrap = icons.get("icon_shrinkwrap")
    simple_deform = icons.get("icon_simple_deform")
    wireframe = icons.get("icon_wireframe")
    curve = icons.get("icon_curve")
    corrective_smooth = icons.get("icon_corrective_smooth")
    mod_visibility = icons.get("icon_mod_visibility")
    cutter = icons.get("icon_cutter")
    skin = icons.get("icon_skin")
    weighted_normal = icons.get("icon_weighted_normal")


    modals_dict = {"array": ("speedflow.array", array, "view3d.help_array"),
                   "bevel": ("speedflow.bevel", bevel, "view3d.help_bevel"),
                   "solidify": ("speedflow.solidify", solidify, "view3d.help_solidify"),
                   "booleans": ("speedflow.boolean", boolean, "view3d.help_booleans"),
                   "mirror": ("speedflow.mirror", mirror, "view3d.help_mirror"),
                   "subsurf": ("speedflow.subsurf", subsurf, "view3d.help_subsurf"),
                   "screw": ("speedflow.screw", screw, "view3d.help_screw"),
                   "displace": ("speedflow.displace", displace, "view3d.help_displace"),
                   "decimate": ("speedflow.decimate", decimate, "view3d.help_decimate"),
                   "triangulate": ("speedflow.triangulate", triangulate, "view3d.help_triangulate"),
                   "tubify": ("speedflow.tubify", tubify, "view3d.help_tubify"),
                   "edge_split": ("speedflow.edge_split", edge_split, "view3d.help_edge_split"),
                   "shrinkwrap": ("speedflow.shrinkwrap", shrinkwrap, "view3d.help_shrinkwrap"),
                   "simple_deform": ("speedflow.simple_deform", simple_deform, "view3d.help_simple_deform"),
                   "wireframe": ("speedflow.wireframe", wireframe, "view3d.help_wireframe"),
                   "curve": ("speedflow.curve", curve, "view3d.help_curve"),
                   "corrective_smooth": ("speedflow.corrective_smooth", corrective_smooth, "view3d.help_corrective_smooth"),
                   "mod_visibility": ("speedflow.mod_visibility", mod_visibility, "view3d.help_mod_visibility"),
                   "cutter": ("speedflow.cutter", cutter, "view3d.cutter"),
                   "skin": ("speedflow.skin", skin, "view3d.skin"),
                   "weighted_normal" : ("speedflow.weighted_normal", weighted_normal, "view3d.weighted_normal")
                   }

    return modals_dict


# -----------------------------------------------------------------------------
#    Help
# -----------------------------------------------------------------------------

help_dictionnary = {'bevel': [("You can add and Adjust Bevel modifier on your selection", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_bevel_001.gif"),
                              ("You can use Subdiv and NoSubdiv Mode", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_bevel_004.gif"),
                              ("You can change Width(S), Segments(D), Profile(F)", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_bevel_002.gif"),
                              ("You can change the bevel mode in weight with R to have different bevel size", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_bevel_010.gif"),
                              ("You can change the bevel settings in the preferences", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_bevel_options.jpg"),
                              ("The Bevel is combined to the booleans to have different results depending of the bevel mode (Subdiv/NoSubdiv" , "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_bevel_012.gif"),
                              ],

                    'booleans': [("You can add Booleans modifiers on your selection", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_boolean_001.gif"),
                                ("You can change the Operation, Union(S), Difference(D) and Intersection(F)", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_boolean_002.gif"),
                                ("You can switch between modifiers with < or > ", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_boolean_003.gif"),
                                ("You can keep the boolean object or delete it with E", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_boolean_004.gif"),
                                ("You can make a rebool with R", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_boolean_005.gif"),
                                ],

                    'array': [("You can add several arrays modifiers on your selection", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_array_001.gif"),
                              ("You can change the axis of an array with X, Y or Z", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_array_002.gif"),
                              ("You can combine modifiers", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_array_003.gif"),
                              ("To edit your array, you can press S to change the count, D to change the offset", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_array_005.gif"),
                              ("By default you are in relative mode, you can switch in constant mode by pressing F", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_array_006.gif"),
                              ("You can switch between modifiers and edit them directly in the modal with < or >", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_array_007.gif"),
                              ("You can make an array on curve by selecting a curve and your mesh", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_array_008.gif"),
                              ("You can make cables with Start(E) and End(R) caps", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_array_010.gif"),
                              ],

                    'solidify': [("You can add solidify modifier to your selection", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_solidify_001.gif"),
                                 ("You can change settings in the 3dview for Thickness, offset etc", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_solidify_002.gif"),
                                 ("You can add Bevel(R) and Subsurf(T) modifiers directly in the modal ", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_solidify_005.gif"),
                                 ],

                    # 'rotate': [("You can rotate your object with increments 5(Ctrl),10(Shift)or 45 degrees on X, Y and Z", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_rotate_001.gif"),
                    #            ("You can use Local mode with D", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_rotate_003.gif"),
                    #            ("For one objects or multiple objects, the last object selected will be the one the modal uses for the local axis", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_rotate_004.gif"),
                    #            ("You can change the pivot when rotating", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_rotate_005.gif"),
                    #            ("You can move the cursor with F", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_rotate_006.gif"),
                    #            ],

                    'tubify': [("You can add Tubify on curves", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_tubify_001.gif"),
                               ("You can change Depth(S), U resolution(D) and V resolution(F)", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_tubify_007.gif"),
                               ("You can add Tubify on mesh lines", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_tubify_003.gif"),
                               ("You can add a profile for the curve by pressing F and selecting a new profile", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_tubify_005.gif"),
                               ("And change the type of the curve directly in the modal with R (Bezier/Poly)", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_tubify_008.gif"),
                               ],

                    'mirror': [("You can add Mirror Modifier on your object", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_mirror_001.gif"),
                               ("You can add a mirror from a selection, select your object as reference and the object who will be mirrored", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_mirror_002.gif"),
                               ("You can add(Shift) or remove(Alt) axis (X,Y,Z)", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_mirror_003.gif"),
                               ("You can move the mirrored object and the reference object", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_mirror_004.gif"),
                               ("You can add a reference object(Empty) with S", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_mirror_007.gif"),
                               ],

                    'subsurf': [("You can add Subsurf Modifier on your selection", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_subdiv_3.gif"),
                                ("You can activate Optimal display(S) and Open subdiv(D)", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_subdiv_4.gif"),
                                ("You can increase the subdivisions with Shift", "http://www.pitiwazou.com/wp-content/uploads/2016/06/speedflow_subdiv_5.gif"),
                                ],
 #### !!!! add gifs
                    'screw': [("You can add Screw Modifier on your selection"),
                              ("You can change the Axis, the steps, etc"),
                                ],

                    'displace': [("You can add Displace Modifier on your selection"),
                              ("You can change the Axis, the Strenght, etc"),
                                ],

                    'decimate': [("You can add a Decimate Modifier on your selection"),
                              ("You can change the Angle Limit, etc"),
                                ],

                    'triangulate': [("You can add a Triangulate Modifier on your selection"),
                              ("You can change the Ngon Method, Minimum Vertices, etc"),
                                ],

                    'edge_split': [("You can add an Edge Split Modifier on your selection"),
                                ("You can change the Split angle, use Sharp Edges or Angle, etc"),
                                ],

                    'shrinkwrap': [("You can add a Shrinkwrap Modifier on your selection"),
                                ("You can change the Offset,  the Mode to stitch to the surface, etc"),
                                ],

                    'simple_deform': [("You can add a Simple Deform Modifier on your selection"),
                                ("You can change the Angle/Factor,  the lock Axis, etc"),
                                ],

                    'wireframe': [("You can add a Wireframe Modifier on your selection"),
                                ("You can change the Thickness/Offset,  the lock Axis, etc"),
                                ],

                    'curve': [("You can add a Curve Modifier on your selection"),
                                ("You can change the axis, etc"),
                                ],

                    'corrective_smooth': [("You can add a Corrective Smooth Modifier on your selection"),
                              ("You can change the Repeat, the Factor, etc"),
                              ],

                    'mod_visibility': [("You can Apply, Remove, Hide Modifiers on your selection"),
                              ("You can show or hide one by one modifiers too"),
                              ],

                    'cutter': [("You can Cut part of your selection"),
                              ],

                    'skin': [("You can add a Skin  Modifier on your selection"),
                              ],

                    'weighted_normal':  [("You can add a Weighted Normal Modifier on your selection"),
                              ("You can change the Weight, the Treshold, etc"),
                              ],

                    }




class SPEEDFLOW_OT_help_panel_selector(bpy.types.Operator):
    bl_idname = "speedflow.help_panel_selector"
    bl_label = "Help Panel Selector"

    modal_name : StringProperty()

    def execute(self, context):
        SF = bpy.context.window_manager.SF
        SF.modal_name = self.modal_name

        bpy.ops.wm.call_menu(name = 'SPEEDFLOW_MT_help_menu')

        return {"FINISHED"}


class SPEEDFLOW_MT_help_menu(Menu):
    bl_label = "SpeedFlow Help"

    def draw(self, context):
        layout = self.layout

        SF = bpy.context.window_manager.SF
        modal_dict = get_modal_dictionnary()
        icon = modal_dict[SF.modal_name][1]

        layout.label(text=SF.modal_name.capitalize(), icon_value = icon.icon_id)
        layout.separator()
        for datas in help_dictionnary[SF.modal_name]:
            info, url = datas
            layout.operator('wm.url_open', text = info).url = url


# class Speedflow_UI_Menu(bpy.types.Menu):
#     bl_idname = "view3d.speedflow_ui_menu"
#     bl_label = "Speedflow UI Menu"
#
#     @classmethod
#     def poll(cls, context):
#         return context.object is not None and context.selected_objects
#
#     def draw(self, context):
#         layout = self.layout
#         pie = layout.menu_pie()
#         icons = load_icons()
#
#         # 4 - LEFT
#         col = pie.column(align=True)
#         row = col.row(align=True)
#         row.scale_x = 1.5
#         row.scale_y = 1.4
#         rotate = icons.get("icon_rotate")
#         row.operator("speedflow.rotate", text="Rotate", icon_value=rotate.icon_id)
#
#         # 6 - RIGHT
#         col = pie.column(align=True)
#         row = col.row(align=True)
#         row.scale_x = 1.5
#         row.scale_y = 1.4
#         bevel = icons.get("icon_bevel")
#         row.operator("speedflow.bevel", text="Bevel", icon_value=bevel.icon_id)
#
#         # Bottom
#         col = pie.column(align=True)
#         row = col.row(align=True)
#         row.scale_x = 1.5
#         row.scale_y = 1.4
#         mirror = icons.get("icon_mirror")
#         row.operator("speedflow.mirror", text="Mirror", icon_value=mirror.icon_id)
#         row = col.row(align=True)
#         row.scale_x = 1.5
#         row.scale_y = 1.4
#         symetrize = icons.get("icon_symetrize")
#         row.operator("speedflow.symetrize", text="Symmetrize", icon_value=symetrize.icon_id)
#         row = col.row(align=True)
#         row.scale_x = 1.5
#         row.scale_y = 1.4
#         screw = icons.get("icon_screw")
#         row.operator("speedflow.screw", text="Screw", icon_value=screw.icon_id)
#
#         # 8 - TOP
#         col = pie.column(align=True)
#         row = col.row(align=True)
#         row.scale_x = 1.5
#         row.scale_y = 1.4
#         array = icons.get("icon_array")
#         row.operator("speedflow.array", text="Array", icon_value=array.icon_id)
#
#         # 7 - TOP - LEFT
#         col = pie.column(align=True)
#         row = col.row(align=True)
#         row.scale_x = 1.5
#         row.scale_y = 1.4
#         solidify = icons.get("icon_solidify")
#         row.operator("speedflow.solidify", text="Solidify", icon_value=solidify.icon_id)
#
#         # 9 - TOP - RIGHT
#         col = pie.column(align=True)
#         row = col.row(align=True)
#         row.scale_x = 1.5
#         row.scale_y = 1.4
#         boolean = icons.get("icon_boolean")
#         row.operator("speedflow.boolean", text="Boolean", icon_value=boolean.icon_id)
#
#         # 1 - BOTTOM - LEFT
#         col = pie.column(align=True)
#         row = col.row(align=True)
#         row.scale_x = 1.5
#         row.scale_y = 1.4
#         tubify = icons.get("icon_tubify")
#         row.operator("speedflow.tubify", text="Tubify", icon_value=tubify.icon_id)
#
#         # 3 - BOTTOM - RIGHT
#         col = pie.column(align=True)
#         row = col.row(align=True)
#         row.scale_x = 1.5
#         row.scale_y = 1.4
#         subsurf = icons.get("icon_subsurf")
#         row.operator("speedflow.subsurf", text="Subsurf", icon_value=subsurf.icon_id)

#Pie Menu if prefs.sf_update_check: prefs = bpy.context.preferences.addons[__name__].preferences



class SPEEDFLOW_MT_pie_menu(Menu):
    bl_label = "Speedflow"

    # @classmethod
    # def poll(cls, context):
    #     return context.object is not None and context.object.mode in {'EDIT', 'OBJECT'}

    def draw(self, context):
        layout = self.layout
        pie = layout.menu_pie()
        # col = layout.column(align=True)

        prefs = get_addon_preferences()
        modal_dict = get_modal_dictionnary()
        modal_order = ['4', '5', '2', '9','10','11', '12','13','14','15','16','17','18','19','20', '7', '6', '8', '1', '3']

        if context.object is not None and context.selected_objects:
            # left, Right
            for idx in modal_order[:2]: # 0 et 1
                # col = pie.column(align=True)
                # row = col.row(align=True)
                modal_target = getattr(prefs, 'enum_modals_%s' %idx)
                if modal_target != 'none':
                    modal, icon = modal_dict[modal_target][:2]
                    # row.scale_y = prefs.buttons_size
                    pie.operator(modal, text = modal_target, icon_value = icon.icon_id)
                else:
                    pie.separator()

            # bottom
            col = pie.column(align=True)
            row = col.row(align=True)
            for idx in modal_order[2:3]:  # 0 et 1
                modal_target = getattr(prefs, 'enum_modals_%s' % idx)
                if modal_target != 'none':
                    modal, icon = modal_dict[modal_target][:2]
                    row.scale_y = prefs.buttons_size
                    row.scale_x = 1.3
                    row.operator(modal, text=modal_target, icon_value=icon.icon_id)
                else:
                    row.separator()

            # col = pie.column(align=True)
            row = col.row(align=True)
            for idx in modal_order[3:7]:
                modal_target = getattr(prefs, 'enum_modals_%s' %idx)
                if modal_target != 'none':
                    modal, icon = modal_dict[modal_target][:2]
                    row.scale_y = prefs.buttons_size
                    row.scale_x = 1.3
                    row.operator(modal, text = "", icon_value = icon.icon_id)
                else:
                    row.label(text="")

            row = col.row(align=True)
            for idx in modal_order[7:11]:
                modal_target = getattr(prefs, 'enum_modals_%s' %idx)
                if modal_target != 'none':
                    modal, icon = modal_dict[modal_target][:2]
                    row.scale_y = prefs.buttons_size
                    row.scale_x = 1.3
                    row.operator(modal, text = "", icon_value = icon.icon_id)

                else:
                    row.label(text="")

            row = col.row(align=True)
            for idx in modal_order[11:15]:
                modal_target = getattr(prefs, 'enum_modals_%s' % idx)
                if modal_target != 'none':
                    modal, icon = modal_dict[modal_target][:2]
                    row.scale_y = prefs.buttons_size
                    row.scale_x = 1.3
                    row.operator(modal, text="", icon_value=icon.icon_id)

                else:
                    row.label(text="")

            # the other
            for idx in modal_order[15:]: # les 5 derniers
                # col = pie.column(align=True)
                # row = col.row(align=True)
                modal_target = getattr(prefs, 'enum_modals_%s' %idx)
                if modal_target != 'none':
                    modal, icon = modal_dict[modal_target][:2]
                    # row.scale_y = prefs.buttons_size
                    # row.scale_x = 1.4

                    pie.operator(modal, text = modal_target, icon_value = icon.icon_id)
                else:
                    pie.separator()
        else:
            icons = load_icons()
            # 4 - LEFT
            cutter = icons.get("icon_cutter")
            pie.operator("speedflow.cutter", text="Cutter", icon_value=cutter.icon_id)
            # 6 - RIGHT
            tubify = icons.get("icon_tubify")
            pie.operator("speedflow.tubify", text="Tubify", icon_value=tubify.icon_id)
            # 2 - BOTTOM
            pie.separator()
            # 8 - TOP
            pie.separator()
            # 7 - TOP - LEFT
            pie.separator()
            # 9 - TOP - RIGHT
            pie.separator()
            # 1 - BOTTOM - LEFT
            pie.separator()
            # 3 - BOTTOM - RIGHT
            pie.separator()

class SPEEDFLOW_OT_show_addon_prefs(bpy.types.Operator):
    # bl_idname = 'SPEEDFLOW_OT_show_addon_prefs'
    bl_idname = 'speedflow.show_addon_prefs'
    bl_label = "Show_addon_prefs"
    bl_options = {'REGISTER'}

    def execute(self, context):
        bpy.ops.screen.userpref_show('INVOKE_DEFAULT')
        bpy.context.window_manager.addon_search = "speedflow"
        return {'FINISHED'}

#Simple Menu
class SPEEDFLOW_MT_simple_menu(Menu):
    bl_label = "Speedflow"

    # @classmethod
    # def poll(cls, context):
    #     return context.object is not None and context.selected_objects and context.object.mode in {'EDIT', 'OBJECT'}

    def draw(self, context):
        layout = self.layout

        SF = context.window_manager.SF
        prefs = get_addon_preferences()
        if SF.update_available and prefs.show_update:
            layout.operator("speedflow.show_addon_prefs",text="An Update is Available!", icon='ERROR')


        layout.operator_context = "INVOKE_DEFAULT"

        # prefs = get_addon_preferences()
        modal_dict = get_modal_dictionnary()
        modal_order = ['4', '5', '2', '9','10','11', '12','13','14','15','16','17','18', '19','20','7', '6', '8', '1', '3']

        for idx in modal_order:
            modal_target = getattr(prefs, 'enum_modals_%s' %idx)

            if modal_target != 'none':
                modal, icon = modal_dict[modal_target][:2]
                row = layout.row(align=True)
                row.scale_y = prefs.buttons_size
                row.operator(modal, text = modal_target, icon_value = icon.icon_id)


#Panel
class SPEEDFLOW_PT_panel(Panel):
    bl_label = "SPEEDFLOW"
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"
    bl_category = "Tools"
    # bl_idname = "SPEEDFLOW_PT_panel"

    @classmethod
    def poll(cls, context):
        return context.object is not None and context.selected_objects and context.object.mode in {'EDIT', 'OBJECT'}

    def draw(self, context):
        layout = self.layout

        if context.object is not None and context.selected_objects:
            SF = context.window_manager.SF
            prefs = get_addon_preferences()
            if SF.update_available and prefs.show_update:
                layout.operator("speedflow.show_addon_prefs", text="An Update is Available!", icon='ERROR')

            col = layout.column(align=True)

            prefs = get_addon_preferences()
            # self.show_help = prefs.show_help
            modal_dict = get_modal_dictionnary()
            modal_order = ['4', '5', '2', '9','10','11', '12','13','14','15','16','17','18','19','20', '7', '6', '8', '1', '3']

            for idx in modal_order:
                modal_target = getattr(prefs, 'enum_modals_%s' %idx)

                if modal_target != 'none':
                    modal, icon, help = modal_dict[modal_target]
                    row = col.row(align=True)
                    row.scale_y = prefs.buttons_size
                    row.operator(modal, text = modal_target, icon_value = icon.icon_id)
                    # if self.show_help :
                    if prefs.show_help:
                        row.operator('speedflow.help_panel_selector', text = "", icon = 'TRIA_RIGHT').modal_name = modal_target
        else:
            layout.label(text="No active object selected")


#Panel
class SPEEDFLOW_PT_property_panel_keymaps(Panel):
    bl_label = "Speedflow Global Keymaps"
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"
    bl_category = "Tool"

    def draw(self, context):

        icons = load_icons()

        layout = self.layout
        speedflow = icons.get("icon_speedflow")
        layout.label(text="SPEEDFLOW GLOBAL KEYMAP", icon_value=speedflow.icon_id)
        layout.separator()
        # modifiers = icons.get("icon_modifiers")
        # layout.label(text="MODIFIERS:", icon_value=modifiers.icon_id)

        layout.label(text="MODIFIERS:", icon='MODIFIER')
        box = layout.box()
        icon = icons.get("icon_space")
        box.label(text="Call Menu or Pie Menu", icon_value=icon.icon_id)
        row = box.row(align=True)

        shift = icons.get("icon_shift")
        row.label(text="", icon_value=shift.icon_id)
        icon = icons.get("icon_space")
        row.label(text="ADD NEW SIMILAR MODIFIER", icon_value=icon.icon_id)

        box.separator()
        icon = icons.get("icon_tab")
        box.label(text="Enter/Exit Adit Mode", icon_value=icon.icon_id)

        box.separator()
        icon = icons.get("icon_a")
        box.label(text="Apply Modifier", icon_value=icon.icon_id)
        suppr = icons.get("icon_del")
        box.label(text="Remove Modifier", icon_value=suppr.icon_id)
        icon = icons.get("icon_h")
        box.label(text="Hide Modifier", icon_value=icon.icon_id)
        box.separator()
        icon = icons.get("icon_up")
        box.label(text="Move Modifier UP", icon_value=icon.icon_id)
        icon = icons.get("icon_down")
        box.label(text="Move Modifier DOWN", icon_value=icon.icon_id)
        icon = icons.get("icon_right")
        box.label(text="Select Next Similar Modifier", icon_value=icon.icon_id)

        icon = icons.get("icon_left")
        box.label(text="Select Previous Similar Modifier", icon_value=icon.icon_id)

        # row = box.row(align=True)
        # icon = icons.get("icon_ctrl")
        # row.label(text="", icon_value=icon.icon_id)
        # icon = icons.get("icon_greater_than")
        # row.label(text="", icon_value=icon.icon_id)
        # row.label(text="Select Next Modifier")
        #
        # row = box.row(align=True)
        # icon = icons.get("icon_ctrl")
        # row.label(text="", icon_value=icon.icon_id)
        # icon = icons.get("icon_less_than")
        # row.label(text="", icon_value=icon.icon_id)
        # row.label(text="Select Previous Modifier")

        box.separator()

        icon = icons.get("icon_left")
        box.label(text="Hide Previous Modifier", icon_value=icon.icon_id)
        icon = icons.get("icon_right")
        box.label(text="Show Next Modifier", icon_value=icon.icon_id)
        box.separator()

        row = box.row(align=True)
        icon = icons.get("icon_ctrl")
        row.label(text="", icon_value=icon.icon_id)
        icon = icons.get("icon_h")
        row.label(text="Show/hide Keymaps", icon_value=icon.icon_id)

        box.separator()
        row = box.row(align=True)
        icon = icons.get("icon_shift")
        row.label(text="", icon_value=icon.icon_id)
        icon = icons.get("icon_c")
        row.label(text="", icon_value=icon.icon_id)
        row.label(text="Invert Vertex Group")

        row = box.row(align=True)
        icon = icons.get("icon_ctrl")
        row.label(text="", icon_value=icon.icon_id)
        icon = icons.get("icon_c")
        row.label(text="", icon_value=icon.icon_id)
        row.label(text="Remove Vertex Group")

        box.separator()
        layout.label(text="SHADING:", icon='SHADING_RENDERED')
        box = layout.box()
        icon = icons.get("icon_1")
        box.label(text="Keep Wire Visible", icon_value=icon.icon_id)
        icon = icons.get("icon_2")
        box.label(text="Show Wire In Modals", icon_value=icon.icon_id)
        icon = icons.get("icon_3")
        box.label(text="Xray Mode", icon_value=icon.icon_id)
        icon = icons.get("icon_4")
        box.label(text="Wireframe Mode", icon_value=icon.icon_id)
        icon = icons.get("icon_5")
        box.label(text="Random Shading", icon_value=icon.icon_id)
        icon = icons.get("icon_6")
        box.label(text="Show/Hide Overlays", icon_value=icon.icon_id)
        icon = icons.get("icon_7")
        box.label(text="Check Normals Direction", icon_value=icon.icon_id)
        icon = icons.get("icon_8")
        box.label(text="Show/Hide Grid", icon_value=icon.icon_id)
        icon = icons.get("icon_9")
        box.label(text="Boolean Shading", icon_value=icon.icon_id)
        box.separator()

        layout.label(text="SNAPPING:", icon='SNAP_ON')
        box = layout.box()
        icon = icons.get("icon_f1")
        box.label(text="Edit Origin", icon_value=icon.icon_id)
        icon = icons.get("icon_f2")
        box.label(text="Activate Snap", icon_value=icon.icon_id)
        icon = icons.get("icon_f3")
        box.label(text="Snap Vertex", icon_value=icon.icon_id)
        icon = icons.get("icon_f4")
        box.label(text="Snap Faces", icon_value=icon.icon_id)
        icon = icons.get("icon_f5")
        box.label(text="Snap Grid", icon_value=icon.icon_id)
        icon = icons.get("icon_f6")
        box.label(text="Origin To Mesh", icon_value=icon.icon_id)
        icon = icons.get("icon_f7")
        box.label(text="Origin To Grid", icon_value=icon.icon_id)

#Panel
class SPEEDFLOW_PT_property_panel_help(Panel):
    bl_label = "Speedflow Documentation"
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"
    bl_category = "Tool"

    def draw(self, context):
        icons = load_icons()
        SF = context.window_manager.SF
        layout = self.layout
        speedflow = icons.get("icon_speedflow")
        layout.label(text="SPEEDFLOW DOCUMENTATION", icon_value=speedflow.icon_id)

        # INTRO
        box = layout.box()
        box.prop(SF, "doc_intro", text="INTRODUCTION", icon='TRIA_UP' if SF.doc_intro else 'TRIA_DOWN')
        if SF.doc_intro:
            box.label(text="Speedflow is an add-on that drastically accelerates blender modeling.")
            box.separator()
            box.label(text="You will be able to add modifiers on your objects")
            box.label(text="and to edit them in the 3DView")
            box.label(text="Each Modal will give you all the modifiers possibilities")
            box.label(text="You will be able to Add, Remove, Hide modifiers")

        # WORKFLOW
        box = layout.box()
        box.prop(SF, "doc_workflow", text="ADDON WORKFLOW", icon='TRIA_UP' if SF.doc_workflow else 'TRIA_DOWN')
        if SF.doc_workflow:
            row = box.row()
            row.scale_y = 2
            youtube = icons.get("icon_youtube")
            row.operator("wm.url_open", text="Workflow Video", icon_value=youtube.icon_id).url = "https://www.youtube.com/watch?v=-7KQkGy2YjY"
            box.scale_y = 1
            box.label(text="Select one or more objects,")
            box.label(text="launch Speedflow and choose the modifier of your choice.")
            box.label(text="The modifier will be added and a text will appear.")
            box.separator()
            box.label(text="At this time, the first action of the modifier will be enabled.")
            box.label(text="You can edit it with the mouse by moving or with the wheel")
            box.label(text="(if you choosed it in the add-on preferences).")
            box.separator()
            box.label(text="The modal will show you all the keys you can use")

            box.label(text="to edit your modifier.")
            box.label(text="The keys are: ")
            row = box.row(align = True)
            icon = icons.get("icon_speedflow")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_d")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_f")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_g")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_h")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_j")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_k")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_l")
            row.label(text="", icon_value=icon.icon_id)
            box.label(text="Etc, depending on the modifier.")
            box.label(text="Some will have more or less keys.")
            box.separator()
            box.label(text="Once you are ok, press LMB in the 3Dview to valid the action.")
            box.label(text="You will exit the modal.")

        # MODALS
        box = layout.box()
        box.prop(SF, "doc_modals", text="MODALS", icon='TRIA_UP' if SF.doc_modals else 'TRIA_DOWN')
        if SF.doc_modals:
            box.label(text="When you click on a Modifier button, you will add or edit a modifier")
            box.label(text="and you will enter in a Modal.")
            box.label(text="This is a mode in which you can do several operations.")
            box.label(text="You will be able to edit the modifier settings.")
            box.separator()
            box.label(text="The keys are the same for all modals.")
            row = box.row(align=True)
            icon = icons.get("icon_speedflow")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_d")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_f")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_g")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_h")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_j")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_k")
            row.label(text="", icon_value=icon.icon_id)
            icon = icons.get("icon_l")
            row.label(text="", icon_value=icon.icon_id)
            box.label(text="The difference will be the actions.")
            row = box.row(align=True)
            icon = icons.get("icon_speedflow")
            row.label(text="", icon_value=icon.icon_id)
            row.label(text="on the Bevel modal will edit the Width.")
            row = box.row(align=True)
            row.label(text="", icon_value=icon.icon_id)
            row.label(text="on the Solidify modal will edit the Thickness.")
            box.separator()
            box.label(text="Depending on the modal, you will have more or less keys.")
            box.separator()
            box.label(text="To exit a modal, just click outside")

            # Array
            icon = icons.get("icon_array")
            box.prop(SF, "doc_modals_array", text="ARRAY", icon_value = icon.icon_id)
            if SF.doc_modals_array:
                box.label(text="To launch the Array Modal, just click on the Array icon.")
                box.label(text="That will create the Array modifier and you will be in the Modal Operator.")
                box.label(text="As every Modals in Speedflow, you will use the same Keys.")
                box.separator()

                row = box.row(align=True)
                icon = icons.get("icon_speedflow")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="COUNT - That will change the count of the array Modifier.")

                row = box.row(align=True)
                icon = icons.get("icon_d")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="RELATIVE OFFSET - You will change the Offset in Relative Mode.")

                row = box.row(align=True)
                icon = icons.get("icon_f")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="CONSTANT OFFSET - You will change the Offset in Constant Mode.")

                box.separator()
                box.label(text="WORKFLOW")

                box.separator()
                box.label(text="When you launch the modal, speedflow will create the Array in X.")
                box.label(text="With Relative Offset to 1.")
                box.label(text="Note: You can change it in the Addon Preferences > Modals > Array.", icon='ERROR')

                box.separator()
                box.label(text="To edit, just press D and move your mouse.")
                box.separator()
                box.label(text="To use the array, you need to choose an Axis first.")
                box.label(text="and then, use Relative or Constant Offsets, or both.")
                box.separator()
                box.label(text="1 - Choose the Axis.")
                row = box.row(align=True)
                icon = icons.get("icon_x")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_y")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_z")
                row.label(text="", icon_value=icon.icon_id)
                row = box.row(align=True)
                row.label(text="2 - Edit the Offsets Relative Or Constant or Both.")
                row = box.row(align=True)
                icon = icons.get("icon_d")
                row.label(text="", icon_value=icon.icon_id)
                row = box.row(align=True)
                row.label(text="or/and")
                row = box.row(align=True)
                icon = icons.get("icon_f")
                row.label(text="", icon_value=icon.icon_id)
                row = box.row(align=True)
                row.label(text="3 - Valid or choose another Axis and Press D or F to change the Offset.")

                box.separator()
                row = box.row(align=True)
                icon = icons.get("icon_shift")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_space")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="To add a New Modifier.")

                box.separator()
                box.label(text="Note: You can add more than one modifier.", icon='ERROR')

            #Bevel
            icon = icons.get("icon_bevel")
            box.prop(SF, "doc_modals_bevel", text="BEVEL", icon_value=icon.icon_id)
            if SF.doc_modals_bevel:
                box.label(text="To launch the Bevel Modal, just click on the Bevel icon.")
                box.label(text="That will create the Bevel modifier and you will be in the Modal Operator.")
                box.label(text="As every Modals in Speedflow, you will use the same Keys.")
                box.separator()

                row = box.row(align=True)
                icon = icons.get("icon_speedflow")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="WIDTH - That will change the size of the Bevel.")

                row = box.row(align=True)
                icon = icons.get("icon_d")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="SEGMENTS - You will change the number of segments.")

                row = box.row(align=True)
                icon = icons.get("icon_f")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="PROFILE - You will change the profile.")

                row = box.row(align=True)
                icon = icons.get("icon_g")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="LIMIT METHOD - You will change the Limit Method.")

                box.separator()
                box.label(text="By changing the Limit Method, you will change the result of the Bevel.")
                box.label(text="NONE - Bevel on every Edges.")
                box.label(text="ANGLE - Bevel on Edges with the specified Angle.")
                box.label(text="WEIGHT - Bevel on marked Edges with Bevel Weight.")
                box.label(text="VGROUP - Bevel on Edges with Vertices added in a Vertex Groups.")
                box.label(text="Note: You can change the settings in the Addon Preferences > Modals > Bevel.", icon='ERROR')

                box.separator()
                box.label(text="Depending on your selection before calling the Bevel Modal.")
                box.label(text="you will active one of the Limit Method value.")
                box.separator()

                box.label(text="EDGE - Speedflow will add Bevel Weight on the edge(s) and set to BEVEL WEIGHT.")
                box.label(text="VERTEX - Speedflow will create a Vertex Group and set to VGROUP.")

                box.separator()
                row = box.row(align=True)
                icon = icons.get("icon_tab")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="You can Enter/Exit in EDIT MODE in the modal with TAB.")
                box.label(text="In this mode, you can select Vertices or Edges.")
                row = box.row(align=True)
                icon = icons.get("icon_1")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="VERTEX")
                row = box.row(align=True)
                icon = icons.get("icon_2")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="EDGES")

                box.separator()
                box.label(text="Select the component of you choice and press SPACE to call the menu.")
                box.label(text="Speedflow will setup the modifier according of your selection.")
                box.label(text="EDGES - Speedflow will create or edit the current modifier in BEVEL WEIGHT.")
                box.label(text="VERTEX - Speedflow will create a new modifier in VGROUP.")

                box.separator()
                row = box.row(align=True)
                icon = icons.get("icon_shift")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_space")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="To add a New Modifier.")

                box.separator()
                box.label(text="Note: You can add more than one modifier.", icon='ERROR')

            # Boolean
            icon = icons.get("icon_boolean")
            box.prop(SF, "doc_modals_boolean", text="BOOLEAN", icon_value=icon.icon_id)
            if SF.doc_modals_boolean:
                box.label(text="To launch the Boolean Modal, select at least 2 objects and click on the Boolean icon.")
                box.label(text="That will create the Boolean modifier on the active object")
                box.label(text="and you will be in the Modal Operator.")
                box.label(text="As every Modals in Speedflow, you will use the same Keys.")
                box.separator()

                row = box.row(align=True)
                icon = icons.get("icon_speedflow")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="UNION - That will change the to Union to merge the objects.")

                row = box.row(align=True)
                icon = icons.get("icon_d")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="DIFFERENCE - That will cut the Active object with the second object 'Bool_object'.")

                row = box.row(align=True)
                icon = icons.get("icon_f")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="INTERSECT - That will give you the result of the intersection part of the objects.")

                box.separator()
                box.label(text="WORKFLOW", icon='INDIRECT_ONLY_ON')

                box.separator()
                box.label(text="When you launch the modal, speedflow will create the Boolean modifier.")
                box.label(text="You will be in 'DIFFERENCE' mode.")
                box.label(text="Note: You can change it in the Addon Preferences > Modals > Boolean.", icon='ERROR')

                box.separator()
                box.label(text="If you have More than one 'Bool_object'.")

                row = box.row(align=True)
                icon = icons.get("icon_greater_than")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="You will be able to go from one to another 'Bool_object' and change the mode.")

                box.separator()
                box.label(text="Note: You can add more than one modifier.", icon='ERROR')

            # Curve
            icon = icons.get("icon_curve")
            box.prop(SF, "doc_modals_curve", text="CURVE", icon_value=icon.icon_id)
            if SF.doc_modals_curve:
                box.label(text="To launch the Curve Modal, select one object and click on the Curve icon.")
                box.label(text="That will create the Curve modifier on the active object")
                box.label(text="and you will be in the Modal Operator.")
                box.label(text="As every Modals in Speedflow, you will use the same Keys.")
                box.separator()

                row = box.row(align=True)
                icon = icons.get("icon_speedflow")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="DEFORMATION EXIS - That will change the Deformation axis of the modifier.")

                row = box.row(align=True)
                icon = icons.get("icon_o")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="OBJECT - By pressing 'O', you will add a Curve as reference.")

                box.separator()
                box.label(text="WORKFLOW", icon='INDIRECT_ONLY_ON')

                box.separator()
                box.label(text="Select an object and add the Modifier.")
                box.label(text="Edit the Deformation Axis.")
                box.label(text="Valid.")

                box.separator()
                box.label(text="You can also select your object and the curve as active object")
                box.label(text="to add the modifier with the Curve as Reference.")

            # # Decimate
            # icon = icons.get("icon_decimate")
            # box.prop(SF, "doc_modals_decimate", text="DISPLACE", icon_value=icon.icon_id)
            #     box.label(text="To launch the Decimate Modal, select one object and click on the Decimate icon.")
            #     box.label(text="That will create the Decimate modifier on the active object")
            #     box.label(text="and you will be in the Modal Operator.")
            #     box.label(text="As every Modals in Speedflow, you will use the same Keys.")
            #     box.separator()

            # Displace
            icon = icons.get("icon_displace")
            box.prop(SF, "doc_modals_displace", text="DISPLACE", icon_value = icon.icon_id)
            if SF.doc_modals_displace:
                box.label(text="To launch the Displace Modal, select one object and click on the Displace icon.")
                box.label(text="That will create the Displace modifier on the active object")
                box.label(text="and you will be in the Modal Operator.")
                box.label(text="As every Modals in Speedflow, you will use the same Keys.")
                box.separator()

                row = box.row(align=True)
                icon = icons.get("icon_speedflow")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="STRENGTH - You will change Strength.")

                row = box.row(align=True)
                icon = icons.get("icon_d")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="MIDELEVEL - You will change the Mid Level.")

                row = box.row(align=True)
                icon = icons.get("icon_f")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="DIRECTION LIST - You will change the direction, X, Y, Z, NORMAL, etc.")

                box.separator()
                row = box.row(align=True)
                icon = icons.get("icon_x")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_y")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_z")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="You can directly choose the wanted direction")

                box.separator()
                box.label(text="WORKFLOW", icon='INDIRECT_ONLY_ON')
                box.label(text="Select one or more objects and launch the Modal.")
                box.label(text="Choose the direction.")

                box.separator()
                box.label(text="Note: To have proper distance values, keep the Mid Level to 0.", icon='ERROR')

                box.separator()
                row = box.row(align=True)
                icon = icons.get("icon_shift")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_space")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="To add a New Modifier.")

                box.separator()
                box.label(text="Note: You can add more than one modifier.", icon='ERROR')

                box.separator()
                row = box.row(align=True)
                icon = icons.get("icon_shift")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_x")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="To add a New Modifier in X direction.")
                box.label(text="Same for Y and Z.")

            # Edge Split
            icon = icons.get("icon_edge_split")
            box.prop(SF, "doc_modals_edge_split", text="EDGE SPLIT", icon_value=icon.icon_id)
            if SF.doc_modals_edge_split:
                box.label(text="To launch the Edge Split Modal, select one object and click on the Edge Split icon.")
                box.label(text="That will create the Edge Split modifier on the active object")
                box.label(text="and you will be in the Modal Operator.")
                box.label(text="As every Modals in Speedflow, you will use the same Keys.")
                box.separator()

                row = box.row(align=True)
                icon = icons.get("icon_speedflow")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="SPLIT ANGLE - You will change Split Angle.")

                row = box.row(align=True)
                icon = icons.get("icon_d")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="USE EDGE ANGLE - The modifier will take the angle in account.")

                row = box.row(align=True)
                icon = icons.get("icon_f")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="USE SHARP EDGE - The modifier will take the Edges market with 'Mark Sharp' in account.")

                box.separator()
                box.label(text="WORKFLOW", icon='INDIRECT_ONLY_ON')

                box.separator()
                box.label(text="OBJECT MODE", icon='OBJECT_DATAMODE')
                box.label(text="Select one or more objects and launch the Modal, that will add the modifier.")
                row = box.row(align=True)
                icon = icons.get("icon_d")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="Edit the Split Angle.")

                box.separator()
                box.label(text="EDIT MODE", icon='EDITMODE_HLT')
                box.label(text="Select one or more Edges, add a sharp (RMB > Mark Sharp).")
                box.label(text="Launch de modal by clicking on the Edge Split icon.")
                box.label(text="The modifier will take the Edges marked with 'Mark Sharp' in account.")

                box.separator()
                box.label(text="Note: You can add a solidify and a bevel to make panels.", icon='ERROR')

            # Mirror
            icon = icons.get("icon_mirror")
            box.prop(SF, "doc_modals_mirror", text="MIRROR", icon_value=icon.icon_id)
            if SF.doc_modals_mirror:
                box.label(text="To launch the Mirror Modal, select one object and click on the Mirror icon.")
                box.label(text="That will create the Mirror modifier on the active object")
                box.label(text="and you will be in the Modal Operator.")

                box.separator()
                box.label(text="The Mirror will be set on the X Axis,")
                box.label(text="(you can change it in the addon preferences Modals > Mirror.")

                row = box.row(align=True)
                icon = icons.get("icon_x")
                row.label(text="", icon_value=icon.icon_id)

                icon = icons.get("icon_y")
                row.label(text="", icon_value=icon.icon_id)

                icon = icons.get("icon_z")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="You will directly be able to choose the Axis.")

                box.separator()
                box.label(text="As every Modals in Speedflow, you will use the same Keys.")

                row = box.row(align=True)
                icon = icons.get("icon_speedflow")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="CLIP - To avoid the overlapping of the edges at the center of the Mirror.")

                row = box.row(align=True)
                icon = icons.get("icon_d")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="MERGE VERTICES - The modifier will merge the vertices at the Center.")

                row = box.row(align=True)
                icon = icons.get("icon_f")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="MERGE LIMIT - Threshold for the Merge Vertices.")

                box.separator()
                box.label(text="WORKFLOW", icon='INDIRECT_ONLY_ON')

                box.separator()
                box.label(text="Add the modifier, choose the Axis, Activate the toggle you need (Clip, Merge Vertices, etc)")
                box.label(text="Valid to exit the modal")

                box.separator()
                box.label(text="You can use the new Bisect Options")
                row = box.row(align=True)
                icon = icons.get("icon_shift")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_x")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_y")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_z")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="Click on SHIFT and choose an Axis to add the Bisect to this Axis")

                box.separator()
                row = box.row(align=True)
                icon = icons.get("icon_ctrl")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_x")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_y")
                row.label(text="", icon_value=icon.icon_id)
                icon = icons.get("icon_z")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="Click on CTRL and choose an Axis to Flip the Bisect to the other side")

            # Screw
            icon = icons.get("icon_screw")
            box.prop(SF, "doc_modals_screw", text="SCREW", icon_value=icon.icon_id)
            if SF.doc_modals_screw:
                box.label(text="To launch the Screw Modal, select one object and click on the Screw icon.")
                box.label(text="That will create the Screw modifier on the active object")
                box.label(text="and you will be in the Modal Operator.")

                box.separator()
                box.label(text="The Screw will be set on the Z Axis,")
                box.label(text="(you can change it in the addon preferences Modals > Screw.")

                row = box.row(align=True)
                icon = icons.get("icon_x")
                row.label(text="", icon_value=icon.icon_id)

                icon = icons.get("icon_y")
                row.label(text="", icon_value=icon.icon_id)

                icon = icons.get("icon_z")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="You will directly be able to choose the Axis.")

                box.separator()
                box.label(text="As every Modals in Speedflow, you will use the same Keys.")

                row = box.row(align=True)
                icon = icons.get("icon_speedflow")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="STEPS - The number of Steps (divisions) you will set for the modifier.")

                row = box.row(align=True)
                icon = icons.get("icon_d")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="SCREW - Offset the revolution along the selected Axis.")

                row = box.row(align=True)
                icon = icons.get("icon_f")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="ITERATIONS - Number of times to apply the Screw operation.")

                row = box.row(align=True)
                icon = icons.get("icon_g")
                row.label(text="", icon_value=icon.icon_id)
                row.label(text="ANGLE - Change the angle of the Screw.")

                box.separator()
                box.label(text="WORKFLOW", icon='INDIRECT_ONLY_ON')

                box.separator()
                box.label(text="Select one or more objects and launch the Modal, that will add the modifier.")
                box.label(text="These objects can be polygons or edges only.")
                box.label(text="The best result is with Edges.")

                box.separator()
                box.label(text="Note 1: You can add a Bevel in VROUP on the vertices of the edges.", icon='ERROR')
                box.label(text="Note 2: You can a lot of different objects with the Screw modifier.", icon='ERROR')

        # TUTORIALS
        box = layout.box()
        box.prop(SF, "doc_tutos", text="TUTORIALS", icon='TRIA_UP' if SF.doc_tutos else 'TRIA_DOWN')
        if SF.doc_tutos:
            box.label(text="Note: Settings and shortcuts may change")
            box.label(text="but the workflow is always the same")

            # SPEEDFLOW BASICS
            box = layout.box()
            box.prop(SF, "doc_basics", text="SPEEDFLOW BASICS", icon='TRIA_UP' if SF.doc_basics else 'TRIA_DOWN')
            if SF.doc_basics:
                box.label(text="Speedflow Basics is a serie of basics tutorials to learn Speedflow")
                row = box.row()
                icon = icons.get("icon_youtube")
                row.operator("wm.url_open", text="Speedflow Basics - 01 - Jack Adapter",
                             icon_value=icon.icon_id).url = "https://www.youtube.com/watch?v=YqytzYgM0MM"
                row = box.row()
                row.operator("wm.url_open", text="Speedflow Basics - 02 - Bluetooth Speaker",
                             icon_value=icon.icon_id).url = "https://www.youtube.com/watch?v=xUV6zCosP60"
                row = box.row()
                row.operator("wm.url_open", text="Speedflow Basics - 03 - Wooden Barrel",
                             icon_value=icon.icon_id).url = "https://www.youtube.com/watch?v=gJxdHXY92W8"
                row = box.row()
                row.operator("wm.url_open", text="Speedflow Basics - 04 - Parametric Gear",
                             icon_value=icon.icon_id).url = "https://youtu.be/WF9kahE_hKo"
                row = box.row()
                row.operator("wm.url_open", text="Speedflow Basics - 05 - Rope",
                             icon_value=icon.icon_id).url = "https://youtu.be/s1yTqulpC-Y"
                row = box.row()
                row.operator("wm.url_open", text="Speedflow Basics - 06 - Parametric Belt",
                             icon_value=icon.icon_id).url = "https://youtu.be/twH2KUmCcMY"


                #
                

            # YOUTUBE
            box = layout.box()
            box.prop(SF, "doc_youtube_tutos", text="YOUTUBE TUTORIALS", icon='TRIA_UP' if SF.doc_youtube_tutos else 'TRIA_DOWN')
            if SF.doc_youtube_tutos:
                row = box.row()
                icon = icons.get("icon_youtube")
                row.operator("wm.url_open", text="Speedflow for Beginners",
                             icon_value=icon.icon_id).url = "https://youtu.be/zpYz_qWlOQk"

                row = box.row()
                icon = icons.get("icon_youtube")
                row.operator("wm.url_open", text="Bevel Modifier - 4 types of Bevels",
                             icon_value=icon.icon_id).url = "https://www.youtube.com/watch?v=cbw0gzQsGgg"

                row = box.row()
                icon = icons.get("icon_youtube")
                row.operator("wm.url_open", text="Bevel Modifier - Bevelception!",
                             icon_value=icon.icon_id).url = "https://youtu.be/3ETxShfNcZ0"

                row = box.row()
                icon = icons.get("icon_youtube")
                row.operator("wm.url_open", text="Screw Modifier - Fix limitation and make an animated cut",
                             icon_value=icon.icon_id).url = "https://youtu.be/YmY-JoxIfNU"

                row = box.row()
                icon = icons.get("icon_youtube")
                row.operator("wm.url_open", text="Screw Modifier - Make a Barrel",
                             icon_value=icon.icon_id).url = "https://www.youtube.com/watch?v=EOcSRVTFqmA"

                row = box.row()
                icon = icons.get("icon_youtube")
                row.operator("wm.url_open", text="Tubify - 100% Editable Curve Asset",
                             icon_value=icon.icon_id).url = "https://www.youtube.com/watch?v=KzVzMyZ7Kgk"

                row = box.row()
                icon = icons.get("icon_youtube")
                row.operator("wm.url_open", text="All Modifiers - Non-Destructive Workflow - Basics",
                             icon_value=icon.icon_id).url = "https://www.youtube.com/watch?v=dQhJUIrkXdI"




            # GUMROAD/MARKET
            box = layout.box()
            box.prop(SF, "doc_gum_market_tutos", text="PAID TUTORIALS", icon='TRIA_UP' if SF.doc_gum_market_tutos else 'TRIA_DOWN')
            if SF.doc_gum_market_tutos:
                row = box.row(align = True)
                icon = icons.get("icon_gumroad")
                row.operator("wm.url_open", text="Sony BSP10",
                             icon_value=icon.icon_id).url = "https://gumroad.com/l/sony_bsp10_non_destructive_tutorial"
                icon = icons.get("icon_market")
                row.operator("wm.url_open", text="Sony BSP10",
                             icon_value=icon.icon_id).url = "https://blendermarket.com/products/sony-bsp10-non-destructive-worflow-tutorial"

                row = box.row(align = True)
                icon = icons.get("icon_gumroad")
                row.operator("wm.url_open", text="Non-Destructive workflow 1",
                             icon_value=icon.icon_id).url = "https://gumroad.com/l/Non-Destructive_Workflow_Tutorial_1"
                icon = icons.get("icon_market")
                row.operator("wm.url_open", text="Non-Destructive workflow 1",
                             icon_value=icon.icon_id).url = "https://blendermarket.com/products/hard-surface-non-destructive-modeling"

                row = box.row(align=True)
                icon = icons.get("icon_gumroad")
                row.operator("wm.url_open", text="Non-Destructive workflow 2",
                             icon_value=icon.icon_id).url = "https://gumroad.com/l/Non-Destructive_Workflow_Tutorial_2"

                row = box.row(align = True)
                icon = icons.get("icon_gumroad")
                row.operator("wm.url_open", text="Non-Destructive workflow 3",
                             icon_value=icon.icon_id).url = "https://gumroad.com/l/Non-Destructive_Workflow_Tutorial_3"
                icon = icons.get("icon_market")
                row.operator("wm.url_open", text="Non-Destructive workflow 3",
                             icon_value=icon.icon_id).url = "https://blendermarket.com/products/blender-non-destructive-workflow-tutorial-3"

                row = box.row(align=True)
                row.label(text="FRENCH TUTORIALS")
                row = box.row(align=True)
                icon = icons.get("icon_tutocom")
                row.operator("wm.url_open", text="NAS Synology",
                             icon_value=icon.icon_id).url = "https://fr.tuto.com/blender/modelisation-non-destructive-sur-blender-2-8-blender,118191.html?cc=EiVCRz"
                row = box.row(align=True)
                icon = icons.get("icon_tutocom")
                row.operator("wm.url_open", text="RAZER SEIREN X",
                             icon_value=icon.icon_id).url = "https://fr.tuto.com/blender/modelisation-non-destructive-razer-seiren-x-blender,118771.html?cc=EiVCRz"

UI_CLASSES =  [SPEEDFLOW_OT_help_panel_selector,
               SPEEDFLOW_MT_help_menu,
               SPEEDFLOW_OT_show_addon_prefs,
               SPEEDFLOW_PT_property_panel_keymaps,
               SPEEDFLOW_PT_property_panel_help]

EXTRA_CLASSES = [
               SPEEDFLOW_PT_panel,
               SPEEDFLOW_MT_pie_menu,
               SPEEDFLOW_MT_simple_menu]

def register():
    for cls in UI_CLASSES:
        try:
            bpy.utils.register_class(cls)
        except:
            print(f"{cls.__name__} already registred")


def unregister():
    for cls in UI_CLASSES + EXTRA_CLASSES:
        if hasattr(bpy.types, cls.__name__):
            bpy.utils.unregister_class(cls)