'''
Copyright (C) 2015 Pistiwique, Pitiwazou
 
Created by Pistiwique, Pitiwazou
 
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
'''


import os
import bpy
import bpy.utils.previews

speedflow_icon_collections = {}
speedflow_icons_loaded = False


def load_icons():
    global speedflow_icon_collections
    global speedflow_icons_loaded

    if speedflow_icons_loaded: return speedflow_icon_collections["main"]

    custom_icons = bpy.utils.previews.new()

    icons_dir = os.path.join(os.path.dirname(__file__))

    # modals
    custom_icons.load("icon_bevel", os.path.join(icons_dir, "bevel.png"), 'IMAGE')
    custom_icons.load("icon_tubify", os.path.join(icons_dir, "tubify.png"), 'IMAGE')
    custom_icons.load("icon_mirror", os.path.join(icons_dir, "mirror.png"), 'IMAGE')
    custom_icons.load("icon_rotate", os.path.join(icons_dir, "rotate.png"), 'IMAGE')
    custom_icons.load("icon_solidify", os.path.join(icons_dir, "solidify.png"), 'IMAGE')
    custom_icons.load("icon_subsurf", os.path.join(icons_dir, "subsurf.png"), 'IMAGE')
    custom_icons.load("icon_symetrize", os.path.join(icons_dir, "symetrize.png"), 'IMAGE')
    custom_icons.load("icon_array", os.path.join(icons_dir, "array.png"), 'IMAGE')
    custom_icons.load("icon_boolean", os.path.join(icons_dir, "boolean.png"), 'IMAGE')
    custom_icons.load("icon_screw", os.path.join(icons_dir, "screw.png"), 'IMAGE')
    custom_icons.load("icon_displace", os.path.join(icons_dir, "displace.png"), 'IMAGE')
    custom_icons.load("icon_decimate", os.path.join(icons_dir, "decimate.png"), 'IMAGE')
    custom_icons.load("icon_triangulate", os.path.join(icons_dir, "triangulate.png"), 'IMAGE')
    custom_icons.load("icon_edge_split", os.path.join(icons_dir, "edge_split.png"), 'IMAGE')
    custom_icons.load("icon_shrinkwrap", os.path.join(icons_dir, "shrinkwrap.png"), 'IMAGE')
    custom_icons.load("icon_simple_deform", os.path.join(icons_dir, "simple_deform.png"), 'IMAGE')
    custom_icons.load("icon_wireframe", os.path.join(icons_dir, "wireframe.png"), 'IMAGE')
    custom_icons.load("icon_curve", os.path.join(icons_dir, "curve.png"), 'IMAGE')
    custom_icons.load("icon_corrective_smooth", os.path.join(icons_dir, "corrective_smooth.png"), 'IMAGE')
    custom_icons.load("icon_mod_visibility", os.path.join(icons_dir, "mod_visibility.png"), 'IMAGE')
    custom_icons.load("icon_cutter", os.path.join(icons_dir, "cutter.png"), 'IMAGE')
    custom_icons.load("icon_skin", os.path.join(icons_dir, "skin.png"), 'IMAGE')
    custom_icons.load("icon_weighted_normal", os.path.join(icons_dir, "weighted_normal.png"), 'IMAGE')


    custom_icons.load("icon_market", os.path.join(icons_dir, "market.png"), 'IMAGE')
    custom_icons.load("icon_artstation", os.path.join(icons_dir, "artstation.png"), 'IMAGE')
    custom_icons.load("icon_gumroad", os.path.join(icons_dir, "gumroad.png"), 'IMAGE')
    custom_icons.load("icon_youtube", os.path.join(icons_dir, "youtube.png"), 'IMAGE')
    custom_icons.load("icon_tutocom", os.path.join(icons_dir, "tutocom.png"), 'IMAGE')


    custom_icons.load("icon_speedflow", os.path.join(icons_dir, "speedflow.png"), 'IMAGE')
    custom_icons.load("icon_modifiers", os.path.join(icons_dir, "modifiers.png"), 'IMAGE')
    custom_icons.load("icon_shading", os.path.join(icons_dir, "shading.png"), 'IMAGE')


    custom_icons.load("icon_a", os.path.join(icons_dir, "a.png"), 'IMAGE')
    custom_icons.load("icon_b", os.path.join(icons_dir, "b.png"), 'IMAGE')
    custom_icons.load("icon_c", os.path.join(icons_dir, "c.png"), 'IMAGE')
    custom_icons.load("icon_d", os.path.join(icons_dir, "d.png"), 'IMAGE')
    custom_icons.load("icon_e", os.path.join(icons_dir, "e.png"), 'IMAGE')
    custom_icons.load("icon_f", os.path.join(icons_dir, "f.png"), 'IMAGE')
    custom_icons.load("icon_g", os.path.join(icons_dir, "g.png"), 'IMAGE')
    custom_icons.load("icon_h", os.path.join(icons_dir, "h.png"), 'IMAGE')
    custom_icons.load("icon_i", os.path.join(icons_dir, "i.png"), 'IMAGE')
    custom_icons.load("icon_j", os.path.join(icons_dir, "j.png"), 'IMAGE')
    custom_icons.load("icon_k", os.path.join(icons_dir, "k.png"), 'IMAGE')
    custom_icons.load("icon_l", os.path.join(icons_dir, "l.png"), 'IMAGE')
    custom_icons.load("icon_m", os.path.join(icons_dir, "m.png"), 'IMAGE')
    custom_icons.load("icon_n", os.path.join(icons_dir, "n.png"), 'IMAGE')
    custom_icons.load("icon_o", os.path.join(icons_dir, "o.png"), 'IMAGE')
    custom_icons.load("icon_p", os.path.join(icons_dir, "p.png"), 'IMAGE')
    custom_icons.load("icon_q", os.path.join(icons_dir, "q.png"), 'IMAGE')
    custom_icons.load("icon_r", os.path.join(icons_dir, "r.png"), 'IMAGE')
    custom_icons.load("icon_s", os.path.join(icons_dir, "s.png"), 'IMAGE')
    custom_icons.load("icon_t", os.path.join(icons_dir, "t.png"), 'IMAGE')
    custom_icons.load("icon_u", os.path.join(icons_dir, "u.png"), 'IMAGE')
    custom_icons.load("icon_v", os.path.join(icons_dir, "v.png"), 'IMAGE')
    custom_icons.load("icon_w", os.path.join(icons_dir, "w.png"), 'IMAGE')
    custom_icons.load("icon_x", os.path.join(icons_dir, "x.png"), 'IMAGE')
    custom_icons.load("icon_y", os.path.join(icons_dir, "y.png"), 'IMAGE')
    custom_icons.load("icon_z", os.path.join(icons_dir, "z.png"), 'IMAGE')


    custom_icons.load("icon_1", os.path.join(icons_dir, "1.png"), 'IMAGE')
    custom_icons.load("icon_2", os.path.join(icons_dir, "2.png"), 'IMAGE')
    custom_icons.load("icon_3", os.path.join(icons_dir, "3.png"), 'IMAGE')
    custom_icons.load("icon_4", os.path.join(icons_dir, "4.png"), 'IMAGE')
    custom_icons.load("icon_5", os.path.join(icons_dir, "5.png"), 'IMAGE')
    custom_icons.load("icon_6", os.path.join(icons_dir, "6.png"), 'IMAGE')
    custom_icons.load("icon_7", os.path.join(icons_dir, "7.png"), 'IMAGE')
    custom_icons.load("icon_8", os.path.join(icons_dir, "8.png"), 'IMAGE')
    custom_icons.load("icon_9", os.path.join(icons_dir, "9.png"), 'IMAGE')
    custom_icons.load("icon_0", os.path.join(icons_dir, "0.png"), 'IMAGE')


    custom_icons.load("icon_f1", os.path.join(icons_dir, "f1.png"), 'IMAGE')
    custom_icons.load("icon_f2", os.path.join(icons_dir, "f2.png"), 'IMAGE')
    custom_icons.load("icon_f3", os.path.join(icons_dir, "f3.png"), 'IMAGE')
    custom_icons.load("icon_f4", os.path.join(icons_dir, "f4.png"), 'IMAGE')
    custom_icons.load("icon_f5", os.path.join(icons_dir, "f5.png"), 'IMAGE')
    custom_icons.load("icon_f6", os.path.join(icons_dir, "f6.png"), 'IMAGE')
    custom_icons.load("icon_f7", os.path.join(icons_dir, "f7.png"), 'IMAGE')
    custom_icons.load("icon_f8", os.path.join(icons_dir, "f8.png"), 'IMAGE')
    custom_icons.load("icon_f9", os.path.join(icons_dir, "f9.png"), 'IMAGE')


    custom_icons.load("icon_ctrl", os.path.join(icons_dir, "ctrl.png"), 'IMAGE')
    custom_icons.load("icon_shift", os.path.join(icons_dir, "shift.png"), 'IMAGE')
    custom_icons.load("icon_tab", os.path.join(icons_dir, "tab.png"), 'IMAGE')
    custom_icons.load("icon_up", os.path.join(icons_dir, "up.png"), 'IMAGE')
    custom_icons.load("icon_down", os.path.join(icons_dir, "down.png"), 'IMAGE')
    custom_icons.load("icon_left", os.path.join(icons_dir, "left.png"), 'IMAGE')
    custom_icons.load("icon_right", os.path.join(icons_dir, "right.png"), 'IMAGE')
    custom_icons.load("icon_del", os.path.join(icons_dir, "del.png"), 'IMAGE')
    custom_icons.load("icon_greater_than", os.path.join(icons_dir, "greater_than.png"), 'IMAGE')
    custom_icons.load("icon_less_than", os.path.join(icons_dir, "less_than.png"), 'IMAGE')
    custom_icons.load("icon_space", os.path.join(icons_dir, "space.png"), 'IMAGE')


    speedflow_icon_collections["main"] = custom_icons
    speedflow_icons_loaded = True

    return speedflow_icon_collections["main"]


def speedflow_clear_icons():
    global speedflow_icons_loaded
    for icon in speedflow_icon_collections.values():
        bpy.utils.previews.remove(icon)
    speedflow_icon_collections.clear()
    speedflow_icons_loaded = False