/*
 * Decompiled with CFR 0.152.
 */
package com.damytec.printplacetag.view;

import com.damytec.printplacetag.enums.Folha;
import com.damytec.printplacetag.enums.Formato;
import com.damytec.printplacetag.enums.Orientacao;
import com.damytec.printplacetag.enums.Tema;
import com.damytec.printplacetag.pojo.ResultadoCalculo;
import com.damytec.printplacetag.pojo.ShowOptions;
import com.damytec.printplacetag.service.PrintplacetagService;
import com.damytec.printplacetag.ui.BaseWindow;
import com.damytec.printplacetag.ui.CustomButton;
import com.damytec.printplacetag.util.ImageUtil;
import com.damytec.printplacetag.util.KeyboardUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public class PrintplacetagPanel
implements BaseWindow.ContentForm {
    private JPanel root;
    private JTextField larguraField;
    private JTextField alturaField;
    private JComboBox<Folha> folhaCombo;
    private JTextField margemField;
    private JTextField espacoField;
    private JButton calcularButton;
    private JButton limparButton;
    private JLabel pageImage;
    private JPanel lowerPanel;
    private JSplitPane vSplit;
    private JLabel resultLabel;
    private JCheckBox showTags;
    private JCheckBox showCorte;
    private JCheckBox showFolha;
    private JCheckBox showMargem;
    private JPanel customButtonHub;
    private JPanel menusPanel;
    private JPanel resultPanel;
    private JTextPane resultText;
    private JSplitPane hSplit;
    private CustomButton retratoBtn;
    private CustomButton paisagemBtn;
    private CustomButton retoBtn;
    private CustomButton ovalBtn;
    private CustomButton disneyBtn;
    private CustomButton temaBtn;
    private ImageIcon ok;
    private ImageIcon nok;
    private Orientacao orientacao = Orientacao.RETRATO;
    private Formato formato = Formato.RETO;
    private Tema tema = Tema.YELLOW_BLACK;
    private static final Map<Orientacao, CustomButton> orientacaoMap = new HashMap<Orientacao, CustomButton>();
    private static final Map<Formato, CustomButton> formatoMap = new HashMap<Formato, CustomButton>();
    private static final String DEFAULT_LARGURA = "40";
    private static final String DEFAULT_ALTURA = "15";
    private static final String DEFAULT_MARGEM = "7";
    private static final String DEFAULT_ESPACO = "0";
    private PrintplacetagService service;

    public PrintplacetagPanel() {
        this.$$$setupUI$$$();
        this.icones();
        this.service = PrintplacetagService.getInstance();
        EnumSet.allOf(Folha.class).stream().forEach(this.folhaCombo::addItem);
        this.defaults(null);
        this.acoes();
        this.customButtonMaps();
        this.customButtonShow();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.dispatcher());
        this.hSplit.setResizeWeight(0.3);
    }

    private void calcular(Object e) {
        try {
            ResultadoCalculo res = this.service.calcularQuantidade(Integer.parseInt(this.margemField.getText()), Integer.parseInt(this.espacoField.getText()), Integer.parseInt(this.larguraField.getText()), Integer.parseInt(this.alturaField.getText()), (Folha)((Object)this.folhaCombo.getSelectedItem()), this.orientacao, this.formato, new ShowOptions(this.showTags.isSelected(), this.showFolha.isSelected(), this.showCorte.isSelected(), this.showMargem.isSelected(), this.tema));
            this.pageImage.setIcon(new ImageIcon(ImageUtil.resize(res.getImg(), this.lowerPanel.getHeight() - 10, this.lowerPanel.getWidth() - 10)));
            this.resultText.setText(res.getTpf().toHtml());
            this.resultColor(res.getTpf().isLimiar() ? Color.PINK : UIManager.getColor("Panel.background"));
            this.resultLabel.setIcon(res.isBest() ? this.ok : this.nok);
            this.customButtonShow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void acoes() {
        this.calcularButton.addActionListener(this::calcular);
        this.limparButton.addActionListener(this::defaults);
        this.showTags.addActionListener(this::calcular);
        this.showMargem.addActionListener(this::calcular);
        this.showFolha.addActionListener(this::calcular);
        this.showCorte.addActionListener(this::calcular);
        this.folhaCombo.addActionListener(this::calcular);
        this.paisagemBtn = new CustomButton("images/paisagem.png"){

            @Override
            public void actionPerformed() {
                PrintplacetagPanel.this.toggleOrientacao();
            }
        };
        this.paisagemBtn.setCursor(Cursor.getPredefinedCursor(12));
        this.retratoBtn = new CustomButton("images/retrato.png"){

            @Override
            public void actionPerformed() {
                PrintplacetagPanel.this.toggleOrientacao();
            }
        };
        this.retoBtn = new CustomButton("images/reto.png"){

            @Override
            public void actionPerformed() {
                PrintplacetagPanel.this.toggleFormato();
            }
        };
        this.ovalBtn = new CustomButton("images/oval.png"){

            @Override
            public void actionPerformed() {
                PrintplacetagPanel.this.toggleFormato();
            }
        };
        this.disneyBtn = new CustomButton("images/disney.png"){

            @Override
            public void actionPerformed() {
                PrintplacetagPanel.this.toggleFormato();
            }
        };
        this.temaBtn = new CustomButton("images/cmyk.png"){

            @Override
            public void actionPerformed() {
                PrintplacetagPanel.this.toggleTema();
            }
        };
    }

    private void toggleFormato() {
        this.formato = this.formato.next();
        this.calcular(null);
    }

    private void toggleTema() {
        this.tema = this.tema.next();
        this.calcular(null);
    }

    private void toggleOrientacao() {
        this.orientacao = this.orientacao == Orientacao.RETRATO ? Orientacao.PAISAGEM : Orientacao.RETRATO;
        this.calcular(null);
    }

    private void icones() {
        this.ok = new ImageIcon(PrintplacetagPanel.class.getClassLoader().getResource("images/ok.gif"));
        this.nok = new ImageIcon(PrintplacetagPanel.class.getClassLoader().getResource("images/nok.png"));
    }

    private KeyEventDispatcher dispatcher() {
        return new KeyboardUtil(){

            @Override
            public void enter() {
                PrintplacetagPanel.this.calcular(null);
            }
        }.shortcuts();
    }

    private void customButtonMaps() {
        orientacaoMap.put(Orientacao.RETRATO, this.retratoBtn);
        orientacaoMap.put(Orientacao.PAISAGEM, this.paisagemBtn);
        formatoMap.put(Formato.RETO, this.retoBtn);
        formatoMap.put(Formato.OVAL, this.ovalBtn);
        formatoMap.put(Formato.DISNEY, this.disneyBtn);
    }

    private void defaults(ActionEvent e) {
        this.alturaField.setText(DEFAULT_ALTURA);
        this.larguraField.setText(DEFAULT_LARGURA);
        this.margemField.setText(DEFAULT_MARGEM);
        this.espacoField.setText(DEFAULT_ESPACO);
        this.folhaCombo.setSelectedItem((Object)Folha.A4);
    }

    private void customButtonShow() {
        this.customButtonHub.removeAll();
        this.customButtonHub.add(orientacaoMap.get((Object)this.orientacao));
        this.customButtonHub.add(formatoMap.get((Object)this.formato));
        this.customButtonHub.add(this.temaBtn);
        this.customButtonHub.updateUI();
    }

    private void resultColor(Color c) {
        this.customButtonHub.setBackground(c);
        this.resultText.setBackground(c);
        this.resultPanel.setBackground(c);
    }

    @Override
    public JPanel root() {
        return this.root;
    }

    @Override
    public String title() {
        return PrintplacetagPanel.class.getPackage().getImplementationTitle() + " - " + PrintplacetagPanel.class.getPackage().getImplementationVersion();
    }

    private void createUIComponents() {
        this.customButtonHub = new JPanel();
        this.customButtonHub.setLayout(new BoxLayout(this.customButtonHub, 1));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextPane jTextPane;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JButton jButton;
        JButton jButton2;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JPanel jPanel2;
        JSplitPane jSplitPane;
        JLabel jLabel2;
        JPanel jPanel3;
        JSplitPane jSplitPane2;
        JPanel jPanel4;
        this.createUIComponents();
        this.root = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        this.vSplit = jSplitPane2 = new JSplitPane();
        jSplitPane2.setContinuousLayout(false);
        jSplitPane2.setDividerSize(0);
        ((Component)jSplitPane2).setEnabled(false);
        jSplitPane2.setOrientation(0);
        jPanel4.add((Component)jSplitPane2, "Center");
        this.lowerPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jSplitPane2.setRightComponent(jPanel3);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null, 0, 0, null, null));
        this.pageImage = jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setHorizontalTextPosition(0);
        jLabel2.setText("");
        jPanel3.add((Component)jLabel2, "Center");
        this.hSplit = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(600);
        jSplitPane.setDividerSize(0);
        ((Component)jSplitPane).setEnabled(false);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane2.setLeftComponent(jSplitPane);
        this.menusPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jSplitPane.setLeftComponent(jPanel2);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null, 0, 0, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Largura:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 1);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Altura:");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 1);
        jPanel2.add((Component)jLabel4, gridBagConstraints2);
        this.larguraField = jTextField4 = new JTextField();
        jTextField4.setColumns(5);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(0, 1, 0, 1);
        jPanel2.add((Component)jTextField4, gridBagConstraints3);
        this.alturaField = jTextField3 = new JTextField();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(0, 1, 0, 1);
        jPanel2.add((Component)jTextField3, gridBagConstraints4);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Margem:");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.insets = new Insets(0, 0, 0, 1);
        jPanel2.add((Component)jLabel5, gridBagConstraints5);
        this.margemField = jTextField2 = new JTextField();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(0, 1, 0, 1);
        jPanel2.add((Component)jTextField2, gridBagConstraints6);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Espa\u00e7amento:");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 3;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.insets = new Insets(0, 0, 0, 1);
        jPanel2.add((Component)jLabel6, gridBagConstraints7);
        this.espacoField = jTextField = new JTextField();
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 3;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.insets = new Insets(0, 1, 0, 1);
        jPanel2.add((Component)jTextField, gridBagConstraints8);
        this.limparButton = jButton2 = new JButton();
        jButton2.setText("Limpar");
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 4;
        gridBagConstraints9.gridy = 3;
        gridBagConstraints9.fill = 2;
        jPanel2.add((Component)jButton2, gridBagConstraints9);
        this.calcularButton = jButton = new JButton();
        jButton.setText("Calcular");
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 3;
        gridBagConstraints10.gridy = 3;
        gridBagConstraints10.fill = 2;
        jPanel2.add((Component)jButton, gridBagConstraints10);
        this.showMargem = jCheckBox4 = new JCheckBox();
        jCheckBox4.setSelected(true);
        jCheckBox4.setText("Margem");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 4;
        gridBagConstraints11.gridy = 0;
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.insets = new Insets(0, 1, 0, 1);
        jPanel2.add((Component)jCheckBox4, gridBagConstraints11);
        this.showCorte = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(true);
        jCheckBox3.setText("Corte");
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 4;
        gridBagConstraints12.gridy = 1;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.insets = new Insets(0, 1, 0, 1);
        jPanel2.add((Component)jCheckBox3, gridBagConstraints12);
        this.showFolha = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Folha");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 3;
        gridBagConstraints13.gridy = 1;
        gridBagConstraints13.anchor = 17;
        gridBagConstraints13.insets = new Insets(0, 1, 0, 1);
        jPanel2.add((Component)jCheckBox2, gridBagConstraints13);
        this.showTags = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Tags");
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 3;
        gridBagConstraints14.gridy = 0;
        gridBagConstraints14.anchor = 17;
        jPanel2.add((Component)jCheckBox, gridBagConstraints14);
        JComboBox jComboBox = new JComboBox();
        this.folhaCombo = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.gridx = 2;
        gridBagConstraints15.gridy = 0;
        gridBagConstraints15.fill = 2;
        gridBagConstraints15.insets = new Insets(0, 1, 0, 1);
        jPanel2.add(jComboBox, gridBagConstraints15);
        this.resultPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jSplitPane.setRightComponent(jPanel);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null, 0, 0, null, null));
        this.resultText = jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        jPanel.add((Component)jTextPane, "Center");
        JPanel jPanel5 = this.customButtonHub;
        jPanel.add((Component)jPanel5, "West");
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.resultLabel = jLabel = new JLabel();
        ((Component)jLabel).setBackground(new Color(-1));
        jLabel.setText("");
        jPanel.add((Component)jLabel, "East");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }
}

