/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.URLUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

class NbDefaultUnixBrowserImpl
extends ExtBrowserImpl {
    private static final String XDG_COMMAND = "xdg-open";
    private static final String XBROWSER_COMMAND = "x-www-browser";
    private static final RequestProcessor REQUEST_PROCESSOR = new RequestProcessor(NbDefaultUnixBrowserImpl.class);
    private static final boolean XDG_AVAILABLE = new File("/usr/bin/xdg-open").exists();
    private static final boolean XBROWSER_AVAILABLE = new File("/usr/bin/x-www-browser").exists();

    static boolean isAvailable() {
        return XDG_AVAILABLE || XBROWSER_AVAILABLE;
    }

    NbDefaultUnixBrowserImpl(ExtWebBrowser extBrowser) {
        this.extBrowserFactory = extBrowser;
        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
            ExtWebBrowser.getEM().log(Level.FINE, "" + System.currentTimeMillis() + "NbDefaultUnixBrowserImpl created with factory: " + this.extBrowserFactory);
        }
    }

    public void setURL(URL url) {
        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
            ExtWebBrowser.getEM().log(Level.FINE, "" + System.currentTimeMillis() + "NbDeaultUnixBrowserImpl.setUrl: " + url);
        }
        url = URLUtil.createExternalURL(url, false);
        String urlArg = url.toExternalForm();
        String command = XBROWSER_AVAILABLE ? XBROWSER_COMMAND : XDG_COMMAND;
        ProcessBuilder pb = new ProcessBuilder(command, urlArg);
        try {
            Process p = pb.start();
            REQUEST_PROCESSOR.post((Runnable)new ProcessWatcher(p));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void cleanupProcess(Process p) {
        NbDefaultUnixBrowserImpl.closeStream(p.getOutputStream());
        NbDefaultUnixBrowserImpl.closeStream(p.getInputStream());
        NbDefaultUnixBrowserImpl.closeStream(p.getErrorStream());
        p.destroy();
    }

    private static void closeStream(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException ioe) {
            NbDefaultUnixBrowserImpl.log(ioe);
        }
    }

    private static void log(Exception e) {
        Logger.getLogger(NbDefaultUnixBrowserImpl.class.getName()).log(Level.INFO, null, e);
    }

    private static final class ProcessWatcher
    implements Runnable {
        private final Process p;

        ProcessWatcher(Process p) {
            this.p = p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: {
                try {
                    int exitValue = this.p.waitFor();
                    if (exitValue == 0) break block8;
                    StringBuilder sb = new StringBuilder();
                    InputStream is = this.p.getErrorStream();
                    try {
                        int curByte = 0;
                        while ((curByte = is.read()) != -1) {
                            sb.append((char)curByte);
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    ExtWebBrowser.getEM().log(Level.WARNING, sb.toString());
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    NbDefaultUnixBrowserImpl.cleanupProcess(this.p);
                }
            }
        }
    }
}

