/*
 * Decompiled with CFR 0.152.
 */
package kiyut.swing.statusbar;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import kiyut.swing.statusbar.StatusBarItem;

public class StatusBar
extends JPanel {
    private List<StatusBarItem> itemList;

    public StatusBar() {
        this.setLayout(new GridBagLayout());
        this.itemList = new ArrayList<StatusBarItem>();
    }

    public void addItem(StatusBarItem statusBarItem) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = this.itemList.size();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (this.itemList.size() >= 1) {
            gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        }
        this.add((Component)statusBarItem, gridBagConstraints);
        int pos = this.itemList.size() - 1;
        if (pos >= 0) {
            StatusBarItem prevItem = this.itemList.get(pos);
            GridBagLayout layout = (GridBagLayout)this.getLayout();
            gridBagConstraints = layout.getConstraints(prevItem);
            gridBagConstraints.weightx = 0.0;
            layout.setConstraints(prevItem, gridBagConstraints);
        }
        this.itemList.add(statusBarItem);
    }

    public StatusBarItem removeItem(int pos) {
        super.remove(pos);
        StatusBarItem removed = this.itemList.remove(pos);
        if (pos == this.itemList.size() && pos > 0) {
            StatusBarItem prevItem = this.itemList.get(pos);
            GridBagLayout layout = (GridBagLayout)this.getLayout();
            GridBagConstraints gridBagConstraints = layout.getConstraints(prevItem);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            layout.setConstraints(prevItem, gridBagConstraints);
        }
        return removed;
    }

    public List<StatusBarItem> getItemList() {
        return this.itemList;
    }

    public StatusBarItem getItem(int pos) {
        return this.itemList.get(pos);
    }

    public int getItemCount() {
        return this.itemList.size();
    }
}

