/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.xmleditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.TextAction;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.io.NodeRange;
import kiyut.sketsa.io.SVGWriter;
import kiyut.sketsa.xmleditor.FindPane;
import kiyut.sketsa.xmleditor.LineNumber;
import kiyut.sketsa.xmleditor.ReplacePane;
import kiyut.sketsa.xmleditor.XMLTextEditor;
import kiyut.swing.statusbar.StatusBar;
import kiyut.swing.statusbar.StatusBarItem;
import kiyut.swing.text.xml.XMLDocument;
import kiyut.swing.util.MenuFactory;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;

public class SourceEditorPane
extends JPanel {
    private static final String PARSE_ACTION_COMMAND = "Parse";
    private static final String APPLY_ACTION_COMMAND = "Apply";
    private static final String UNDO_ACTION_COMMAND = "Undo";
    private static final String REDO_ACTION_COMMAND = "Redo";
    private static final String CUT_ACTION_COMMAND = "Cut";
    private static final String COPY_ACTION_COMMAND = "Copy";
    private static final String PASTE_ACTION_COMMAND = "Paste";
    private static final String FIND_ACTION_COMMAND = "Find";
    private static final String FIND_NEXT_ACTION_COMMAND = "FindNext";
    private static final String REPLACE_ACTION_COMMAND = "Replace";
    private static final String GOTO_ACTION_COMMAND = "Goto";
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.xmleditor.SourceEditorPane");
    private VectorCanvas canvas;
    private StatusBar statusBar;
    private boolean modified;
    private FindPane findPane;
    private ReplacePane replacePane;
    private List<String> findHistory;
    private List<String> replaceHistory;
    private JPopupMenu popup;
    private JScrollPane scrollPane;
    private JPanel statusBarPane;
    private JToolBar toolBar;
    private JEditorPane xmlTextEditor;

    public SourceEditorPane() {
        this.initComponents();
        this.modified = false;
        this.statusBar = new StatusBar();
        StatusBarItem statusBarItem = new StatusBarItem(" ", 100, 0);
        this.statusBar.addItem(statusBarItem);
        statusBarItem = new StatusBarItem("INS", 40, 0);
        this.statusBar.addItem(statusBarItem);
        statusBarItem = new StatusBarItem(" ", 150, 2);
        this.statusBar.addItem(statusBarItem);
        this.statusBarPane.add((Component)this.statusBar, "Center");
        this.xmlTextEditor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                SourceEditorPane.this.editorCaretUpdate(evt);
            }
        });
        Document doc = this.xmlTextEditor.getDocument();
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SourceEditorPane.this.modified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SourceEditorPane.this.modified = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SourceEditorPane.this.modified = true;
            }
        });
        PropertyChangeListener findListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SourceEditorPane.this.findPropertyChange(evt);
            }
        };
        this.findPane = new FindPane();
        this.findPane.addPropertyChangeListener(findListener);
        PropertyChangeListener replaceListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SourceEditorPane.this.replacePropertyChange(evt);
            }
        };
        this.replacePane = new ReplacePane();
        this.replacePane.addPropertyChangeListener(replaceListener);
        this.initActions();
        this.xmlTextEditor.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showPopup(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showPopup(evt);
                }
            }

            private void showPopup(MouseEvent evt) {
                SourceEditorPane.this.popup.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        });
        this.scrollPane.setRowHeaderView(new LineNumber(this.xmlTextEditor));
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.scrollPane = new JScrollPane();
        this.xmlTextEditor = new XMLTextEditor();
        this.statusBarPane = new JPanel();
        this.setLayout(new BorderLayout());
        this.toolBar.setRollover(true);
        this.toolBar.setFocusable(false);
        this.add((Component)this.toolBar, "North");
        this.scrollPane.setAutoscrolls(true);
        this.scrollPane.setViewportView(this.xmlTextEditor);
        this.add((Component)this.scrollPane, "Center");
        this.statusBarPane.setFocusable(false);
        this.statusBarPane.setLayout(new BorderLayout());
        this.add((Component)this.statusBarPane, "South");
    }

    private void initActions() {
        HashMap<String, Action> actionMap = new HashMap<String, Action>();
        actionMap.put(PARSE_ACTION_COMMAND, new EditorAction(PARSE_ACTION_COMMAND));
        actionMap.put(APPLY_ACTION_COMMAND, new EditorAction(APPLY_ACTION_COMMAND));
        actionMap.put(UNDO_ACTION_COMMAND, new EditorAction(UNDO_ACTION_COMMAND));
        actionMap.put(REDO_ACTION_COMMAND, new EditorAction(REDO_ACTION_COMMAND));
        actionMap.put(CUT_ACTION_COMMAND, new EditorAction(CUT_ACTION_COMMAND));
        actionMap.put(COPY_ACTION_COMMAND, new EditorAction(COPY_ACTION_COMMAND));
        actionMap.put(PASTE_ACTION_COMMAND, new EditorAction(PASTE_ACTION_COMMAND));
        actionMap.put(FIND_ACTION_COMMAND, new EditorAction(FIND_ACTION_COMMAND));
        actionMap.put(FIND_NEXT_ACTION_COMMAND, new EditorAction(FIND_NEXT_ACTION_COMMAND));
        actionMap.put(REPLACE_ACTION_COMMAND, new EditorAction(REPLACE_ACTION_COMMAND));
        actionMap.put(GOTO_ACTION_COMMAND, new EditorAction(GOTO_ACTION_COMMAND));
        MenuFactory.configureActionMap(bundle, actionMap);
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(PARSE_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(APPLY_ACTION_COMMAND)));
        this.toolBar.addSeparator();
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(UNDO_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(REDO_ACTION_COMMAND)));
        this.toolBar.addSeparator();
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(CUT_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(COPY_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(PASTE_ACTION_COMMAND)));
        this.toolBar.addSeparator();
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(FIND_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(FIND_NEXT_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(REPLACE_ACTION_COMMAND)));
        this.toolBar.add(this.createToolBarButton((Action)actionMap.get(GOTO_ACTION_COMMAND)));
        this.popup = MenuFactory.createPopupMenu(bundle, actionMap, "PopupMenu");
        InputMap inputMap = this.xmlTextEditor.getInputMap();
        Action action = (Action)actionMap.get(PARSE_ACTION_COMMAND);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action);
        action = (Action)actionMap.get(APPLY_ACTION_COMMAND);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action);
        action = (Action)actionMap.get(UNDO_ACTION_COMMAND);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action);
        action = (Action)actionMap.get(REDO_ACTION_COMMAND);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action);
        action = (Action)actionMap.get(CUT_ACTION_COMMAND);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action);
        action = (Action)actionMap.get(COPY_ACTION_COMMAND);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action);
        action = (Action)actionMap.get(PASTE_ACTION_COMMAND);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action);
        action = (Action)actionMap.get(FIND_ACTION_COMMAND);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action);
        action = (Action)actionMap.get(FIND_NEXT_ACTION_COMMAND);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action);
        action = (Action)actionMap.get(REPLACE_ACTION_COMMAND);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action);
        action = (Action)actionMap.get(GOTO_ACTION_COMMAND);
        inputMap.put((KeyStroke)action.getValue("AcceleratorKey"), action);
    }

    private JButton createToolBarButton(Action action) {
        JButton button = new JButton(action);
        button.setText("");
        button.setFocusable(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
        SVGDocument doc = canvas.getSVGDocument();
        try {
            NodeRange nodeRange = null;
            List<SVGElement> list = canvas.getCanvasSelection().getSelectionList();
            if (list.size() > 0) {
                nodeRange = new NodeRange((Node)list.get(0));
            }
            StringWriter writer = new StringWriter();
            BufferedWriter bw = new BufferedWriter(writer);
            SVGWriter.write(doc, bw, nodeRange);
            bw.flush();
            bw.close();
            this.xmlTextEditor.setText(writer.getBuffer().toString());
            if (nodeRange == null) {
                this.xmlTextEditor.setCaretPosition(0);
            } else {
                Caret caret = this.xmlTextEditor.getCaret();
                int startIndex = (int)nodeRange.getStartIndex();
                int endIndex = (int)nodeRange.getEndIndex();
                startIndex = startIndex > 0 ? startIndex : 0;
                endIndex = endIndex > 0 ? endIndex : startIndex;
                caret.setDot(startIndex);
                caret.moveDot(endIndex);
            }
            this.modified = false;
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_GenericError.Title"), 0);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVGDocument parseText() {
        SVGDocument doc = null;
        String uri = this.canvas.getSVGDocument().getURL();
        StringReader reader = new StringReader(this.xmlTextEditor.getText());
        try {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            doc = f.createSVGDocument(uri, (Reader)reader);
        }
        catch (OutOfMemoryError ex) {
            doc = null;
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        catch (Exception ex) {
            doc = null;
            String msg = ex.getMessage();
            JOptionPane.showMessageDialog(this, msg, bundle.getString("MSG_SyntaxError.Title"), 0);
        }
        finally {
            reader.close();
        }
        return doc;
    }

    public SVGDocument apply() {
        SVGDocument newDoc = this.parseText();
        if (newDoc != null) {
            try {
                this.canvas.setSVGDocument(newDoc);
                this.modified = false;
            }
            catch (Exception ex) {
                newDoc = null;
                this.modified = true;
                JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_SyntaxError.Title"), 0);
            }
        }
        return newDoc;
    }

    protected void find() {
        this.findPane.setFindTextHistory(this.findHistory);
        this.findPane.showDialog(this);
        this.findHistory = this.findPane.getFindTextHistory();
    }

    protected void findNext() {
        this.findNext(this.xmlTextEditor.getCaretPosition());
    }

    protected void findNext(int fromIndex) {
        String text = this.findPane.getFindText();
        if (text == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SourceEditorPane.this.find();
                }
            });
            return;
        }
        Map<String, Object> optionMap = this.findPane.getOptionMap();
        boolean caseSensitive = (Boolean)optionMap.get("case_sensitive");
        int offset = -1;
        try {
            offset = ((XMLDocument)this.xmlTextEditor.getDocument()).find(text, fromIndex, caseSensitive);
            if (offset == -1 && fromIndex > 0) {
                offset = ((XMLDocument)this.xmlTextEditor.getDocument()).find(text, 0, caseSensitive);
            }
        }
        catch (BadLocationException ex) {
            offset = -1;
        }
        if (offset != -1) {
            this.xmlTextEditor.setCaretPosition(offset);
            this.xmlTextEditor.moveCaretPosition(offset + text.length());
        }
    }

    protected void replace() {
        String selected = this.xmlTextEditor.getSelectedText();
        if (selected != null) {
            int pos = this.xmlTextEditor.getCaretPosition();
            this.xmlTextEditor.setCaretPosition(pos);
        }
        this.replacePane.setFindTextHistory(this.findHistory);
        this.replacePane.setReplaceTextHistory(this.replaceHistory);
        this.replacePane.showDialog(this);
        this.findHistory = this.replacePane.getFindTextHistory();
        this.replaceHistory = this.replacePane.getReplaceTextHistory();
    }

    protected void replaceFindNext() {
        this.replaceFindNext(this.xmlTextEditor.getCaretPosition());
    }

    protected void replaceFindNext(int fromIndex) {
        String text = this.replacePane.getFindText();
        if (text == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SourceEditorPane.this.replaceFindNext();
                }
            });
            return;
        }
        Map<String, Object> optionMap = this.replacePane.getOptionMap();
        boolean caseSensitive = (Boolean)optionMap.get("case_sensitive");
        int offset = -1;
        try {
            offset = ((XMLDocument)this.xmlTextEditor.getDocument()).find(text, fromIndex, caseSensitive);
            if (offset == -1 && fromIndex > 0) {
                offset = ((XMLDocument)this.xmlTextEditor.getDocument()).find(text, 0, caseSensitive);
            }
        }
        catch (BadLocationException ex) {
            offset = -1;
        }
        if (offset != -1) {
            this.xmlTextEditor.setCaretPosition(offset);
            this.xmlTextEditor.moveCaretPosition(offset + text.length());
        }
    }

    protected void replaceNext() {
        String selected = this.xmlTextEditor.getSelectedText();
        String replaceText = this.replacePane.getReplaceText();
        if (selected != null) {
            this.xmlTextEditor.replaceSelection(replaceText);
        }
        this.replaceFindNext();
    }

    protected void replaceAll() {
        String findText = this.replacePane.getFindText();
        String replaceText = this.replacePane.getReplaceText();
        Map<String, Object> optionMap = this.replacePane.getOptionMap();
        boolean caseSensitive = (Boolean)optionMap.get("case_sensitive");
        if (!caseSensitive) {
            findText = "(?iu)" + findText;
        }
        int pos = this.xmlTextEditor.getCaretPosition();
        String str = this.xmlTextEditor.getText();
        str = str.replaceAll(findText, replaceText);
        this.xmlTextEditor.setText(str);
        if (pos < this.xmlTextEditor.getDocument().getLength()) {
            this.xmlTextEditor.setCaretPosition(pos);
        }
    }

    protected void gotoLine() {
        String inputValue = JOptionPane.showInputDialog(this, bundle.getString("CTL_GoToLine.Text"), bundle.getString("CTL_GoToLine.Title"), 3);
        int line = -1;
        try {
            line = Integer.parseInt(inputValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (line > 0) {
            ((XMLTextEditor)this.xmlTextEditor).gotoLine(line - 1);
        }
    }

    public void setFindTextHistory(List<String> history) {
        this.findHistory = history;
    }

    public void setReplaceTextHistory(List<String> history) {
        this.replaceHistory = history;
    }

    public List<String> getFindTextHistory() {
        return this.findHistory;
    }

    public List<String> getReplaceTextHistory() {
        return this.replaceHistory;
    }

    private void editorCaretUpdate(CaretEvent e) {
        int offset = Math.max(e.getDot(), e.getMark());
        Element element = this.xmlTextEditor.getDocument().getDefaultRootElement();
        int line = element.getElementIndex(offset);
        int col = offset - element.getElement(line).getStartOffset();
        this.statusBar.getItem(0).setText(++line + ":" + ++col);
    }

    private void findPropertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (!prop.equals("value_property")) {
            return;
        }
        int value = (Integer)e.getNewValue();
        if (value == 0) {
            this.findNext();
        }
    }

    private void replacePropertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (!prop.equals("value_property")) {
            return;
        }
        int value = (Integer)e.getNewValue();
        if (value == 0) {
            this.replaceFindNext();
        } else if (value == 1) {
            this.replaceNext();
        } else if (value == 2) {
            this.replaceAll();
        }
    }

    private class EditorAction
    extends TextAction {
        public EditorAction(String name) {
            super(name);
            this.putValue("ActionCommandKey", name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String command = evt.getActionCommand();
            if (command.equalsIgnoreCase(SourceEditorPane.PARSE_ACTION_COMMAND)) {
                SourceEditorPane.this.parseText();
            } else if (command.equalsIgnoreCase(SourceEditorPane.APPLY_ACTION_COMMAND)) {
                SourceEditorPane.this.apply();
            } else if (command.equalsIgnoreCase(SourceEditorPane.CUT_ACTION_COMMAND)) {
                SourceEditorPane.this.xmlTextEditor.cut();
            } else if (command.equalsIgnoreCase(SourceEditorPane.COPY_ACTION_COMMAND)) {
                SourceEditorPane.this.xmlTextEditor.copy();
            } else if (command.equalsIgnoreCase(SourceEditorPane.PASTE_ACTION_COMMAND)) {
                SourceEditorPane.this.xmlTextEditor.paste();
            } else if (command.equalsIgnoreCase(SourceEditorPane.UNDO_ACTION_COMMAND)) {
                ((XMLTextEditor)SourceEditorPane.this.xmlTextEditor).undo();
            } else if (command.equalsIgnoreCase(SourceEditorPane.REDO_ACTION_COMMAND)) {
                ((XMLTextEditor)SourceEditorPane.this.xmlTextEditor).redo();
            } else if (command.equalsIgnoreCase(SourceEditorPane.FIND_ACTION_COMMAND)) {
                SourceEditorPane.this.find();
            } else if (command.equalsIgnoreCase(SourceEditorPane.FIND_NEXT_ACTION_COMMAND)) {
                SourceEditorPane.this.findNext();
            } else if (command.equalsIgnoreCase(SourceEditorPane.REPLACE_ACTION_COMMAND)) {
                SourceEditorPane.this.replace();
            } else if (command.equalsIgnoreCase(SourceEditorPane.GOTO_ACTION_COMMAND)) {
                SourceEditorPane.this.gotoLine();
            }
        }
    }
}

