/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.pattern;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.defs.AbstractElementProperty;
import kiyut.sketsa.windows.defs.gradient.SVGGradientUtilities;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGPatternElement;

public class PatternProperties
extends AbstractElementProperty {
    private boolean editing;
    private boolean refreshing;
    private JComboBox contentUnitsCombo;
    private JTextField heightField;
    private JTextField idField;
    private JComboBox patternUnitsCombo;
    private JTextField widthField;
    private JTextField xField;
    private JTextField yField;

    public PatternProperties() {
        this.initComponents();
        this.initEventHandler();
        this.editing = false;
        this.refreshing = false;
    }

    private void initComponents() {
        JLabel jLabel7 = new JLabel();
        this.idField = new JTextField();
        JLabel jLabel1 = new JLabel();
        this.xField = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.yField = new JTextField();
        JButton applyButton = new JButton();
        JSeparator jSeparator1 = new JSeparator();
        JLabel jLabel5 = new JLabel();
        this.patternUnitsCombo = new JComboBox();
        JLabel jLabel6 = new JLabel();
        this.contentUnitsCombo = new JComboBox();
        JLabel jLabel4 = new JLabel();
        this.widthField = new JTextField();
        JLabel jLabel8 = new JLabel();
        this.heightField = new JTextField();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        jLabel7.setText("id");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.idField, gridBagConstraints);
        jLabel1.setText("x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.xField, gridBagConstraints);
        jLabel2.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.yField, gridBagConstraints);
        applyButton.setMnemonic('A');
        applyButton.setText("Apply");
        applyButton.setFocusPainted(false);
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternProperties.this.applyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)applyButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)jSeparator1, gridBagConstraints);
        jLabel5.setText("pattern units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel5, gridBagConstraints);
        this.patternUnitsCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"objectBoundingBox", "userSpaceOnUse"}));
        this.patternUnitsCombo.setSelectedIndex(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.patternUnitsCombo, gridBagConstraints);
        jLabel6.setText("content units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel6, gridBagConstraints);
        this.contentUnitsCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"objectBoundingBox", "userSpaceOnUse"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.contentUnitsCombo, gridBagConstraints);
        jLabel4.setText("width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.widthField, gridBagConstraints);
        jLabel8.setText("height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.heightField, gridBagConstraints);
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.updateVectorCanvas();
    }

    private void initEventHandler() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternProperties.this.updateDOM();
            }
        };
        this.idField.addActionListener(fieldActionHandler);
        this.xField.addActionListener(fieldActionHandler);
        this.yField.addActionListener(fieldActionHandler);
        this.widthField.addActionListener(fieldActionHandler);
        this.heightField.addActionListener(fieldActionHandler);
        ItemListener itemListenerHandler = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                PatternProperties.this.updateDOM();
            }
        };
        this.patternUnitsCombo.addItemListener(itemListenerHandler);
        this.contentUnitsCombo.addItemListener(itemListenerHandler);
    }

    @Override
    public void setSVGElement(SVGElement element) {
        super.setSVGElement(element);
        this.refreshProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        try {
            SVGPatternElement elt = (SVGPatternElement)this.element;
            this.idField.setText(elt.getId());
            SVGLength length = elt.getX().getBaseVal();
            this.xField.setText(length.getValueAsString());
            length = elt.getY().getBaseVal();
            this.yField.setText(length.getValueAsString());
            length = elt.getWidth().getBaseVal();
            this.widthField.setText(length.getValueAsString());
            length = elt.getHeight().getBaseVal();
            this.heightField.setText(length.getValueAsString());
            short s = elt.getPatternUnits().getBaseVal();
            if (s == 1) {
                this.patternUnitsCombo.setSelectedIndex(0);
            } else if (s == 2) {
                this.patternUnitsCombo.setSelectedIndex(1);
            }
            s = elt.getPatternContentUnits().getBaseVal();
            if (s == 1) {
                this.contentUnitsCombo.setSelectedIndex(0);
            } else if (s == 2) {
                this.contentUnitsCombo.setSelectedIndex(1);
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDOM() {
        if (this.refreshing) {
            return;
        }
        SVGPatternElement elt = (SVGPatternElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Pattern properties");
        try {
            String attrName = "x";
            String str = this.xField.getText().trim();
            String defaultStr = "0";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "refY";
            str = this.yField.getText().trim();
            defaultStr = "0";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "width";
            str = this.widthField.getText().trim();
            Number number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative width value is an error.");
            }
            defaultStr = "0";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "height";
            str = this.heightField.getText().trim();
            number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative height value is an error.");
            }
            defaultStr = "0";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "patternUnits";
            str = this.patternUnitsCombo.getSelectedItem().toString().trim();
            if (!str.equalsIgnoreCase("objectBoundingBox")) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "patternContentUnits";
            str = this.contentUnitsCombo.getSelectedItem().toString().trim();
            if (!str.equalsIgnoreCase("userSpaceOnUse")) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            String newId = this.idField.getText();
            this.updateReferenceElement(newId);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }

    public void updateVectorCanvas() {
        String newId = this.idField.getText();
        this.updateReferenceElement(newId);
        if (this.canvas != null) {
            this.canvas.refreshSelection();
            this.canvas.refresh();
        }
    }

    protected void updateReferenceElement(String newId) {
        SVGGradientUtilities.updateReferenceElement(this.element, newId);
    }
}

