/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.gradient;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import kiyut.sketsa.util.ColorConvertion;
import kiyut.sketsa.util.DOMUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGColor;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGGradientElement;
import org.w3c.dom.svg.SVGStopElement;
import org.w3c.dom.svg.SVGStylable;

public class GradientStopTableModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"offset", "color", "opacity"};
    private List<SVGStopElement> data = new ArrayList<SVGStopElement>();
    private SVGGradientElement element;
    private Map<SVGStopElement, CSSStyleDeclaration> computedStyleMap = new HashMap<SVGStopElement, CSSStyleDeclaration>();

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SVGStopElement elt = this.data.get(rowIndex);
        CSSStyleDeclaration computedStyle = this.computedStyleMap.get(elt);
        Object obj = null;
        if (columnIndex == 0) {
            obj = elt.getAttributeNS(null, "offset");
        } else if (columnIndex == 1) {
            Color color = Color.BLACK;
            SVGColor svgColor = (SVGColor)computedStyle.getPropertyCSSValue("stop-color");
            if (svgColor.getColorType() == 1) {
                color = ColorConvertion.getColor(svgColor);
            } else if (svgColor.getColorType() == 3) {
                color = ColorConvertion.getColor(svgColor.getCssText());
            }
            obj = color;
        } else if (columnIndex == 2) {
            obj = computedStyle.getPropertyValue("stop-opacity");
        }
        return obj;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        SVGStopElement elt = this.data.get(row);
        if (col == 0) {
            String str = (String)value;
            this.validateOffset(str);
            elt.setAttributeNS(null, "offset", str);
        } else if (col == 1) {
            Color color = (Color)value;
            DOMUtilities.updateProperty((SVGStylable)elt, null, "stop-color", ColorConvertion.toHexString(color));
        } else if (col == 2) {
            String str = (String)value;
            this.validateOpacity(str);
            DOMUtilities.updateProperty((SVGStylable)elt, null, "stop-opacity", str);
        } else {
            throw new RuntimeException("Invalid column");
        }
        this.fireTableCellUpdated(row, col);
    }

    public void newRow() {
        int index = this.data.size();
        String ns = "http://www.w3.org/2000/svg";
        SVGDocument svgDocument = (SVGDocument)this.element.getOwnerDocument();
        SVGStopElement stopElement = (SVGStopElement)svgDocument.createElementNS(ns, "stop");
        stopElement.setAttributeNS(null, "offset", "100%");
        DOMUtilities.updateProperty((SVGStylable)stopElement, null, "stop-color", ColorConvertion.toHexString(Color.BLACK));
        DOMUtilities.updateProperty((SVGStylable)stopElement, null, "stop-opacity", "1");
        this.element.appendChild((Node)stopElement);
        this.data.add(stopElement);
        ViewCSS viewCSS = (ViewCSS)((Object)stopElement.getOwnerDocument().getDocumentElement());
        this.computedStyleMap.put(stopElement, viewCSS.getComputedStyle((Element)stopElement, null));
        this.fireTableRowsInserted(index, index);
    }

    public void removeRow(int index) {
        Node node = (Node)this.data.get(index);
        this.element.removeChild(node);
        this.data.remove(index);
        this.computedStyleMap.remove(node);
        this.fireTableRowsDeleted(index, index);
    }

    protected void validateOffset(String text) {
        String errorMsg = "For <percentage> value must be between 0-100%.\nFor <number> value must be between 0-1";
        if (text.endsWith("%")) {
            String str = text.substring(0, text.length() - 1);
            float f = Float.parseFloat(str);
            if (f < 0.0f || f > 100.0f) {
                throw new RuntimeException(errorMsg);
            }
        } else {
            if (!Character.isDigit(text.charAt(text.length() - 1))) {
                throw new RuntimeException(errorMsg);
            }
            float f = Float.parseFloat(text);
            if (f < 0.0f || f > 1.0f) {
                throw new RuntimeException(errorMsg);
            }
        }
    }

    protected void validateOpacity(String text) {
        String errorMsg = "Value must be between 0-1";
        if (!Character.isDigit(text.charAt(text.length() - 1))) {
            throw new RuntimeException(errorMsg);
        }
        float f = Float.parseFloat(text);
        if (f < 0.0f || f > 1.0f) {
            throw new RuntimeException(errorMsg);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setGradientElement(SVGGradientElement element) {
        this.element = element;
        this.refresh();
    }

    public SVGGradientElement getGradientElement() {
        return this.element;
    }

    public void refresh() {
        this.data.clear();
        this.computedStyleMap.clear();
        ViewCSS viewCSS = (ViewCSS)((Object)this.element.getOwnerDocument().getDocumentElement());
        NodeList nodeList = this.element.getElementsByTagName("stop");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            SVGStopElement elt = (SVGStopElement)nodeList.item(i);
            this.data.add(elt);
            this.computedStyleMap.put(elt, viewCSS.getComputedStyle((Element)elt, null));
        }
        this.fireTableDataChanged();
    }
}

