/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DOMUtilities;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.util.SVGNodeFilter;
import kiyut.sketsa.windows.defs.AbstractElementProperty;
import kiyut.sketsa.windows.defs.filter.FilterEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGFilterElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGStylable;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class FilterProperties
extends AbstractElementProperty {
    private FilterEditor editor;
    private boolean editing;
    private boolean refreshing;
    private JPanel buttonPane;
    private JPanel editorPane;
    private JComboBox filterUnitsCombo;
    private JTextField hField;
    private JTextField idField;
    private JComboBox primitiveUnitsCombo;
    private JTextField wField;
    private JTextField xField;
    private JTextField yField;

    public FilterProperties() {
        this.initComponents();
        this.editor = new FilterEditor();
        this.editorPane.setLayout(new BorderLayout());
        this.editorPane.add((Component)this.editor, "Center");
        this.setPreferredSize(new Dimension(450, 580));
        this.initEventHandler();
        this.editing = false;
        this.refreshing = false;
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        this.idField = new JTextField();
        this.xField = new JTextField();
        this.yField = new JTextField();
        this.wField = new JTextField();
        this.hField = new JTextField();
        this.filterUnitsCombo = new JComboBox();
        this.primitiveUnitsCombo = new JComboBox();
        this.editorPane = new JPanel();
        this.buttonPane = new JPanel();
        JButton applyButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        jLabel1.setText("id");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText("x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel4, gridBagConstraints);
        jLabel5.setText("height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel5, gridBagConstraints);
        jLabel6.setText("filter units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel6, gridBagConstraints);
        jLabel7.setText("primitive units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.idField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.xField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.yField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.wField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.hField, gridBagConstraints);
        this.filterUnitsCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"userSpaceOnUse", "objectBoundingBox"}));
        this.filterUnitsCombo.setSelectedIndex(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.filterUnitsCombo, gridBagConstraints);
        this.primitiveUnitsCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"userSpaceOnUse", "objectBoundingBox"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.primitiveUnitsCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.editorPane, gridBagConstraints);
        this.buttonPane.setLayout(new GridLayout(1, 0));
        applyButton.setMnemonic('A');
        applyButton.setText("Apply");
        applyButton.setFocusPainted(false);
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterProperties.this.applyButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(applyButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.buttonPane, gridBagConstraints);
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.updateVectorCanvas();
    }

    private void initEventHandler() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterProperties.this.updateDOM();
            }
        };
        this.idField.addActionListener(fieldActionHandler);
        this.xField.addActionListener(fieldActionHandler);
        this.yField.addActionListener(fieldActionHandler);
        this.wField.addActionListener(fieldActionHandler);
        this.hField.addActionListener(fieldActionHandler);
        ItemListener itemListenerHandler = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                FilterProperties.this.updateDOM();
            }
        };
        this.filterUnitsCombo.addItemListener(itemListenerHandler);
        this.primitiveUnitsCombo.addItemListener(itemListenerHandler);
    }

    @Override
    public void setSVGElement(SVGElement element) {
        super.setSVGElement(element);
        this.refreshProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        try {
            SVGFilterElement elt = (SVGFilterElement)this.element;
            this.idField.setText(elt.getId());
            SVGLength length = elt.getX().getBaseVal();
            this.xField.setText(length.getValueAsString());
            length = elt.getY().getBaseVal();
            this.yField.setText(length.getValueAsString());
            length = elt.getWidth().getBaseVal();
            this.wField.setText(length.getValueAsString());
            length = elt.getHeight().getBaseVal();
            this.hField.setText(length.getValueAsString());
            short s = elt.getFilterUnits().getBaseVal();
            if (s == 1) {
                this.filterUnitsCombo.setSelectedIndex(0);
            } else if (s == 2) {
                this.filterUnitsCombo.setSelectedIndex(1);
            }
            s = elt.getPrimitiveUnits().getBaseVal();
            if (s == 1) {
                this.primitiveUnitsCombo.setSelectedIndex(0);
            } else if (s == 2) {
                this.primitiveUnitsCombo.setSelectedIndex(1);
            }
            this.editor.setSVGFilterElement(this.canvas, (SVGFilterElement)this.element);
        }
        finally {
            this.refreshing = false;
        }
    }

    public void updateVectorCanvas() {
        String newId = this.idField.getText();
        this.updateReferenceElement(newId);
        if (this.canvas != null) {
            this.canvas.refreshSelection();
            this.canvas.refresh();
        }
    }

    protected void updateReferenceElement(String newId) {
        String baseUri = this.element.getBaseURI();
        String fragment = this.element.getId();
        String newBaseUri = baseUri;
        String newFragment = newId;
        this.element.setId(newId);
        Document doc = this.element.getOwnerDocument();
        SVGFilterableNode filter = new SVGFilterableNode();
        DocumentTraversal travelsal = (DocumentTraversal)((Object)doc);
        TreeWalker treeWalker = travelsal.createTreeWalker(doc, 1, filter, false);
        if (baseUri == null) {
            baseUri = "";
        }
        if (newBaseUri == null) {
            newBaseUri = "";
        }
        this.recursiveUpdate(treeWalker, baseUri, fragment, newBaseUri, newFragment);
    }

    private void recursiveUpdate(TreeWalker treeWalker, String baseUri, String fragment, String newBaseUri, String newFragment) {
        Node n = treeWalker.getCurrentNode();
        Node child = treeWalker.firstChild();
        while (child != null) {
            Element elt = (Element)child;
            this.updateElement(elt, "filter", baseUri, fragment, newBaseUri, newFragment);
            this.recursiveUpdate(treeWalker, baseUri, fragment, newBaseUri, newFragment);
            child = treeWalker.nextSibling();
        }
        treeWalker.setCurrentNode(n);
    }

    private void updateElement(Element element, String attr, String baseUri, String fragment, String newBaseUri, String newFragment) {
        String curUri;
        String oldUri;
        ViewCSS viewCSS = (ViewCSS)((Object)element.getOwnerDocument().getDocumentElement());
        CSSStyleDeclaration computedStyle = viewCSS.getComputedStyle(element, null);
        String value = computedStyle.getPropertyValue(attr);
        if (!value.equalsIgnoreCase("none") && !value.equalsIgnoreCase("inherit") && (oldUri = value).equalsIgnoreCase(curUri = "url(" + baseUri + "#" + fragment + ")")) {
            String newUri = "#" + newFragment;
            if (!baseUri.equals(newBaseUri)) {
                newUri = newBaseUri + newUri;
            }
            SVGStylable stylable = (SVGStylable)element;
            DOMUtilities.updateProperty(stylable, null, attr, "none");
            DOMUtilities.updateProperty(stylable, null, attr, "url(" + newUri + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDOM() {
        if (this.refreshing) {
            return;
        }
        SVGFilterElement elt = (SVGFilterElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Filter properties");
        try {
            String attrName = "x";
            String str = this.xField.getText().trim();
            String defaultStr = "-10%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "y";
            str = this.yField.getText().trim();
            defaultStr = "-10%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "width";
            str = this.wField.getText().trim();
            Number number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative width value is an error.");
            }
            defaultStr = "120%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "height";
            str = this.hField.getText().trim();
            number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException("A negative height value is an error.");
            }
            defaultStr = "120%";
            if (!DataTypeUtilities.identicalLength(str, defaultStr)) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "filterUnits";
            str = this.filterUnitsCombo.getSelectedItem().toString().trim();
            if (!str.equalsIgnoreCase("objectBoundingBox")) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            attrName = "primitiveUnits";
            str = this.primitiveUnitsCombo.getSelectedItem().toString().trim();
            if (!str.equalsIgnoreCase("userSpaceOnUse")) {
                elt.setAttributeNS(null, attrName, str);
            } else {
                elt.removeAttributeNS(null, attrName);
            }
            String newId = this.idField.getText();
            this.updateReferenceElement(newId);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
    }

    private static class SVGFilterableNode
    extends SVGNodeFilter {
        @Override
        public short acceptNode(Node n) {
            short result = 3;
            if (this.isContainerElement(n)) {
                result = 1;
            } else if (this.isGraphicsElement(n)) {
                result = 1;
            }
            return result;
        }
    }
}

