/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.windows.defs.filter.FilterProperties;
import kiyut.sketsa.windows.defs.gradient.LinearGradientProperties;
import kiyut.sketsa.windows.defs.gradient.RadialGradientProperties;
import kiyut.sketsa.windows.defs.marker.MarkerProperties;
import kiyut.sketsa.windows.defs.pattern.PatternProperties;
import kiyut.swing.dialog.DialogESC;
import kiyut.swing.util.WindowUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDefsElement;
import org.w3c.dom.svg.SVGDescElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGFilterElement;
import org.w3c.dom.svg.SVGLinearGradientElement;
import org.w3c.dom.svg.SVGMarkerElement;
import org.w3c.dom.svg.SVGPatternElement;
import org.w3c.dom.svg.SVGRadialGradientElement;

public class DefsPane
extends JPanel {
    private static final String ADD_ACTION = "add";
    private static final String EDIT_ACTION = "edit";
    private static final String REFRESH_ACTION = "refresh";
    private static final String REMOVE_ACTION = "remove";
    private static final String ADD_LINEAR_GRADIENT_ACTION = "addLinearGradient";
    private static final String ADD_RADIAL_GRADIENT_ACTION = "addRadialGradient";
    private static final String ADD_FILTER_ACTION = "addFilter";
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.windows.defs.DefsPane");
    private VectorCanvas canvas;
    private SVGDocument svgDocument;
    protected EventListener domListener;
    private JButton addButton;
    private JButton editButton;
    private JPopupMenu popupMenu;
    private JButton refreshButton;
    private JButton removeButton;
    private JTable resourceTable;
    private JScrollPane scrollPane;

    public DefsPane() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem1 = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        JMenuItem jMenuItem3 = new JMenuItem();
        this.scrollPane = new JScrollPane();
        this.resourceTable = new JTable();
        JToolBar buttonBar = new JToolBar();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.refreshButton = new JButton();
        this.removeButton = new JButton();
        jMenuItem1.setText(bundle.getString("CTL_AddLinearGradient.Text"));
        jMenuItem1.setActionCommand(ADD_LINEAR_GRADIENT_ACTION);
        jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefsPane.this.buttonActionPerformed(evt);
            }
        });
        this.popupMenu.add(jMenuItem1);
        jMenuItem2.setText(bundle.getString("CTL_AddRadialGradient.Text"));
        jMenuItem2.setActionCommand(ADD_RADIAL_GRADIENT_ACTION);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefsPane.this.buttonActionPerformed(evt);
            }
        });
        this.popupMenu.add(jMenuItem2);
        jMenuItem3.setText(bundle.getString("CTL_AddFilter.Text"));
        jMenuItem3.setActionCommand(ADD_FILTER_ACTION);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefsPane.this.buttonActionPerformed(evt);
            }
        });
        this.popupMenu.add(jMenuItem3);
        this.setLayout(new BorderLayout());
        this.resourceTable.setModel(new ResourceTableModel());
        this.resourceTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DefsPane.this.resourceTableMouseClicked(evt);
            }
        });
        this.scrollPane.setViewportView(this.resourceTable);
        this.add((Component)this.scrollPane, "Center");
        buttonBar.setRollover(true);
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/actions/new.png")));
        this.addButton.setToolTipText(bundle.getString("CTL_Add.Tooltip"));
        this.addButton.setActionCommand(ADD_ACTION);
        this.addButton.setFocusPainted(false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefsPane.this.buttonActionPerformed(evt);
            }
        });
        buttonBar.add(this.addButton);
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/domeditor/edit.png")));
        this.editButton.setToolTipText(bundle.getString("CTL_Edit.Tooltip"));
        this.editButton.setActionCommand(EDIT_ACTION);
        this.editButton.setFocusPainted(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefsPane.this.buttonActionPerformed(evt);
            }
        });
        buttonBar.add(this.editButton);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/domeditor/refresh.png")));
        this.refreshButton.setToolTipText(bundle.getString("CTL_Refresh.Tooltip"));
        this.refreshButton.setFocusPainted(false);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefsPane.this.buttonActionPerformed(evt);
            }
        });
        buttonBar.add(this.refreshButton);
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/kiyut/sketsa/windows/domeditor/delete.png")));
        this.removeButton.setToolTipText(bundle.getString("CTL_Remove.Tooltip"));
        this.removeButton.setActionCommand(REMOVE_ACTION);
        this.removeButton.setFocusPainted(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DefsPane.this.buttonActionPerformed(evt);
            }
        });
        buttonBar.add(this.removeButton);
        this.add((Component)buttonBar, "North");
    }

    private void resourceTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() != 2) {
            return;
        }
        int index = this.resourceTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        ResourceTableModel model = (ResourceTableModel)this.resourceTable.getModel();
        Element element = model.getValueAt(index);
        this.editResource(element);
    }

    private void buttonActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase(ADD_ACTION)) {
            JComponent comp = (JComponent)evt.getSource();
            this.popupMenu.show(comp, comp.getX() + comp.getWidth(), comp.getY());
        } else if (evt.getActionCommand().equalsIgnoreCase(EDIT_ACTION)) {
            int index = this.resourceTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            ResourceTableModel model = (ResourceTableModel)this.resourceTable.getModel();
            Element element = model.getValueAt(index);
            this.editResource(element);
        } else if (evt.getActionCommand().equalsIgnoreCase(REFRESH_ACTION)) {
            this.refresh();
        } else if (evt.getActionCommand().equalsIgnoreCase(REMOVE_ACTION)) {
            if (this.svgDocument == null) {
                return;
            }
            this.removeResource();
        } else if (evt.getActionCommand().equalsIgnoreCase(ADD_LINEAR_GRADIENT_ACTION)) {
            if (this.svgDocument == null) {
                return;
            }
            this.addLinearGradient();
        } else if (evt.getActionCommand().equalsIgnoreCase(ADD_RADIAL_GRADIENT_ACTION)) {
            if (this.svgDocument == null) {
                return;
            }
            this.addRadialGradient();
        } else if (evt.getActionCommand().equalsIgnoreCase(ADD_FILTER_ACTION)) {
            if (this.svgDocument == null) {
                return;
            }
            this.addFilter();
        }
    }

    private void initCustomComponents() {
        this.domListener = new EventListener(){

            @Override
            public void handleEvent(Event e) {
                DefsPane.this.domNodeHandleEvent(e);
            }
        };
        this.resourceTable.getSelectionModel().setSelectionMode(0);
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        EventTarget et;
        this.canvas = canvas;
        SVGDocument document = null;
        if (canvas != null) {
            document = canvas.getSVGDocument();
        }
        if (document != null && document.equals(this.svgDocument)) {
            this.refresh();
            return;
        }
        SVGDocument old = this.svgDocument;
        if (old != null) {
            et = (EventTarget)((Object)old.getDocumentElement());
            et.removeEventListener("DOMAttrModified", this.domListener, false);
            et.removeEventListener("DOMNodeInsertedIntoDocument", this.domListener, false);
            et.removeEventListener("DOMNodeRemovedFromDocument", this.domListener, false);
        }
        this.svgDocument = document;
        if (this.svgDocument != null) {
            et = (EventTarget)((Object)this.svgDocument.getDocumentElement());
            et.addEventListener("DOMAttrModified", this.domListener, false);
            et.addEventListener("DOMNodeInsertedIntoDocument", this.domListener, false);
            et.addEventListener("DOMNodeRemovedFromDocument", this.domListener, false);
        }
        this.refresh();
    }

    public void refresh() {
        if (this.svgDocument == null) {
            return;
        }
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = this.svgDocument.getElementsByTagNameNS("http://www.w3.org/2000/svg", "filter");
        list.addAll(this.nodeListToList(nodeList));
        nodeList = this.svgDocument.getElementsByTagNameNS("http://www.w3.org/2000/svg", "linearGradient");
        list.addAll(this.nodeListToList(nodeList));
        nodeList = this.svgDocument.getElementsByTagNameNS("http://www.w3.org/2000/svg", "radialGradient");
        list.addAll(this.nodeListToList(nodeList));
        nodeList = this.svgDocument.getElementsByTagNameNS("http://www.w3.org/2000/svg", "pattern");
        list.addAll(this.nodeListToList(nodeList));
        nodeList = this.svgDocument.getElementsByTagNameNS("http://www.w3.org/2000/svg", "marker");
        list.addAll(this.nodeListToList(nodeList));
        ((ResourceTableModel)this.resourceTable.getModel()).setData(list);
    }

    private List<Node> nodeListToList(NodeList nodeList) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            list.add(node);
        }
        return list;
    }

    private void removeResource() {
        int index = this.resourceTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(this, bundle.getString("MSG_ConfirmRemoveResource.Text"), bundle.getString("MSG_ConfirmRemoveResource.Title"), 0);
        if (result == 0) {
            ResourceTableModel model = (ResourceTableModel)this.resourceTable.getModel();
            Element element = model.getValueAt(index);
            Node parentNode = element.getParentNode();
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Remove resource");
            parentNode.removeChild(element);
            undoManager.end();
            this.refresh();
        }
    }

    private void addLinearGradient() {
        Element defsElt = this.getFirstDefsElement();
        Document doc = defsElt.getOwnerDocument();
        SVGElement elt = (SVGElement)doc.createElementNS("http://www.w3.org/2000/svg", "linearGradient");
        elt.setId("grad" + System.currentTimeMillis());
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Create Linear Gradient");
        defsElt.appendChild((Node)elt);
        undoManager.end();
        this.editResource((Element)elt);
    }

    private void addRadialGradient() {
        Element defsElt = this.getFirstDefsElement();
        Document doc = defsElt.getOwnerDocument();
        SVGElement elt = (SVGElement)doc.createElementNS("http://www.w3.org/2000/svg", "radialGradient");
        elt.setId("grad" + System.currentTimeMillis());
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Create Radial Gradient");
        defsElt.appendChild((Node)elt);
        undoManager.end();
        this.editResource((Element)elt);
    }

    private void addFilter() {
        Element defsElt = this.getFirstDefsElement();
        Document doc = defsElt.getOwnerDocument();
        SVGElement elt = (SVGElement)doc.createElementNS("http://www.w3.org/2000/svg", "filter");
        elt.setId("fe" + System.currentTimeMillis());
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Create Filter Effects");
        defsElt.appendChild((Node)elt);
        undoManager.end();
        this.editResource((Element)elt);
    }

    private void editResource(Element element) {
        DialogESC dialog = DialogESC.createDialog(this, "Resource", true);
        dialog.setDefaultCloseOperation(2);
        if (element instanceof SVGLinearGradientElement) {
            LinearGradientProperties pane = new LinearGradientProperties();
            pane.setVectorCanvas(this.canvas);
            pane.setSVGElement((SVGElement)element);
            dialog.setTitle(bundle.getString("CTL_LinearGradient.Title"));
            dialog.setContentPane(pane);
            dialog.pack();
            WindowUtilities.centerWindow(dialog);
            dialog.setVisible(true);
            if (this.canvas.getUndoManager().canUndo()) {
                pane.updateVectorCanvas();
            }
        } else if (element instanceof SVGRadialGradientElement) {
            RadialGradientProperties pane = new RadialGradientProperties();
            pane.setVectorCanvas(this.canvas);
            pane.setSVGElement((SVGElement)element);
            dialog.setTitle(bundle.getString("CTL_RadialGradient.Title"));
            dialog.setContentPane(pane);
            dialog.pack();
            WindowUtilities.centerWindow(dialog);
            dialog.setVisible(true);
            if (this.canvas.getUndoManager().canUndo()) {
                pane.updateVectorCanvas();
            }
        } else if (element instanceof SVGFilterElement) {
            FilterProperties pane = new FilterProperties();
            pane.setVectorCanvas(this.canvas);
            pane.setSVGElement((SVGElement)element);
            dialog.setTitle(bundle.getString("CTL_FilterEffects.Title"));
            dialog.setContentPane(pane);
            dialog.pack();
            WindowUtilities.centerWindow(dialog);
            dialog.setVisible(true);
            if (this.canvas.getUndoManager().canUndo()) {
                pane.updateVectorCanvas();
            }
        } else if (element instanceof SVGFilterElement) {
            PatternProperties pane = new PatternProperties();
            pane.setVectorCanvas(this.canvas);
            pane.setSVGElement((SVGElement)element);
            dialog.setTitle(bundle.getString("CTL_Pattern.Title"));
            dialog.setContentPane(pane);
            dialog.pack();
            WindowUtilities.centerWindow(dialog);
            dialog.setVisible(true);
            if (this.canvas.getUndoManager().canUndo()) {
                pane.updateVectorCanvas();
            }
        } else if (element instanceof SVGMarkerElement) {
            MarkerProperties pane = new MarkerProperties();
            pane.setVectorCanvas(this.canvas);
            pane.setSVGElement((SVGElement)element);
            dialog.setTitle(bundle.getString("CTL_Marker.Title"));
            dialog.setContentPane(pane);
            dialog.pack();
            WindowUtilities.centerWindow(dialog);
            dialog.setVisible(true);
            if (this.canvas.getUndoManager().canUndo()) {
                pane.updateVectorCanvas();
            }
        } else if (element instanceof SVGPatternElement) {
            PatternProperties pane = new PatternProperties();
            pane.setVectorCanvas(this.canvas);
            pane.setSVGElement((SVGElement)element);
            dialog.setTitle(bundle.getString("CTL_Pattern.Title"));
            dialog.setContentPane(pane);
            dialog.pack();
            WindowUtilities.centerWindow(dialog);
            dialog.setVisible(true);
            if (this.canvas.getUndoManager().canUndo()) {
                pane.updateVectorCanvas();
            }
        } else {
            JOptionPane.showMessageDialog(this, bundle.getString("MSG_UnknownResource.Text"), bundle.getString("MSG_UnknownResource.Title"), 1);
            return;
        }
    }

    private Element getFirstDefsElement() {
        Element elt = null;
        SVGDocument doc = this.canvas.getSVGDocument();
        Element svgElt = doc.getDocumentElement();
        NodeList children = svgElt.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof SVGDefsElement)) continue;
            elt = (Element)node;
            break;
        }
        if (elt == null) {
            Node sibling = svgElt.getFirstChild();
            if (sibling instanceof SVGDescElement) {
                sibling = sibling.getNextSibling();
            }
            elt = doc.createElementNS("http://www.w3.org/2000/svg", "defs");
            if (sibling == null) {
                svgElt.appendChild(elt);
            } else {
                svgElt.insertBefore(elt, sibling);
            }
        }
        return elt;
    }

    private void domNodeHandleEvent(Event evt) {
        Node node = (Node)((Object)evt.getTarget());
        if (node instanceof SVGLinearGradientElement || node instanceof SVGRadialGradientElement || node instanceof SVGFilterElement || node instanceof SVGPatternElement) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefsPane.this.refresh();
                }
            });
        }
    }

    private class ResourceTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"type", "id"};
        private List data = new ArrayList();

        public void setData(List list) {
            this.data = list;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Element element = (Element)this.data.get(rowIndex);
            if (columnIndex == 0) {
                return element.getNodeName();
            }
            if (columnIndex == 1) {
                return element.getAttribute("id");
            }
            return null;
        }

        public Element getValueAt(int rowIndex) {
            return (Element)this.data.get(rowIndex);
        }
    }
}

