/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public class IOUtilities {
    private IOUtilities() {
        throw new Error("IOUtilities is a utility class for static methods");
    }

    public static JFileChooser getFileChooser() {
        String def = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
        String str = System.getProperty("user.dir", def);
        File dir = new File(str);
        JFileChooser fc = new JFileChooser(dir);
        return fc;
    }

    public static void setUserDir(File file) {
        if (file == null) {
            String def = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
            System.setProperty("user.dir", def);
            return;
        }
        try {
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            if (file != null) {
                System.setProperty("user.dir", file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String relativize(File base, File file) {
        File tmp;
        StringBuilder sb = new StringBuilder();
        ArrayList<File> bases = new ArrayList<File>();
        ArrayList<File> files = new ArrayList<File>();
        for (tmp = base.getParentFile(); tmp != null; tmp = tmp.getParentFile()) {
            bases.add(tmp);
        }
        for (tmp = file.getParentFile(); tmp != null; tmp = tmp.getParentFile()) {
            files.add(tmp);
        }
        Collections.reverse(bases);
        Collections.reverse(files);
        boolean sameRoot = true;
        if (!((File)bases.get(0)).equals(files.get(0))) {
            sb.append(file.toURI());
            sameRoot = false;
        }
        if (sameRoot) {
            int j;
            int i = 0;
            for (i = 0; i < bases.size(); ++i) {
                tmp = (File)bases.get(i);
                if (i >= files.size() || !tmp.equals(files.get(i))) break;
            }
            for (j = i; j < bases.size(); ++j) {
                sb.append("../");
            }
            for (j = i; j < files.size(); ++j) {
                sb.append(((File)files.get(j)).getName() + "/");
            }
            sb.append(file.getName());
        }
        return sb.toString();
    }
}

