/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUndoableEdit
extends AbstractUndoableEdit {
    private String type;
    private Node node;
    private Node parentNode;
    private Node nextSibling;
    private int index;
    private Node relatedNode;
    private String prevValue;
    private String newValue;
    private String attrName;
    private short attrChange;

    public DOMUndoableEdit(String type, Node node, Node relatedNode, String prevValue, String newValue, String attrName, short attrChange) {
        this.node = node;
        this.type = type;
        this.parentNode = node.getParentNode();
        this.nextSibling = node.getNextSibling();
        this.relatedNode = relatedNode;
        this.prevValue = prevValue;
        this.newValue = newValue;
        this.attrName = attrName;
        this.attrChange = attrChange;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.type.equals("DOMAttrModified")) {
            if (this.attrChange == 1) {
                Attr attr = (Attr)this.relatedNode;
                attr.setValue(this.prevValue);
            } else if (this.attrChange == 2) {
                ((Element)this.node).removeAttributeNode((Attr)this.relatedNode);
            } else if (this.attrChange == 3) {
                NamedNodeMap nodeMap = ((Element)this.node).getAttributes();
                nodeMap.setNamedItemNS(this.relatedNode);
            }
        } else if (this.type.equals("DOMNodeInserted")) {
            if (this.parentNode != null) {
                this.parentNode.removeChild(this.node);
            }
        } else if (this.type.equals("DOMNodeRemoved")) {
            if (this.parentNode != null) {
                if (this.nextSibling == null) {
                    this.parentNode.appendChild(this.node);
                } else {
                    this.parentNode.insertBefore(this.node, this.nextSibling);
                }
            }
        } else if (this.type.equals("DOMCharacterDataModified") && this.node instanceof CharacterData) {
            CharacterData characterData = (CharacterData)this.node;
            characterData.replaceData(0, characterData.getLength(), this.prevValue);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.type.equals("DOMAttrModified")) {
            if (this.attrChange == 1) {
                Attr attr = (Attr)this.relatedNode;
                attr.setValue(this.newValue);
            } else if (this.attrChange == 2) {
                NamedNodeMap nodeMap = ((Element)this.node).getAttributes();
                nodeMap.setNamedItemNS(this.relatedNode);
            } else if (this.attrChange == 3) {
                ((Element)this.node).removeAttributeNode((Attr)this.relatedNode);
            }
        } else if (this.type.equals("DOMNodeInserted")) {
            if (this.parentNode != null) {
                this.parentNode.appendChild(this.node);
            }
        } else if (this.type.equals("DOMNodeRemoved")) {
            if (this.parentNode != null) {
                this.parentNode.removeChild(this.node);
            }
        } else if (this.type.equals("DOMCharacterDataModified") && this.node instanceof CharacterData) {
            CharacterData characterData = (CharacterData)this.node;
            characterData.replaceData(0, characterData.getLength(), this.newValue);
        }
    }
}

