/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.tool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import kiyut.swing.statusbar.StatusBar;
import kiyut.swing.statusbar.StatusBarItem;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderListener;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.swing.svg.SVGUserAgentGUIAdapter;
import org.w3c.dom.svg.SVGDocument;

public class PreviewPane
extends JPanel {
    private StatusBar statusBar = new StatusBar();
    private JSVGCanvas svgCanvas;

    public PreviewPane() {
        StatusBarItem statusBarItem = new StatusBarItem(" ", 100, 0);
        this.statusBar.addItem(statusBarItem);
        statusBarItem = new StatusBarItem(" ", 150, 2);
        this.statusBar.addItem(statusBarItem);
        SVGUserAgentGUIAdapter ua = new SVGUserAgentGUIAdapter(this){

            public void displayMessage(String message) {
                PreviewPane.this.statusBar.getItem(1).setText(message);
            }
        };
        this.svgCanvas = new JSVGCanvas((SVGUserAgent)ua, true, true);
        this.svgCanvas.setDoubleBufferedRendering(true);
        this.svgCanvas.setDocumentState(1);
        this.svgCanvas.setAnimationLimitingNone();
        this.svgCanvas.addSVGDocumentLoaderListener((SVGDocumentLoaderListener)new SVGDocumentLoaderAdapter(){

            public void documentLoadingStarted(SVGDocumentLoaderEvent evt) {
                PreviewPane.this.statusBar.getItem(1).setText("Document Loading...");
            }

            public void documentLoadingCompleted(SVGDocumentLoaderEvent evt) {
                PreviewPane.this.statusBar.getItem(1).setText("Document Loaded.");
            }
        });
        this.svgCanvas.addGVTTreeBuilderListener((GVTTreeBuilderListener)new GVTTreeBuilderAdapter(){

            public void gvtBuildStarted(GVTTreeBuilderEvent evt) {
                PreviewPane.this.statusBar.getItem(1).setText("Build Started...");
            }

            public void gvtBuildCompleted(GVTTreeBuilderEvent evt) {
                PreviewPane.this.statusBar.getItem(1).setText("Build Done.");
            }
        });
        this.svgCanvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingPrepare(GVTTreeRendererEvent evt) {
                PreviewPane.this.statusBar.getItem(1).setText("Rendering Started...");
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent evt) {
                PreviewPane.this.statusBar.getItem(1).setText(" ");
            }
        });
        this.svgCanvas.addMouseMotionListener((MouseMotionListener)new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PreviewPane.this.canvasMouseMoved(evt);
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                PreviewPane.this.canvasMouseDragged(evt);
            }
        });
        this.svgCanvas.addMouseListener((MouseListener)new MouseInputAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PreviewPane.this.canvasMouseExited(evt);
            }
        });
        Dimension size = new Dimension(780, 540);
        this.setSize(size);
        this.setPreferredSize(size);
        this.setLayout(new BorderLayout());
        this.add((Component)this.svgCanvas, "Center");
        this.add((Component)this.statusBar, "South");
    }

    public void setSVGDocument(SVGDocument doc) {
        this.svgCanvas.setSVGDocument(doc);
    }

    private void canvasMouseMoved(MouseEvent evt) {
        this.statusBar.getItem(0).setText(evt.getX() + "," + evt.getY());
    }

    private void canvasMouseDragged(MouseEvent evt) {
        this.statusBar.getItem(0).setText(evt.getX() + "," + evt.getY());
    }

    private void canvasMouseExited(MouseEvent evt) {
        this.statusBar.getItem(0).setText(" ");
    }
}

