/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.tool;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.undo.DOMUndoManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class DuplicateIdFinderPane
extends JPanel {
    private ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getName());
    private VectorCanvas canvas;
    private JButton closeButton;
    private JButton editButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JButton refreshButton;
    private JTable tableId;

    public DuplicateIdFinderPane() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.editButton = new JButton();
        this.refreshButton = new JButton();
        this.closeButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableId = new JTable();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setPreferredSize(new Dimension(320, 300));
        this.setLayout(new BorderLayout(12, 0));
        this.jPanel1.setLayout(new GridBagLayout());
        this.editButton.setText(this.bundle.getString("CTL_Edit.Text"));
        this.editButton.setFocusPainted(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DuplicateIdFinderPane.this.editButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.editButton, gridBagConstraints);
        this.refreshButton.setText(this.bundle.getString("CTL_Refresh.Text"));
        this.refreshButton.setFocusPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.refreshButton, gridBagConstraints);
        this.closeButton.setText(this.bundle.getString("CTL_Close.Text"));
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DuplicateIdFinderPane.this.closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.closeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.add((Component)this.jPanel1, "East");
        this.tableId.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DuplicateIdFinderPane.this.tableIdMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tableId);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void tableIdMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() != 2) {
            return;
        }
        int index = this.tableId.getSelectedRow();
        if (index < 0) {
            return;
        }
        this.changeSelected();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.changeSelected();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.setVisible(false);
        }
    }

    private void initCustomComponents() {
        SimpleTableModel model = new SimpleTableModel();
        this.tableId.setModel(model);
        this.tableId.getSelectionModel().setSelectionMode(0);
    }

    public String getTitle() {
        return this.bundle.getString("CTL_Title.Text");
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
        SVGDocument doc = canvas.getSVGDocument();
        SimpleTableModel model = (SimpleTableModel)this.tableId.getModel();
        model.setDocument((Document)doc);
        this.refresh();
    }

    private void refresh() {
        SimpleTableModel model = (SimpleTableModel)this.tableId.getModel();
        model.refresh();
    }

    private void changeSelected() {
        int index = this.tableId.getSelectedRow();
        if (index < 0) {
            return;
        }
        if (index > this.tableId.getRowCount() - 1) {
            return;
        }
        TableModel model = this.tableId.getModel();
        String id = (String)model.getValueAt(index, 0);
        String type = (String)model.getValueAt(index, 1);
        String msg = "Please enter the new id for\nid: " + id + "\ntype: " + type;
        String newId = JOptionPane.showInputDialog(this, (Object)msg);
        if (newId == null) {
            return;
        }
        if ((newId = newId.trim()).length() <= 0) {
            return;
        }
        if (newId.equalsIgnoreCase(id)) {
            return;
        }
        Element element = ((SimpleTableModel)model).getElementAt(index);
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change id");
        element.setAttributeNS(null, "id", newId);
        undoManager.end();
        this.refresh();
        if (--index < model.getRowCount() && model.getRowCount() > 0) {
            this.tableId.setRowSelectionInterval(index, index);
        }
    }

    private class SimpleTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"id", "type"};
        private List<Element> data = new ArrayList<Element>();
        Document document;

        public void setDocument(Document doc) {
            this.document = doc;
        }

        public Document getDocument() {
            return this.document;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Element element = this.data.get(rowIndex);
            if (columnIndex == 0) {
                return element.getAttributeNS(null, "id");
            }
            if (columnIndex == 1) {
                return element.getNodeName();
            }
            return null;
        }

        public Element getElementAt(int rowIndex) {
            return this.data.get(rowIndex);
        }

        public void refresh() {
            this.data.clear();
            HashMap<String, Element> map = new HashMap<String, Element>();
            DocumentTraversal travelsal = (DocumentTraversal)((Object)this.document);
            NodeIterator iter = travelsal.createNodeIterator(this.document.getDocumentElement(), 1, null, false);
            Node node = iter.nextNode();
            while (node != null) {
                Element elt = (Element)node;
                String id = elt.getAttributeNS(null, "id").trim();
                if (id.length() > 0) {
                    Element obj = (Element)map.get(id);
                    if (obj != null) {
                        if (this.data.indexOf(obj) == -1) {
                            this.data.add(obj);
                        }
                        this.data.add(elt);
                    }
                    map.put(id, elt);
                }
                node = iter.nextNode();
            }
            this.fireTableDataChanged();
        }
    }
}

