/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.registration;

import java.util.prefs.Preferences;
import kiyut.sketsa.Application;
import kiyut.sketsa.options.AbstractOptions;

public final class RegistrationOptions
extends AbstractOptions {
    private static RegistrationOptions instance = new RegistrationOptions();
    public static final String UNREGISTERED_NAME = "Unregistered";
    private static final String REGISTRATION_NAME_PROPERTY = "registration_name";
    private static final String SERIAL_NUMBER_PROPERTY = "serial_number";
    private static final String BUILD_NUMBER_PROPERTY = "build_number";
    private static final String MILLIS_PROPERTY = "millis";
    private static final String CHECKED_PROPERTY = "checked";
    private String name;
    private String serialNumber;
    private String buildNumber;
    private long millis;
    private long checked;

    public static RegistrationOptions getInstance() {
        return instance;
    }

    protected RegistrationOptions() {
        this.nodeName = "registration";
        Preferences prefs = this.getPreferences();
        this.name = prefs.get(REGISTRATION_NAME_PROPERTY, UNREGISTERED_NAME);
        this.serialNumber = prefs.get(SERIAL_NUMBER_PROPERTY, null);
        this.buildNumber = prefs.get(BUILD_NUMBER_PROPERTY, null);
        this.millis = prefs.getLong(MILLIS_PROPERTY, -1L);
        this.checked = prefs.getLong(CHECKED_PROPERTY, -1L);
    }

    void setRegistrationName(String name) {
        String old = this.name;
        this.name = name;
        this.getPreferences().put(REGISTRATION_NAME_PROPERTY, name);
        this.firePropertyChange(REGISTRATION_NAME_PROPERTY, old, name);
    }

    public String getRegistrationName() {
        return this.name;
    }

    void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        if (serialNumber != null) {
            this.getPreferences().put(SERIAL_NUMBER_PROPERTY, serialNumber);
        } else {
            this.getPreferences().remove(SERIAL_NUMBER_PROPERTY);
        }
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    void setBuildNumber(String buildNumber) {
        String old = this.buildNumber;
        this.buildNumber = buildNumber;
        this.getPreferences().put(BUILD_NUMBER_PROPERTY, buildNumber);
        this.firePropertyChange(BUILD_NUMBER_PROPERTY, old, buildNumber);
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    long getMillis() {
        return this.millis;
    }

    void updateMillis(boolean forceUpdate) {
        long current = System.currentTimeMillis();
        if (!forceUpdate) {
            if (!Application.getBuildNumber().equalsIgnoreCase(this.buildNumber)) {
                forceUpdate = true;
            }
            if (this.millis > current || this.millis < 0L) {
                forceUpdate = true;
            }
        }
        if (forceUpdate) {
            this.millis = current;
            this.getPreferences().putLong(MILLIS_PROPERTY, this.millis);
            this.setBuildNumber(Application.getBuildNumber());
        }
    }

    long getChecked() {
        return this.checked;
    }

    void updateChecked() {
        long current;
        this.checked = current = System.currentTimeMillis();
        this.getPreferences().putLong(CHECKED_PROPERTY, this.checked);
    }
}

