/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.registration;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.imageio.ImageIO;
import javax.swing.Timer;
import kiyut.sketsa.Application;
import kiyut.sketsa.registration.BetaVersionPane;
import kiyut.sketsa.registration.RegistrationOptions;
import kiyut.sketsa.registration.ReminderDialog;
import kiyut.util.Base64;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class RegistrationManager {
    private static RegistrationManager instance;
    private boolean registered = false;
    private Image unregisteredImage;
    private Timer registrationTimer;
    private int expired = 30;

    public static synchronized RegistrationManager getInstance() {
        if (instance == null) {
            instance = new RegistrationManager();
        }
        return instance;
    }

    private RegistrationManager() {
        RegistrationOptions opts = RegistrationOptions.getInstance();
        this.registered = this.isValid(opts.getSerialNumber(), true);
        if (!this.registered) {
            try {
                opts.updateMillis(false);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.unregisteredImage = ImageIO.read(this.getClass().getResource("/kiyut/sketsa/registration/unregistered.png"));
            }
            catch (Exception ex) {
                this.unregisteredImage = null;
            }
            this.registrationTimer = new Timer(600000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (RegistrationManager.this.registered) {
                        return;
                    }
                    RegistrationManager.this.showReminder();
                }
            });
            this.registrationTimer.setCoalesce(true);
            this.registrationTimer.setRepeats(true);
            this.registrationTimer.start();
        }
    }

    private boolean isValid(String serialNo, boolean checkExpired) {
        boolean valid = false;
        if (serialNo == null) {
            return valid;
        }
        try {
            valid = this.verify(serialNo);
            if (checkExpired && this.expired > 0) {
                valid = false;
            }
        }
        catch (Exception ex) {
            valid = false;
        }
        return valid;
    }

    private boolean verify(String serialNo) throws Exception {
        boolean valid = false;
        String license = serialNo.replaceAll("\\r|\\n", "");
        StringBuilder sbPub = new StringBuilder();
        sbPub.append("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAtcH0VCGmf+uYUg75NQ2UScnQ+TICWfYv");
        sbPub.append("z1HMBWXWFchsmW3DYFOs+is0+W3rAdWXdLjSu/2RpDAaa2dS/ZTqIP3BgXalJ2qA4i4sx3y/cHNh");
        sbPub.append("J00ZgoZMUemMJwmxMGhKFInoIUMxYn8dj5Rkc+bRwn1PjsyKYQlygmn2lr8dENTMTfTPxfog9eqd");
        sbPub.append("Tn3QWbzl6/TmwOK+SvOSQRF69yvTRQU3CoJT9+4CrLuhgAUFvcq+Ak5QP0A4PuU4QaDKg4EmvwU7");
        sbPub.append("XwjX9qSqSINT/T6q1Oqu6pAPNEz/+DtC46vcaq4Qj/9fiE5jwOvukKnZoWmgHt0IDC1lHJnd4cW2");
        sbPub.append("SOKaAwIDAQAB");
        KeyFactory keyFac = KeyFactory.getInstance("RSA");
        PublicKey pubKey = keyFac.generatePublic(new X509EncodedKeySpec(Base64.decode(sbPub.toString())));
        Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        c.init(2, pubKey);
        byte[] outByte = c.doFinal(Base64.decode(license));
        String out = new String(outByte);
        if (out.startsWith("Sketsa SVG Editor")) {
            valid = true;
            int index = out.lastIndexOf("expired");
            if (index > 0) {
                this.expired = (out = out.substring(index + 8, out.length())).toLowerCase().equals("none") ? -999 : Integer.parseInt(out);
            }
        }
        return valid;
    }

    public boolean register(String name, String serialNo) {
        if (!this.isValid(serialNo, false)) {
            return false;
        }
        RegistrationOptions opts = RegistrationOptions.getInstance();
        opts.setRegistrationName(name);
        opts.setSerialNumber(serialNo);
        opts.updateMillis(true);
        opts.updateChecked();
        this.unregisteredImage = null;
        this.registered = true;
        if (this.registrationTimer != null) {
            this.registrationTimer.stop();
            this.registrationTimer = null;
        }
        return true;
    }

    public void unRegister() {
        RegistrationOptions opts = RegistrationOptions.getInstance();
        opts.setSerialNumber(null);
        this.registered = false;
    }

    public void paintUnregisteredImage(Component component, Graphics g) {
        if (this.registered) {
            return;
        }
        if (this.unregisteredImage == null) {
            return;
        }
        g.drawImage(this.unregisteredImage, 2, 2, component);
    }

    public synchronized boolean checkRegistration() {
        boolean result = true;
        if (this.registered) {
            return result;
        }
        this.showReminder();
        int day = this.getElapsedDays();
        if (day > this.expired) {
            result = false;
            String msg = NbBundle.getMessage(RegistrationManager.class, (String)"MSG_EvaluationExpired");
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        }
        return result;
    }

    public synchronized void showReminder() {
        if (this.registered) {
            return;
        }
        if (Application.isBeta()) {
            return;
        }
        if (this.registrationTimer != null) {
            this.registrationTimer.stop();
        }
        Frame owner = WindowManager.getDefault().getMainWindow();
        ReminderDialog dialog = new ReminderDialog(owner, true);
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        if (this.registrationTimer != null) {
            this.registrationTimer.restart();
        }
    }

    public void showBetaNotice() {
        if (!Application.isBeta()) {
            return;
        }
        Frame owner = WindowManager.getDefault().getMainWindow();
        BetaVersionPane.showDialog(owner);
    }

    public int getElapsedDays() {
        RegistrationOptions opts = RegistrationOptions.getInstance();
        long millis = opts.getMillis();
        long now = System.currentTimeMillis();
        int elapsed = (int)((now - millis) / 86400000L);
        return elapsed;
    }

    public int getElapsedChecked() {
        int elapsed = -1;
        if (!this.registered) {
            return elapsed;
        }
        RegistrationOptions opts = RegistrationOptions.getInstance();
        long checked = opts.getChecked();
        long now = System.currentTimeMillis();
        elapsed = (int)((now - checked) / 86400000L);
        return elapsed;
    }

    public long getExpiredMillis() {
        RegistrationOptions opts = RegistrationOptions.getInstance();
        return opts.getMillis() + 86400000L * (long)this.expired;
    }
}

