/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.options;

import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import kiyut.sketsa.options.AbstractOptions;

public class MRUFilesOptions
extends AbstractOptions {
    private static MRUFilesOptions instance = new MRUFilesOptions();
    public static final String MRU_FILE_LIST_PROPERTY = "MRUFileList";
    private List<String> mruFileList;
    private int maxSize;

    public static MRUFilesOptions getInstance() {
        return instance;
    }

    protected MRUFilesOptions() {
        this.nodeName = "mrufiles";
        this.maxSize = 9;
        this.mruFileList = new ArrayList<String>(this.maxSize);
        this.retrieve();
    }

    public List<String> getMRUFileList() {
        return this.mruFileList;
    }

    public void setMRUFileList(List<String> list) {
        this.mruFileList.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.mruFileList.add(list.get(i));
            if (i >= this.maxSize) break;
        }
        this.firePropertyChange(MRU_FILE_LIST_PROPERTY, null, this.mruFileList);
        this.store();
    }

    public void addFile(String absolutePath) {
        this.mruFileList.remove(absolutePath);
        this.mruFileList.add(0, absolutePath);
        while (this.mruFileList.size() > this.maxSize) {
            this.mruFileList.remove(this.mruFileList.size() - 1);
        }
        this.firePropertyChange(MRU_FILE_LIST_PROPERTY, null, this.mruFileList);
        this.store();
    }

    protected void store() {
        Preferences prefs = this.getPreferences();
        try {
            prefs.clear();
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        for (int i = 0; i < this.mruFileList.size(); ++i) {
            String str = this.mruFileList.get(i);
            prefs.put(MRU_FILE_LIST_PROPERTY + i, str);
        }
    }

    protected void retrieve() {
        String str;
        this.mruFileList.clear();
        Preferences prefs = this.getPreferences();
        for (int i = 0; i < this.maxSize && (str = prefs.get(MRU_FILE_LIST_PROPERTY + i, null)) != null; ++i) {
            this.mruFileList.add(str);
        }
    }
}

