/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import kiyut.sketsa.io.DOMTranscoder;
import kiyut.sketsa.options.AbstractOptionsPane;
import kiyut.sketsa.options.CodeFormatOptions;

public class CodeFormatOptionsPane
extends AbstractOptionsPane {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.options.CodeFormatOptionsPane");
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel8;
    private JComboBox lineBreakCombo;
    private JTextField lineWidthField;
    private JRadioButton stylingCSSRadio;
    private ButtonGroup stylingGroup;
    private JRadioButton stylingPresentationAttribute;
    private JTextField tabWidthField;

    public CodeFormatOptionsPane() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.stylingGroup = new ButtonGroup();
        JPanel jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.tabWidthField = new JTextField();
        this.jLabel1 = new JLabel();
        this.lineWidthField = new JTextField();
        this.jLabel2 = new JLabel();
        this.stylingCSSRadio = new JRadioButton();
        this.stylingPresentationAttribute = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.lineBreakCombo = new JComboBox();
        JPanel jPanel2 = new JPanel();
        this.setLayout(new GridBagLayout());
        jPanel1.setLayout(new GridBagLayout());
        this.jLabel8.setText(bundle.getString("CTL_TabWidth.Text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        jPanel1.add((Component)this.jLabel8, gridBagConstraints);
        this.tabWidthField.setText("4");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add((Component)this.tabWidthField, gridBagConstraints);
        this.jLabel1.setText(bundle.getString("CTL_LineWidth.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.lineWidthField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel1.add((Component)this.lineWidthField, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("CTL_Styling.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.stylingGroup.add(this.stylingCSSRadio);
        this.stylingCSSRadio.setText(bundle.getString("CTL_CSSStyle.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel1.add((Component)this.stylingCSSRadio, gridBagConstraints);
        this.stylingGroup.add(this.stylingPresentationAttribute);
        this.stylingPresentationAttribute.setSelected(true);
        this.stylingPresentationAttribute.setText(bundle.getString("CTL_PresentationAttribute.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel1.add((Component)this.stylingPresentationAttribute, gridBagConstraints);
        this.jLabel3.setText(bundle.getString("CTL_LineBreak.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.lineBreakCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"CR LF (Windows)", "CR (Macintosh)", "LF (Unix)"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel1.add((Component)this.lineBreakCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel2, gridBagConstraints);
    }

    private void initCustomComponents() {
    }

    @Override
    public void refreshOptions() {
        CodeFormatOptions opts = CodeFormatOptions.getInstance();
        this.tabWidthField.setText(Integer.toString(opts.getTabWidth()));
        this.lineWidthField.setText(Integer.toString(opts.getLineWidth()));
        if (opts.isStylingCSS()) {
            this.stylingCSSRadio.setSelected(true);
        } else {
            this.stylingPresentationAttribute.setSelected(true);
        }
        String str = opts.getLineBreak();
        int index = 0;
        if (str.equalsIgnoreCase(DOMTranscoder.VALUE_NEWLINE_CR.getValue())) {
            index = 1;
        } else if (str.equalsIgnoreCase(DOMTranscoder.VALUE_NEWLINE_LF.getValue())) {
            index = 2;
        }
        this.lineBreakCombo.setSelectedIndex(index);
    }

    @Override
    public void applyChanges() {
        int i;
        CodeFormatOptions opts = CodeFormatOptions.getInstance();
        try {
            i = Integer.parseInt(this.tabWidthField.getText());
            opts.setTabWidth(i);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            i = Integer.parseInt(this.lineWidthField.getText());
            opts.setLineWidth(i);
        }
        catch (Exception e) {
            // empty catch block
        }
        opts.setStylingCSS(this.stylingCSSRadio.isSelected());
        int index = this.lineBreakCombo.getSelectedIndex();
        String lineBreak = DOMTranscoder.VALUE_NEWLINE_CR_LF.getValue();
        if (index == 1) {
            lineBreak = DOMTranscoder.VALUE_NEWLINE_CR.getValue();
        } else if (index == 2) {
            lineBreak = DOMTranscoder.VALUE_NEWLINE_LF.getValue();
        }
        opts.setLineBreak(lineBreak);
    }
}

