/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.io;

import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import kiyut.sketsa.io.DOMTranscoder;
import kiyut.sketsa.io.NodeRange;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGStylable;
import org.w3c.dom.svg.SVGTextContentElement;
import org.w3c.dom.svg.SVGTextElement;

public class DOMPrettyPrinter {
    protected Writer writer;
    protected String newline = DOMTranscoder.VALUE_NEWLINE_CR_LF.getValue();
    protected boolean format = true;
    protected int tabulationWidth = 4;
    protected int documentWidth = 80;
    protected String publicId;
    protected String systemId;
    protected String xmlDeclaration;
    protected int type;
    protected int level;
    protected StringBuilder margin = new StringBuilder();
    protected int line = 1;
    protected int column;
    protected long size = 0L;
    protected boolean canIndent = true;
    protected NodeRange nodeRange = null;

    public void setNodeRange(NodeRange nodeRange) {
        this.nodeRange = nodeRange;
    }

    public void setXMLDeclaration(String s) {
        this.xmlDeclaration = s;
    }

    public void setPublicId(String s) {
        this.publicId = s;
    }

    public void setSystemId(String s) {
        this.systemId = s;
    }

    public void setNewline(String s) {
        this.newline = s;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setFormat(boolean b) {
        this.format = b;
    }

    public boolean getFormat() {
        return this.format;
    }

    public void setTabulationWidth(int i) {
        this.tabulationWidth = Math.max(i, 0);
    }

    public int getTabulationWidth() {
        return this.tabulationWidth;
    }

    public void setDocumentWidth(int i) {
        this.documentWidth = Math.max(i, 0);
    }

    public int getDocumentWidth() {
        return this.documentWidth;
    }

    protected int newlines(char[] text) {
        int result = 0;
        for (int i = 0; i < text.length; ++i) {
            if (text[i] != '\n') continue;
            ++result;
        }
        return result;
    }

    protected void printCharacter(char c) throws IOException {
        if (c == '\n') {
            this.printNewline();
        } else {
            ++this.size;
            ++this.column;
            this.writer.write(c);
        }
    }

    protected void printNewline() throws IOException {
        String nl = this.getNewline();
        for (int i = 0; i < nl.length(); ++i) {
            this.writer.write(nl.charAt(i));
        }
        ++this.size;
        this.column = 0;
        ++this.line;
    }

    protected void printString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.printCharacter(s.charAt(i));
        }
    }

    protected void printCharacters(char[] ca) throws IOException {
        for (int i = 0; i < ca.length; ++i) {
            this.printCharacter(ca[i]);
        }
    }

    protected void printSpaces(char[] text, boolean opt) throws IOException {
        if (this.getFormat()) {
            if (!opt) {
                this.printCharacter(' ');
            }
        } else {
            this.printCharacters(text);
        }
    }

    protected void printTopSpaces(char[] text) throws IOException {
        if (this.getFormat()) {
            int nl = this.newlines(text);
            for (int i = 0; i < nl; ++i) {
                this.printNewline();
            }
        } else {
            this.printCharacters(text);
        }
    }

    protected void marginAppend() {
        for (int i = 0; i < this.getTabulationWidth(); ++i) {
            this.margin.append(' ');
        }
    }

    protected void marginDelete() {
        for (int i = 0; i < this.getTabulationWidth(); ++i) {
            this.margin.deleteCharAt(0);
        }
    }

    protected String contentToString(String s) {
        StringBuilder result = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block7;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    protected String normalizeAttributeValue(String s) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("'");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        StringTokenizer st = new StringTokenizer(sb.toString());
        sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken()).append(" ");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected void formatText(String text) throws IOException {
        this.formatText(text, true);
    }

    protected void formatText(String text, boolean reformat) throws IOException {
        StringTokenizer st = new StringTokenizer(text);
        while (st.hasMoreTokens()) {
            int i;
            String str = st.nextToken();
            if (str.length() + this.column > this.getDocumentWidth()) {
                this.printNewline();
                this.printString(this.margin.toString());
                for (i = 0; i < this.getTabulationWidth(); ++i) {
                    this.printCharacter(' ');
                }
            }
            this.printString(str);
            if (!st.hasMoreTokens()) continue;
            this.printCharacter(' ');
            if (reformat) continue;
            this.printNewline();
            this.printString(this.margin.toString());
            for (i = 0; i < this.getTabulationWidth(); ++i) {
                this.printCharacter(' ');
            }
        }
    }

    protected boolean isWhiteSpace(char[] text) {
        for (int i = 0; i < text.length; ++i) {
            if (XMLUtilities.isXMLSpace((char)text[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isAttributeValueLineBreakable(Attr attr) {
        boolean breakable = false;
        Element elt = attr.getOwnerElement();
        String name = attr.getName();
        if (name.equalsIgnoreCase("points")) {
            if (elt instanceof SVGPolygonElement || elt instanceof SVGPolylineElement) {
                breakable = true;
            }
        } else if (name.equalsIgnoreCase("d")) {
            if (elt instanceof SVGPathElement) {
                breakable = true;
            }
        } else if (name.equalsIgnoreCase("style")) {
            if (elt instanceof SVGStylable) {
                breakable = true;
            }
        } else if (name.equalsIgnoreCase("href") && elt instanceof SVGImageElement) {
            breakable = true;
        }
        return breakable;
    }

    public void print(Document doc, Writer w) throws TranscoderException, IOException {
        this.writer = w;
        this.printXMLDecl();
        this.printDocType();
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.writeNode(n);
        }
    }

    protected void printXMLDecl() throws TranscoderException, IOException {
        if (this.xmlDeclaration != null) {
            this.printString(this.xmlDeclaration);
        }
    }

    protected void printDocType() throws TranscoderException, IOException {
        if (this.publicId != null && this.systemId != null) {
            if (this.xmlDeclaration != null) {
                this.printNewline();
            }
            this.printString("<!DOCTYPE svg PUBLIC \"" + this.publicId + "\"" + this.getNewline());
            for (int i = 0; i < this.getTabulationWidth(); ++i) {
                this.printCharacter(' ');
            }
            this.printString("\"" + this.systemId + "\">");
        }
    }

    protected void writeNode(Node n) throws IOException {
        long startIndex = this.size;
        switch (n.getNodeType()) {
            case 1: {
                this.writeElement(n);
                break;
            }
            case 3: {
                this.writeCharacterData(n);
                break;
            }
            case 4: {
                this.writeCDATASection(n);
                break;
            }
            case 5: {
                this.writeEntityReference(n);
                break;
            }
            case 7: {
                this.writePI(n);
                break;
            }
            case 8: {
                this.writeComment(n);
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new Error("Internal error (" + n.getNodeType() + ")");
            }
        }
        long endIndex = this.size;
        if (this.nodeRange != null && this.nodeRange.getNode().equals(n)) {
            this.nodeRange.setStartIndex(startIndex);
            this.nodeRange.setEndIndex(endIndex);
        }
    }

    protected void writeElement(Node n) throws IOException {
        Node c;
        Node parent = n.getParentNode();
        if (!(parent instanceof SVGTextElement) && this.getFormat() && this.canIndent) {
            this.printNewline();
            this.printString(this.margin.toString());
        }
        int startLine = this.line;
        this.printCharacter('<');
        this.printString(n.getNodeName());
        if (n.hasAttributes()) {
            NamedNodeMap attr = n.getAttributes();
            int len = attr.getLength();
            boolean newLine = false;
            for (int i = 0; i < len; ++i) {
                int j;
                Attr a = (Attr)attr.item(i);
                if (!a.getSpecified()) continue;
                newLine = false;
                String attrName = a.getNodeName() + "=";
                if (attrName.length() + 1 + this.column > this.getDocumentWidth()) {
                    this.printNewline();
                    this.printString(this.margin.toString());
                    for (j = 0; j < this.getTabulationWidth(); ++j) {
                        this.printCharacter(' ');
                    }
                    newLine = true;
                }
                if (newLine) {
                    this.printString(attrName);
                } else {
                    this.printString(" " + attrName);
                }
                if (a.getNodeName().toLowerCase().startsWith("xlink:href")) {
                    this.formatText("\"" + a.getNodeValue() + "\"", false);
                    this.printNewline();
                    this.printString(this.margin.toString());
                    for (j = 0; j < this.getTabulationWidth() - 1; ++j) {
                        this.printCharacter(' ');
                    }
                    continue;
                }
                String attrValue = "\"" + this.normalizeAttributeValue(a.getNodeValue()) + "\"";
                if (this.isAttributeValueLineBreakable(a)) {
                    this.formatText(attrValue);
                    continue;
                }
                this.printString(attrValue);
            }
        }
        if ((c = n.getFirstChild()) != null) {
            this.printCharacter('>');
            ++this.level;
            this.marginAppend();
            this.canIndent = true;
            while (c != null) {
                this.writeNode(c);
                c = c.getNextSibling();
            }
            --this.level;
            this.marginDelete();
            if (!(n instanceof SVGTextContentElement) && this.getFormat() && XMLSupport.getXMLSpace((Element)((Element)n)).equals("default") && (this.column + n.getNodeName().length() + 3 >= this.getDocumentWidth() || startLine != this.line)) {
                this.printNewline();
                this.printString(this.margin.toString());
            }
            this.printString("</");
            this.printString(n.getNodeName());
            this.printString(">");
        } else {
            this.printString("/>");
        }
    }

    protected void writeComment(Node n) throws IOException {
        String str = n.getNodeValue();
        if (this.getFormat()) {
            if (this.canIndent) {
                this.printNewline();
                this.printString(this.margin.toString());
            }
            this.printString("<!--");
            this.printString(str);
            if (this.column + 3 > this.getDocumentWidth()) {
                this.printNewline();
                this.printString(this.margin.toString());
            }
            this.printString("-->");
        } else {
            this.printString("<!--");
            this.printString(str);
            this.printString("-->");
        }
    }

    protected void writeCharacterData(Node n) throws IOException {
        String text;
        Node parent = n.getParentNode();
        if (XMLSupport.getXMLSpace((Element)((Element)parent)).equals("default")) {
            if (parent instanceof SVGTextContentElement) {
                String data = n.getNodeValue();
                StringBuilder result = new StringBuilder();
                boolean space = false;
                block4: for (int i = 0; i < data.length(); ++i) {
                    char c = data.charAt(i);
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            space = false;
                            continue block4;
                        }
                        case '\t': 
                        case ' ': {
                            if (space) continue block4;
                            result.append(' ');
                            space = true;
                            continue block4;
                        }
                        default: {
                            result.append(c);
                            space = false;
                        }
                    }
                }
                text = result.toString();
            } else {
                text = XMLSupport.defaultXMLSpace((String)n.getNodeValue());
            }
        } else {
            text = XMLSupport.preserveXMLSpace((String)n.getNodeValue());
        }
        this.printString(this.contentToString(text));
    }

    protected void writeEntityReference(Node n) throws IOException {
        this.printCharacter('&');
        this.printString(n.getNodeName());
        this.printCharacter(';');
    }

    protected void writeCDATASection(Node n) throws IOException {
        this.printString("<![CDATA[");
        this.printString(n.getNodeValue());
        this.printString("]]>");
    }

    public void writePI(Node n) throws IOException {
        if (this.getFormat() && this.canIndent) {
            this.printNewline();
            this.printString(this.margin.toString());
        }
        this.printString("<?");
        this.printString(n.getNodeName());
        this.printString(" ");
        this.printString(n.getNodeValue());
        this.printString("?>");
    }
}

