/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.canvas.tool.DropperPane;

public class DropperTool
extends AbstractTool {
    public static final String COLOR_PROPERTY = "color";
    protected VectorCanvas canvas;
    protected GeneralPath path = new GeneralPath();
    protected Cursor cursor;
    protected Robot robot;
    protected Color color;
    protected EventListenerList listenerList;

    public DropperTool() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Dimension dim = toolkit.getBestCursorSize(32, 32);
            if (dim.getWidth() == 0.0 || dim.getHeight() == 0.0) {
                throw new RuntimeException("doesn't support custom cursor");
            }
            Image cursorImage = toolkit.getImage(this.getClass().getResource("/kiyut/sketsa/canvas/tool/dropper-cursor32.png"));
            this.cursor = toolkit.createCustomCursor(cursorImage, new Point(9, 22), "DROPPER_CURSOR");
        }
        catch (Exception ex) {
            this.cursor = Cursor.getDefaultCursor();
        }
        this.listenerList = new EventListenerList();
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void startTool() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException ex) {
            return;
        }
        this.canvas.getCanvasSelection().setEnabledVisible(false, true, false);
        if (this.canvas.getCursor() != this.cursor) {
            this.canvas.setCursor(this.cursor);
        }
        this.color = null;
        this.fireMessageReceived(0, "Color Picker.");
    }

    @Override
    public void endTool() {
        this.robot = null;
        this.color = null;
        super.endTool();
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.robot == null) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        Color oldColor = this.color;
        Point p = evt.getPoint();
        SwingUtilities.convertPointToScreen(p, this.canvas);
        Color newColor = this.robot.getPixelColor(p.x, p.y);
        newColor = DropperPane.showDialog(this.canvas, newColor);
        if (newColor == null) {
            return;
        }
        this.color = newColor;
        this.firePropertyChange(COLOR_PROPERTY, oldColor, this.color);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.add(PropertyChangeListener.class, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listenerList.remove(PropertyChangeListener.class, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        Object[] listeners = this.listenerList.getListenerList();
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)listeners[i + 1]).propertyChange(event);
        }
    }
}

