/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.canvas.tool.ResizeTool;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.GeomUtilities;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGEllipseElement;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGRectElement;
import org.w3c.dom.svg.SVGTextElement;
import org.w3c.dom.svg.SVGUseElement;

public class DefaultResizeTool
extends AbstractTool
implements ResizeTool {
    private VectorCanvas canvas;
    private Stroke stroke = new BasicStroke(1.0f);
    private int startX;
    private int startY;
    private int newX;
    private int newY;
    private boolean constraint = false;
    private List<SVGElement> selectionList = new ArrayList<SVGElement>();
    private List<Shape> outlineList = new ArrayList<Shape>();
    private List<Shape> newOutlineList = new ArrayList<Shape>();
    private Rectangle2D bounds;
    private int direction = -1;

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.canvas.getCanvasSelection().getStrokePaint());
        if (this.newOutlineList.size() > 0) {
            g2d.setStroke(this.canvas.getCanvasSelection().getStroke());
            Rectangle2D rBounds = GeomUtilities.getBounds2D(this.newOutlineList);
            g2d.draw(rBounds);
        }
        g2d.setStroke(this.stroke);
        for (int i = 0; i < this.newOutlineList.size(); ++i) {
            Shape shape = this.newOutlineList.get(i);
            g2d.draw(shape);
        }
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void startTool() {
        this.direction = -1;
        this.constraint = false;
        this.fireMessageReceived(0, "Drag to resize selection");
    }

    @Override
    public void endTool() {
        this.selectionList.clear();
        this.outlineList.clear();
        this.newOutlineList.clear();
    }

    protected int determineDirection(int x, int y) {
        Rectangle2D r = null;
        int dir = -1;
        Map<String, Rectangle2D> border = this.canvas.getCanvasSelection().getBorder();
        for (int i = 1; i <= 9; ++i) {
            if (i == 5 || !(r = border.get(Integer.toString(i))).contains(x, y)) continue;
            dir = i;
            if (i > 0) break;
        }
        return dir;
    }

    protected AffineTransform createTransform() {
        Rectangle2D r = this.canvas.getCanvasSelection().getSelectionBounds2D();
        float x = (float)r.getX();
        float y = (float)r.getY();
        float w = (float)r.getWidth();
        float h = (float)r.getHeight();
        float sx = 1.0f;
        float sy = 1.0f;
        if (w == 0.0f) {
            w = 1.0f;
        }
        if (h == 0.0f) {
            h = 1.0f;
        }
        if (this.direction == 1) {
            x += w;
            y += h;
            sx = (w - (float)(this.newX - this.startX)) / w;
            sy = (h - (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                if (sx >= 0.0f && sy < 0.0f) {
                    sx = sy;
                }
                sy = sx;
            }
        } else if (this.direction == 2) {
            y += h;
            sy = (h - (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                sx = sy;
                x = (float)r.getCenterX();
            }
        } else if (this.direction == 3) {
            y += h;
            sx = (w + (float)(this.newX - this.startX)) / w;
            sy = (h - (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                if (sx >= 0.0f && sy < 0.0f) {
                    sx = sy;
                }
                sy = sx;
            }
        } else if (this.direction == 4) {
            x += w;
            sx = (w - (float)(this.newX - this.startX)) / w;
            if (this.constraint) {
                sy = sx;
                y = (float)r.getCenterY();
            }
        } else if (this.direction == 6) {
            sx = (w + (float)(this.newX - this.startX)) / w;
            if (this.constraint) {
                sy = sx;
                y = (float)r.getCenterY();
            }
        } else if (this.direction == 7) {
            x += w;
            sx = (w - (float)(this.newX - this.startX)) / w;
            sy = (h + (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                if (sx >= 0.0f && sy < 0.0f) {
                    sx = sy;
                }
                sy = sx;
            }
        } else if (this.direction == 8) {
            sy = (h + (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                sx = sy;
                x = (float)r.getCenterX();
            }
        } else {
            sx = (w + (float)(this.newX - this.startX)) / w;
            sy = (h + (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                if (sx >= 0.0f && sy < 0.0f) {
                    sx = sy;
                }
                sy = sx;
            }
        }
        AffineTransform newAt = new AffineTransform();
        newAt.translate(x, y);
        newAt.scale(sx, sy);
        newAt.translate(-x, -y);
        return newAt;
    }

    protected void swap(double[] array, int index1, int index2) {
        double td = array[index1];
        array[index1] = array[index2];
        array[index2] = td;
    }

    protected void updateDOM() {
        if (this.selectionList.isEmpty()) {
            return;
        }
        this.newOutlineList.clear();
        double[] dstPts = new double[6];
        AffineTransform resizeAt = this.createTransform();
        AffineTransform canvasAt = this.canvas.getTransform();
        CanvasModel model = this.canvas.getModel();
        for (int i = 0; i < this.selectionList.size(); ++i) {
            SVGPoint p;
            SVGPointList pointList;
            SVGLength ecy;
            SVGLength ecx;
            SVGLength ey;
            SVGLength ex;
            SVGImageElement svgElement;
            GraphicsNode gn = model.getGraphicsNode(this.selectionList.get(i));
            if (gn == null) continue;
            AffineTransform at = (AffineTransform)canvasAt.clone();
            at.concatenate(gn.getGlobalTransform());
            AffineTransform invAt = null;
            try {
                invAt = at.createInverse();
            }
            catch (NoninvertibleTransformException ex2) {
                // empty catch block
            }
            SVGElement element = model.getSVGElement(gn);
            if (element instanceof SVGImageElement) {
                svgElement = (SVGImageElement)element;
                ex = svgElement.getX().getBaseVal();
                ey = svgElement.getY().getBaseVal();
                SVGLength ew = svgElement.getWidth().getBaseVal();
                SVGLength eh = svgElement.getHeight().getBaseVal();
                dstPts[0] = ex.getValue();
                dstPts[1] = ey.getValue();
                dstPts[2] = ex.getValue() + ew.getValue();
                dstPts[3] = ey.getValue() + eh.getValue();
                at.transform(dstPts, 0, dstPts, 0, 2);
                resizeAt.transform(dstPts, 0, dstPts, 0, 2);
                if (invAt != null) {
                    invAt.transform(dstPts, 0, dstPts, 0, 2);
                }
                if (dstPts[0] > dstPts[2]) {
                    this.swap(dstPts, 0, 2);
                }
                if (dstPts[1] > dstPts[3]) {
                    this.swap(dstPts, 1, 3);
                }
                ex.setValue((float)dstPts[0]);
                ey.setValue((float)dstPts[1]);
                ew.setValue((float)dstPts[2] - ex.getValue());
                eh.setValue((float)dstPts[3] - ey.getValue());
                continue;
            }
            if (element instanceof SVGRectElement) {
                svgElement = (SVGRectElement)element;
                ex = svgElement.getX().getBaseVal();
                ey = svgElement.getY().getBaseVal();
                SVGLength ew = svgElement.getWidth().getBaseVal();
                SVGLength eh = svgElement.getHeight().getBaseVal();
                dstPts[0] = ex.getValue();
                dstPts[1] = ey.getValue();
                dstPts[2] = ex.getValue() + ew.getValue();
                dstPts[3] = ey.getValue() + eh.getValue();
                at.transform(dstPts, 0, dstPts, 0, 2);
                resizeAt.transform(dstPts, 0, dstPts, 0, 2);
                if (invAt != null) {
                    invAt.transform(dstPts, 0, dstPts, 0, 2);
                }
                if (dstPts[0] > dstPts[2]) {
                    this.swap(dstPts, 0, 2);
                }
                if (dstPts[1] > dstPts[3]) {
                    this.swap(dstPts, 1, 3);
                }
                ex.setValue((float)dstPts[0]);
                ey.setValue((float)dstPts[1]);
                ew.setValue((float)dstPts[2] - ex.getValue());
                eh.setValue((float)dstPts[3] - ey.getValue());
                continue;
            }
            if (element instanceof SVGEllipseElement) {
                svgElement = (SVGEllipseElement)element;
                ecx = svgElement.getCx().getBaseVal();
                ecy = svgElement.getCy().getBaseVal();
                SVGLength erx = svgElement.getRx().getBaseVal();
                SVGLength ery = svgElement.getRy().getBaseVal();
                dstPts[0] = ecx.getValue() - erx.getValue();
                dstPts[1] = ecy.getValue() - ery.getValue();
                dstPts[2] = ecx.getValue() + erx.getValue();
                dstPts[3] = ecy.getValue() + ery.getValue();
                at.transform(dstPts, 0, dstPts, 0, 2);
                resizeAt.transform(dstPts, 0, dstPts, 0, 2);
                if (invAt != null) {
                    invAt.transform(dstPts, 0, dstPts, 0, 2);
                }
                if (dstPts[0] > dstPts[2]) {
                    this.swap(dstPts, 0, 2);
                }
                if (dstPts[1] > dstPts[3]) {
                    this.swap(dstPts, 1, 3);
                }
                float cx = (float)((dstPts[0] + dstPts[2]) / 2.0);
                float cy = (float)((dstPts[1] + dstPts[3]) / 2.0);
                float rx = (float)dstPts[2] - cx;
                float ry = (float)dstPts[3] - cy;
                ecx.setValue(cx);
                ecy.setValue(cy);
                erx.setValue(rx > 0.0f ? rx : 1.0f);
                ery.setValue(ry > 0.0f ? ry : 1.0f);
                continue;
            }
            if (element instanceof SVGCircleElement) {
                svgElement = (SVGCircleElement)element;
                ecx = svgElement.getCx().getBaseVal();
                ecy = svgElement.getCy().getBaseVal();
                SVGLength er = svgElement.getR().getBaseVal();
                dstPts[0] = ecx.getValue() - er.getValue();
                dstPts[1] = ecy.getValue() - er.getValue();
                dstPts[2] = ecx.getValue() + er.getValue();
                dstPts[3] = ecy.getValue() + er.getValue();
                at.transform(dstPts, 0, dstPts, 0, 2);
                resizeAt.transform(dstPts, 0, dstPts, 0, 2);
                if (invAt != null) {
                    invAt.transform(dstPts, 0, dstPts, 0, 2);
                }
                if (dstPts[0] > dstPts[2]) {
                    this.swap(dstPts, 0, 2);
                }
                if (dstPts[1] > dstPts[3]) {
                    this.swap(dstPts, 1, 3);
                }
                float cx = (float)((dstPts[0] + dstPts[2]) / 2.0);
                float cy = (float)((dstPts[1] + dstPts[3]) / 2.0);
                float rad = (float)dstPts[2] - cx;
                ecx.setValue(cx);
                ecy.setValue(cy);
                er.setValue(rad > 0.0f ? rad : 1.0f);
                continue;
            }
            if (element instanceof SVGLineElement) {
                svgElement = (SVGLineElement)element;
                SVGLength lengthX1 = svgElement.getX1().getBaseVal();
                SVGLength lengthY1 = svgElement.getY1().getBaseVal();
                SVGLength lengthX2 = svgElement.getX2().getBaseVal();
                SVGLength lengthY2 = svgElement.getY2().getBaseVal();
                dstPts[0] = lengthX1.getValue();
                dstPts[1] = lengthY1.getValue();
                dstPts[2] = lengthX2.getValue();
                dstPts[3] = lengthY2.getValue();
                at.transform(dstPts, 0, dstPts, 0, 2);
                resizeAt.transform(dstPts, 0, dstPts, 0, 2);
                if (invAt != null) {
                    invAt.transform(dstPts, 0, dstPts, 0, 2);
                }
                lengthX1.setValue((float)dstPts[0]);
                lengthY1.setValue((float)dstPts[1]);
                lengthX2.setValue((float)dstPts[2]);
                lengthY2.setValue((float)dstPts[3]);
                continue;
            }
            if (element instanceof SVGPolylineElement) {
                svgElement = (SVGPolylineElement)element;
                pointList = svgElement.getPoints();
                for (int j = 0; j < pointList.getNumberOfItems(); ++j) {
                    p = pointList.getItem(j);
                    dstPts[0] = p.getX();
                    dstPts[1] = p.getY();
                    at.transform(dstPts, 0, dstPts, 0, 1);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 1);
                    }
                    p.setX((float)dstPts[0]);
                    p.setY((float)dstPts[1]);
                }
                continue;
            }
            if (element instanceof SVGPolygonElement) {
                svgElement = (SVGPolygonElement)element;
                pointList = svgElement.getPoints();
                for (int j = 0; j < pointList.getNumberOfItems(); ++j) {
                    p = pointList.getItem(j);
                    p = pointList.getItem(j);
                    dstPts[0] = p.getX();
                    dstPts[1] = p.getY();
                    at.transform(dstPts, 0, dstPts, 0, 1);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 1);
                    }
                    p.setX((float)dstPts[0]);
                    p.setY((float)dstPts[1]);
                }
                continue;
            }
            if (!(element instanceof SVGPathElement)) continue;
            svgElement = (SVGPathElement)element;
            SVGPathSegList segList = svgElement.getPathSegList();
            double[] lastPts = new double[4];
            lastPts[2] = 0.0;
            lastPts[3] = 0.0;
            lastPts[2] = 0.0;
            lastPts[3] = 0.0;
            for (int j = 0; j < segList.getNumberOfItems(); ++j) {
                SVGPathSegLinetoAbs line;
                SVGPathSegCurvetoQuadraticAbs quad;
                SVGPathSegCurvetoCubicAbs cubic;
                float r2;
                float r1;
                Arc2D awtArc;
                SVGPathSegArcAbs arc;
                SVGPathSegMovetoAbs moveTo;
                SVGPathSeg pathSeg = segList.getItem(j);
                short type = pathSeg.getPathSegType();
                if (type == 2) {
                    moveTo = (SVGPathSegMovetoAbs)pathSeg;
                    dstPts[0] = moveTo.getX();
                    dstPts[1] = moveTo.getY();
                    lastPts[0] = moveTo.getX();
                    lastPts[1] = moveTo.getY();
                    at.transform(dstPts, 0, dstPts, 0, 1);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 1);
                    }
                    moveTo.setX((float)dstPts[0]);
                    moveTo.setY((float)dstPts[1]);
                    lastPts[2] = moveTo.getX();
                    lastPts[3] = moveTo.getY();
                    continue;
                }
                if (type == 3) {
                    moveTo = (SVGPathSegMovetoRel)pathSeg;
                    dstPts[0] = lastPts[0] + (double)moveTo.getX();
                    dstPts[1] = lastPts[1] + (double)moveTo.getY();
                    lastPts[0] = lastPts[0] + (double)moveTo.getX();
                    lastPts[1] = lastPts[1] + (double)moveTo.getY();
                    at.transform(dstPts, 0, dstPts, 0, 1);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 1);
                    }
                    moveTo.setX((float)dstPts[0] - (float)lastPts[2]);
                    moveTo.setY((float)dstPts[1] - (float)lastPts[3]);
                    lastPts[2] = lastPts[2] + (double)moveTo.getX();
                    lastPts[3] = lastPts[3] + (double)moveTo.getY();
                    continue;
                }
                if (type == 10) {
                    arc = (SVGPathSegArcAbs)pathSeg;
                    awtArc = ExtendedGeneralPath.computeArc((double)lastPts[2], (double)lastPts[3], (double)arc.getR1(), (double)arc.getR2(), (double)arc.getAngle(), (boolean)arc.getLargeArcFlag(), (boolean)arc.getSweepFlag(), (double)arc.getX(), (double)arc.getY());
                    dstPts[0] = arc.getX();
                    dstPts[1] = arc.getY();
                    dstPts[2] = awtArc.getCenterX();
                    dstPts[3] = awtArc.getCenterY();
                    dstPts[4] = awtArc.getX();
                    dstPts[5] = awtArc.getY();
                    lastPts[0] = arc.getX();
                    lastPts[1] = arc.getY();
                    at.transform(dstPts, 0, dstPts, 0, 3);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 3);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 3);
                    }
                    if ((r1 = (float)(dstPts[2] - dstPts[4])) < 0.0f) {
                        r1 = 0.0f - r1;
                    }
                    if ((r2 = (float)(dstPts[3] - dstPts[5])) < 0.0f) {
                        r2 = 0.0f - r2;
                    }
                    arc.setX((float)dstPts[0]);
                    arc.setY((float)dstPts[1]);
                    arc.setR1(r1);
                    arc.setR2(r2);
                    lastPts[2] = arc.getX();
                    lastPts[3] = arc.getY();
                    continue;
                }
                if (type == 11) {
                    arc = (SVGPathSegArcRel)pathSeg;
                    awtArc = ExtendedGeneralPath.computeArc((double)lastPts[2], (double)lastPts[3], (double)arc.getR1(), (double)arc.getR2(), (double)arc.getAngle(), (boolean)arc.getLargeArcFlag(), (boolean)arc.getSweepFlag(), (double)(lastPts[2] + (double)arc.getX()), (double)(lastPts[3] + (double)arc.getY()));
                    dstPts[0] = lastPts[0] + (double)arc.getX();
                    dstPts[1] = lastPts[1] + (double)arc.getY();
                    dstPts[2] = awtArc.getCenterX();
                    dstPts[3] = awtArc.getCenterY();
                    dstPts[4] = awtArc.getX();
                    dstPts[5] = awtArc.getY();
                    lastPts[0] = lastPts[0] + (double)arc.getX();
                    lastPts[1] = lastPts[1] + (double)arc.getY();
                    at.transform(dstPts, 0, dstPts, 0, 3);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 3);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 3);
                    }
                    if ((r1 = (float)(dstPts[2] - dstPts[4])) < 0.0f) {
                        r1 = 0.0f - r1;
                    }
                    if ((r2 = (float)(dstPts[3] - dstPts[5])) < 0.0f) {
                        r2 = 0.0f - r2;
                    }
                    arc.setX((float)dstPts[0] - (float)lastPts[2]);
                    arc.setY((float)dstPts[1] - (float)lastPts[3]);
                    arc.setR1(r1);
                    arc.setR2(r2);
                    lastPts[2] = lastPts[2] + (double)arc.getX();
                    lastPts[3] = lastPts[3] + (double)arc.getY();
                    continue;
                }
                if (type == 6) {
                    cubic = (SVGPathSegCurvetoCubicAbs)pathSeg;
                    dstPts[0] = cubic.getX();
                    dstPts[1] = cubic.getY();
                    dstPts[2] = cubic.getX1();
                    dstPts[3] = cubic.getY1();
                    dstPts[4] = cubic.getX2();
                    dstPts[5] = cubic.getY2();
                    lastPts[0] = cubic.getX();
                    lastPts[1] = cubic.getY();
                    at.transform(dstPts, 0, dstPts, 0, 3);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 3);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 3);
                    }
                    cubic.setX((float)dstPts[0]);
                    cubic.setY((float)dstPts[1]);
                    cubic.setX1((float)dstPts[2]);
                    cubic.setY1((float)dstPts[3]);
                    cubic.setX2((float)dstPts[4]);
                    cubic.setY2((float)dstPts[5]);
                    lastPts[2] = cubic.getX();
                    lastPts[3] = cubic.getY();
                    continue;
                }
                if (type == 7) {
                    cubic = (SVGPathSegCurvetoCubicRel)pathSeg;
                    dstPts[0] = lastPts[0] + (double)cubic.getX();
                    dstPts[1] = lastPts[1] + (double)cubic.getY();
                    dstPts[2] = lastPts[0] + (double)cubic.getX1();
                    dstPts[3] = lastPts[1] + (double)cubic.getY1();
                    dstPts[4] = lastPts[0] + (double)cubic.getX2();
                    dstPts[5] = lastPts[1] + (double)cubic.getY2();
                    lastPts[0] = lastPts[0] + (double)cubic.getX();
                    lastPts[1] = lastPts[1] + (double)cubic.getY();
                    at.transform(dstPts, 0, dstPts, 0, 3);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 3);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 3);
                    }
                    cubic.setX((float)dstPts[0] - (float)lastPts[2]);
                    cubic.setY((float)dstPts[1] - (float)lastPts[3]);
                    cubic.setX1((float)dstPts[2] - (float)lastPts[2]);
                    cubic.setY1((float)dstPts[3] - (float)lastPts[3]);
                    cubic.setX2((float)dstPts[4] - (float)lastPts[2]);
                    cubic.setY2((float)dstPts[5] - (float)lastPts[3]);
                    lastPts[2] = lastPts[2] + (double)cubic.getX();
                    lastPts[3] = lastPts[3] + (double)cubic.getY();
                    continue;
                }
                if (type == 16) {
                    cubic = (SVGPathSegCurvetoCubicSmoothAbs)pathSeg;
                    dstPts[0] = cubic.getX();
                    dstPts[1] = cubic.getY();
                    dstPts[2] = cubic.getX2();
                    dstPts[3] = cubic.getY2();
                    lastPts[0] = cubic.getX();
                    lastPts[1] = cubic.getY();
                    at.transform(dstPts, 0, dstPts, 0, 2);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 2);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 2);
                    }
                    cubic.setX((float)dstPts[0]);
                    cubic.setY((float)dstPts[1]);
                    cubic.setX2((float)dstPts[2]);
                    cubic.setY2((float)dstPts[3]);
                    lastPts[2] = cubic.getX();
                    lastPts[3] = cubic.getY();
                    continue;
                }
                if (type == 17) {
                    cubic = (SVGPathSegCurvetoCubicSmoothRel)pathSeg;
                    dstPts[0] = lastPts[0] + (double)cubic.getX();
                    dstPts[1] = lastPts[1] + (double)cubic.getY();
                    dstPts[2] = lastPts[0] + (double)cubic.getX2();
                    dstPts[3] = lastPts[1] + (double)cubic.getY2();
                    lastPts[0] = lastPts[0] + (double)cubic.getX();
                    lastPts[1] = lastPts[1] + (double)cubic.getY();
                    at.transform(dstPts, 0, dstPts, 0, 2);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 2);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 2);
                    }
                    cubic.setX((float)dstPts[0] - (float)lastPts[2]);
                    cubic.setY((float)dstPts[1] - (float)lastPts[3]);
                    cubic.setX2((float)dstPts[2] - (float)lastPts[2]);
                    cubic.setY2((float)dstPts[3] - (float)lastPts[3]);
                    lastPts[2] = lastPts[2] + (double)cubic.getX();
                    lastPts[3] = lastPts[3] + (double)cubic.getY();
                    continue;
                }
                if (type == 8) {
                    quad = (SVGPathSegCurvetoQuadraticAbs)pathSeg;
                    dstPts[0] = quad.getX();
                    dstPts[1] = quad.getY();
                    dstPts[2] = quad.getX1();
                    dstPts[3] = quad.getY1();
                    lastPts[0] = quad.getX();
                    lastPts[1] = quad.getY();
                    at.transform(dstPts, 0, dstPts, 0, 2);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 2);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 2);
                    }
                    quad.setX((float)dstPts[0]);
                    quad.setY((float)dstPts[1]);
                    quad.setX1((float)dstPts[2]);
                    quad.setY1((float)dstPts[3]);
                    lastPts[2] = quad.getX();
                    lastPts[3] = quad.getY();
                    continue;
                }
                if (type == 9) {
                    quad = (SVGPathSegCurvetoQuadraticRel)pathSeg;
                    dstPts[0] = lastPts[0] + (double)quad.getX();
                    dstPts[1] = lastPts[1] + (double)quad.getY();
                    dstPts[2] = lastPts[0] + (double)quad.getX1();
                    dstPts[3] = lastPts[1] + (double)quad.getY1();
                    lastPts[0] = lastPts[0] + (double)quad.getX();
                    lastPts[1] = lastPts[1] + (double)quad.getY();
                    at.transform(dstPts, 0, dstPts, 0, 2);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 2);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 2);
                    }
                    quad.setX((float)dstPts[0] - (float)lastPts[2]);
                    quad.setY((float)dstPts[1] - (float)lastPts[3]);
                    quad.setX1((float)dstPts[2] - (float)lastPts[2]);
                    quad.setY1((float)dstPts[3] - (float)lastPts[3]);
                    lastPts[2] = lastPts[2] + (double)quad.getX();
                    lastPts[3] = lastPts[3] + (double)quad.getY();
                    continue;
                }
                if (type == 18) {
                    quad = (SVGPathSegCurvetoQuadraticSmoothAbs)pathSeg;
                    dstPts[0] = quad.getX();
                    dstPts[1] = quad.getY();
                    lastPts[0] = quad.getX();
                    lastPts[1] = quad.getY();
                    at.transform(dstPts, 0, dstPts, 0, 1);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 1);
                    }
                    quad.setX((float)dstPts[0]);
                    quad.setY((float)dstPts[1]);
                    lastPts[2] = quad.getX();
                    lastPts[3] = quad.getY();
                    continue;
                }
                if (type == 19) {
                    quad = (SVGPathSegCurvetoQuadraticSmoothRel)pathSeg;
                    dstPts[0] = lastPts[0] + (double)quad.getX();
                    dstPts[1] = lastPts[1] + (double)quad.getY();
                    lastPts[0] = lastPts[0] + (double)quad.getX();
                    lastPts[1] = lastPts[1] + (double)quad.getY();
                    at.transform(dstPts, 0, dstPts, 0, 1);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 1);
                    }
                    quad.setX((float)dstPts[0] - (float)lastPts[2]);
                    quad.setY((float)dstPts[1] - (float)lastPts[3]);
                    lastPts[2] = lastPts[2] + (double)quad.getX();
                    lastPts[3] = lastPts[3] + (double)quad.getY();
                    continue;
                }
                if (type == 4) {
                    line = (SVGPathSegLinetoAbs)pathSeg;
                    dstPts[0] = line.getX();
                    dstPts[1] = line.getY();
                    lastPts[0] = line.getX();
                    lastPts[1] = line.getY();
                    at.transform(dstPts, 0, dstPts, 0, 1);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 1);
                    }
                    line.setX((float)dstPts[0]);
                    line.setY((float)dstPts[1]);
                    lastPts[2] = line.getX();
                    lastPts[3] = line.getY();
                    continue;
                }
                if (type == 12) {
                    line = (SVGPathSegLinetoHorizontalAbs)pathSeg;
                    dstPts[0] = line.getX();
                    dstPts[1] = lastPts[3];
                    lastPts[0] = line.getX();
                    at.transform(dstPts, 0, dstPts, 0, 1);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 1);
                    }
                    line.setX((float)dstPts[0]);
                    lastPts[2] = line.getX();
                    continue;
                }
                if (type == 13) {
                    line = (SVGPathSegLinetoHorizontalRel)pathSeg;
                    dstPts[0] = lastPts[0] + (double)line.getX();
                    dstPts[1] = lastPts[1];
                    lastPts[0] = lastPts[0] + (double)line.getX();
                    at.transform(dstPts, 0, dstPts, 0, 1);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 1);
                    }
                    line.setX((float)dstPts[0] - (float)lastPts[2]);
                    lastPts[2] = lastPts[2] + (double)line.getX();
                    continue;
                }
                if (type == 5) {
                    line = (SVGPathSegLinetoRel)pathSeg;
                    dstPts[0] = lastPts[0] + (double)line.getX();
                    dstPts[1] = lastPts[1] + (double)line.getY();
                    lastPts[0] = lastPts[0] + (double)line.getX();
                    lastPts[1] = lastPts[1] + (double)line.getY();
                    at.transform(dstPts, 0, dstPts, 0, 1);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 1);
                    }
                    line.setX((float)dstPts[0] - (float)lastPts[2]);
                    line.setY((float)dstPts[1] - (float)lastPts[3]);
                    lastPts[2] = lastPts[2] + (double)line.getX();
                    lastPts[3] = lastPts[3] + (double)line.getY();
                    continue;
                }
                if (type == 14) {
                    line = (SVGPathSegLinetoVerticalAbs)pathSeg;
                    dstPts[0] = lastPts[1];
                    dstPts[1] = line.getY();
                    lastPts[1] = line.getY();
                    at.transform(dstPts, 0, dstPts, 0, 1);
                    resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                    if (invAt != null) {
                        invAt.transform(dstPts, 0, dstPts, 0, 1);
                    }
                    line.setY((float)dstPts[1]);
                    lastPts[3] = line.getY();
                    continue;
                }
                if (type != 15) continue;
                line = (SVGPathSegLinetoVerticalAbs)pathSeg;
                dstPts[0] = lastPts[0];
                dstPts[1] = lastPts[1] + (double)line.getY();
                lastPts[1] = lastPts[1] + (double)line.getY();
                at.transform(dstPts, 0, dstPts, 0, 1);
                resizeAt.transform(dstPts, 0, dstPts, 0, 1);
                if (invAt != null) {
                    invAt.transform(dstPts, 0, dstPts, 0, 1);
                }
                line.setY((float)dstPts[1] - (float)lastPts[3]);
                lastPts[3] = lastPts[3] + (double)line.getY();
            }
        }
    }

    protected void updateOutline() {
        this.newOutlineList.clear();
        AffineTransform at = this.createTransform();
        for (int i = 0; i < this.outlineList.size(); ++i) {
            Shape shape = this.outlineList.get(i);
            shape = at.createTransformedShape(shape);
            this.newOutlineList.add(shape);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        if (this.selectionList.size() < 1) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        this.constraint = (evt.getModifiersEx() & 0x40) == 64;
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.newX = gridSize * Math.round((float)this.newX / (float)gridSize);
            this.newY = gridSize * Math.round((float)this.newY / (float)gridSize);
        }
        this.updateOutline();
        Rectangle2D newBounds = GeomUtilities.getBounds2D(this.newOutlineList);
        Rectangle2D.union(this.bounds, newBounds, this.bounds);
        Rectangle r = this.bounds.getBounds();
        this.canvas.repaint(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
        this.bounds = newBounds;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.startX = evt.getX();
        this.startY = evt.getY();
        this.newX = this.startX;
        this.newY = this.startY;
        this.outlineList.clear();
        this.newOutlineList.clear();
        this.direction = this.determineDirection(this.startX, this.startY);
        if (this.direction == -1) {
            return;
        }
        AffineTransform canvasAt = (AffineTransform)this.canvas.getTransform().clone();
        CanvasModel model = this.canvas.getModel();
        this.selectionList = CanvasUtilities.getGraphicsElement(this.canvas.getCanvasSelection().getSelectionList());
        for (int i = 0; i < this.selectionList.size(); ++i) {
            SVGElement elt = this.selectionList.get(i);
            GraphicsNode gn = model.getGraphicsNode(elt);
            if (gn == null || elt instanceof SVGTextElement || elt instanceof SVGUseElement) continue;
            Shape shape = gn.getOutline();
            AffineTransform at = (AffineTransform)canvasAt.clone();
            at.concatenate(gn.getGlobalTransform());
            shape = at.createTransformedShape(shape);
            this.outlineList.add(shape);
        }
        Rectangle2D r = this.canvas.getCanvasSelection().getSelectionBounds2D();
        if (this.direction == 1) {
            this.startX = (int)r.getX();
            this.startY = (int)r.getY();
        } else if (this.direction == 2) {
            this.startX = (int)r.getCenterX();
            this.startY = (int)r.getY();
        } else if (this.direction == 3) {
            this.startX = (int)(r.getX() + r.getWidth());
            this.startY = (int)r.getY();
        } else if (this.direction == 4) {
            this.startX = (int)r.getX();
            this.startY = (int)r.getCenterY();
        } else if (this.direction == 6) {
            this.startX = (int)(r.getX() + r.getWidth());
            this.startY = (int)r.getCenterY();
        } else if (this.direction == 7) {
            this.startX = (int)r.getX();
            this.startY = (int)(r.getY() + r.getHeight());
        } else if (this.direction == 8) {
            this.startX = (int)r.getCenterX();
            this.startY = (int)(r.getY() + r.getHeight());
        } else {
            this.startX = (int)(r.getX() + r.getWidth());
            this.startY = (int)(r.getY() + r.getHeight());
        }
        this.bounds = GeomUtilities.getBounds2D(this.outlineList);
        this.canvas.getCanvasSelection().setEnabledVisible(false, false, false);
        this.canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.constraint = (evt.getModifiersEx() & 0x40) == 64;
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.newX = gridSize * Math.round((float)this.newX / (float)gridSize);
            this.newY = gridSize * Math.round((float)this.newY / (float)gridSize);
        }
        this.outlineList.clear();
        this.newOutlineList.clear();
        if (this.selectionList.size() > 0) {
            Cursor prevCursor = this.canvas.getCursor();
            this.canvas.setCursor(Cursor.getPredefinedCursor(3));
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Resize selections");
            try {
                this.updateDOM();
                this.canvas.refresh();
            }
            finally {
                undoManager.end();
                this.selectionList.clear();
                this.canvas.setCursor(prevCursor);
            }
        }
        this.canvas.getCanvasSelection().setEnabledVisible(true, true, true);
        this.canvas.setTool(this.canvas.getPreviousTool());
    }
}

