/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.text;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.text.TextCaret;
import kiyut.sketsa.canvas.text.TextDocument;
import org.apache.batik.gvt.TextNode;
import org.w3c.dom.svg.SVGTextElement;

public abstract class TextEditor {
    protected VectorCanvas canvas;
    protected TextNode textNode;
    protected TextCaret caret;
    protected TextDocument document;
    protected boolean editable;

    public void paint(Graphics2D g2d) {
        if (!this.isEditable()) {
            return;
        }
        this.caret.paint(g2d);
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
        this.document.setVectorCanvas(canvas);
        this.stopEdit();
    }

    public void setSVGTextElement(SVGTextElement element) {
        this.document.setSVGTextElement(element);
    }

    public TextDocument getDocument() {
        return this.document;
    }

    public TextCaret getCaret() {
        return this.caret;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public abstract void stopEdit();

    public abstract void startEdit();

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }
}

