/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.text;

import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.event.TextEvent;
import kiyut.sketsa.canvas.event.TextListener;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGTextElement;

public abstract class TextDocument {
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_ID = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_ID;
    protected VectorCanvas canvas;
    protected SVGTextElement element;
    protected EventListenerList listenerList = new EventListenerList();

    public void setSVGTextElement(SVGTextElement element) {
        this.element = element;
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    public SVGTextElement getSVGTextElement() {
        return this.element;
    }

    public void addTextListener(TextListener listener) {
        this.listenerList.add(TextListener.class, listener);
    }

    public void removeTextListener(TextListener listener) {
        this.listenerList.remove(TextListener.class, listener);
    }

    protected void fireInsertUpdate(TextEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TextListener.class) continue;
            ((TextListener)listeners[i + 1]).insertUpdate(e);
        }
    }

    protected void fireChangedUpdate(TextEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TextListener.class) continue;
            ((TextListener)listeners[i + 1]).changedUpdate(e);
        }
    }

    protected void fireRemoveUpdate(TextEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TextListener.class) continue;
            ((TextListener)listeners[i + 1]).removeUpdate(e);
        }
    }

    public int getLength() {
        TextNode textNode = (TextNode)this.canvas.getModel().getGraphicsNode((SVGElement)this.element);
        AttributedCharacterIterator aci = textNode.getAttributedCharacterIterator();
        int i = aci.getEndIndex();
        if (i > 0) {
            --i;
        }
        return i;
    }

    public SVGElement getSVGElement(int offset) {
        Object obj;
        TextNode textNode = (TextNode)this.canvas.getModel().getGraphicsNode((SVGElement)this.element);
        try {
            AttributedCharacterIterator aci = textNode.getAttributedCharacterIterator();
            aci.setIndex(offset);
            obj = aci.getAttribute(TEXT_COMPOUND_ID);
        }
        catch (NullPointerException ex) {
            obj = null;
        }
        SVGElement node = null;
        if (obj != null) {
            node = (SVGElement)((SoftReference)obj).get();
        }
        return node;
    }

    public abstract void insertString(int var1, String var2) throws BadLocationException;

    public abstract void remove(int var1, int var2) throws BadLocationException;

    public abstract void replace(int var1, int var2, String var3) throws BadLocationException;

    public abstract void insertNewLine(int var1) throws BadLocationException;

    public abstract void setCharacterAttributes(int var1, int var2, Map<String, String> var3) throws BadLocationException;
}

