/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.text;

import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import kiyut.sketsa.canvas.event.TextAdapter;
import kiyut.sketsa.canvas.event.TextEvent;
import kiyut.sketsa.canvas.text.DefaultTextDocument;
import kiyut.sketsa.canvas.text.TextCaret;
import kiyut.sketsa.canvas.text.TextEditor;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextSpanLayout;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGTextElement;

public class DefaultTextEditor
extends TextEditor {
    private int newX;
    private int newY;
    private Rectangle2D bounds = new Rectangle2D.Double();
    private SVGElement currentElement;
    private int keyCodePressed;

    public DefaultTextEditor() {
        this.caret = new TextCaret();
        this.document = new DefaultTextDocument();
        TextAdapter textListener = new TextAdapter(){

            @Override
            public void changedUpdate(TextEvent evt) {
                DefaultTextEditor.this.textChangedUpdate(evt);
            }

            @Override
            public void insertUpdate(TextEvent evt) {
                DefaultTextEditor.this.textInsertUpdate(evt);
            }

            @Override
            public void removeUpdate(TextEvent evt) {
                DefaultTextEditor.this.textRemoveUpdate(evt);
            }
        };
        this.document.addTextListener(textListener);
        CaretListener caretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                DefaultTextEditor.this.textCaretUpdate(evt);
            }
        };
        this.caret.addCaretListener(caretListener);
    }

    @Override
    public void stopEdit() {
        this.editable = false;
        this.currentElement = null;
        this.caret.setVisible(false);
        SVGTextElement elt = this.document.getSVGTextElement();
        ArrayList<SVGElement> list = new ArrayList<SVGElement>(1);
        if (elt != null) {
            list.add((SVGElement)elt);
        }
        this.canvas.getCanvasSelection().setSelectionList(list);
        this.setSVGTextElement(null);
    }

    @Override
    public void startEdit() {
        SVGTextElement element = this.document.getSVGTextElement();
        this.textNode = (TextNode)this.canvas.getModel().getGraphicsNode((SVGElement)element);
        this.caret.prepareCaret(this.canvas, this.textNode, 0);
        this.caret.setVisible(true);
        this.editable = true;
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode((SVGElement)element);
        if (gn != null) {
            AffineTransform at = gn.getGlobalTransform();
            Shape shape = gn.getBounds();
            shape = at.createTransformedShape(shape);
            this.bounds = shape.getBounds();
        }
    }

    private TextHit hitTestChar(double x, double y) {
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        srcPts[0] = x;
        srcPts[1] = y;
        AffineTransform at = this.canvas.getTransform(true);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        at.transform(srcPts, 0, dstPts, 0, 1);
        x = dstPts[0];
        y = dstPts[1];
        List textRuns = this.textNode.getTextRuns();
        for (int i = 0; i < textRuns.size(); ++i) {
            Rectangle2D lBounds;
            StrokingTextPainter.TextRun textRun = (StrokingTextPainter.TextRun)textRuns.get(i);
            TextSpanLayout layout = textRun.getLayout();
            TextHit textHit = layout.hitTestChar((float)x, (float)y);
            if (textHit == null || layout == null || (lBounds = layout.getBounds2D()) == null || !layout.getBounds2D().contains(x, y)) continue;
            return textHit;
        }
        return null;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        evt.consume();
        this.keyCodePressed = evt.getKeyCode();
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        evt.consume();
        int keyCode = evt.getKeyCode();
        int modifiers = evt.getModifiersEx();
        if (keyCode == 39 || keyCode == 227) {
            if (modifiers == 64) {
                this.caret.moveDot(this.caret.getDot() + 1);
            } else {
                this.caret.setDot(this.caret.getDot() + 1);
            }
        } else if (keyCode == 37 || keyCode == 226) {
            if (modifiers == 64) {
                this.caret.moveDot(this.caret.getDot() - 1);
            } else {
                this.caret.setDot(this.caret.getDot() - 1);
            }
        } else if (keyCode != 38 && keyCode != 224 && keyCode != 40 && keyCode != 225) {
            if (keyCode == 127) {
                int dot = this.caret.getDot();
                int mark = this.caret.getMark();
                try {
                    if (dot == mark) {
                        this.document.remove(dot, 1);
                    } else {
                        if (dot > mark) {
                            int swap = mark;
                            mark = dot;
                            dot = swap;
                        }
                        this.document.remove(dot, mark - dot);
                    }
                    this.caret.setDot(dot);
                }
                catch (BadLocationException ex) {}
            } else if (keyCode == 8) {
                int dot = this.caret.getDot();
                int mark = this.caret.getMark();
                int length = this.document.getLength();
                try {
                    if (mark == dot) {
                        dot = dot > length ? length : dot - 1;
                        dot = dot < 0 ? 0 : dot;
                        this.document.remove(dot, 1);
                    } else {
                        if (dot > mark) {
                            int swap = mark;
                            mark = dot;
                            dot = swap;
                        }
                        this.document.remove(dot, mark - dot);
                    }
                    this.caret.setDot(dot);
                }
                catch (BadLocationException ex) {}
            } else if (keyCode == 10) {
                int dot = this.caret.getDot();
                try {
                    this.document.insertNewLine(dot);
                    this.caret.setDot(dot);
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        if (this.keyCodePressed == 127 || this.keyCodePressed == 8 || this.keyCodePressed == 27) {
            return;
        }
        char keyChar = evt.getKeyChar();
        int dot = this.caret.getDot();
        int mark = this.caret.getMark();
        int len = 1;
        try {
            if (dot > mark) {
                int swap = mark;
                mark = dot;
                dot = swap;
            }
            len = mark - dot;
            this.document.replace(dot, len, keyChar + "");
            this.caret.setDot(dot + 1);
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        TextHit textHit = this.hitTestChar(this.newX, this.newY);
        if (textHit != null && this.caret.getDot() > -1) {
            this.caret.moveDot(textHit.getCharIndex() + 1);
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        srcPts[0] = this.newX;
        srcPts[1] = this.newY;
        AffineTransform at = this.canvas.getTransform(true);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            // empty catch block
        }
        at.transform(srcPts, 0, dstPts, 0, 1);
        Rectangle2D r = this.textNode.getBounds();
        if (r.contains(dstPts[0], dstPts[1])) {
            TextHit textHit = this.hitTestChar(this.newX, this.newY);
            if (textHit != null) {
                this.caret.setDot(textHit.getCharIndex());
            }
        } else {
            this.stopEdit();
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        TextHit textHit;
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        if (this.editable && (textHit = this.hitTestChar(this.newX, this.newY)) != null && this.caret.getDot() > -1) {
            this.caret.moveDot(textHit.getCharIndex());
        }
    }

    private void textInsertUpdate(TextEvent evt) {
        Rectangle2D newBounds = this.bounds;
        SVGTextElement elt = this.document.getSVGTextElement();
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode((SVGElement)elt);
        if (gn != null) {
            AffineTransform at = gn.getGlobalTransform();
            Shape shape = gn.getBounds();
            if (shape != null) {
                shape = at.createTransformedShape(shape);
                newBounds = shape.getBounds();
            } else {
                newBounds = this.bounds.getBounds2D();
            }
        }
        Rectangle2D.union(this.bounds, newBounds, this.bounds);
        this.canvas.refresh(this.bounds);
        this.bounds = newBounds;
    }

    private void textRemoveUpdate(TextEvent evt) {
        Rectangle2D newBounds = this.bounds;
        SVGTextElement elt = this.document.getSVGTextElement();
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode((SVGElement)elt);
        if (gn != null) {
            AffineTransform at = gn.getGlobalTransform();
            Shape shape = gn.getBounds();
            if (shape != null) {
                shape = at.createTransformedShape(shape);
                newBounds = shape.getBounds();
            }
        }
        Rectangle2D.union(this.bounds, newBounds, this.bounds);
        this.canvas.refresh(this.bounds);
        this.bounds = newBounds;
        if (elt == null) {
            this.stopEdit();
        }
    }

    private void textChangedUpdate(TextEvent evt) {
        if (this.isEditable()) {
            int mark;
            int dot = evt.getOffset();
            int iTemp = mark = evt.getOffset() + evt.getLength();
            mark = dot;
            dot = iTemp;
            this.caret.setDot(mark);
            this.caret.moveDot(dot);
        }
        Rectangle2D newBounds = this.bounds;
        SVGTextElement elt = this.document.getSVGTextElement();
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode((SVGElement)elt);
        if (gn != null) {
            AffineTransform at = gn.getGlobalTransform();
            Shape shape = gn.getBounds();
            shape = at.createTransformedShape(shape);
            newBounds = shape.getBounds();
        }
        Rectangle2D.union(this.bounds, newBounds, this.bounds);
        this.canvas.refresh(this.bounds);
        this.bounds = newBounds;
    }

    private void textCaretUpdate(CaretEvent evt) {
        SVGElement oldElement = this.currentElement;
        this.currentElement = this.document.getSVGElement(evt.getDot());
        if (this.currentElement == null) {
            return;
        }
        if (this.currentElement.equals(oldElement)) {
            return;
        }
        ArrayList<SVGElement> list = new ArrayList<SVGElement>(1);
        list.add(this.currentElement);
        this.canvas.getCanvasSelection().setSelectionList(list);
    }
}

