/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import kiyut.sketsa.canvas.CanvasSelectionTransferData;
import kiyut.sketsa.canvas.CanvasTransferData;
import kiyut.sketsa.canvas.CanvasTransferable;
import kiyut.sketsa.canvas.VectorCanvas;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;

public class CanvasTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent comp) {
        if (!(comp instanceof VectorCanvas)) {
            return 0;
        }
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent comp) {
        VectorCanvas canvas = (VectorCanvas)comp;
        List<SVGElement> selectionList = canvas.getCanvasSelection().getSelectionList();
        if (selectionList == null || selectionList.isEmpty()) {
            return null;
        }
        ArrayList<Node> newList = new ArrayList<Node>();
        for (int i = 0; i < selectionList.size(); ++i) {
            Node n = (Node)selectionList.get(i);
            Node copyNode = n.cloneNode(true);
            if (n instanceof SVGElement && n instanceof SVGTransformable) {
                AffineTransform at = canvas.getModel().getGraphicsNode((SVGElement)n).getGlobalTransform();
                SVGTransform transform = null;
                if (!at.isIdentity()) {
                    double[] values = new double[6];
                    at.getMatrix(values);
                    SVGMatrix matrix = canvas.getModel().getSVGDocument().getRootElement().createSVGMatrix();
                    matrix.setA((float)values[0]);
                    matrix.setB((float)values[1]);
                    matrix.setC((float)values[2]);
                    matrix.setD((float)values[3]);
                    matrix.setE((float)values[4]);
                    matrix.setF((float)values[5]);
                    transform = canvas.getModel().getSVGDocument().getRootElement().createSVGTransformFromMatrix(matrix);
                }
                if (transform != null) {
                    SVGTransformList childTransformList = ((SVGTransformable)copyNode).getTransform().getBaseVal();
                    childTransformList.clear();
                    childTransformList.appendItem(transform);
                }
            }
            newList.add(copyNode);
        }
        CanvasSelectionTransferData data = new CanvasSelectionTransferData(newList);
        CanvasTransferable transferable = new CanvasTransferable(data);
        return transferable;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        Object obj;
        boolean imported = false;
        if (!this.canImport(comp, t.getTransferDataFlavors())) {
            return imported;
        }
        try {
            obj = t.getTransferData(CanvasTransferable.CANVAS_DATA_FLAVOR);
        }
        catch (UnsupportedFlavorException ex) {
            return imported;
        }
        catch (IOException ex) {
            return imported;
        }
        CanvasTransferData data = (CanvasTransferData)obj;
        imported = data.importData(comp, t);
        return imported;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        boolean b = false;
        for (int i = 0; i < transferFlavors.length; ++i) {
            if (!transferFlavors[i].equals(CanvasTransferable.CANVAS_DATA_FLAVOR)) continue;
            b = true;
            break;
        }
        return b;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        Object obj;
        if (action != 2) {
            return;
        }
        try {
            obj = data.getTransferData(CanvasTransferable.CANVAS_DATA_FLAVOR);
        }
        catch (UnsupportedFlavorException ex) {
            obj = null;
        }
        catch (IOException ex) {
            obj = null;
        }
        if (obj instanceof CanvasTransferData) {
            ((CanvasTransferData)obj).exportDone(source, data, action);
        }
    }
}

