/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import kiyut.sketsa.canvas.VectorCanvas;

public class CanvasBackground {
    private VectorCanvas canvas;
    private boolean visible = false;
    protected Image image;
    protected Image imageCache;
    protected int horizontalAlignment = 0;
    protected int verticalAlignment = 0;
    protected String imagePath;

    public void paint(Graphics2D g2d) {
        if (!this.visible) {
            return;
        }
        if (this.imageCache == null) {
            return;
        }
        Dimension dim = this.canvas.getPreferredSize();
        if (dim == null) {
            return;
        }
        double canvasW = dim.getWidth();
        double canvasH = dim.getHeight();
        int x = 0;
        int y = 0;
        int w = this.imageCache.getWidth(null);
        int h = this.imageCache.getHeight(null);
        if (this.horizontalAlignment == 0) {
            x = (int)Math.round((canvasW - (double)w) / 2.0);
        } else if (this.horizontalAlignment == 4) {
            x = (int)(canvasW - (double)w);
        }
        if (this.verticalAlignment == 0) {
            y = (int)Math.round((canvasH - (double)h) / 2.0);
        } else if (this.verticalAlignment == 3) {
            y = (int)(canvasH - (double)h);
        }
        g2d.drawImage(this.imageCache, x, y, null);
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
        canvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CanvasBackground.this.updateImageCache();
            }
        });
    }

    protected void updateImageCache() {
        if (this.image == null) {
            this.imageCache = null;
            return;
        }
        double zoomFactor = this.canvas.getZoomFactor();
        if (zoomFactor == 1.0) {
            this.imageCache = this.image;
        } else {
            int w = (int)Math.ceil((double)this.image.getWidth(null) * zoomFactor);
            int h = (int)Math.ceil((double)this.image.getHeight(null) * zoomFactor);
            this.imageCache = this.image.getScaledInstance(w, h, 1);
        }
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setImage(Image image) {
        this.image = image;
        this.updateImageCache();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImagePath(String path) {
        this.imagePath = path;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setHorizontalAlignment(int alignment) {
        this.horizontalAlignment = alignment;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int alignment) {
        this.verticalAlignment = alignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }
}

