/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.actions;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import kiyut.sketsa.io.SVGFileFilter;
import kiyut.sketsa.util.IOUtilities;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;

public final class OpenAction
extends CallableSystemAction {
    public void performAction() {
        SVGFileFilter filter = new SVGFileFilter();
        JFileChooser fc = IOUtilities.getFileChooser();
        fc.setFileFilter(filter);
        fc.setFileSelectionMode(0);
        int choice = fc.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (choice != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        IOUtilities.setUserDir(file);
        try {
            DataObject data = DataObject.find((FileObject)FileUtil.toFileObject((File)file));
            OpenCookie cookie = (OpenCookie)data.getCookie(OpenCookie.class);
            cookie.open();
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public String getName() {
        return NbBundle.getMessage(OpenAction.class, (String)"CTL_OpenAction");
    }

    protected String iconResource() {
        return NbBundle.getMessage(OpenAction.class, (String)"ICON_OpenAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

