/*
 * Decompiled with CFR 0.152.
 */
package org.gtk.laf.extended;

import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthStyleFactory;
import org.gtk.laf.extended.GTKExtendedUI;

public class GTKLookAndFeelExtended
extends GTKLookAndFeel
implements PropertyChangeListener {
    private static Font customFont = null;

    @Override
    public String getID() {
        return "GTK extended";
    }

    @Override
    public String getName() {
        return "GTK look and feel extended";
    }

    @Override
    public String getDescription() {
        return "GTK look and feel extended";
    }

    public static Font getCustomFont() {
        return customFont;
    }

    public static void setCustomFont(Font customFont) {
        GTKLookAndFeelExtended.customFont = customFont;
    }

    @Override
    public void initialize() {
        super.initialize();
        GTKLookAndFeelExtended.applayGTKLookAndFeelExtendImp();
        UIManager.addPropertyChangeListener(this);
    }

    @Override
    public void uninitialize() {
        UIManager.removePropertyChangeListener(this);
        GTKLookAndFeelExtended.unapplyGTKLookAndFeelExtended();
        super.uninitialize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("lookAndFeel".equals(evt.getPropertyName())) {
            GTKLookAndFeelExtended.installGTKCustomFontAditionals();
        }
    }

    public static void applayGTKLookAndFeelExtended() {
        GTKLookAndFeelExtended.installGTKMenuBorders();
        GTKLookAndFeelExtended.loadDefaultFont();
        GTKLookAndFeelExtended.installGTKCustomFonts();
        GTKLookAndFeelExtended.installGTKCustomFontAditionals();
    }

    private static void applayGTKLookAndFeelExtendImp() {
        GTKLookAndFeelExtended.installGTKMenuBorders();
        GTKLookAndFeelExtended.loadDefaultFont();
        GTKLookAndFeelExtended.installGTKCustomFonts();
    }

    public static void unapplyGTKLookAndFeelExtended() {
        try {
            LookAndFeel laf = UIManager.getLookAndFeel();
            Class<?> lafClass = laf.getClass();
            if (lafClass.getName().equals(GTKLookAndFeelExtended.class.getName())) {
                Method m = lafClass.getSuperclass().getDeclaredMethod("getGTKStyleFactory", new Class[0]);
                m.setAccessible(true);
                GTKLookAndFeelExtended.setStyleFactory((SynthStyleFactory)m.invoke((Object)laf, new Object[0]));
                m.setAccessible(false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void installGTKMenuBorders() {
        if (!"false".equals(System.getProperty("laf.extended.gtkmenuborder"))) {
            try {
                GTKLookAndFeelExtended.changeGtkYThikcness(GTKLookAndFeelExtended.getStyle(null, Region.POPUP_MENU), 1);
                GTKLookAndFeelExtended.changeGtkXThikcness(GTKLookAndFeelExtended.getStyle(null, Region.POPUP_MENU), 1);
                GTKLookAndFeelExtended.changeGtkYThikcness(GTKLookAndFeelExtended.getStyle(null, Region.POPUP_MENU_SEPARATOR), 1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void installGTKCustomFonts() {
        if (GTKLookAndFeelExtended.getCustomFont() != null) {
            try {
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.ARROW_BUTTON), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.BUTTON), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.CHECK_BOX), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.CHECK_BOX_MENU_ITEM), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.COLOR_CHOOSER), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.COMBO_BOX), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.DESKTOP_ICON), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.DESKTOP_PANE), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.EDITOR_PANE), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.FILE_CHOOSER), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.FORMATTED_TEXT_FIELD), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.INTERNAL_FRAME), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.INTERNAL_FRAME_TITLE_PANE), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.LABEL), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.LIST), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.MENU), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.MENU_BAR), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.MENU_ITEM), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.MENU_ITEM_ACCELERATOR), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.OPTION_PANE), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.PANEL), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.PASSWORD_FIELD), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.POPUP_MENU), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.POPUP_MENU_SEPARATOR), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.PROGRESS_BAR), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.RADIO_BUTTON), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.RADIO_BUTTON_MENU_ITEM), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.ROOT_PANE), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.SCROLL_BAR), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.SCROLL_BAR_THUMB), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.SCROLL_BAR_TRACK), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.SCROLL_PANE), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.SEPARATOR), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.SLIDER), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.SLIDER_THUMB), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.SLIDER_TRACK), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.SPINNER), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.SPLIT_PANE), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.SPLIT_PANE_DIVIDER), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TABBED_PANE), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TABBED_PANE_CONTENT), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TABBED_PANE_TAB), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TABBED_PANE_TAB_AREA), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TABLE), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TABLE_HEADER), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TEXT_AREA), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TEXT_FIELD), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TEXT_PANE), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TOGGLE_BUTTON), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TOOL_BAR), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TOOL_BAR_CONTENT), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TOOL_BAR_DRAG_WINDOW), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TOOL_BAR_SEPARATOR), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TOOL_TIP), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TREE), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.TREE_CELL), GTKLookAndFeelExtended.getCustomFont());
                GTKLookAndFeelExtended.changeGtkFont(GTKLookAndFeelExtended.getStyle(null, Region.VIEWPORT), GTKLookAndFeelExtended.getCustomFont());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void installGTKCustomFontAditionals() {
        if (GTKLookAndFeelExtended.getCustomFont() != null) {
            try {
                BorderFactory.createTitledBorder("");
                UIManager.put("ButtonUI", GTKExtendedUI.class.getName());
                UIManager.put("ToggleButtonUI", GTKExtendedUI.class.getName());
                UIManager.put("CheckBoxUI", GTKExtendedUI.class.getName());
                UIManager.put("RadioButtonUI", GTKExtendedUI.class.getName());
                UIManager.put("TitledBorder.font", GTKLookAndFeelExtended.getCustomFont());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void loadDefaultFont() {
        if (System.getProperty("laf.extended.gtkfont") != null && customFont == null) {
            try {
                String[] param = System.getProperty("laf.extended.gtkfont").split(":");
                customFont = new Font(param[0], "BOLD".equals(param[1]) ? 1 : 0, Integer.parseInt(param[2]));
            }
            catch (Exception e) {
                customFont = null;
            }
        }
    }

    private static void changeGtkYThikcness(Object style, int border) throws Exception {
        Field field = style.getClass().getDeclaredField("yThickness");
        field.setAccessible(true);
        field.setInt(style, Math.max(border, field.getInt(style)));
        field.setAccessible(false);
    }

    private static void changeGtkXThikcness(Object style, int border) throws Exception {
        Field field = style.getClass().getDeclaredField("xThickness");
        field.setAccessible(true);
        field.setInt(style, Math.max(border, field.getInt(style)));
        field.setAccessible(false);
    }

    private static void changeGtkFont(Object style, Font newFont) throws Exception {
        Field fieldFont = style.getClass().getDeclaredField("font");
        fieldFont.setAccessible(true);
        fieldFont.set(style, newFont);
        fieldFont.setAccessible(false);
    }
}

