/*
 * Decompiled with CFR 0.152.
 */
package kiyut.swing.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class ComboToggleButton
extends JToggleButton {
    protected JPopupMenu popupMenu;
    protected JMenuItem selectedItem;
    protected Timer timer;
    protected int delay = 500;
    private MouseInputListener componentMouseInputListener = new MouseInputAdapter(){

        @Override
        public void mousePressed(MouseEvent evt) {
            ComboToggleButton.this.componentMousePressed(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            ComboToggleButton.this.componentMouseReleased(evt);
        }
    };
    private ActionListener timerActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ComboToggleButton.this.timerActionPerformed(evt);
        }
    };
    private ItemListener popupMenuItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent evt) {
            ComboToggleButton.this.popupMenuItemStateChanged(evt);
        }
    };

    public ComboToggleButton() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent evt) {
                ComboToggleButton.this.popupMenuComponentAdded(evt);
            }

            @Override
            public void componentRemoved(ContainerEvent evt) {
                ComboToggleButton.this.popupMenuComponentRemoved(evt);
            }
        });
        this.timer = new Timer(this.delay, this.timerActionListener);
        this.addMouseListener(this.componentMouseInputListener);
        this.addMouseMotionListener(this.componentMouseInputListener);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int w = this.getWidth();
        int h = this.getHeight();
        Paint oldPaint = g2d.getPaint();
        g2d.setPaint(Color.BLACK);
        int[] xPoints = new int[]{w - 4, w - 4, w - 10};
        int[] yPoints = new int[]{h - 4, h - 10, h - 4};
        g2d.fillPolygon(xPoints, yPoints, xPoints.length);
        g2d.setPaint(oldPaint);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupVisible(boolean v) {
        if (v) {
            this.showPopup();
        } else {
            this.hidePopup();
        }
    }

    public boolean isPopupVisible() {
        return this.popupMenu.isVisible();
    }

    public void showPopup() {
        if (!this.isPopupVisible()) {
            this.popupMenu.show(this, this.getWidth(), 0);
        }
    }

    public void hidePopup() {
        this.popupMenu.setVisible(false);
    }

    @Override
    public Action getAction() {
        if (this.selectedItem != null) {
            return this.selectedItem.getAction();
        }
        return super.getAction();
    }

    protected void componentMousePressed(MouseEvent evt) {
        this.timer.start();
    }

    protected void componentMouseReleased(MouseEvent evt) {
        this.timer.stop();
    }

    protected void componentItemStateChanged(ItemEvent evt) {
        if (this.selectedItem == null) {
            return;
        }
        if (evt.getStateChange() == 1) {
            this.selectedItem.setSelected(true);
        }
    }

    protected void timerActionPerformed(ActionEvent evt) {
        this.timer.stop();
        this.showPopup();
    }

    protected void popupMenuComponentAdded(ContainerEvent evt) {
        Component comp = evt.getChild();
        if (comp instanceof JRadioButtonMenuItem) {
            JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)comp;
            menuItem.addItemListener(this.popupMenuItemListener);
        }
    }

    protected void popupMenuComponentRemoved(ContainerEvent evt) {
        Component comp = evt.getChild();
        if (comp instanceof JRadioButtonMenuItem) {
            JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)comp;
            menuItem.removeItemListener(this.popupMenuItemListener);
        }
    }

    public void popupMenuItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 1) {
            return;
        }
        this.hidePopup();
        JMenuItem menuItem = (JMenuItem)evt.getSource();
        this.setIcon(menuItem.getIcon());
        this.setToolTipText(menuItem.getText());
        this.selectedItem = menuItem;
        if (!this.isSelected()) {
            this.setSelected(true);
        }
        this.repaint();
    }
}

