/*
 * Decompiled with CFR 0.152.
 */
package kiyut.swing.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class ColorChooserButton
extends JButton {
    protected Color color;

    public ColorChooserButton() {
        this.setText("");
        this.setIcon(new ColorIcon());
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (this.color != color) {
            this.color = color;
            this.repaint();
        }
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        Color newColor = JColorChooser.showDialog(this, "Choose Color", this.getColor());
        if (newColor != null) {
            this.setColor(newColor);
        }
        super.fireActionPerformed(event);
    }

    public class ColorIcon
    implements Icon {
        private int inset = 2;

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            ColorChooserButton comp = (ColorChooserButton)c;
            if (comp.getColor() == null) {
                return;
            }
            Dimension size = comp.getSize();
            g.setColor(comp.getColor());
            g.fillRect(y += this.inset, y, size.width - y * 2, size.height - y * 2);
        }
    }
}

