/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.textstyle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import kiyut.sketsa.canvas.CanvasSelection;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.event.CanvasSelectionAdapter;
import kiyut.sketsa.canvas.event.CanvasSelectionEvent;
import kiyut.sketsa.canvas.text.TextCaret;
import kiyut.sketsa.canvas.text.TextDocument;
import kiyut.sketsa.options.FontSetOptions;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.textstyle.FontChooserPane;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGStylable;
import org.w3c.dom.svg.SVGTextContentElement;

public class TextStyleProperties
extends JPanel {
    private ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.windows.textstyle.TextStyleProperties");
    private String EDIT_FONT_LIST = this.bundle.getString("EDIT_FONT_LIST");
    private boolean editing;
    private boolean refreshing;
    private VectorCanvas canvas;
    private CaretListener caretListener;
    private CanvasSelectionHandler canvasSelectionHandler;
    private SVGElement element;
    private int viewIndex = 0;
    private JPanel emptyPane;
    private JScrollPane fontScrollPane;
    private JComboBox fontSetCombo;
    private JComboBox fontSizeCombo;
    private JComboBox fontStretchCombo;
    private JComboBox fontStyleCombo;
    private JComboBox fontVariantCombo;
    private JComboBox fontWeightCombo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JTabbedPane tabPane;
    private JComboBox textAnchorCombo;
    private JComboBox textDecorationCombo;
    private JScrollPane textScrollPane;

    public TextStyleProperties() {
        this.initComponents();
        this.initCustomComponents();
        FontSetOptions.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!evt.getPropertyName().equals("font_set")) {
                    return;
                }
                TextStyleProperties.this.refreshing = true;
                try {
                    TextStyleProperties.this.refreshFontSetCombo();
                }
                finally {
                    TextStyleProperties.this.refreshing = false;
                }
            }
        });
        this.editing = false;
        this.refreshing = false;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.tabPane = new JTabbedPane();
        this.fontScrollPane = new JScrollPane();
        this.jPanel6 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.fontSetCombo = new JComboBox();
        this.fontSizeCombo = new JComboBox();
        this.fontWeightCombo = new JComboBox();
        this.fontStyleCombo = new JComboBox();
        this.fontVariantCombo = new JComboBox();
        this.fontStretchCombo = new JComboBox();
        this.jPanel5 = new JPanel();
        this.textScrollPane = new JScrollPane();
        this.jPanel7 = new JPanel();
        this.jLabel4 = new JLabel();
        this.textDecorationCombo = new JComboBox();
        this.jLabel5 = new JLabel();
        this.textAnchorCombo = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jPanel2.setLayout(new GridBagLayout());
        this.setLayout(new BorderLayout());
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.jPanel6.setLayout(new GridBagLayout());
        this.jLabel1.setText(this.bundle.getString("CTL_Size.Text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.jPanel6.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(this.bundle.getString("CTL_Style.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.jPanel6.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(this.bundle.getString("CTL_Weight.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.jPanel6.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel7.setText(this.bundle.getString("CTL_Variant.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.jPanel6.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText(this.bundle.getString("CTL_Stretch.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.jPanel6.add((Component)this.jLabel8, gridBagConstraints);
        this.fontSetCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextStyleProperties.this.fontSetComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel6.add((Component)this.fontSetCombo, gridBagConstraints);
        this.fontSizeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"6", "7", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "60", "72", "xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large", "larger", "smaller"}));
        this.fontSizeCombo.setSelectedIndex(6);
        this.fontSizeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextStyleProperties.this.fontSizeComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel6.add((Component)this.fontSizeCombo, gridBagConstraints);
        this.fontWeightCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"normal", "bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900"}));
        this.fontWeightCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextStyleProperties.this.fontWeightComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel6.add((Component)this.fontWeightCombo, gridBagConstraints);
        this.fontStyleCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"normal", "italic", "oblique"}));
        this.fontStyleCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextStyleProperties.this.fontStyleComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel6.add((Component)this.fontStyleCombo, gridBagConstraints);
        this.fontVariantCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"normal", "small-caps"}));
        this.fontVariantCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextStyleProperties.this.fontVariantComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel6.add((Component)this.fontVariantCombo, gridBagConstraints);
        this.fontStretchCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"normal", "wider", "narrower", "ultra-condensed", "extra-condensed", "condensed", "semi-condensed", "semi-expanded", "expanded", "extra-expanded", "ultra-expanded"}));
        this.fontStretchCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextStyleProperties.this.fontStretchComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel6.add((Component)this.fontStretchCombo, gridBagConstraints);
        this.jPanel5.setMinimumSize(new Dimension(1, 1));
        this.jPanel5.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel5, gridBagConstraints);
        this.fontScrollPane.setViewportView(this.jPanel6);
        this.tabPane.addTab(this.bundle.getString("CTL_Font.Text"), this.fontScrollPane);
        this.jPanel7.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.jPanel7.setLayout(new GridBagLayout());
        this.jLabel4.setText(this.bundle.getString("CTL_Decoration.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.jPanel7.add((Component)this.jLabel4, gridBagConstraints);
        this.textDecorationCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "underline", "overline", "line-through", "blink"}));
        this.textDecorationCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextStyleProperties.this.textDecorationComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel7.add((Component)this.textDecorationCombo, gridBagConstraints);
        this.jLabel5.setText(this.bundle.getString("CTL_Anchor.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.jPanel7.add((Component)this.jLabel5, gridBagConstraints);
        this.textAnchorCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"start", "middle", "end"}));
        this.textAnchorCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TextStyleProperties.this.textAnchorComboItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel7.add((Component)this.textAnchorCombo, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(1, 1));
        this.jPanel1.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.jPanel1, gridBagConstraints);
        this.textScrollPane.setViewportView(this.jPanel7);
        this.tabPane.addTab(this.bundle.getString("CTL_Text.Text"), this.textScrollPane);
        this.add((Component)this.tabPane, "Center");
    }

    private void textAnchorComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        String value = (String)this.textAnchorCombo.getSelectedItem();
        if (value.equals("start")) {
            value = null;
        }
        this.updateDOM("text-anchor", value);
    }

    private void fontVariantComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        String value = (String)this.fontVariantCombo.getSelectedItem();
        if (value.equals("normal")) {
            value = null;
        }
        this.updateDOM("font-variant", value);
    }

    private void fontStretchComboItemStateChanged(ItemEvent evt) {
        if (this.refreshing) {
            return;
        }
        String value = (String)this.fontStretchCombo.getSelectedItem();
        if (value.equals("normal")) {
            value = null;
        }
        this.updateDOM("font-stretch", value);
    }

    private void textDecorationComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        String value = (String)this.textDecorationCombo.getSelectedItem();
        if (value.equals("none")) {
            value = null;
        }
        this.updateDOM("text-decoration", value);
    }

    private void fontStyleComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        String value = (String)this.fontStyleCombo.getSelectedItem();
        if (value.equals("normal")) {
            value = null;
        }
        this.updateDOM("font-style", value);
    }

    private void fontWeightComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        String value = (String)this.fontWeightCombo.getSelectedItem();
        if (value.equals("normal") || value.equals("400")) {
            value = null;
        }
        this.updateDOM("font-weight", value);
    }

    private void fontSetComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        String fontSet = (String)this.fontSetCombo.getSelectedItem();
        if (fontSet.equalsIgnoreCase(this.EDIT_FONT_LIST)) {
            this.fontSetCombo.hidePopup();
            this.editFontList();
            return;
        }
        StringBuilder sb = new StringBuilder();
        List<String> list = FontSetOptions.stringToList(fontSet);
        for (int i = 0; i < list.size(); ++i) {
            String str = list.get(i);
            if (str.equals("serif") || str.equals("sans-serif") || str.equals("cursive") || str.equals("fantasy") || str.equals("monospace")) {
                sb.append(str + ", ");
                continue;
            }
            sb.append("\"" + str + "\", ");
        }
        fontSet = sb.length() > 0 ? sb.substring(0, sb.length() - 2) : null;
        this.updateDOM("font-family", fontSet);
    }

    private void fontSizeComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        String item = null;
        try {
            item = ((String)this.fontSizeCombo.getSelectedItem()).trim();
            if (!(item.equals("xx-small") || item.equals("x-small") || item.equals("small") || item.equals("medium") || item.equals("large") || item.equals("x-large") || item.equals("xx-large") || item.equals("larger") || item.equals("smaller"))) {
                if (item.length() == 0) {
                    item = null;
                } else {
                    Number number = DataTypeUtilities.validateLength(item);
                    if (number.floatValue() < 0.0f) {
                        throw new RuntimeException(this.bundle.getString("MSG_InvalidValue.Text"));
                    }
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("MSG_InvalidValue.Text"), this.bundle.getString("MSG_InvalidValue.Title"), 0);
            return;
        }
        this.updateDOM("font-size", item);
    }

    private void initCustomComponents() {
        this.refreshing = true;
        this.emptyPane = new JPanel();
        this.refreshFontSetCombo();
        this.caretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                TextStyleProperties.this.textCaretUpdate(evt.getDot(), evt.getMark());
            }
        };
        this.refreshing = false;
        this.fontSetCombo.setPrototypeDisplayValue(this.EDIT_FONT_LIST);
        this.fontSizeCombo.setPrototypeDisplayValue("medium");
        this.fontWeightCombo.setPrototypeDisplayValue("normal");
        this.fontStyleCombo.setPrototypeDisplayValue("normal");
        this.fontVariantCombo.setPrototypeDisplayValue("normal");
        this.fontStretchCombo.setPrototypeDisplayValue("normal");
        this.textDecorationCombo.setPrototypeDisplayValue("none");
        this.textAnchorCombo.setPrototypeDisplayValue("start");
        this.canvasSelectionHandler = new CanvasSelectionHandler();
        this.tabPane.setEnabled(false);
        this.fontSetCombo.setEditable(true);
        this.fontSizeCombo.setEditable(true);
        this.updatePropertyEditor();
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        TextCaret caret;
        VectorCanvas oldCanvas = this.canvas;
        if (oldCanvas != null) {
            oldCanvas.getCanvasSelection().removeSelectionListener(this.canvasSelectionHandler);
            caret = oldCanvas.getTextEditor().getCaret();
            caret.removeCaretListener(this.caretListener);
        }
        this.canvas = canvas;
        if (canvas == null) {
            this.element = null;
            this.updatePropertyEditor();
            return;
        }
        this.element = null;
        caret = canvas.getTextEditor().getCaret();
        caret.addCaretListener(this.caretListener);
        CanvasSelection canvasSelection = canvas.getCanvasSelection();
        canvasSelection.addSelectionListener(this.canvasSelectionHandler);
        if (canvas.getTextEditor().isEditable() && caret != null) {
            this.textCaretUpdate(caret.getDot(), caret.getMark());
        }
        this.updatePropertyEditor();
    }

    @Deprecated
    public void refreshProperty() {
        this.refreshProperties();
    }

    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        CSSStyleDeclaration cssStyle = ((SVGStylable)this.element).getStyle();
        ViewCSS viewCSS = (ViewCSS)((Object)this.element.getOwnerDocument().getDocumentElement());
        CSSStyleDeclaration computedStyle = viewCSS.getComputedStyle((Element)this.element, null);
        String str = cssStyle.getPropertyValue("font-family");
        if (str.length() == 0) {
            str = this.element.getAttributeNS(null, "font-family");
        }
        this.fontSetCombo.setSelectedItem(this.formatCSSFont(str));
        str = cssStyle.getPropertyValue("font-size");
        if (str.length() == 0) {
            str = this.element.getAttributeNS(null, "font-size");
        }
        this.fontSizeCombo.setSelectedItem(str);
        str = computedStyle.getPropertyValue("font-weight");
        this.fontWeightCombo.setSelectedItem(str);
        str = computedStyle.getPropertyValue("font-style");
        this.fontStyleCombo.setSelectedItem(str);
        str = computedStyle.getPropertyValue("font-variant");
        this.fontVariantCombo.setSelectedItem(str);
        str = computedStyle.getPropertyValue("font-stretch");
        this.fontStretchCombo.setSelectedItem(str);
        str = computedStyle.getPropertyValue("text-decoration");
        this.textDecorationCombo.setSelectedItem(str);
        str = computedStyle.getPropertyValue("text-anchor");
        this.textAnchorCombo.setSelectedItem(str);
        this.refreshing = false;
    }

    private void refreshFontSetCombo() {
        this.fontSetCombo.removeAllItems();
        List<List<String>> fontSetList = FontSetOptions.getInstance().getFontSetList();
        for (int i = 0; i < fontSetList.size(); ++i) {
            List<String> subList = fontSetList.get(i);
            this.fontSetCombo.addItem(FontSetOptions.listToString(subList));
        }
        this.fontSetCombo.addItem(this.EDIT_FONT_LIST);
    }

    private void updatePropertyEditor() {
        if (this.tabPane.isEnabled()) {
            this.viewIndex = this.tabPane.getSelectedIndex();
        }
        if (this.element == null || this.canvas == null) {
            this.tabPane.setComponentAt(0, this.emptyPane);
            this.tabPane.setSelectedIndex(0);
            this.tabPane.setEnabled(false);
        } else {
            this.tabPane.setComponentAt(0, this.fontScrollPane);
            this.tabPane.validate();
            this.tabPane.setEnabled(true);
            this.tabPane.setSelectedIndex(this.viewIndex);
        }
        this.repaint();
    }

    private void editFontList() {
        FontSetOptions opts = FontSetOptions.getInstance();
        List<List<String>> fontSetList = opts.getFontSetList();
        FontChooserPane.showDialog(this.fontSetCombo, fontSetList, true);
    }

    private String formatCSSFont(String string) {
        List<String> list = FontSetOptions.stringToList(string);
        String formatedItem = FontSetOptions.listToString(list);
        return formatedItem;
    }

    private void textCaretUpdate(int dot, int mark) {
        if (dot < 0 || mark < 0) {
            this.element = null;
            this.updatePropertyEditor();
        } else {
            SVGElement newElement = this.canvas.getTextEditor().getDocument().getSVGElement(dot);
            if (newElement != null && !newElement.equals(this.element)) {
                this.element = newElement;
                this.refreshProperties();
                this.updatePropertyEditor();
            }
        }
    }

    protected void updateDOM(String name, String value) {
        if (this.element == null) {
            return;
        }
        HashMap<String, String> attrMap = new HashMap<String, String>();
        attrMap.put(name, value);
        this.updateDOM(attrMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDOM(Map<String, String> attrMap) {
        int mark;
        TextCaret caret = this.canvas.getTextEditor().getCaret();
        int dot = caret.getDot();
        if (dot == (mark = caret.getMark())) {
            return;
        }
        this.editing = true;
        try {
            int start = Math.min(mark, dot);
            int end = Math.max(mark, dot);
            TextDocument textDocument = this.canvas.getTextEditor().getDocument();
            textDocument.setCharacterAttributes(start, end - start, attrMap);
        }
        catch (BadLocationException ex) {
        }
        finally {
            this.editing = false;
        }
    }

    private class CanvasSelectionHandler
    extends CanvasSelectionAdapter {
        private CanvasSelectionHandler() {
        }

        @Override
        public void valueChanged(CanvasSelectionEvent e) {
            List<SVGElement> selectionList = e.getSelectionList();
            if (selectionList.size() == 0) {
                TextStyleProperties.this.element = null;
            } else if (selectionList.size() == 1) {
                if (TextStyleProperties.this.canvas == null) {
                    return;
                }
                if (selectionList.get(0) instanceof SVGTextContentElement) {
                    TextStyleProperties.this.element = (SVGElement)((SVGTextContentElement)selectionList.get(0));
                }
            }
        }
    }
}

