/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties.geometry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.properties.geometry.ElementGeometryProperties;
import org.w3c.dom.svg.SVGPreserveAspectRatio;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGGeometryProperties
extends ElementGeometryProperties {
    private boolean editing = false;
    private boolean refreshing = false;
    private JPanel attributePane;
    private JTextField hField;
    private JLabel jLabel7;
    private JComboBox preserveAspectRatioAlignCombo;
    private JComboBox preserveAspectRatioMeetOrSliceCombo;
    private JButton viewBoxClearButton;
    private JTextField viewBoxHeightField;
    private JLabel viewBoxLabel;
    private JTextField viewBoxMinXField;
    private JTextField viewBoxMinYField;
    private JPanel viewBoxPane;
    private JTextField viewBoxWidthField;
    private JTextField wField;
    private JTextField xField;
    private JTextField yField;

    public SVGGeometryProperties() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.attributePane = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.xField = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.yField = new JTextField();
        JLabel jLabel4 = new JLabel();
        this.wField = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.hField = new JTextField();
        this.viewBoxLabel = new JLabel();
        this.viewBoxPane = new JPanel();
        this.viewBoxMinXField = new JTextField();
        this.viewBoxMinYField = new JTextField();
        this.viewBoxWidthField = new JTextField();
        this.viewBoxHeightField = new JTextField();
        this.viewBoxClearButton = new JButton();
        this.jLabel7 = new JLabel();
        this.preserveAspectRatioAlignCombo = new JComboBox();
        this.preserveAspectRatioMeetOrSliceCombo = new JComboBox();
        this.setLayout(new BorderLayout());
        this.attributePane.setLayout(new GridBagLayout());
        jLabel2.setText("x");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.attributePane.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.attributePane.add((Component)this.xField, gridBagConstraints);
        jLabel3.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.yField, gridBagConstraints);
        jLabel4.setText("w");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.wField, gridBagConstraints);
        jLabel5.setText("h");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.hField, gridBagConstraints);
        this.viewBoxLabel.setText("viewBox");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.attributePane.add((Component)this.viewBoxLabel, gridBagConstraints);
        this.viewBoxPane.setLayout(new GridLayout(1, 0));
        this.viewBoxPane.add(this.viewBoxMinXField);
        this.viewBoxPane.add(this.viewBoxMinYField);
        this.viewBoxPane.add(this.viewBoxWidthField);
        this.viewBoxPane.add(this.viewBoxHeightField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.viewBoxPane, gridBagConstraints);
        this.viewBoxClearButton.setText("clear viewBox");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.viewBoxClearButton, gridBagConstraints);
        this.jLabel7.setText("preserveAspectRatio");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.jLabel7, gridBagConstraints);
        this.preserveAspectRatioAlignCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "xMinYMin", "xMidYMin", "xMaxYMin", "xMinYMid", "xMidYMid", "xMaxYMid", "xMinYMax", "xMidYMax", "xMaxYMax"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.attributePane.add((Component)this.preserveAspectRatioAlignCombo, gridBagConstraints);
        this.preserveAspectRatioMeetOrSliceCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"meet", "slice"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.attributePane.add((Component)this.preserveAspectRatioMeetOrSliceCombo, gridBagConstraints);
        this.add((Component)this.attributePane, "First");
    }

    private void initCustomComponents() {
        ActionListener geomFieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGGeometryProperties.this.geomFieldActionPerformed(evt);
            }
        };
        this.xField.addActionListener(geomFieldActionHandler);
        this.yField.addActionListener(geomFieldActionHandler);
        this.wField.addActionListener(geomFieldActionHandler);
        this.hField.addActionListener(geomFieldActionHandler);
        ActionListener viewBoxFieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGGeometryProperties.this.viewBoxFieldActionPerformed(evt);
            }
        };
        this.viewBoxMinXField.addActionListener(viewBoxFieldActionHandler);
        this.viewBoxMinYField.addActionListener(viewBoxFieldActionHandler);
        this.viewBoxWidthField.addActionListener(viewBoxFieldActionHandler);
        this.viewBoxHeightField.addActionListener(viewBoxFieldActionHandler);
        this.viewBoxClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVGGeometryProperties.this.viewBoxClearActionPerformed(evt);
            }
        });
        this.preserveAspectRatioAlignCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SVGGeometryProperties.this.preserveAspectRatioItemStateChanged(evt);
            }
        });
        this.preserveAspectRatioMeetOrSliceCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SVGGeometryProperties.this.preserveAspectRatioItemStateChanged(evt);
            }
        });
        this.preserveAspectRatioAlignCombo.setPrototypeDisplayValue("xMaxYMax");
        this.preserveAspectRatioMeetOrSliceCombo.setPrototypeDisplayValue("meet");
    }

    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        SVGSVGElement elt = (SVGSVGElement)this.element;
        this.refreshing = true;
        try {
            this.xField.setText(elt.getAttributeNS(null, "x"));
        }
        catch (Exception ex) {
            this.xField.setText("");
        }
        try {
            this.yField.setText(elt.getAttributeNS(null, "y"));
        }
        catch (Exception ex) {
            this.yField.setText("");
        }
        try {
            this.wField.setText(elt.getAttributeNS(null, "width"));
        }
        catch (Exception ex) {
            this.wField.setText("");
        }
        try {
            this.hField.setText(elt.getAttributeNS(null, "height"));
        }
        catch (Exception ex) {
            this.hField.setText("");
        }
        try {
            String[] values = DataTypeUtilities.parseViewBox(elt.getAttributeNS(null, "viewBox"));
            this.viewBoxMinXField.setText(values[0]);
            this.viewBoxMinYField.setText(values[1]);
            this.viewBoxWidthField.setText(values[2]);
            this.viewBoxHeightField.setText(values[3]);
        }
        catch (Exception ex) {
            this.viewBoxMinXField.setText("");
            this.viewBoxMinYField.setText("");
            this.viewBoxWidthField.setText("");
            this.viewBoxHeightField.setText("");
        }
        int index = -1;
        SVGPreserveAspectRatio preserveAspectRatio = elt.getPreserveAspectRatio().getBaseVal();
        switch (preserveAspectRatio.getAlign()) {
            case 1: {
                index = 0;
                break;
            }
            case 2: {
                index = 1;
                break;
            }
            case 3: {
                index = 2;
                break;
            }
            case 4: {
                index = 3;
                break;
            }
            case 5: {
                index = 4;
                break;
            }
            case 6: {
                index = 5;
                break;
            }
            case 7: {
                index = 6;
                break;
            }
            case 8: {
                index = 7;
                break;
            }
            case 9: {
                index = 8;
                break;
            }
            case 10: {
                index = 9;
            }
        }
        this.preserveAspectRatioAlignCombo.setSelectedIndex(index);
        index = -1;
        switch (preserveAspectRatio.getMeetOrSlice()) {
            case 1: {
                index = 0;
                break;
            }
            case 2: {
                index = 1;
            }
        }
        this.preserveAspectRatioMeetOrSliceCombo.setSelectedIndex(index);
        this.refreshing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void geomFieldActionPerformed(ActionEvent evt) {
        if (this.refreshing) {
            return;
        }
        SVGSVGElement elt = (SVGSVGElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change SVG attributes");
        try {
            String attrName = "x";
            String str = this.xField.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
            attrName = "y";
            str = this.yField.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
            attrName = "width";
            str = this.wField.getText().trim();
            Number number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException(bundle.getString("MSG_NegativeWidth.Text"));
            }
            elt.setAttributeNS(null, attrName, str);
            attrName = "height";
            str = this.hField.getText().trim();
            number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException(bundle.getString("MSG_NegativeHeight.Text"));
            }
            elt.setAttributeNS(null, attrName, str);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
        if (this.canvas != null) {
            this.canvas.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewBoxFieldActionPerformed(ActionEvent evt) {
        if (this.refreshing) {
            return;
        }
        SVGSVGElement elt = (SVGSVGElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change SVG viewBox attributes");
        try {
            String vb = "";
            String separator = " ";
            String str = this.viewBoxMinXField.getText().trim();
            DataTypeUtilities.validateNumber(str);
            vb = vb + str;
            str = this.viewBoxMinYField.getText().trim();
            DataTypeUtilities.validateNumber(str);
            vb = vb + separator + str;
            str = this.viewBoxWidthField.getText().trim();
            Number number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException(bundle.getString("MSG_NegativeWidth.Text"));
            }
            vb = vb + separator + str;
            str = this.viewBoxHeightField.getText().trim();
            number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException(bundle.getString("MSG_NegativeHeight.Text"));
            }
            vb = vb + separator + str;
            elt.setAttributeNS(null, "viewBox", vb);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
        if (this.canvas != null) {
            this.canvas.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void viewBoxClearActionPerformed(ActionEvent evt) {
        if (this.refreshing) {
            return;
        }
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change SVG viewBox attributes");
        try {
            SVGSVGElement elt = (SVGSVGElement)this.element;
            elt.removeAttributeNS(null, "viewBox");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
        if (this.canvas != null) {
            this.canvas.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preserveAspectRatioItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        int alignIndex = this.preserveAspectRatioAlignCombo.getSelectedIndex();
        int meetOrSliceIndex = this.preserveAspectRatioMeetOrSliceCombo.getSelectedIndex();
        short align = 6;
        short meetOrSlice = 1;
        switch (alignIndex) {
            case 0: {
                align = 1;
                break;
            }
            case 1: {
                align = 2;
                break;
            }
            case 2: {
                align = 3;
                break;
            }
            case 3: {
                align = 4;
                break;
            }
            case 4: {
                align = 5;
                break;
            }
            case 5: {
                align = 6;
                break;
            }
            case 6: {
                align = 7;
                break;
            }
            case 7: {
                align = 8;
                break;
            }
            case 8: {
                align = 9;
                break;
            }
            case 9: {
                align = 10;
            }
        }
        switch (meetOrSliceIndex) {
            case 0: {
                meetOrSlice = 1;
                break;
            }
            case 1: {
                meetOrSlice = 2;
            }
        }
        boolean isDefault = false;
        if (align == 6 && meetOrSlice == 1) {
            isDefault = true;
        }
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change SVG preserveAspectRatio");
        try {
            SVGSVGElement elt = (SVGSVGElement)this.element;
            SVGPreserveAspectRatio preserveAspectRatio = elt.getPreserveAspectRatio().getBaseVal();
            if (!isDefault) {
                preserveAspectRatio.setAlign(align);
                preserveAspectRatio.setMeetOrSlice(meetOrSlice);
            } else {
                String attrName = "preserveAspectRatio";
                elt.removeAttributeNS(null, attrName);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            this.editing = false;
            undoManager.end();
            this.refreshProperties();
        }
        if (this.canvas != null) {
            this.canvas.refresh();
        }
    }
}

