/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import kiyut.sketsa.canvas.CanvasSelection;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.event.CanvasSelectionAdapter;
import kiyut.sketsa.canvas.event.CanvasSelectionEvent;
import kiyut.sketsa.windows.properties.FillProperties;
import kiyut.sketsa.windows.properties.FilterProperties;
import kiyut.sketsa.windows.properties.GeometryProperties;
import kiyut.sketsa.windows.properties.GraphicsProperties;
import kiyut.sketsa.windows.properties.MarkerProperties;
import kiyut.sketsa.windows.properties.SelectionEmptyProperties;
import kiyut.sketsa.windows.properties.StrokeProperties;

public class Properties
extends JPanel {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.windows.properties.Properties");
    private VectorCanvas canvas;
    private CanvasSelectionHandler canvasSelectionHandler;
    private SelectionEmptyProperties selectionEmptyProperty;
    private GeometryProperties geometryProperties;
    private StrokeProperties strokeProperties;
    private FillProperties fillProperties;
    private FilterProperties filterProperties;
    private MarkerProperties markerProperties;
    private List<GraphicsProperties> propertyList;
    private int viewIndex = 0;
    private JTabbedPane tabPane;

    public Properties() {
        this.setPreferredSize(new Dimension(260, 340));
        this.selectionEmptyProperty = new SelectionEmptyProperties();
        this.geometryProperties = new GeometryProperties();
        this.strokeProperties = new StrokeProperties();
        this.fillProperties = new FillProperties();
        this.filterProperties = new FilterProperties();
        this.markerProperties = new MarkerProperties();
        this.propertyList = new ArrayList<GraphicsProperties>();
        this.propertyList.add(this.geometryProperties);
        this.propertyList.add(this.strokeProperties);
        this.propertyList.add(this.fillProperties);
        this.propertyList.add(this.filterProperties);
        this.propertyList.add(this.markerProperties);
        this.tabPane = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabPane, "Center");
        this.tabPane.add(bundle.getString("CTL_Geom.Text"), this.selectionEmptyProperty);
        this.tabPane.add(bundle.getString("CTL_Stroke.Text"), this.strokeProperties);
        this.tabPane.add(bundle.getString("CTL_Fill.Text"), this.fillProperties);
        this.tabPane.add(bundle.getString("CTL_Filter.Text"), this.filterProperties);
        this.tabPane.add(bundle.getString("CTL_Marker.Text"), this.markerProperties);
        this.canvasSelectionHandler = new CanvasSelectionHandler();
        this.tabPane.setEnabled(false);
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        if (this.canvas != null) {
            VectorCanvas old = this.canvas;
            old.getCanvasSelection().removeSelectionListener(this.canvasSelectionHandler);
        }
        this.canvas = canvas;
        for (int i = 0; i < this.propertyList.size(); ++i) {
            GraphicsProperties property = this.propertyList.get(i);
            property.setVectorCanvas(this.canvas);
        }
        if (this.canvas == null) {
            this.updatePropertyEditor(new ArrayList());
            return;
        }
        CanvasSelection canvasSelection = canvas.getCanvasSelection();
        canvasSelection.addSelectionListener(this.canvasSelectionHandler);
        this.updatePropertyEditor(canvasSelection.getSelectionList());
    }

    private void updatePropertyEditor(List selectionList) {
        if (this.tabPane.isEnabled()) {
            this.viewIndex = this.tabPane.getSelectedIndex();
        }
        if (selectionList.isEmpty()) {
            this.tabPane.setComponentAt(0, this.selectionEmptyProperty);
            this.tabPane.setSelectedIndex(0);
            this.tabPane.setEnabled(false);
        } else {
            this.geometryProperties.setSelectionList(selectionList);
            this.strokeProperties.setSelectionList(selectionList);
            this.fillProperties.setSelectionList(selectionList);
            this.filterProperties.setSelectionList(selectionList);
            this.markerProperties.setSelectionList(selectionList);
            this.tabPane.setComponentAt(0, this.geometryProperties);
            this.tabPane.validate();
            this.tabPane.setEnabled(true);
            this.tabPane.setSelectedIndex(this.viewIndex);
        }
        this.repaint();
    }

    private class CanvasSelectionHandler
    extends CanvasSelectionAdapter {
        private CanvasSelectionHandler() {
        }

        @Override
        public void valueChanged(CanvasSelectionEvent evt) {
            Properties.this.updatePropertyEditor(evt.getSelectionList());
        }
    }
}

