/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.gradient;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import kiyut.sketsa.windows.defs.gradient.GradientStopTableModel;
import kiyut.sketsa.windows.defs.gradient.SVGGradientUtilities;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGGradientElement;

public class GradientStopTable
extends JTable {
    public GradientStopTable() {
        this.setUpColorRenderer();
        this.setUpColorEditor();
        GradientStopTableModel model = new GradientStopTableModel();
        this.setModel(model);
    }

    private void setUpColorRenderer() {
        this.setDefaultRenderer(Color.class, new ColorRenderer(true));
    }

    private void setUpColorEditor() {
        ColorEditor colorEditor = new ColorEditor();
        this.setDefaultEditor(Color.class, colorEditor);
    }

    public void setGradientElement(SVGGradientElement element) {
        GradientStopTableModel model = (GradientStopTableModel)this.getModel();
        model.setGradientElement(element);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        try {
            super.editingStopped(e);
            GradientStopTableModel model = (GradientStopTableModel)this.getModel();
            SVGGradientElement element = model.getGradientElement();
            String newId = element.getId();
            SVGGradientUtilities.updateReferenceElement((SVGElement)element, newId);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
    }

    class ColorEditor
    extends DefaultCellEditor {
        private Color currentColor;

        public ColorEditor() {
            super(new JCheckBox());
            this.currentColor = null;
            this.setClickCountToStart(2);
            JButton button = new JButton("");
            button.setBackground(Color.white);
            button.setBorderPainted(false);
            button.setMargin(new Insets(0, 0, 0, 0));
            this.editorComponent = button;
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color newColor = JColorChooser.showDialog(ColorEditor.this.editorComponent, "Pick a Color", ColorEditor.this.currentColor);
                    if (newColor != null) {
                        ColorEditor.this.currentColor = newColor;
                    }
                    ColorEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JButton)this.editorComponent).setText(value.toString());
            this.currentColor = (Color)value;
            return this.editorComponent;
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground((Color)color);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }
}

