/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.defs.filter;

import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGFilterElement;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class FilterTreeModel
extends DefaultTreeModel {
    private SVGFilterElement element;
    private Map<TreeNode, Node> treeNodeMap = new HashMap<TreeNode, Node>();
    private Map<Node, TreeNode> domNodeMap = new HashMap<Node, TreeNode>();

    public FilterTreeModel() {
        super(null);
    }

    public void setSVGFilterElement(SVGFilterElement element) {
        if (element == null) {
            return;
        }
        this.element = element;
        this.treeNodeMap.clear();
        this.domNodeMap.clear();
        DocumentTraversal travelsal = (DocumentTraversal)((Object)element.getOwnerDocument());
        TreeWalker tw = travelsal.createTreeWalker((Node)element, 1, null, false);
        MutableTreeNode rootNode = this.buildTree(tw);
        this.setRoot(rootNode);
    }

    public SVGFilterElement getSVGFilterElement() {
        return this.element;
    }

    private MutableTreeNode buildTree(TreeWalker tw) {
        Node n = tw.getCurrentNode();
        DefaultMutableTreeNode result = new DefaultMutableTreeNode(n);
        this.treeNodeMap.put(result, n);
        this.domNodeMap.put(n, result);
        Node child = tw.firstChild();
        while (child != null) {
            MutableTreeNode treeNode = this.buildTree(tw);
            if (treeNode != null) {
                result.add(treeNode);
            }
            child = tw.nextSibling();
        }
        tw.setCurrentNode(n);
        return result;
    }

    @Override
    public boolean isLeaf(Object node) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Node domNode = (Node)treeNode.getUserObject();
        return !domNode.hasChildNodes();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void reload(TreeNode node) {
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Node domNode = (Node)treeNode.getUserObject();
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)treeNode.getChildAt(i);
            Node dn = (Node)tn.getUserObject();
            this.treeNodeMap.remove(tn);
            this.domNodeMap.remove(dn);
        }
        treeNode.removeAllChildren();
        Document doc = domNode.getOwnerDocument();
        DocumentTraversal travelsal = (DocumentTraversal)((Object)doc);
        TreeWalker tw = travelsal.createTreeWalker(domNode, 1, null, false);
        MutableTreeNode child = this.buildTree(tw);
        if (child != null) {
            while (child.getChildCount() > 0) {
                treeNode.add((MutableTreeNode)child.getChildAt(0));
            }
        }
        super.reload(node);
    }

    public TreeNode getTreeNode(Node domNode) {
        return this.domNodeMap.get(domNode);
    }

    public void moveNodeUp(TreeNode node) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        DefaultMutableTreeNode prevTreeNode = treeNode.getPreviousSibling();
        Node domNode = (Node)treeNode.getUserObject();
        Node prevNode = prevTreeNode != null ? (Node)prevTreeNode.getUserObject() : null;
        Node parentNode = domNode.getParentNode();
        if (parentNode != null && prevNode != null) {
            parentNode.insertBefore(domNode, prevNode);
            this.reload(treeNode.getParent());
        }
    }

    public void moveNodeDown(TreeNode node) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        DefaultMutableTreeNode nextTreeNode = treeNode.getNextSibling();
        nextTreeNode = nextTreeNode != null ? nextTreeNode.getNextSibling() : null;
        Node domNode = (Node)treeNode.getUserObject();
        Node nextNode = nextTreeNode != null ? (Node)nextTreeNode.getUserObject() : null;
        Node parentNode = domNode.getParentNode();
        if (parentNode != null) {
            if (nextNode != null) {
                parentNode.insertBefore(domNode, nextNode);
            } else {
                parentNode.removeChild(domNode);
                parentNode.appendChild(domNode);
            }
            this.reload(treeNode.getParent());
        }
    }

    public void removeNode(TreeNode node) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Node domNode = (Node)treeNode.getUserObject();
        Node parentNode = domNode.getParentNode();
        if (parentNode != null) {
            parentNode.removeChild(domNode);
            this.removeNodeFromParent(treeNode);
            this.domNodeMap.remove(domNode);
            this.treeNodeMap.remove(treeNode);
        }
    }
}

